<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/VBTClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/VBTClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>

&lt;*PRAGMA LL*&gt;
</PRE> The <CODE>VBTClass</CODE> interface specifies the up methods, the split methods,
   and the wrapper procedures by which a parent activates a child's down
   methods.
<P>
   In general, to implement a split or filter you override the down
   methods, up methods, and split methods of the parent.  However, usually
   you will be able to inherit the majority of the methods from existing
   classes, and only have to override a few of them.  We mention several
   groups of methods that in most cases you will want to inherit rather
   than reimplement.
<P>
   The two down methods
<P>
<PRE>
      VBT.Split.mouse
      VBT.Split.position
</PRE>
   together with the two up methods
<P>
<PRE>
      VBT.Split.setcage
      VBT.Split.setcursor
</PRE>
   conspire to implement the mouse-cage semantics described in the <CODE>VBT</CODE>
   interface for delivering mouse clicks and cursor positions and for
   setting the cursor shape.  They work for any <CODE>VBT.Split</CODE>, and there is
   almost never any reason to override them.  As a far-fetched example of
   when you would override them, imagine a filter that converts shifted
   left button clicks to right button clicks.
<P>
   Although you probably won't want to override these methods, you will
   have to help them a bit.  They cache the results of the <CODE>locate</CODE> method,
   and therefore require that you call <CODE>VBTClass.LocateChanged</CODE> whenever
   the geometry of your split changes in a way that affects the locate
   method.
<P>
   The up methods
<P>
<PRE>
      VBT.Split.acquire
      VBT.Split.release
      VBT.Split.put
      VBT.Split.forge
      VBT.Split.readUp
      VBT.Split.writeUp
</PRE>
   implement the event-time semantics described in the <CODE>VBT</CODE> interface.
   They simply recurse up the tree of <CODE>VBT</CODE>s.  At the root the recursive
   calls reach a <CODE>VBT</CODE> in which these methods are overridden to make the
   appropriate X calls.  There is rarely any reason to override these
   methods.  As an example of when you might want to override them, imagine
   keeping track of which <CODE>VBT</CODE> in your application last held the keyboard
   focus.  You could do this by introducing a filter whose <CODE>acquire</CODE> method
   recorded the information before recursing on the parent.
<P>
   Keystrokes and miscellaneous codes can skip levels of the tree when they
   are delivered.  For example, associated with each top-level window is a
   filter much like the one just described, which keeps track of which of
   its decendants are selection owners.  This filter forwards keystrokes
   and lost codes directly to the appropriate owner, bypassing the
   intermediate windows in the tree.
<P>
   The up methods
<P>
<PRE>
      VBT.Split.paintbatch
      VBT.Split.capture
      VBT.Split.sync
</PRE>
   implement painting, painting synchronization, and screen capture.  The
   <CODE>sync</CODE> and <CODE>capture</CODE> methods recurse up the tree in the obvious way.
   The <CODE>paintbatch</CODE> method also recurses up the tree, but in a less obvious
   way.
<P>
   It would be too inefficient to call a method for every painting command;
   therefore the class-independent painting code groups painting commands
   into batches and hands them to the method a batch at a time.  For
   example, the <CODE>paintbatch</CODE> method of a <CODE>ZSplit</CODE> clips the batch of
   painting commands to the visible portion of the child's domain and then
   executes the clipped operations on itself.
<P>
   Painting on the vast majority of <CODE>VBT</CODE>s can be implemented simply by
   clipping to their domain and then relaying the painting to their parent.
   To speed up this common case, every <CODE>VBT</CODE> has a {\it short-circuit} bit.
   If this bit is set then Trestle doesn't call the <CODE>VBT</CODE>'s <CODE>paintbatch</CODE>
   method at all; it just clips to the <CODE>VBT</CODE>'s domain and paints on its
   parent.  Typically the only <CODE>VBT</CODE>s whose short-circuit bits are not set
   are the root <CODE>VBT</CODE> and those <CODE>ZSplit</CODE> children that are overlapped by
   other children or that extend outside the parent's domain.
<P>
   If the short-circuit bits are set on all the <CODE>VBT</CODE>s from <CODE>v</CODE> to the
   root, then the class-independent painting code will relay batches of
   painting commands from <CODE>v</CODE> to the root without activating any methods.
   The <CODE>paintbatch</CODE> method at the root translates the batch of painting
   commands into the appropriate X operations.
<P>
   The default method <CODE>VBT.Split.paintbatch</CODE> sets the short-circuit bit and
   recurses on the parent.  In the unlikely event that you want to override
   this method, the interfaces <CODE>Batch</CODE>, <CODE>BatchUtil</CODE>, and <CODE>PaintPrivate</CODE>
   define the representation of painting commands in batches.  You could
   for example overriding the paintbatch method to implement a class of
   <CODE>VBT</CODE> that paints into a raw pixmap in your address space.
<P>
   To speed up painting, Trestle does not rely on garbage collection for
   paintbatches: you must free them explicitly.
<P>
   You almost never need to implement the split methods <CODE>succ</CODE>, <CODE>pred</CODE>,
   <CODE>move</CODE>, <CODE>nth</CODE>, <CODE>index</CODE>, and <CODE>locate</CODE>; on the other hand you must be
   careful to inherit them from the right place.  There are two main
   subtypes of <CODE>VBT.Split</CODE>, filters and ``proper'' splits, and they have
   different suites of split methods.  The implementations of the split
   methods for filters are
<P>
<PRE>
      Filter.T.succ
      Filter.T.pred
      Filter.T.move
      Filter.T.nth
      Filter.T.index
      Filter.T.locate
</PRE>
   These are all quite trivial procedures, since a filter has at most one
   child.  If you declare a split as a subtype of <CODE>Filter.T</CODE>, you inherit
   these methods automatically.
<P>
   Most proper splits are subtypes of <CODE>ProperSplit.T</CODE>, which keeps the
   children in a doubly-linked list.  For example, <CODE>ZSplits</CODE>, <CODE>HVSplits</CODE>,
   <CODE>TSplits</CODE>, and <CODE>PackSplits</CODE> are all subtypes of <CODE>ProperSplit.T</CODE>.  The
   methods
<P>
<PRE>
      ProperSplit.T.succ
      ProperSplit.T.pred
      ProperSplit.T.move
      ProperSplit.T.nth
      ProperSplit.T.index
      ProperSplit.T.locate
</PRE>
   implement the split methods using the doubly-linked list.  If you
   declare a split as a subtype of <CODE>ProperSplit.T</CODE>, you inherit these
   methods automatically.
<P>
   

<P><PRE>INTERFACE <interface><A HREF="VBTClass.m3">VBTClass</A></interface>;

IMPORT <A HREF="VBT.i3">VBT</A>, <A HREF="Trestle.i3">Trestle</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="ScrnCursor.i3">ScrnCursor</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>,
       <A HREF="Cursor.i3">Cursor</A>, <A HREF="Batch.i3">Batch</A>;
</PRE> Before we get to the up methods and the split methods, there is more to
   be revealed about <CODE>VBT</CODE>s in general: 

<P><PRE>REVEAL VBT.Prefix &lt;: Prefix;

TYPE
  Prefix = MUTEX OBJECT          &lt;* LL &gt;= {VBT.mu, SELF} *&gt;
             parent: VBT.Split      := NIL;
             upRef : ROOT           := NIL;
             domain: Rect.T         := Rect.Empty;
             st    : VBT.ScreenType := NIL;
           METHODS               &lt;* LL.sup = SELF *&gt;
             getcursor (): ScrnCursor.T;
             &lt;* LL.sup = VBT.mu *&gt;
             axisOrder (): Axis.T;
           END;
</PRE> From <CODE>VBT.Prefix &lt;: Prefix</CODE> it follows <CODE>VBT.T &lt;: Prefix</CODE>; hence every
   <CODE>VBT</CODE> is a <CODE>MUTEX</CODE> object, and has the above fields and methods.  The
   complete revelation for the type <CODE>VBT.T</CODE> is private to Trestle.
<P>
   The fields <CODE>v.parent</CODE>, <CODE>v.domain</CODE>, and <CODE>v.st</CODE> record <CODE>v</CODE>'s parent,
   domain, and screentype.
<P>
   The object <CODE>v.upRef</CODE> is used by the methods of <CODE>v.parent</CODE> to store
   information specific to the child <CODE>v</CODE>.  For example, if <CODE>v.parent</CODE> is a
   <CODE>ZSplit</CODE>, then <CODE>v.upRef</CODE> contains a region representing the visible part
   of <CODE>v</CODE>, pointers to the children before and after <CODE>v</CODE>, and other
   information.  In a filter, <CODE>v.upRef</CODE> is usually <CODE>NIL</CODE>, since when there
   is only one child, all the state can be stored in data fields directly
   in the parent object.
<P>
   If <CODE>v.parent</CODE> is <CODE>NIL</CODE>, then so is <CODE>v.upRef</CODE>.
<P>
   The locking level comment on the data fields means that in order to
   write one of the fields <CODE>v.parent</CODE>, <CODE>v.upRef</CODE>, <CODE>v.domain</CODE>, or <CODE>v.st</CODE>, a
   thread must have both <CODE>VBT.mu</CODE> and <CODE>v</CODE> locked.  Consequently, in order
   to read one of the fields, a thread must have either <CODE>VBT.mu</CODE> (or a
   share of <CODE>VBT.mu</CODE>) or <CODE>v</CODE> locked.  Thus the fields can be read either by
   up methods or by down methods.
<P>
   The call <CODE>v.getcursor()</CODE> returns the cursor that should be displayed
   over <CODE>v</CODE>; that is, the cursor that was called <CODE>GetCursor(v)</CODE> in the
   <CODE>VBT</CODE> interface.  It is almost never necessary to override the
   <CODE>getcursor</CODE> method, since leaves and splits have suitable default
   methods.
<P>
   The <CODE>axisOrder</CODE> method determines whether it is preferable to fix a
   <CODE>VBT</CODE>'s height first or its width first.  For example, a horizontal
   packsplit would rather have its width fixed before its range of heights
   is queried, since its height depends on its width.  In general, if <CODE>v</CODE>'s
   size range in axis <CODE>ax</CODE> affects its size range in the other axis (and
   not vice-versa), then <CODE>v.axisOrder()</CODE> should return <CODE>ax</CODE>.  The default
   is to return <CODE>Axis.T.Hor</CODE>.
<P>
   Next we come to the specifications of the split methods and the up
   methods: 

<P><PRE>REVEAL VBT.Split &lt;: Public;

TYPE
  Public =
    VBT.Leaf OBJECT
    METHODS

      (*
      | (* The split methods *)
      *)
      &lt;* LL &gt;= {VBT.mu, SELF, ch} *&gt;
      beChild (ch: VBT.T);
      &lt;* LL.sup = VBT.mu *&gt;
      replace (ch, new: VBT.T);
      insert  (pred, new: VBT.T);
      move    (pred, ch: VBT.T);
      locate  (READONLY pt: Point.T; VAR (*OUT*) r: Rect.T): VBT.T;
      &lt;* LL &gt;= {VBT.mu} *&gt;
      succ  (ch: VBT.T): VBT.T;
      pred  (ch: VBT.T): VBT.T;
      nth   (n: CARDINAL): VBT.T;
      index (ch: VBT.T): CARDINAL;

      (*
      | (* The up methods *)
      *)

      &lt;* LL.sup = ch *&gt;
      setcage    (ch: VBT.T);
      setcursor  (ch: VBT.T);
      paintbatch (ch: VBT.T; b: Batch.T);
      sync       (ch: VBT.T; wait := TRUE);
      capture (ch: VBT.T; READONLY rect: Rect.T; VAR (*out*) br: Region.T):
               ScrnPixmap.T;
      screenOf (ch: VBT.T; READONLY pt: Point.T): Trestle.ScreenOfRec;
      &lt;* LL.sup &lt; SELF AND LL &gt;= {ch, VBT.mu.ch} *&gt;
      newShape (ch: VBT.T);
      &lt;* LL.sup = ch *&gt;
      acquire (ch: VBT.T; w: VBT.T; s: VBT.Selection; ts: VBT.TimeStamp)
               RAISES {VBT.Error};
      release (ch: VBT.T; w: VBT.T; s: VBT.Selection);
      put (         ch    : VBT.T;
                    w     : VBT.T;
                    s     : VBT.Selection;
                    ts    : VBT.TimeStamp;
                    type  : VBT.MiscCodeType;
           READONLY detail                     := VBT.NullDetail)
           RAISES {VBT.Error};
      forge (         ch    : VBT.T;
                      w     : VBT.T;
                      type  : VBT.MiscCodeType;
             READONLY detail                     := VBT.NullDetail)
             RAISES {VBT.Error};
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      readUp (ch: VBT.T;
              w : VBT.T;
              s : VBT.Selection;
              ts: VBT.TimeStamp;
              tc: CARDINAL       ): VBT.Value RAISES {VBT.Error};
      writeUp (ch : VBT.T;
               w  : VBT.T;
               s  : VBT.Selection;
               ts : VBT.TimeStamp;
               val: VBT.Value;
               tc : CARDINAL       ) RAISES {VBT.Error};
    END;
</PRE> Notice that a <CODE>VBT.Split</CODE> is a subtype of a <CODE>VBT.Leaf</CODE>.  That is, every
   <CODE>VBT.Split</CODE> is also a <CODE>VBT.Leaf</CODE>, and therefore the painting operations
   in the <CODE>VBT</CODE> interface can be applied to splits.  This fact is revealed
   here rather than in the <CODE>VBT</CODE> interface to prevent clients of <CODE>VBT</CODE> from
   accidentally painting on splits.  To do so is almost certainly a
   mistake---it is the responsibility of the split's implementation to
   paint on the parent as necessary to keep its screen up to date. 

<P> \subsubsection{Specifications of the split methods} 

<P> The first group of methods implement the behavior in the <CODE>Split</CODE>
   interface:
<P>
   The method call <CODE>v.beChild(ch)</CODE> initializes <CODE>ch.upRef</CODE> as appropriate
   for a child of <CODE>v</CODE>.  The method can assume that <CODE>ch</CODE> is non-nil and has
   the same screentype as <CODE>v</CODE>.  When the method is called, <CODE>LL &gt;= {VBT.mu,
   v, ch}</CODE>.
<P>
   When declaring a subtype <CODE>ST</CODE> of a split type <CODE>S</CODE>, the <CODE>beChild</CODE> method
   for <CODE>ST</CODE> will ordinarily call <CODE>S.beChild(v, ch)</CODE>, which in turn will
   call <CODE>S</CODE>'s supertype's <CODE>beChild</CODE> method, and so on.  Only one of the
   methods should allocate the <CODE>upRef</CODE>, but all of them may initialize
   different parts of it.  Two rules make this work.  First, the type of
   the <CODE>upRef</CODE> for children of <CODE>ST</CODE> splits should be a subtype of the type
   of the <CODE>upRef</CODE> for children of <CODE>S</CODE> splits.  Second, if a <CODE>beChild</CODE>
   method finds <CODE>ch.upRef</CODE> is <CODE>NIL</CODE> and <CODE>NIL</CODE> is not appropriate for the
   type, the method should allocate <CODE>ch.upRef</CODE>; otherwise it should narrow
   <CODE>ch.upRef</CODE> to the appropriate type and initialize it.
<P>
   For example, <CODE>HVSplit.T</CODE> is a subtype of <CODE>ProperSplit.T</CODE>.  Hidden in the
   <CODE>HVSplit</CODE> module is a type <CODE>HVSplit.Child</CODE>, which represents the
   per-child information needed by an <CODE>HVSplit</CODE>.  The type <CODE>HVSplit.Child</CODE>
   is a subtype of <CODE>ProperSplit.Child</CODE>.  The method <CODE>HVSplit.beChild(hv,
   ch)</CODE> allocates a new <CODE>HVSplit.Child</CODE>, stores it in <CODE>ch.upRef</CODE>,
   initializes the part of it that is specific to <CODE>HVSplit</CODE>, and then calls
   <CODE>ProperSplit.beChild(hv, ch)</CODE>, which initializes the part of <CODE>ch.upRef</CODE>
   that is common to all proper splits, and then calls its supertype's
   <CODE>beChild</CODE> method, and so on.
<P>
   The chain of calls eventually ends with a call to <CODE>VBT.Split.beChild</CODE>,
   which causes an error if <CODE>ch</CODE> is not detached or if <CODE>ch</CODE>'s screentype
   differs from <CODE>v</CODE>, and otherwise sets <CODE>ch.parent</CODE> to <CODE>v</CODE> and marks <CODE>v</CODE>
   for redisplay.
<P>
   The method call <CODE>v.replace(ch, new)</CODE> simply implements the operation
   <CODE>Split.Replace(v, ch, new)</CODE>, and the call <CODE>v.replace(ch, NIL)</CODE>
   implements <CODE>Split.Delete(v, ch)</CODE>.  Before calling the method, the
   generic code in <CODE>Split</CODE> marks <CODE>v</CODE> for redisplay, checks that <CODE>ch</CODE> is a
   child of <CODE>v</CODE> and that <CODE>new</CODE> is detached, and rescreens <CODE>new</CODE> to the
   screentype of <CODE>v</CODE>.
<P>
   Similarly, the method call <CODE>v.insert(pred, new)</CODE> implements the
   operation <CODE>Split.Insert(v, pred, new)</CODE>.  Before calling the method, the
   generic code in <CODE>Split</CODE> marks <CODE>v</CODE> for redisplay, checks that <CODE>pred</CODE> is
   <CODE>NIL</CODE> or a child of <CODE>v</CODE> and that <CODE>new</CODE> is detached, and rescreens <CODE>new</CODE>
   to the screentype of <CODE>v</CODE>.  A split that can only contain a limited
   number of children may detach and discard the previous child to
   implement <CODE>insert</CODE>.
<P>
   The call <CODE>v.move(pred, ch)</CODE> implements <CODE>Split.Move(v, pred, ch)</CODE>.
   Before calling the method, the generic code verifies that <CODE>pred</CODE> and
   <CODE>ch</CODE> are children of <CODE>v</CODE> (or <CODE>NIL</CODE>, in the case of <CODE>pred</CODE>), and avoids
   the call if <CODE>pred = ch</CODE> or <CODE>v.succ(pred) = ch</CODE>.
<P>
   When the <CODE>replace</CODE>, <CODE>insert</CODE>, or <CODE>move</CODE> method is called, <CODE>LL.sup =
   VBT.mu</CODE>.  The default methods are equal to <CODE>NIL</CODE>; so every split class
   must arrange to override these methods, usually by inheriting them from
   <CODE>Filter</CODE> or from <CODE>ProperSplit</CODE>.
<P>
   The method calls <CODE>v.succ(ch)</CODE>, <CODE>v.pred(ch)</CODE>, <CODE>v.nth(n)</CODE>, and
   <CODE>v.index(ch)</CODE> implement the corresponding operations in the <CODE>Split</CODE>
   interface.  In all cases, <CODE>LL &gt;= {VBT.mu}</CODE>.
<P>
   The default method <CODE>VBT.Split.succ</CODE> is <CODE>NIL</CODE>; so every split class must
   arrange to override the method, usually by inheriting them from <CODE>Filter</CODE>
   or from <CODE>ProperSplit</CODE>.  The default methods <CODE>VBT.Split.pred</CODE>,
   <CODE>VBT.Split.nth</CODE>, and <CODE>VBT.Split.index</CODE> are implemented by repeatedly
   calling the <CODE>succ</CODE> method.
<P>
   The method call <CODE>v.locate(pt, r)</CODE> returns the child of <CODE>v</CODE> that controls
   the position <CODE>pt</CODE>, or <CODE>NIL</CODE> if there is no such child.  The method also
   sets <CODE>r</CODE> to a rectangle containing <CODE>pt</CODE> such that for all points <CODE>q</CODE> in
   the meet of <CODE>r</CODE> and <CODE>domain(v)</CODE>, <CODE>v.locate(q, ...)</CODE> would return the
   same result as <CODE>v.locate(pt, ...)</CODE>.  The split implementation is
   expected to make <CODE>r</CODE> as large as possible, so that clients can avoid
   calling <CODE>locate</CODE> unnecessarily.  When the method is called, <CODE>pt</CODE> will be
   in <CODE>domain(v)</CODE>.  When the locate method is called, <CODE>LL.sup = VBT.mu</CODE>.
<P>
   If <CODE>v</CODE> inherits the <CODE>mouse</CODE>, <CODE>position</CODE>, <CODE>setcursor</CODE>, or <CODE>setcage</CODE>
   methods from <CODE>VBT.Split</CODE>, then you must call <CODE>LocateChanged(v)</CODE> whenever
   any operation on the split invalidates a rectangle-child pair returned
   previously by <CODE>v.locate</CODE>: 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#LocateChanged">LocateChanged</A> (v: VBT.Split);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Clear any cached results of the <CODE>locate</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> The default method <CODE>VBT.Split.locate(v, pt, r)</CODE> enumerates <CODE>v</CODE>'s
   children in <CODE>succ</CODE> order and returns the first child <CODE>ch</CODE> whose domain
   contains <CODE>pt</CODE>.  It sets <CODE>r</CODE> to a maximal rectangle that lies inside the
   domain of <CODE>ch</CODE> and outside the domains of all preceding children.  If no
   child contains <CODE>pt</CODE>, it returns <CODE>NIL</CODE> and sets <CODE>r</CODE> to a maximal
   rectangle that lies inside the domain of <CODE>v</CODE> and outside the domains of
   all its children.  This is suitable if the children don't overlap or if
   whenever two children overlap, the top one appears earlier in <CODE>succ</CODE>
   order. 

<P> \subsubsection{Specifications of the up methods} 

<P> So much for the split methods; here now are the specifications of the up
   methods.  In all cases, <CODE>ch</CODE> is a child of <CODE>v</CODE>.
<P>
   The method call <CODE>v.setcage(ch)</CODE> is called by the system whenever <CODE>ch</CODE>'s
   cage is changed.  It is called with <CODE>LL.sup = ch</CODE>.  The default method
   implements the behavior described in the <CODE>VBT</CODE> interface.
<P>
   The method call <CODE>v.setcursor(ch)</CODE> is called by the system whenever the
   result of <CODE>ch.getcursor()</CODE> might have changed.  It is called with
   <CODE>LL.sup = ch</CODE>.  The default method implements the behavior described in
   the <CODE>VBT</CODE> interface.
<P>
   The method call <CODE>v.paintbatch(ch, b)</CODE> is called to paint the batch <CODE>b</CODE>
   of painting commands on <CODE>v</CODE>'s child <CODE>ch</CODE>.  The procedure can assume that
   the batch is not empty and that its clipping rectangle is a subset of
   <CODE>ch</CODE>'s domain.  It is responsible for ensuring that <CODE>b</CODE> is eventually
   freed, which can be achieved by calling passing <CODE>b</CODE> to <CODE>Batch.Free</CODE> or
   by passing <CODE>b</CODE> to another paintbatch method, which will inherit the
   obligation to free the batch.  A <CODE>paintbatch</CODE> method is allowed to
   modify the batch.  The default method clips the batch to <CODE>ch</CODE>'s domain,
   paints the batch on the parent, and sets <CODE>ch</CODE>'s shortcircuit bit.  The
   method is called with <CODE>LL.sup = ch</CODE>.
<P>
   The method call <CODE>v.sync(ch, wait)</CODE> implements <CODE>VBT.Sync(ch, wait)</CODE>.
   When the method is called, <CODE>ch</CODE>'s batch will have been forced.  The
   default method acquires <CODE>v</CODE>, releases <CODE>ch</CODE>, forces <CODE>v</CODE>, calls
   <CODE>v.parent</CODE>'s sync method, releases <CODE>v</CODE>, and reacquires <CODE>ch</CODE>.  When the
   method is called, <CODE>ch</CODE>'s batch is <CODE>NIL</CODE> and <CODE>LL.sup = ch</CODE>.
<P>
   The method call <CODE>v.capture(ch, r, br)</CODE> implements <CODE>VBT.Capture(ch, r,
   br)</CODE>.  The default method recurses on the parent.  When the method is
   called, <CODE>ch</CODE>'s batch is <CODE>NIL</CODE>, <CODE>r</CODE> is a subset of <CODE>ch</CODE>'s domain, and
   <CODE>LL.sup = ch</CODE>.
<P>
   The method call <CODE>v.screenOf(ch, pt)</CODE> implements <CODE>Trestle.ScreenOf(ch,
   pt)</CODE>.  The default method recurses on the parent.  When the method is
   called, <CODE>LL.sup = ch</CODE>.
<P>
   The method call <CODE>v.newShape(ch)</CODE> signals that <CODE>ch</CODE>'s size range,
   preferred size, or axis order may have changed.  The default recurses on
   the parent.  When the method is called, <CODE>LL.sup &lt; v AND LL &gt;= {ch,
   VBT.mu.ch}</CODE>.
<P>
   The remaining methods implement event-time operations for a descendent
   (not necessarily a direct child) of the window <CODE>v</CODE>.  In all cases, <CODE>ch</CODE>
   is a child of <CODE>v</CODE> and <CODE>w</CODE> is a descendant of <CODE>ch</CODE>.
<P>
   The <CODE>acquire</CODE>, <CODE>release</CODE>, <CODE>put</CODE>, and <CODE>forge</CODE> methods implement the
   corresponding procedures from the <CODE>VBT</CODE> interface.  For example,
   <CODE>v.put(ch, w, s, ts, cd)</CODE> implements <CODE>VBT.Put(w, s, ts, cd.type,
   cd.detail)</CODE>.  When these methods are called, <CODE>LL.sup = ch</CODE>.
<P>
   Similarly, the <CODE>readUp</CODE> and <CODE>writeUp</CODE> methods implement the procedures
   <CODE>VBT.Read</CODE> and <CODE>VBT.Write</CODE>.  When these methods are called, <CODE>LL.sup &lt;=
   VBT.mu</CODE>. 

<P> \subsubsection{Getting and setting the state of a VBT} 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Cage">Cage</A> (v: VBT.T): VBT.Cage; &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Return v's cage. </EM></BLOCKQUOTE><PRE>

TYPE VBTCageType = {Gone, Everywhere, Rectangle};

PROCEDURE <A HREF="VBTClass.m3#CageType">CageType</A> (v: VBT.T): VBTCageType;
&lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s cage's type. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>CageType(v)</CODE> returns <CODE>Gone</CODE> if <CODE>Cage(v) = VBT.GoneCage</CODE>, <CODE>Everywhere</CODE>
   if <CODE>Cage(v) = VBT.EverywhereCage</CODE>, and <CODE>Rectangle</CODE> otherwise.  It is
   more efficient than <CODE>Cage</CODE>. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#GetCursor">GetCursor</A> (v: VBT.T): Cursor.T;
&lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>cursor(v)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#SetShortCircuit">SetShortCircuit</A> (v: VBT.T); &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Set the short-circuit property of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#ClearShortCircuit">ClearShortCircuit</A> (v: VBT.T); &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Clear the short-ciruit propery of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>v</CODE>'s short-circuit property is on, painting on <CODE>v</CODE> will be
   implemented by clipping to its domain and painting on its parent.
<P>
   The next three procedures are equivalent to the corresponding procedures
   in <CODE>VBT</CODE>, except they have a different locking level: 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#PutProp">PutProp</A> (v: VBT.T; ref: REFANY);
&lt;* LL &gt;= {v} *&gt;

PROCEDURE <A HREF="VBTClass.m3#GetProp">GetProp</A> (v: VBT.T; tc: INTEGER): REFANY;
&lt;* LL &gt;= {v} *&gt;

PROCEDURE <A HREF="VBTClass.m3#RemProp">RemProp</A> (v: VBT.T; tc: INTEGER);
&lt;* LL &gt;= {v} *&gt;
</PRE> In implementing a split it is sometimes necessary to read a child's bad
   region; in which case the following procedure is useful: 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#GetBadRegion">GetBadRegion</A> (v: VBT.T): Region.T;
&lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Return v's bad region; that is, the join of <CODE>bad(v)</CODE> and
   <CODE>exposed(v)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> For the convenience of split implementors, every <CODE>VBT</CODE> has a
   ``newshape'' bit which is set by a call to <CODE>VBT.NewShape</CODE>.  For example,
   the redisplay or shape method of a split can test these bits to
   determine which of its children have new shapes. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#HasNewShape">HasNewShape</A> (v: VBT.T): BOOLEAN;
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return the value of <CODE>v</CODE>'s newshape bit. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#ClearNewShape">ClearNewShape</A> (v: VBT.T); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Clear <CODE>v</CODE>'s <CODE>newshape</CODE> bit. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Procedures for activating the down methods of a VBT} 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Reshape">Reshape</A> (v: VBT.T; READONLY new, saved: Rect.T);
&lt;* LL.sup &gt;= VBT.mu.v AND LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>reshape</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Reshape</CODE> changes <CODE>v.domain</CODE> and then schedules a call to
<P>
<PRE>
      v.reshape(VBT.ReshapeRec{v.domain, new, saved})
</PRE>
   It should always be called instead of a direct call to the method, since
   it establishes essential internal invariants before calling the method.
   The bits in the <CODE>saved</CODE> argument must remain valid until the method
   returns.  It is all right for <CODE>saved</CODE> to be larger than <CODE>v</CODE>'s old
   domain; <CODE>Reshape</CODE> will clip it to <CODE>v</CODE>'s old domain before calling the
   method.  It is illegal to reshape a detached <CODE>VBT</CODE> to have a non-empty
   domain.
<P>
   For example, the <CODE>reshape</CODE> method of <CODE>BorderedVBT</CODE> uses
   <CODE>VBTClass.Reshape</CODE> to reshape its child. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Rescreen">Rescreen</A> (v: VBT.T; st: VBT.ScreenType);
&lt;* LL.sup &gt;= VBT.mu.v AND LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>rescreen</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Rescreen</CODE> executes
<P>
<PRE>
      prev := v.domain;
      v.domain := Rect.Empty;
      v.st := st;
      v.rescreen(VBT.RescreenRec{prev, st}).
   

<P> </PRE>
For example, to determine how large a menu <CODE>m</CODE> would be if it were
   inserted into a <CODE>ZSplit</CODE> <CODE>z</CODE>, you can't simply call <CODE>GetShapes(m)</CODE>,
   since in general the screentype of <CODE>m</CODE> could be different from the
   screentype of <CODE>z</CODE>, and the shape can depend on the screentype.  But you
   can call <CODE>VBTClass.Rescreen(m, z.st)</CODE> followed by <CODE>GetShapes(m)</CODE>. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Repaint">Repaint</A> (v: VBT.T; READONLY badR: Region.T);
&lt;* LL.sup &gt;= VBT.mu.v AND LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Join <CODE>badR</CODE> into <CODE>v</CODE>'s bad region and then prepare for and call <CODE>v</CODE>'s
   repaint method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#Position">Position</A> (v: VBT.T; READONLY cd: VBT.PositionRec);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>position</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#Key">Key</A> (v: VBT.T; READONLY cd: VBT.KeyRec);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>key</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#Mouse">Mouse</A> (v: VBT.T; READONLY cd: VBT.MouseRec);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>mouse</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#Misc">Misc</A> (v: VBT.T; READONLY cd: VBT.MiscRec);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>misc</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> The following two procedures schedule calls to the down methods without
   making the calls synchronously.  They are useful when you hold too many
   locks to call a down method directly.  For example, when a <CODE>ZSplit</CODE>
   child scrolls bits that are obscured, the locking level of the
   <CODE>paintbatch</CODE> method precludes calling the <CODE>repaint</CODE> method directly; but
   a call can be scheduled with <CODE>ForceRepaint</CODE>. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#ForceEscape">ForceEscape</A> (v: VBT.T); &lt;* LL.sup &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Enqueue a cage escape to <CODE>gone</CODE> for delivery to <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#ForceRepaint">ForceRepaint</A> (v: VBT.T; READONLY rgn: Region.T; deliver := TRUE);
&lt;* LL.sup &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Join <CODE>rgn</CODE> into <CODE>v</CODE>'s bad region, and possibly schedule a call to <CODE>v</CODE>'s
   repaint method. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>VBTClass.ForceRepaint</CODE> is like <CODE>VBT.ForceRepaint</CODE>, except that it has a
   different locking level, and if <CODE>deliver</CODE> is <CODE>FALSE</CODE> then no thread will
   be forked to deliver the bad region---in this case the caller has the
   obligation to deliver the bad region soon, either by calling
   <CODE>ForceRepaint</CODE> with <CODE>deliver = TRUE</CODE>, or by calling <CODE>Repaint</CODE>. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Redisplay">Redisplay</A> (v: VBT.T);  &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>v</CODE> is marked for redisplay, then unmark it and prepare for and call
   <CODE>v.redisplay()</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTClass.m3#GetShape">GetShape</A> (v            : VBT.T;
                    ax           : Axis.T;
                    n            : CARDINAL;
                    clearNewShape             := TRUE): VBT.SizeRange;
&lt;* LL.sup &gt;= VBT.mu.v AND LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Prepare for and call <CODE>v</CODE>'s <CODE>shape</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>GetShape</CODE> causes a checked runtime error if the result of the shape
   method is invalid.  If <CODE>clearNewShape</CODE> is <CODE>TRUE</CODE>, <CODE>GetShape</CODE> calls
   <CODE>ClearNewShape(v)</CODE> before it calls the method. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#GetShapes">GetShapes</A> (v: VBT.T; clearNewShape := TRUE):
  ARRAY Axis.T OF VBT.SizeRange;
&lt;* LL.sup &gt;= VBT.mu.v AND LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the shapes of <CODE>v</CODE> in both axes. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>GetShapes</CODE> calls the shape method of <CODE>v</CODE> in each axis, using the order
   determined by <CODE>v.axisOrder()</CODE>, and returns the array of the resulting
   size ranges.  If <CODE>clearNewShape</CODE> is <CODE>TRUE</CODE>, <CODE>GetShapes</CODE> calls
   <CODE>ClearNewShape(v)</CODE> before it calls the method.
<P>
   <CODE>GetShapes</CODE> is convenient if both the height and width preferences of
   the child can be accomodated---for example, when inserting a top level
   window or <CODE>ZSplit</CODE> child. 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#Detach">Detach</A> (v: VBT.T);     &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v.parent</CODE> and <CODE>v.upRef</CODE> to <CODE>NIL</CODE>; set <CODE>v</CODE>'s domain to empty,
   enqueue a reshape to empty, and clear <CODE>v</CODE>'s shortcircuit bit. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Procedures for activating the up methods of a VBT} 

<P> The following six procedures are like the corresponding procedures in
   the <CODE>VBT</CODE> interface, except that they have a different locking level: 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#SetCage">SetCage</A> (v: VBT.T; READONLY cg: VBT.Cage);
&lt;* LL.sup = v *&gt;

PROCEDURE <A HREF="VBTClass.m3#SetCursor">SetCursor</A> (v: VBT.T; cs: Cursor.T);
&lt;* LL.sup = v *&gt;

PROCEDURE <A HREF="VBTClass.m3#Acquire">Acquire</A> (v: VBT.T; s: VBT.Selection; t: VBT.TimeStamp)
  RAISES {VBT.Error};            &lt;* LL.sup = v *&gt;

PROCEDURE <A HREF="VBTClass.m3#Release">Release</A> (v: VBT.T; s: VBT.Selection);
&lt;* LL.sup = v *&gt;

PROCEDURE <A HREF="VBTClass.m3#Put">Put</A> (         v     : VBT.T;
                        s     : VBT.Selection;
                        t     : VBT.TimeStamp;
                        type  : VBT.MiscCodeType;
               READONLY detail                     := VBT.NullDetail)
  RAISES {VBT.Error};
&lt;* LL.sup = v *&gt;

PROCEDURE <A HREF="VBTClass.m3#Forge">Forge</A> (         v     : VBT.T;
                          type  : VBT.MiscCodeType;
                 READONLY detail                     := VBT.NullDetail)
  RAISES {VBT.Error};
&lt;* LL.sup = v *&gt;
</PRE> Finally, here is a procedure for executing a batch of painting commands
   on a <CODE>VBT</CODE>: 

<P><PRE>PROCEDURE <A HREF="VBTClass.m3#PaintBatch">PaintBatch</A> (v: VBT.T; VAR b: Batch.T);
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Execute the batch <CODE>b</CODE> of painting commands on <CODE>v</CODE>, free <CODE>b</CODE>, and set <CODE>b</CODE>
   to <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The interpretation of <CODE>b</CODE> is described in the <CODE>Batch</CODE> and <CODE>PaintPrivate</CODE>
   interfaces.  If <CODE>b.clipped</CODE> is erroneously set to <CODE>TRUE</CODE>, then
   <CODE>PaintBatch</CODE> may execute the batched painting commands without clipping
   them to <CODE>b.clip</CODE>, but it will not paint outside <CODE>v</CODE>'s domain. 

<P><PRE>END VBTClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
