<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/VBTRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/VBTRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> VBTRep.def, code Sun Aug 11 12:18:43 1985 by Greg Nelson 

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> The <CODE>VBTRep</CODE> interface defines the representation of <CODE>VBTs</CODE>, and provides
   operations that are useful for implementing low-level or esoteric
   split classes. 

<P><PRE>INTERFACE <interface><A HREF="VBTRep.m3">VBTRep</A></interface>;

IMPORT <A HREF="Batch.i3">Batch</A>, <A HREF="Cursor.i3">Cursor</A>, <A HREF="../../../property/src/PropertyV.i3">PropertyV</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>,
  <A HREF="ScreenType.i3">ScreenType</A>, <A HREF="ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="ScrnCursor.i3">ScrnCursor</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>,
  <A HREF="ScrnFont.i3">ScrnFont</A>, <A HREF="VBT.i3">VBT</A>, <A HREF="VBTClass.i3">VBTClass</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="PaintPrivate.i3">PaintPrivate</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="Palette.i3">Palette</A>,
  <A HREF="PaintOp.i3">PaintOp</A>, <A HREF="Font.i3">Font</A>, <A HREF="Pixmap.i3">Pixmap</A>;

CONST EmptyCage = VBT.EmptyCage;

TYPE
  MiscRef = REF MiscRec;
  MiscRec = RECORD
    cage := EmptyCage;
    badRgn := Region.Empty;
    rpseqno: Word.T;
    oldDomain := Rect.Empty;
    link: MiscRef := NIL
  END;
</PRE> To save space in a <CODE>VBT</CODE>, the <CODE>cage</CODE>, <CODE>badRgn</CODE>, <CODE>rpseqno</CODE>, and 
   <CODE>oldDomain</CODE> fields are only stored if at least one of them has an 
   ``unusual'' value.  This is achieved by including a <CODE>MiscRef</CODE> in the 
   <CODE>VBT</CODE> object.  If the <CODE>MiscRef</CODE> is <CODE>NIL</CODE>, then the <CODE>badRgn</CODE> and <CODE>oldDomain</CODE>
   are empty, the <CODE>rpseqno</CODE> is irrelevant, and the cage is determined
   from the <CODE>cagetype</CODE> field as follows: if the <CODE>cagetype</CODE> is
   <CODE>VBT.CageType.Rectangle</CODE>, then the cage rectangle is assumed to be
   <CODE>Rect.Empty</CODE>; otherwise the rectangle is irrelevant.
   <P>
   The <CODE>rpseqno</CODE> field is the {\it repainting sequence number}.  It is
   incremented whenever the <CODE>badRgn</CODE> is expanded and recorded before
   activating a <CODE>repaint</CODE> method.  Thus when the repaint method returns,
   the current value can be compared with the recorded value to
   determine whether the current <CODE>badRgn</CODE> is the one that the <CODE>repaint</CODE>
   method responded to, or whether a new bad region arrived while the
   client was responding to the old one.  

<P><PRE>TYPE
  Prop =
    {EscapePending, Reshaping, RepaintPending, OnQ,
     Covered, Combiner, ShortCircuit, CageCovered,
     Marked, ExcessBegins, HasNewShape, BlockNewShape,
     EscapeCovered};
  Props = SET OF Prop;

CONST
  AllProps = Props{FIRST(Prop)..LAST(Prop)};
  NoProps = Props{};
</PRE> Here is the meaning of the properties:
<P>
   <CODE>EscapePending</CODE>: Set when a thread of control is forked to deliver a
   cage escape to gone. Set to <CODE>FALSE</CODE> when any position is delivered.
<P>
   <CODE>Reshaping</CODE>: set when the <CODE>VBT</CODE> has a non-empty old domain.
<P>
   <CODE>RepaintPending</CODE>: Set when a thread of control exists that will deliver
   the bad region.
<P>
   <CODE>OnQ</CODE>: Set when the <CODE>VBT</CODE> is on the <CODE>Metermaid</CODE>'s to-be-serviced queue.
<P>
   <CODE>Covered</CODE>:  Ordinarily painting into an empty batch will put the
   <CODE>VBT</CODE> on the <CODE>Metermaid</CODE>'s queue and set <CODE>onQ</CODE>.  If the <CODE>covered</CODE>
   bit is set, this will not happen.  For example, <CODE>PutPosition</CODE> sets
   <CODE>covered</CODE> before passing the position to child, and clears it and
   forces the batch before it returns.  Only set during event delivery,
   so any action that could be deferred until after event delivery can
   check <CODE>covered</CODE> and clean up on method exit.
<P>
   <CODE>Combiner</CODE>: Set to indicate that this <CODE>VBT</CODE> is a good place to pile up
   small paint batches, even if it is not covered. Trestle sets this bit
   in one <CODE>VBT</CODE> near the root of a client address space to avoid shipping
   many small batches across <CODE>RPC</CODE>.
<P>
   <CODE>ShortCircuit</CODE>:  Set on a <CODE>VBT</CODE> when painting on the VBT can be
   implemented by clipping to the <CODE>VBT</CODE>'s domain and painting on its 
   parent.
<P>
   <CODE>Marked</CODE>: set by <CODE>VBT.Mark</CODE>.
<P>
   <CODE>CageCovered</CODE>: <CODE>VBTClass.PutPosition</CODE> sets this bit on a <CODE>VBT</CODE> before 
   calling its position method; after calling the position method, 
   the procedure relays the child's cage to the parent and clears 
   the bit.  <CODE>VBTClass.SetCage</CODE> notices the bit and omits relaying the 
   cage to the parent.  
<P>
   <CODE>ExcessBegins</CODE>: Set when <CODE>excessBegins &gt; 0</CODE>.
<P>
   <CODE>HasNewShape</CODE> is set when <CODE>VBT.NewShape</CODE> is called, and cleared by
   a call to <CODE>VBTClass.HasNewShape</CODE> or <CODE>VBTClass.GetShape</CODE>. 
<P>
   If <CODE>BlockNewShape</CODE> is set, <CODE>VBT.NewShape</CODE> calls will not be relayed
   to the parent of the <CODE>VBT</CODE>.
 

<P><PRE>REVEAL VBT.<A NAME="Prefix">Prefix</A> =
  VBTClass.Prefix BRANDED OBJECT
    &lt;* LL &gt;= {SELF} *&gt;
    cursor := Cursor.DontCare;
    cageType: (*BITS 16 FOR*) VBTClass.VBTCageType
      := VBTClass.VBTCageType.Gone;
    props: (*BITS 16 FOR*) Props := NoProps;
    batch: Batch.T := NIL;
    remaining: INTEGER := 0;
    propset: PropertyV.Set := NIL;
    miscRef: MiscRef := NIL;
  OVERRIDES
    getcursor := GetcursorDefault;
    axisOrder := AxisOrderDefault;
  END;
</PRE> The <CODE>batch</CODE> field contains the batch of uncompleted painting commands
   for the <CODE>VBT</CODE>, and <CODE>remaining</CODE> contains the number of free addressable
   units remaining in the <CODE>batch</CODE>.  In particular, if <CODE>remaining # 0</CODE>, the
   <CODE>batch</CODE> field is not <CODE>NIL</CODE>.  The <CODE>miscRef</CODE> field is always <CODE>NIL</CODE>
   if the parent is <CODE>NIL</CODE>.  

<P><PRE>REVEAL VBT.ScreenType &lt;: STPub;

TYPE STPub =
  ScreenType.Public OBJECT
    ops: REF ARRAY OF ScrnPaintOp.T;
    cursors: REF ARRAY OF ScrnCursor.T;
    pixmaps: REF ARRAY OF ScrnPixmap.T;
    fonts: REF ARRAY OF ScrnFont.T
  METHODS
    opApply(cl: Palette.OpClosure; op: PaintOp.T): ScrnPaintOp.T;
    cursorApply(cl: Palette.CursorClosure; cs: Cursor.T): ScrnCursor.T;
    pixmapApply(cl: Palette.PixmapClosure; pm: Pixmap.T): ScrnPixmap.T;
    fontApply(cl: Palette.FontClosure; ft: Font.T): ScrnFont.T
  END;
</PRE> The tables <CODE>st.ops</CODE>, <CODE>st.fonts</CODE>, <CODE>st.cursors</CODE>, and <CODE>st.pixmaps</CODE> are
   collectively called the screentype's {\it palette}.  They are used
   to translate between screen-independent resources and
   screen-dependent resources.  For example, recall that <CODE>Pixmap.Gray</CODE>
   is a record containing the integer field <CODE>Pixmap.Gray.pm</CODE>.  The
   screen-dependent equivalent of <CODE>Pixmap.Gray</CODE> on the screentype <CODE>st</CODE>
   is simply <CODE>st.pixmaps[Pixmap.Gray.pm]</CODE>.  When creating the palette,
   the above apply methods are called for all resources; if cl is NIL, the
   resource is built-in.  The default values for these return the result of
   invoking the closure or the built-in method; your procedure must not
   return NIL when invoked on a built-in. 
   
<P><PRE>TYPE OffscreenType = VBT.ScreenType OBJECT st: VBT.ScreenType END;
</PRE> An <CODE>OffscreenType</CODE> <CODE>s</CODE>, is a screen type that is derived from the screen
   type <CODE>s.st</CODE>.  An OffscreenType will be replaced by its associated
   screentype in calls to <CODE>Trestle.InstallOffscreen</CODE>.  The <CODE>st</CODE> field
   is read-only after creation. 

<P><PRE>PROCEDURE <A HREF="VBTRep.m3#CheckMisc">CheckMisc</A>(v: VBT.T); &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v.misc := NIL</CODE> if <CODE>v</CODE>'s <CODE>badRgn</CODE> and <CODE>oldDomain</CODE> are empty and its
   cage type is not <CODE>Rect</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#CreateMisc">CreateMisc</A>(v: VBT.T); &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>v.misc = NIL</CODE>, then create a <CODE>misc</CODE> for <CODE>v</CODE> with empty <CODE>badRgn</CODE> and
   <CODE>oldDomain</CODE>, and with appropriate cage. Otherwise, do nothing. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#DestroyMisc">DestroyMisc</A>(v: VBT.T);
&lt;* LL &gt;= {v, v.parent} *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v</CODE>'s misc to <CODE>NIL</CODE>, clearing <CODE>Reshaping</CODE> from <CODE>v.props</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#NewBatch">NewBatch</A>(v: VBT.T; len: INTEGER := -1);
&lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Force <CODE>v</CODE>'s batch if it is non-nil and allocate a new batch for it
   of size at least <CODE>len</CODE>, or of size <CODE>VBTTuning.BatchSize</CODE> if <CODE>len=-1</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#ForceBatch">ForceBatch</A>(v: VBT.T); &lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Force <CODE>v</CODE>'s batch if it is non-nil, and leave it nil. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#CancelBatch">CancelBatch</A>(v: VBT.T); &lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Free <CODE>v</CODE>'s batch and set it to <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#Enqueue">Enqueue</A>(v: VBT.T); &lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Place <CODE>v</CODE> on the list of <CODE>VBTs</CODE> scheduled to be serviced by the
   MeterMaid. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#GetcursorDefault">GetcursorDefault</A>(v: VBT.Prefix): ScrnCursor.T;
</PRE><BLOCKQUOTE><EM> Return the result of resolving <CODE>cursor(v)</CODE> using <CODE>v</CODE>'s screentype. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#AxisOrderDefault">AxisOrderDefault</A>(v: VBT.Prefix): Axis.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Axis.T.Hor</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#ExpandBadRect">ExpandBadRect</A>(w: VBT.T;
  READONLY clp: Rect.T; ba: Batch.T);
&lt;* LL.sup = w *&gt;
</PRE><BLOCKQUOTE><EM> Expand <CODE>w</CODE>'s bad region for <CODE>ba</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> In <CODE>ExpandBadRect</CODE>, the rectangle <CODE>clp</CODE> is the original clipping
   rectangle for <CODE>ba</CODE>, before intersection with <CODE>w.domain</CODE>.  The
   expansion is caused by (a) using out-of-domain bits as source (b)
   painting into the old domain (c) scrolling an existing bad rectangle.
   
     
<P><PRE>PROCEDURE <A HREF="VBTRep.m3#ExtendBatch">ExtendBatch</A>(v: VBT.T; VAR ba: Batch.T);
</PRE><BLOCKQUOTE><EM> Extend <CODE>v</CODE>'s batch to include the painting operations in <CODE>ba</CODE>, and free
   <CODE>ba</CODE>. It is assumed that <CODE>v</CODE> has a non-empty batch which has room for
   the extension. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#MaxRepeat">MaxRepeat</A>(v: VBT.T): CARDINAL;
&lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of RepeatRec's that can fit in <CODE>v</CODE>'s current batch.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#PaintRepeat">PaintRepeat</A>(v: VBT.T;
  READONLY clip: ARRAY OF Rect.T);
&lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Add a <CODE>RepeatRec</CODE> to <CODE>v</CODE>'s batch for each rectangle in <CODE>clip</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>PaintRepeat</CODE> is a checked run-time error if there isn't enough space
   in <CODE>v</CODE>'s batch.  Calling <CODE>PaintRepeat</CODE> does not call
   <CODE>Enqueue(v)</CODE>. 

<P><PRE>PROCEDURE <A HREF="VBTRep.m3#PaintSingle">PaintSingle</A>(v: VBT.T; READONLY clip: Rect.T;
  com: PaintPrivate.CommandPtr); &lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Add the paint operation referenced by <CODE>com</CODE> to <CODE>v</CODE>'s batch, but
   use the clipping rectangle <CODE>clip</CODE> instead of the one in <CODE>com</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>PaintSingle</CODE> forces <CODE>v</CODE>'s batch if necessary and allocates a new
   one.  It does not call <CODE>Enqueue(v)</CODE>.  The command <CODE>com</CODE> must not be a
   scroll command.  

<P><PRE>PROCEDURE <A HREF="VBTRep.m3#Scroll">Scroll</A>(v: VBT.T; READONLY clip: Rect.T;
  com: PaintPrivate.ScrollPtr); &lt;* LL.sup = v *&gt;
</PRE><BLOCKQUOTE><EM> Like <CODE>PaintSingle</CODE>, but <CODE>com</CODE> must be a scroll command. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#Mark">Mark</A>(v: VBT.T); &lt;* LL &gt;= {v} *&gt;
</PRE><BLOCKQUOTE><EM> Identical to <CODE>VBT.Mark</CODE> except for the locking level. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#Redisplay">Redisplay</A>(); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Redisplay and unmark all marked windows whose screentype is non-<CODE>NIL</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Redisplay</CODE> is equivalent to this loop:
<P>
<PRE>
      LOOP
        WITH m = <KBD>an array containing all marked windows</KBD> DO
          IF NUMBER(m) = 0 THEN EXIT END;
          <KBD>Sort </KBD>m<KBD> in order of non-decreasing depth</KBD>;
          FOR i := 0 TO LAST(m) DO 
            IF IsMarked(m[i]) AND m[i].st # NIL THEN
               Unmark(m[i]);
               m[i].redisplay() 
            END
          END
        END
      END
</PRE>
    The depth of a window is the number of parent pointers that must
    be followed to reach <CODE>NIL</CODE>.  Sorting by depth guarantees that
    ancestors will be redisplayed before their descendants.  The reason
    is that redisplaying an ancestor window often reshapes its
    descendants, and if a descendant is going to be reshaped it would
    be wasteful to redisplay it in its old position.
    <P>
   Ordinarily when a window is marked, a thread is forked that will
   call <CODE>Redisplay</CODE>.  This is wasteful if <CODE>Redisplay</CODE> will be called
   soon anyway.  Therefore, if you know that <CODE>Redisplay</CODE> will be called
   soon, you can call <CODE>CoverRedisplay</CODE>, which increments a ``coverage
   counter''.  If the coverage counter is non-zero, marking a <CODE>VBT</CODE>
   does not fork a thread.  Of course by calling <CODE>CoverRedisplay</CODE> you
   acquire the obligation to ensure that <CODE>Redisplay</CODE> will be called
   soon.  Calling <CODE>UncoverRedisplay</CODE> decrements the counter and calls
   <CODE>Redisplay</CODE> if the result is zero.  
    
<P><PRE>PROCEDURE <A HREF="VBTRep.m3#CoverRedisplay">CoverRedisplay</A>(); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Increment the redisplay coverage counter. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VBTRep.m3#UncoverRedisplay">UncoverRedisplay</A>(); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Decrement the redisplay coverage counter and call <CODE>Redisplay</CODE> if
   the result is zero.  </EM></BLOCKQUOTE><PRE>

END VBTRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
