<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/NTClientF.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/NTClientF.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 

<P>
<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> Partitioning following the efforts of
   Steve.Freeman@computer-lab.cambridge.ac.uk - 92-05-13 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="XClientF.i3">XClientF</A></implements></module>;

IMPORT <A HREF="XClient.i3">XClient</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../split/ProperSplit.i3">ProperSplit</A>,
       <A HREF="../../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../../../libm3/derived/IntTextTbl.i3">IntTextTbl</A>, <A HREF="../../../libm3/derived/TextIntTbl.i3">TextIntTbl</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>,
       <A HREF="XEventQueue.i3">XEventQueue</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="XAtomQueue.i3">XAtomQueue</A>, <A HREF="XScreenType.i3">XScreenType</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>,
       <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="XProperties.i3">XProperties</A>, <A HREF="../../../runtime/src/common/RTParams.i3">RTParams</A>, <A HREF="../../../thread/src/Common/Scheduler.i3">Scheduler</A>, <A HREF="../vbt/KeyboardKey.i3">KeyboardKey</A>,
       <A HREF="../../../runtime/src/common/RTHeapRep.i3">RTHeapRep</A>, <A HREF="../../../runtime/src/common/RTCollectorSRC.i3">RTCollectorSRC</A>, <A HREF="../../../runtime/src/common/RTHeapDep.i3">RTHeapDep</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../params/src/Env.i3">Env</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>,
       <A HREF="XInput.i3">XInput</A>, <A HREF="XMessenger.i3">XMessenger</A>, <A HREF="../split/Split.i3">Split</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="#x1">Unetdb</A>, <A HREF="../../../types/src/Char.i3">Char</A>;

FROM <A HREF="XClient.i3">XClient</A> IMPORT T;

REVEAL
  <A NAME="SimpleWaitFor">SimpleWaitFor</A> =
    SimpleWaitForPublic BRANDED OBJECT OVERRIDES match := SimpleMatch END;

  <A NAME="T_Abs">T_Abs</A> = T_Rel BRANDED OBJECT
            await: WaitFor := NIL; (* list of awaited events *)
            awaitCount := ARRAY [0 .. X.LASTEvent - 1] OF INTEGER{0, ..};
            (* awaitCount[i] is the number of awaited events that might
               match an event of type i. *)
            coverage : CARDINAL := 0;
            atomQ               := XAtomQueue.Empty;
            atomCount           := 0;
            (* atomQ contains atoms that are available for transferring
               selections; atomCount is the number of atoms that have been
               created solely for this purpose. *)
            meterMaid: Thread.T := NIL;
            gcCursor : X.Cursor := X.None
          END;

PROCEDURE <A NAME="SimpleMatch"><procedure>SimpleMatch</procedure></A> (wf: SimpleWaitFor; READONLY ev: X.XEvent): BOOLEAN =
  VAR match: BOOLEAN;
  BEGIN
    WITH e    = LOOPHOLE(ADR(ev), X.XAnyEventStar),
         type = e.type                              DO
      IF type = 0 THEN
        match := LOOPHOLE(ADR(ev), X.XErrorEventStar).serial = wf.reqno
      ELSE
        match := e.window = wf.d
      END;
      IF match THEN
        FOR i := FIRST(wf.types) TO LAST(wf.types) DO
          IF wf.types[i] = type THEN RETURN TRUE END
        END
      END;
      RETURN FALSE
    END
  END SimpleMatch;

PROCEDURE <A NAME="StartMeterMaid"><procedure>StartMeterMaid</procedure></A> (trsl: T; stackSize := 20000) =
  BEGIN
    EVAL Thread.Fork(
           NEW(MeterMaidClosure, trsl := trsl, stackSize := stackSize));
  END StartMeterMaid;

TYPE
  MeterMaidClosure = Thread.SizedClosure OBJECT
                       trsl: XClient.T
                     OVERRIDES
                       apply := MeterMaid
                     END;

PROCEDURE <A NAME="MeterMaid"><procedure>MeterMaid</procedure></A> (cl: MeterMaidClosure): REFANY RAISES {} =
  VAR prev, wf: WaitFor;
  BEGIN
    WITH trsl = cl.trsl DO
      LOOP
        Scheduler.Pause(1.0D0);
        LOCK trsl DO
          prev := NIL;
          wf := trsl.await;
          WHILE wf # NIL DO
            IF wf.timelimit = 0 OR trsl.dead THEN
              DeleteWait(trsl, prev, wf);
              wf.turn := TRUE;
              wf.timeout := TRUE;
              Thread.Signal(wf);
              wf := prev
            ELSIF wf.timelimit &gt; 0 THEN
              DEC(wf.timelimit)
            END;
            IF wf = NIL THEN
              wf := trsl.await
            ELSE
              prev := wf;
              wf := wf.next
            END;
          END;
          IF trsl.await = NIL THEN trsl.meterMaid := NIL; RETURN NIL END
        END
      END
    END
  END MeterMaid;

PROCEDURE <A NAME="Kill"><procedure>Kill</procedure></A> (trsl: T) &lt;* LL.sup = trsl *&gt; =
  BEGIN
    LOCK TrestleClass.closeMu DO
      IF NOT trsl.closed THEN trsl.closed := TRUE; END
    END;
    trsl.dead := TRUE;
    Thread.Broadcast(trsl.qEmpty);
    Thread.Broadcast(trsl.qNonEmpty);
    Thread.Broadcast(trsl.evc);
    IF trsl.meterMaid = NIL AND trsl.await # NIL THEN
      StartMeterMaid(trsl)
    END;
    EVAL Thread.Fork(NEW(KillClosure, trsl := trsl))
  END Kill;

TYPE
  KillClosure =
    Thread.Closure OBJECT trsl: T OVERRIDES apply := DoKill END;

PROCEDURE <A NAME="DoKill"><procedure>DoKill</procedure></A> (self: KillClosure): REFANY RAISES {} =
  BEGIN
    LOCK self.trsl DO
      TRY
        X.XCloseDisplay(self.trsl.dpy)
      EXCEPT
        TrestleComm.Failure =&gt;  (* skip *)
      END
    END;
    Scheduler.Pause(60.0D0);
    LOCK errMu DO
      FOR i := 0 TO LAST(dpyTable^) DO
        IF dpyTable[i].trsl = self.trsl THEN dpyTable[i].trsl := NIL END
      END
    END;
    RETURN NIL
  END DoKill;

PROCEDURE <A NAME="Await"><procedure>Await</procedure></A> (trsl: T_Abs; wf: WaitFor; timelimit: INTEGER := -1): INTEGER
  RAISES {TrestleComm.Failure} =
  (* LL = trsl *)
  BEGIN
    IF trsl.dead THEN RETURN 1 END; (* 1 = timeout *)
    FOR i := FIRST(wf.types) TO LAST(wf.types) DO
      IF wf.types[i] # -1 THEN INC(trsl.awaitCount[wf.types[i]]) END
    END;
    wf.timelimit := timelimit;
    wf.next := trsl.await;
    trsl.await := wf;
    IF trsl.meterMaid = NIL THEN
      trsl.meterMaid := Thread.Fork(NEW(MeterMaidClosure, trsl := trsl,
                                        stackSize := 20000))
    END;
    X.XFlush(trsl.dpy);
    IF X.XEventsQueued(trsl.dpy, X.QueuedAfterReading) # 0 THEN
      Thread.Signal(trsl.qNonEmpty)
    END;
    WHILE NOT wf.turn DO Thread.Wait(trsl, wf) END;
    wf.turn := FALSE;
    Thread.Signal(wf);
    IF wf.timeout THEN RETURN 1 (* not a valid xevent *) END;
    WITH e = LOOPHOLE(ADR(wf.ev), X.XAnyEventStar) DO RETURN e.type END
  END Await;

PROCEDURE <A NAME="DeleteWait"><procedure>DeleteWait</procedure></A> (trsl: T; prev, wf: WaitFor) =
  BEGIN
    IF prev = NIL THEN trsl.await := wf.next ELSE prev.next := wf.next END;
    wf.next := NIL;
    FOR i := FIRST(wf.types) TO LAST(wf.types) DO
      IF wf.types[i] # -1 THEN DEC(trsl.awaitCount[wf.types[i]]) END
    END
  END DeleteWait;

PROCEDURE <A NAME="FindWaiter"><procedure>FindWaiter</procedure></A> (trsl: T; READONLY ev: X.XEvent): WaitFor =
  (* LL = trsl *)
  VAR res, prev: WaitFor;
  BEGIN
    WITH e = LOOPHOLE(ADR(ev), X.XAnyEventStar) DO
      IF trsl.awaitCount[e.type] = 0 THEN RETURN NIL END;
      prev := NIL;
      res := trsl.await;
      WHILE (res # NIL) AND NOT res.match(ev) DO
        prev := res;
        res := res.next
      END;
      IF res # NIL THEN DeleteWait(trsl, prev, res) END;
      RETURN res
    END
  END FindWaiter;
</PRE> ---------- various utilities ---------- 

<P><PRE>PROCEDURE <A NAME="ToRect"><procedure>ToRect</procedure></A> (x, y, width, height: INTEGER): Rect.T =
  BEGIN
    RETURN
      Rect.T{west := x, north := y, east := x + width, south := y + height}
  END ToRect;

PROCEDURE <A NAME="NewAtom"><procedure>NewAtom</procedure></A> (v: T): X.Atom RAISES {TrestleComm.Failure} =
  &lt;*FATAL XAtomQueue.Exhausted*&gt;
  BEGIN
    IF XAtomQueue.IsEmpty(v.atomQ) THEN
      INC(v.atomCount);
      RETURN
        XClient.ToAtom(v, &quot;_DEC_TRESTLE_NEWATOM_&quot; &amp; Fmt.Int(v.atomCount))
    END;
    RETURN XAtomQueue.Remove(v.atomQ)
  END NewAtom;

PROCEDURE <A NAME="FreeAtom"><procedure>FreeAtom</procedure></A> (v: T; VAR sym: X.Atom) =
  BEGIN
    IF sym # X.None THEN XAtomQueue.Insert(v.atomQ, sym); sym := X.None END
  END FreeAtom;

PROCEDURE <A NAME="BackDoor"><procedure>BackDoor</procedure></A> (v: T; READONLY ev: X.XEvent) =
  BEGIN
    XEventQueue.Insert(v.errq, ev);
    Thread.Signal(v.qNonEmpty)
  END BackDoor;

PROCEDURE <A NAME="SetUngrabs"><procedure>SetUngrabs</procedure></A> (trsl: T) RAISES {TrestleComm.Failure} =
  BEGIN
    FOR i := FIRST(Ungrab) TO LAST(Ungrab) DO
      trsl.ungrab[i] := X.XKeysymToKeycode(trsl.dpy, Ungrab[i])
    END;
    (* for all vbts, fix the grabs they have by ungrabbing all, and
       regrabbing what we want -- someday. *)
  END SetUngrabs;

PROCEDURE <A NAME="ValidateNW"><procedure>ValidateNW</procedure></A> (trsl: T; ch: Child; st: XScreenType.T)
  RAISES {TrestleComm.Failure} =
  VAR chw: X.Window;
  BEGIN
    IF NOT ch.nwValid THEN
      ch.nwValid := X.XTranslateCoordinates(
                      trsl.dpy, ch.w, st.root, 0, 0, ADR(ch.nw.h),
                      ADR(ch.nw.v), ADR(chw)) # X.False
    END
  END ValidateNW;

PROCEDURE <A NAME="GetDomain"><procedure>GetDomain</procedure></A> (ur: Child; VAR (*OUT*) width, height: CARDINAL) =
  (* Return the domain of ur's X window, or 0,0 when the window is
     unmapped, and clear ur.reshapeComing.  LL = ur.ch.parent *)
  BEGIN
    IF ur.mapped THEN
      width := ur.width;
      height := ur.height
    ELSE
      width := 0;
      height := 0
    END;
    ur.reshapeComing := FALSE
  END GetDomain;

PROCEDURE <A NAME="AdjustCoverage"><procedure>AdjustCoverage</procedure></A> (xcon: T; d: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure} =
  BEGIN
    INC(xcon.coverage, d);
    IF xcon.coverage = 0 THEN X.XFlush(xcon.dpy) END;
    IF X.XEventsQueued(xcon.dpy, X.QueuedAfterReading) # 0 THEN
      Thread.Signal(xcon.qNonEmpty)
    END
  END AdjustCoverage;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (trsl: XClient.T; ch: VBT.T; ur: Child) RAISES {} =
  VAR
    junk: REFANY;
    code         := VBT.Deleted;
  BEGIN
    IF ur = NIL THEN RETURN END;
    LOCK trsl DO
      EVAL trsl.vbts.delete(ur.w, junk);
      FOR s := FIRST(trsl.sel^) TO LAST(trsl.sel^) DO
        IF trsl.sel[s].v = ch THEN trsl.sel[s].v := NIL END
      END;
      IF trsl.dead THEN code := VBT.Disconnected END;
      ur.xcage := X.None
    END;
    ProperSplit.Delete(trsl, ur);
    VBTClass.Misc(ch, VBT.MiscRec{code, VBT.NullDetail, 0, VBT.NilSel});
    VBT.Discard(ch)
  END Delete;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (ch: VBT.T; width, height: CARDINAL; sendMoved := FALSE) =
  (* Reshape ch to new width and height.  If this is a no-op, but sendMoved
     is true, then send a miscellaneous code.  LL = VBT.mu *)
  BEGIN
    IF (ch.domain.east # width) OR (ch.domain.south # height) THEN
      WITH new = Rect.FromSize(width, height) DO
        VBTClass.Reshape(ch, new, Rect.Meet(ch.domain, new))
      END
    ELSIF sendMoved THEN
      VBTClass.Misc(
        ch, VBT.MiscRec{VBT.Moved, VBT.NullDetail, 0, VBT.NilSel})
    END
  END Reshape;
</PRE> ---------- connection management ---------- 

<P><PRE>TYPE
  DpyTable = REF ARRAY OF
                   RECORD
                     dpy : X.DisplayStar;
                     trsl: T
                   END;

VAR
  errMu := NEW(MUTEX);          (* LL &gt; any VBT. *)
  (* protection = errMu *)
  dpyTable, hackDpyTable: DpyTable := NIL;
</PRE><BLOCKQUOTE><EM> maps dpys and hack dpys to their corresponding Ts. </EM></BLOCKQUOTE><PRE>

VAR
  openMu    := NEW(MUTEX);      (* LL maximal *)
  opening   := FALSE;
  firstTime := TRUE;

PROCEDURE <A NAME="Connect"><procedure>Connect</procedure></A> (inst: TEXT; trsl: T := NIL): Trestle.T
  RAISES {TrestleComm.Failure} =
  VAR
    dpy, hackdpy : X.DisplayStar := NIL;
    cpos         : INTEGER;
    machine, rest: TEXT;
  BEGIN
    IF inst = NIL THEN inst := Env.Get(&quot;DISPLAY&quot;); END;
    IF inst = NIL THEN inst := &quot;:0&quot; END;
    cpos := Text.FindChar(inst, ':');
    IF cpos &gt; 0 AND Text.Length(inst) &gt; cpos + 1
         AND Text.GetChar(inst, cpos + 1) IN Char.Digits THEN
      machine := Text.Sub(inst, 0, cpos);
      rest := Text.Sub(inst, cpos, 999999);
      WITH s  = M3toC.TtoS(machine),
           he = Unetdb.gethostbyname(s) DO
        IF he # NIL THEN
          machine := M3toC.CopyStoT(he.h_name);
          inst := Text.Cat(machine, rest)
        END;
      END
    END;
    WITH s = M3toC.TtoS(inst) DO
      TRY
        LOCK openMu DO
          IF firstTime THEN
            firstTime := FALSE;
            EVAL Thread.Fork(NEW(InitClosure))
          END;
          opening := TRUE
        END;
        dpy := X.XOpenDisplay(s);
        IF doHack THEN
          TRY
            hackdpy := X.XOpenDisplay(s)
          EXCEPT
            TrestleComm.Failure =&gt; hackdpy := NIL
          END
        END
      FINALLY
        LOCK openMu DO opening := FALSE END;
      END
    END;
    IF dpy = NIL THEN
      IF hackdpy = NIL THEN
        RAISE TrestleComm.Failure
      ELSE
        dpy := hackdpy;
        hackdpy := NIL
      END
    END;
    IF trsl = NIL THEN trsl := NEW(T) END;
    trsl.dpy := dpy;
    IF trsl.st = NIL THEN trsl.st := NEW(VBT.ScreenType) END;
    trsl.inst := inst;
    (* The st is irrelevant except that it must be non-NIL so that marking
       the trsl for redisplay is not a noop. *)
    trsl.gcCursor := X.None;
    TrestleOnX.Enter(trsl);
    TRY
      LOCK errMu DO
        WITH table = dpyTable,
             hack  = hackDpyTable DO
          IF table = NIL THEN
            table := NEW(DpyTable, 1);
            IF doHack THEN hack := NEW(DpyTable, 1) END
          ELSE
            WITH new = NEW(DpyTable, NUMBER(table^) + 1) DO
              FOR i := 0 TO LAST(table^) DO new[i + 1] := table[i] END;
              table := new
            END;
            IF doHack AND hackdpy # NIL THEN
              WITH new = NEW(DpyTable, NUMBER(hack^) + 1) DO
                FOR i := 0 TO LAST(hack^) DO new[i + 1] := hack[i] END;
                hack := new
              END
            END
          END;
          table[0].trsl := trsl;
          table[0].dpy := trsl.dpy;
          IF doHack AND hackdpy # NIL THEN
            hack[0].trsl := trsl;
            hack[0].dpy := hackdpy
          END
        END
      END;
      trsl.sel := NEW(SelArray, 0);
      trsl.vbts := NEW(IntRefTbl.Default).init();
      trsl.atoms := NEW(IntTextTbl.Default).init();
      trsl.names := NEW(TextIntTbl.Default).init();
      SetUngrabs(trsl);
      trsl.evc := NEW(Thread.Condition);
      trsl.qEmpty := NEW(Thread.Condition);
      trsl.qNonEmpty := NEW(Thread.Condition);
      trsl.defaultScreen := X.XDefaultScreen(trsl.dpy);
      trsl.screens :=
        NEW(REF ARRAY OF XScreenType.T, X.XScreenCount(trsl.dpy));
      trsl.takeFocus := XClient.ToAtom(trsl, &quot;WM_TAKE_FOCUS&quot;);
      trsl.wmMoved := XClient.ToAtom(trsl, &quot;WM_MOVED&quot;);
      trsl.decTakeFocus := XClient.ToAtom(trsl, &quot;DEC_WM_TAKE_FOCUS&quot;);
      trsl.protocols := XClient.ToAtom(trsl, &quot;WM_PROTOCOLS&quot;);
      trsl.deleteWindow := XClient.ToAtom(trsl, &quot;WM_DELETE_WINDOW&quot;);
      trsl.miscAtom := XClient.ToAtom(trsl, &quot;_DEC_TRESTLE_MISCCODE&quot;);
      trsl.paNewScreen := XClient.ToAtom(trsl, &quot;_PALO_ALTO_NEW_SCREEN&quot;);
      trsl.paNewDisplay := XClient.ToAtom(trsl, &quot;_PALO_ALTO_NEW_DISPLAY&quot;);
      trsl.paAddDisplay := XClient.ToAtom(trsl, &quot;_PALO_ALTO_ADD_DISPLAY&quot;);
      XProperties.ExtendSel(trsl.sel, VBT.Target);
      trsl.sel[VBT.Target.sel].name := XClient.ToAtom(trsl, &quot;SECONDARY&quot;);
      XProperties.ExtendSel(trsl.sel, VBT.Source);
      trsl.sel[VBT.Source.sel].name := XClient.ToAtom(trsl, &quot;PRIMARY&quot;);
      XProperties.ExtendSel(trsl.sel, VBT.KBFocus);
      trsl.sel[VBT.KBFocus.sel].name := X.None;
      FixForOpenWin(trsl);
      IF hackdpy # NIL THEN
        TRY
          trsl.gcCursor := X.XCreateFontCursor(hackdpy, 142 (*X.XC_trek*));
          IF trsl.gcCursor # X.None THEN
            VAR bg, fg: X.XColor;
            BEGIN
              bg.red := 65535;
              bg.green := 65535;
              bg.blue := 65535;
              bg.flags := X.DoRed + X.DoGreen + X.DoBlue;
              fg.red := 65535;
              fg.green := 0;
              fg.blue := 0;
              fg.flags := X.DoRed + X.DoGreen + X.DoBlue;
              X.XRecolorCursor(hackdpy, trsl.gcCursor, ADR(fg), ADR(bg))
            END
          END
        EXCEPT
          TrestleComm.Failure =&gt; trsl.gcCursor := X.None
        END
      END;
    FINALLY
      TrestleOnX.Exit(trsl, 1)
    END;
    FOR i := 0 TO LAST(trsl.screens^) DO
      trsl.screens[i] := XScreenType.New(trsl, trsl.dpy, i)
    END;
    XInput.Start(trsl);
    XMessenger.Start(trsl);
    TrestleOnX.Enter(trsl);
    TRY
      FOR i := 0 TO LAST(trsl.screens^) DO
        X.XSelectInput(trsl.dpy, trsl.screens[i].root, X.EnterWindowMask)
      END
    FINALLY
      TrestleOnX.Exit(trsl, -1)
    END;
    RETURN trsl
  END Connect;

PROCEDURE <A NAME="FixForOpenWin"><procedure>FixForOpenWin</procedure></A> (trsl: T) RAISES {TrestleComm.Failure} =
  VAR
    selAtom := XClient.ToAtom(trsl, &quot;_SUN_QUICK_SELECTION_KEY_STATE&quot;);
    dupAtom := XClient.ToAtom(trsl, &quot;DUPLICATE&quot;);
    w       := X.XRootWindow(trsl.dpy, X.XDefaultScreen(trsl.dpy));
    type                  : X.Atom            := X.None;
    format, len, remaining: INTEGER;
    data                  : UNTRACED REF CHAR;
  BEGIN
    EVAL X.XGetWindowProperty(
           trsl.dpy, w, selAtom, 0, 1, X.False, X.AnyPropertyType,
           ADR(type), ADR(format), ADR(len), ADR(remaining), ADR(data));
    IF type = X.None THEN
      X.XChangeProperty(trsl.dpy, w, selAtom, 4 (*atom*), 32,
                        X.PropModeReplace, ADR(dupAtom), 1)
    END
  END FixForOpenWin;

PROCEDURE <A NAME="DoConnect"><procedure>DoConnect</procedure></A> (&lt;*UNUSED*&gt; self     : TrestleClass.ConnectClosure;
                                inst     : TEXT;
                     &lt;*UNUSED*&gt; localOnly: BOOLEAN;
                     VAR (*OUT*) t: Trestle.T): BOOLEAN =
  BEGIN
    TRY
      t := Connect(inst);
      RETURN TRUE
    EXCEPT
      TrestleComm.Failure =&gt; t := NIL; RETURN FALSE
    END
  END DoConnect;

CONST
  Ungrab = ARRAY [0 .. 12] OF
             INTEGER{
             KeyboardKey.Caps_Lock, KeyboardKey.Shift_Lock,
             KeyboardKey.Meta_L, KeyboardKey.Meta_R, KeyboardKey.Alt_L,
             KeyboardKey.Alt_R, KeyboardKey.Super_L, KeyboardKey.Super_R,
             KeyboardKey.Hyper_L, KeyboardKey.Hyper_R,
             KeyboardKey.Scroll_Lock, KeyboardKey.Kana_Lock,
             KeyboardKey.Num_Lock};

PROCEDURE <A NAME="IOError"><procedure>IOError</procedure></A> (dpy: X.DisplayStar): Ctypes.Int
  RAISES {TrestleComm.Failure} =
  VAR
    trsl : T := NIL;
    found    := FALSE;
  BEGIN
    IF doHack AND hackDpyTable # NIL THEN
      FOR i := 0 TO LAST(hackDpyTable^) DO
        IF dpy = hackDpyTable[i].dpy THEN RAISE TrestleComm.Failure END
      END
    END;
    LOCK errMu DO
      IF dpyTable # NIL THEN
        FOR i := 0 TO LAST(dpyTable^) DO
          IF dpyTable[i].dpy = dpy THEN
            trsl := dpyTable[i].trsl;
            found := TRUE;
            EXIT
          END
        END
      END
    END;
    IF trsl # NIL AND NOT trsl.dead THEN
      Kill(trsl)
    ELSIF NOT found THEN
      LOCK openMu DO IF NOT opening THEN RETURN iohandler(dpy) END END
    END;
    RAISE TrestleComm.Failure
  END IOError;

PROCEDURE <A NAME="Error"><procedure>Error</procedure></A> (dpy: X.DisplayStar; errEv: X.XErrorEventStar):
  Ctypes.Int =
  VAR
    trsl : T        := NIL;
    ev   : X.XEvent;
    found           := FALSE;
  BEGIN
    IF doHack AND hackDpyTable # NIL THEN
      FOR i := 0 TO LAST(hackDpyTable^) DO
        IF dpy = hackDpyTable[i].dpy THEN RETURN 0 END
      END
    END;
    WITH evp = LOOPHOLE(ADR(ev), X.XErrorEventStar) DO evp^ := errEv^ END;
    LOCK errMu DO
      IF dpyTable = NIL THEN RETURN ehandler(dpy, errEv) END;
      FOR i := 0 TO LAST(dpyTable^) DO
        IF dpyTable[i].dpy = dpy THEN
          trsl := dpyTable[i].trsl;
          found := TRUE;
          EXIT
        END
      END
    END;
    IF trsl # NIL THEN
      BackDoor(trsl, ev);
      RETURN 0
    ELSIF NOT found THEN
      RETURN ehandler(dpy, errEv)
    ELSE
      RETURN 0
    END;
  END Error;

VAR
  doHack := NOT RTParams.IsPresent(&quot;StarTrek&quot;)
              AND NOT ((RTCollectorSRC.incremental AND RTHeapDep.VM
                          AND RTHeapRep.disableVMCount = 0));
</PRE><BLOCKQUOTE><EM> If doHack is TRUE, XClient will change the cursor of every installed
   window to the Star Trek cursor whenever the garbage collector is
   running.  At runtime, you can force no StarTrek cursor by running your
   program @M3StarTrek. </EM></BLOCKQUOTE><PRE>

TYPE
  GCClosure = RTHeapRep.MonitorClosure OBJECT
              OVERRIDES
                before := HackOn;
                after  := HackOff
              END;

TYPE InitClosure = Thread.Closure OBJECT OVERRIDES apply := DoHackInit END;

PROCEDURE <A NAME="DoHackInit"><procedure>DoHackInit</procedure></A> (&lt;*UNUSED*&gt; self: InitClosure): REFANY =
  BEGIN
    IF doHack THEN RTHeapRep.RegisterMonitor(NEW(GCClosure)) END;
    RETURN NIL
  END DoHackInit;

VAR hacking := FALSE;

PROCEDURE <A NAME="HackOn"><procedure>HackOn</procedure></A> (&lt;*UNUSED*&gt; cl: GCClosure) =
  BEGIN
    IF NOT ((RTCollectorSRC.incremental AND RTHeapDep.VM
               AND RTHeapRep.disableVMCount = 0)) THEN
      HackToggle(TRUE);
      hacking := TRUE
    END
  END HackOn;

PROCEDURE <A NAME="HackOff"><procedure>HackOff</procedure></A> (&lt;*UNUSED*&gt; cl: GCClosure) =
  BEGIN
    IF hacking THEN HackToggle(FALSE); hacking := FALSE END
  END HackOff;

PROCEDURE <A NAME="HackToggle"><procedure>HackToggle</procedure></A> (on: BOOLEAN) =
  &lt;*FATAL Split.NotAChild*&gt;
  VAR dead: BOOLEAN;
  BEGIN
    IF hackDpyTable = NIL THEN RETURN END;
    FOR i := 0 TO LAST(hackDpyTable^) DO
      WITH dpy  = hackDpyTable[i].dpy,
           trsl = hackDpyTable[i].trsl DO
        dead := dpy # NIL;
        IF dpy # NIL AND trsl # NIL AND NOT trsl.dead THEN
          TRY
            VAR v := Split.Succ(trsl, NIL);
            BEGIN
              WHILE v # NIL DO
                VAR ur: Child := v.upRef;
                BEGIN
                  IF ur # NIL AND ur.w # X.None AND ur.xcage # X.None THEN
                    IF on THEN
                      X.XDefineCursor(dpy, ur.w, trsl.gcCursor)
                    ELSE
                      X.XDefineCursor(dpy, ur.w, ur.csid)
                    END
                  END
                END;
                v := Split.Succ(trsl, v)
              END
            END;
            X.XSync(dpy, X.True);
            dead := FALSE
          EXCEPT
            TrestleComm.Failure =&gt; (* skip *)
          END
        END;
        IF dead THEN
          TRY
            X.XCloseDisplay(dpy)
          EXCEPT
            TrestleComm.Failure =&gt; (* skip *)
          END;
          dpy := NIL
        END
      END
    END
  END HackToggle;

VAR
  ehandler  := X.XSetErrorHandler(Error);
  iohandler := X.XSetIOErrorHandler(LOOPHOLE(IOError, X.XIOErrorHandler));

BEGIN
END XClientF.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unetdb is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unetdb.i3#0TOP0">unix/src/aix-3-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unetdb.i3#0TOP0">unix/src/aix-ps2-1-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unetdb.i3#0TOP0">unix/src/freebsd-1/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unetdb.i3#0TOP0">unix/src/freebsd-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unetdb.i3#0TOP0">unix/src/hpux-7-0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unetdb.i3#0TOP0">unix/src/ibm-4-3/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unetdb.i3#0TOP0">unix/src/irix-5.2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/linux/Unetdb.i3#0TOP0">unix/src/linux/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Unetdb.i3#0TOP0">unix/src/osf-1.generic/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unetdb.i3#0TOP0">unix/src/solaris-2-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unetdb.i3#0TOP0">unix/src/sunos-4-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unetdb.i3#0TOP0">unix/src/sysv-4.0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Unetdb.i3#0TOP0">unix/src/ultrix-3-1.generic/Unetdb.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
