<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/TrestleOS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/TrestleOS.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           

<P><PRE>UNSAFE MODULE <module><implements><A HREF="../trestle/TrestleOS.i3">TrestleOS</A></implements></module>;

IMPORT <A HREF="XClient.i3">XClient</A>, <A HREF="#x1">Uutmp</A>, <A HREF="#x2">Uugid</A>, <A HREF="#x3">Upwd</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../../params/src/Env.i3">Env</A>;

VAR mu := NEW(MUTEX);
    inited := FALSE;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    LOCK mu DO IF NOT inited THEN XClient.Init(); inited := TRUE END END
  END Init;

PROCEDURE <A NAME="UserName"><procedure>UserName</procedure></A> (): TEXT =
  VAR res: TEXT;
  BEGIN
    res := Env.Get(&quot;USER&quot;);
    IF res = NIL THEN
      VAR logname := Uutmp.getlogin();
      BEGIN
        IF logname # NIL THEN
          res := M3toC.CopyStoT(logname)
        ELSE
          VAR pwent := Upwd.getpwuid(Uugid.geteuid());
          BEGIN
            IF pwent # NIL THEN
              res := M3toC.CopyStoT(pwent.pw_name)
            ELSE
              res := &quot;Unknown user&quot;
            END
          END
        END
      END
    END;
    RETURN res
  END UserName;

BEGIN
END TrestleOS.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Uutmp is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uutmp.i3#0TOP0">unix/src/aix-3-2/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uutmp.i3#0TOP0">unix/src/aix-ps2-1-2/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uutmp.i3#0TOP0">unix/src/freebsd-1/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uutmp.i3#0TOP0">unix/src/freebsd-2/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uutmp.i3#0TOP0">unix/src/hpux-7-0/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uutmp.i3#0TOP0">unix/src/ibm-4-3/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uutmp.i3#0TOP0">unix/src/irix-5.2/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/linux/Uutmp.i3#0TOP0">unix/src/linux/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uutmp.i3#0TOP0">unix/src/osf-1.generic/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uutmp.i3#0TOP0">unix/src/solaris-2-x/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uutmp.i3#0TOP0">unix/src/sunos-4-x/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uutmp.i3#0TOP0">unix/src/sysv-4.0/Uutmp.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uutmp.i3#0TOP0">unix/src/ultrix-3-1.generic/Uutmp.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uugid is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uugid.i3#0TOP0">unix/src/aix-3-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uugid.i3#0TOP0">unix/src/aix-ps2-1-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uugid.i3#0TOP0">unix/src/freebsd-1/Uugid.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uugid.i3#0TOP0">unix/src/freebsd-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uugid.i3#0TOP0">unix/src/hpux-7-0/Uugid.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uugid.i3#0TOP0">unix/src/ibm-4-3/Uugid.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uugid.i3#0TOP0">unix/src/irix-5.2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/linux/Uugid.i3#0TOP0">unix/src/linux/Uugid.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uugid.i3#0TOP0">unix/src/osf-1.generic/Uugid.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uugid.i3#0TOP0">unix/src/solaris-2-x/Uugid.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uugid.i3#0TOP0">unix/src/sunos-4-x/Uugid.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uugid.i3#0TOP0">unix/src/sysv-4.0/Uugid.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uugid.i3#0TOP0">unix/src/ultrix-3-1.generic/Uugid.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Upwd is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Upwd.i3#0TOP0">unix/src/aix-3-2/Upwd.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Upwd.i3#0TOP0">unix/src/aix-ps2-1-2/Upwd.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Upwd.i3#0TOP0">unix/src/freebsd-1/Upwd.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Upwd.i3#0TOP0">unix/src/freebsd-2/Upwd.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Upwd.i3#0TOP0">unix/src/hpux-7-0/Upwd.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Upwd.i3#0TOP0">unix/src/ibm-4-3/Upwd.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Upwd.i3#0TOP0">unix/src/irix-5.2/Upwd.i3</A>
<LI><A HREF="../../../unix/src/linux/Upwd.i3#0TOP0">unix/src/linux/Upwd.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Upwd.i3#0TOP0">unix/src/osf-1.generic/Upwd.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Upwd.i3#0TOP0">unix/src/solaris-2-x/Upwd.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Upwd.i3#0TOP0">unix/src/sunos-4-x/Upwd.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Upwd.i3#0TOP0">unix/src/sysv-4.0/Upwd.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Upwd.i3#0TOP0">unix/src/ultrix-3-1.generic/Upwd.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
