<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/TrestleOnX.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/TrestleOnX.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE INTERFACE <interface><A HREF="TrestleOnX.m3">TrestleOnX</A></interface>;

IMPORT <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE <A HREF="XPaint.i3#Display">Display</A> &lt;: Trestle.T;

PROCEDURE <A HREF="TrestleOnX.m3#Dpy">Dpy</A> (t: Display): X.DisplayStar;
</PRE><BLOCKQUOTE><EM> You must use Lock and Unlock (see below) around any calls which
   manipulate the dpy.  If Lock raises an exception, you must not call any
   X procedures using that dpy.  Any X procedure can raise the
   TrestleComm.Failure exception; once that happens, you must not call any
   X procedures. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TrestleOnX.m3#Drawable">Drawable</A> (v: VBT.T): X.Drawable; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the window id associated with a VBT (or X.None) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TrestleOnX.m3#Cage">Cage</A> (v: VBT.T): X.Window; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the window id of the cage window for a VBT (or X.None) </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="TrestleOnX.m3#Enter">Enter</A> (t: Display) RAISES {TrestleComm.Failure};
</PRE><BLOCKQUOTE><EM> Lock t.  The exception is raised when the X connection is closed.</EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="TrestleOnX.m3#Exit">Exit</A> (t: Display; deltaCoverage: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure};
</PRE><BLOCKQUOTE><EM> Release the lock on t, after possibly flushing the queue of pending
   operations.
<P>
   Each t: T contains a cardinal t.coverage, which is incremented by
   deltaCoverage as the Exit happens.  If the result is zero, the x
   connection is flushed.  A thread making a sequence of calls to
   Enter/Exit can minimize unnecessary flushing by setting deltaCoverage to
   +1 on the first exit, to -1 on the last exit, and to 0 on the other
   exits.
<P>
   LL = t. </EM></BLOCKQUOTE><PRE>

TYPE EventProc = PROCEDURE (t: Display; READONLY ev: X.XEvent);

PROCEDURE <A HREF="TrestleOnX.m3#EventHook">EventHook</A> (t: Display; p: EventProc): EventProc; &lt;* LL.sup = t *&gt;
</PRE><BLOCKQUOTE><EM> This procedure will be called with all events received on the connection
   t which Trestle doesn't want to handle.  This means all events received
   on windows not created by Trestle, or root windows, and certain events
   received on Trestle windows.  The old EventHook is returned; if non-NIL,
   you should pass on any events that you can't handle. </EM></BLOCKQUOTE><PRE>

VAR Visibility: VBT.MiscCodeType;

CONST
  VisibilityUnobscured        = 0;
  VisibilityPartiallyObscured = 1;
  VisibilityFullyObscured     = 2;
</PRE> When a VBT installed on X changes X visibility state, it receives a
   miscellaneous code with codetype Visibility.  The first element of
   the detail field of the misc code reflects whether the window has
   become fully obscured, partially visible, or fully unobscured.
   Note that X is idiosyncratic in that no obscured message occurs
   when a window is iconified; you'll have to rely on noting that the
   VBT domain has just become empty, instead. 

<P><PRE>END TrestleOnX.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
