<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/TrestleOnX.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/TrestleOnX.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module>TrestleOnX</module> EXPORTS <A HREF="TrestleOnX.i3"><implements>TrestleOnX</A></implements>, <A HREF="TrslOnXF.i3"><implements>TrslOnXF</A></implements>;

IMPORT <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="XClientF.i3">XClientF</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>;

PROCEDURE <A NAME="Dpy"><procedure>Dpy</procedure></A> (t: Display): X.DisplayStar =
  BEGIN
    RETURN t.dpy
  END Dpy;

PROCEDURE <A NAME="Drawable"><procedure>Drawable</procedure></A> (v: VBT.T): X.Drawable =
  BEGIN
    LOOP
      IF v = NIL THEN RETURN X.None END;
      TYPECASE v.upRef OF
        XClientF.Child (ch) =&gt; IF ch # NIL THEN RETURN ch.w END
      ELSE                      (* skip *)
      END;
      v := v.parent
    END
  END Drawable;

PROCEDURE <A NAME="Cage"><procedure>Cage</procedure></A> (v: VBT.T): X.Drawable =
  BEGIN
    LOOP
      IF v = NIL THEN RETURN X.None END;
      TYPECASE v.upRef OF
        XClientF.Child (ch) =&gt; IF ch # NIL THEN RETURN ch.xcage END
      ELSE                      (* skip *)
      END;
      v := v.parent
    END
  END Cage;

PROCEDURE <A NAME="EventHook"><procedure>EventHook</procedure></A> (t: Display; p: EventProc): EventProc =
  VAR res := t.eventHook;
  BEGIN
    t.eventHook := p;
    RETURN res
  END EventHook;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A> (t: Display) RAISES {TrestleComm.Failure} =
  BEGIN
    Thread.Acquire(t);
    IF t.dead THEN Thread.Release(t); RAISE TrestleComm.Failure END
  END Enter;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (t: Display; deltaCoverage: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure} =
  BEGIN
    TRY
      IF t.dead THEN RAISE TrestleComm.Failure END;
      XClientF.AdjustCoverage(t, deltaCoverage)
    FINALLY
      Thread.Release(t)
    END
  END Exit;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>() =
  BEGIN
    Visibility := VBT.GetMiscCodeType(&quot;Visibility&quot;);
  END Init;

BEGIN
END TrestleOnX.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
