<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XAtomQueue.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XAtomQueue.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XAtomQueue.i3">XAtomQueue</A></implements></module>;

IMPORT <A HREF="../../../X11R4/src/Common/X.i3">X</A>;

CONST NormalQSize = 4;

&lt;*INLINE*&gt; PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY rb: T): BOOLEAN =
  BEGIN
    RETURN rb.lo = rb.hi
  END IsEmpty;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (VAR rb: T; READONLY e: X.Atom) =
  BEGIN
    IF rb.buff = NIL THEN
      rb.buff := NEW(REF ARRAY OF X.Atom, NormalQSize)
    END;
    rb.buff[rb.hi] := e;
    INC(rb.hi);
    WITH n = NUMBER(rb.buff^) DO
      IF rb.hi = n THEN rb.hi := 0 END;
      IF rb.hi = rb.lo THEN
        WITH new = NEW(REF ARRAY OF X.Atom, 2 * n) DO
          FOR i := rb.lo TO n - 1 DO new[i] := rb.buff[i] END;
          FOR i := 0 TO rb.hi - 1 DO new[i + n] := rb.buff[i] END;
          INC(rb.hi, n);
          rb.buff := new
        END
      END
    END
  END Insert;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (VAR rb: T): X.Atom RAISES {Exhausted} =
  VAR res: X.Atom;
  BEGIN
    IF rb.lo = rb.hi THEN RAISE Exhausted END;
    res := rb.buff[rb.lo];
    WITH n = NUMBER(rb.buff^) DO
      INC(rb.lo);
      IF rb.lo = n THEN rb.lo := 0 END;
      IF (rb.lo = rb.hi) AND (n &gt; NormalQSize) THEN rb := Empty END
    END;
    RETURN res
  END Remove;

BEGIN
END XAtomQueue.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
