<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XInput.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XInput.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XInput.i3">XInput</A></implements></module>;

IMPORT <A HREF="XClient.i3">XClient</A>, <A HREF="XClientF.i3">XClientF</A>, <A HREF="XEventQueue.i3">XEventQueue</A>, <A HREF="XScrollQueue.i3">XScrollQueue</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>,
       <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="#x1">Unix</A>, <A HREF="../../../thread/src/POSIX/SchedulerPosix.i3">SchedulerPosix</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>,
       <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> (trsl: XClient.T; stackSize := 20000) =
  BEGIN
    EVAL
      Thread.Fork(
        NEW(WaitForXInputClosure, xcon := trsl, stackSize := stackSize));
    EVAL Thread.Fork(
           NEW(FilterXInputClosure, xcon := trsl, stackSize := stackSize));
  END Start;

TYPE
  WaitForXInputClosure = Thread.SizedClosure OBJECT
                           xcon: XClient.T
                         OVERRIDES
                           apply := WaitForXInput
                         END;

PROCEDURE <A NAME="WaitForXInput"><procedure>WaitForXInput</procedure></A> (self: WaitForXInputClosure): REFANY RAISES {} =
  VAR
    checkIfClosed          := FALSE;
    n            : INTEGER;
  BEGIN
    TRY
      WITH xcon = self.xcon,
           dpy  = xcon.dpy,
           file = X.XConnectionNumber(dpy) DO
        LOOP
          LOCK xcon DO
            WHILE (X.XEventsQueued(dpy, X.QueuedAfterReading) # 0)
                    AND NOT xcon.dead DO
              checkIfClosed := FALSE;
              Thread.Signal(xcon.qNonEmpty);
              Thread.Wait(xcon, xcon.qEmpty)
            END;
            IF xcon.dead THEN EXIT END;
            IF checkIfClosed THEN
              IF (SchedulerPosix.IOWait(file, TRUE, 0.0D0)
                    # SchedulerPosix.WaitResult.Timeout)
                   AND (Unix.ioctl(file, Unix.FIONREAD, ADR(n)) &lt; 0
                          OR n = 0) THEN
                XClientF.Kill(xcon);
                EXIT
              END
            END
          END;
          EVAL SchedulerPosix.IOWait(file, TRUE);
          checkIfClosed := TRUE
        END
      END
    EXCEPT
      X.Error =&gt; (* skip *)
    END;
    RETURN NIL
  END WaitForXInput;

TYPE
  FilterXInputClosure = Thread.SizedClosure OBJECT
                          xcon: XClient.T
                        OVERRIDES
                          apply := FilterXInput
                        END;

PROCEDURE <A NAME="FilterXInput"><procedure>FilterXInput</procedure></A> (self: FilterXInputClosure): REFANY RAISES {} =
  VAR
    evRec  : X.XEvent;
    ev     := LOOPHOLE(ADR(evRec), X.XAnyEventStar);
    waiter : XClientF.WaitFor;
    ra     : REFANY;
    enqueue: BOOLEAN;
    v      : VBT.T;
    popped := FALSE;             (* = in the middle of a sequence of
                                    GraphicsExpose *)
    ur  : XClientF.Child;
    xcon                 := self.xcon;
    dpy                  := xcon.dpy;
  &lt;*FATAL XEventQueue.Exhausted*&gt;
  BEGIN
    TRY
      LOCK xcon DO
        LOOP
          WHILE (X.XEventsQueued(dpy, X.QueuedAfterReading) = 0)
                  AND NOT xcon.dead AND XEventQueue.IsEmpty(xcon.errq)
                  AND XEventQueue.IsEmpty(xcon.ooq) DO
            Thread.Signal(xcon.qEmpty);
            Thread.Wait(xcon, xcon.qNonEmpty)
          END;
          IF xcon.dead THEN EXIT END;
          IF NOT XEventQueue.IsEmpty(xcon.errq) THEN
            evRec := XEventQueue.Remove(xcon.errq)
          ELSIF XEventQueue.IsEmpty(xcon.ooq) THEN
            X.XNextEvent(dpy, ADR(evRec))
          ELSIF X.XEventsQueued(dpy, X.QueuedAlready) = 0 THEN
            evRec := XEventQueue.Remove(xcon.ooq)
          ELSE
            VAR
              ooevr                  := XEventQueue.Peek(xcon.ooq);
              ooev := LOOPHOLE(ADR(ooevr), X.XAnyEventStar);
            BEGIN
              X.XPeekEvent(dpy, ADR(evRec));
              IF Word.Minus(ev.serial, ooev.serial) &lt; 0 THEN
                X.XNextEvent(dpy, ADR(evRec))
              ELSE
                evRec := XEventQueue.Remove(xcon.ooq)
              END
            END
          END;
          IF (ev.type # 0) AND xcon.vbts.get(ev.window, ra) THEN
            v := ra;
            ur := v.upRef
          ELSE
            v := NIL;
            ur := NIL
          END;
          waiter := XClientF.FindWaiter(xcon, evRec);
          CASE ev.type OF
            X.KeyPress, X.KeyRelease =&gt;
              WITH e = LOOPHOLE(ev, X.XKeyEventStar) DO
                IF (ur # NIL) AND NOT ur.nwValid
                     AND (e.same_screen # X.False) THEN
                  ur.nw.h := e.x_root - e.x;
                  ur.nw.v := e.y_root - e.y;
                  ur.nwValid := TRUE
                END
              END;
              enqueue := ur # NIL
          | X.ButtonPress, X.ButtonRelease =&gt;
              WITH e = LOOPHOLE(ev, X.XButtonEventStar) DO
                IF ur # NIL AND e.same_screen # X.False THEN
                  IF NOT ur.nwValid THEN
                    ur.nw.h := e.x_root - e.x;
                    ur.nw.v := e.y_root - e.y;
                    ur.nwValid := TRUE
                  END;
                  IF ur.inside THEN
                    e.subwindow := ur.w
                  ELSE
                    e.subwindow := X.None
                  END
                END
              END;
              enqueue := ur # NIL
          | X.EnterNotify, X.LeaveNotify =&gt;
              WITH e = LOOPHOLE(ev, X.XCrossingEventStar) DO
                IF (ur # NIL) AND NOT ur.nwValid
                     AND (e.same_screen # X.False) THEN
                  ur.nw.h := e.x_root - e.x;
                  ur.nw.v := e.y_root - e.y;
                  ur.nwValid := TRUE
                END;
                enqueue :=
                  (e.root = e.window AND e.detail # X.NotifyInferior)
                    OR ((ur # NIL)
                          AND ((e.type = X.EnterNotify)
                                 AND (e.detail # X.NotifyVirtual)
                                 AND (e.detail # X.NotifyNonlinearVirtual)
                                 OR (e.type = X.LeaveNotify)
                                      AND (e.detail # X.NotifyInferior)));
                IF ur # NIL THEN
                  ur.inside :=
                    e.type = X.EnterNotify OR e.detail = X.NotifyInferior;
                  IF NOT ur.inside THEN ur.recentlyOutside := TRUE END;
                  ur.underXFocus := e.focus # X.False
                END;
              END
          | X.MotionNotify =&gt;
              WITH e = LOOPHOLE(ev, X.XMotionEventStar) DO
                IF (ur # NIL) AND NOT ur.nwValid
                     AND (e.same_screen # X.False) THEN
                  ur.nw.h := e.x_root - e.x;
                  ur.nw.v := e.y_root - e.y;
                  ur.nwValid := TRUE
                END;
              END;
              enqueue := TRUE
          | X.FocusIn, X.FocusOut =&gt;
              WITH e = LOOPHOLE(ev, X.XFocusChangeEventStar) DO
                enqueue := ur # NIL AND e.mode # X.NotifyGrab
                             AND e.mode # X.NotifyUngrab;
                IF enqueue THEN
                  ur.isXFocus :=
                    e.type = X.FocusIn AND e.detail # X.NotifyPointer;
                  ur.underXFocus :=
                    e.type = X.FocusIn OR e.detail = X.NotifyAncestor;
                END
              END
          | X.UnmapNotify =&gt;
              IF (ur # NIL) AND ur.mapped THEN
                enqueue := NOT ur.reshapeComing;
                IF enqueue THEN
                  ur.reshapeComing := TRUE;
                  ur.oldWidth := ur.width;
                  ur.oldHeight := ur.height
                END;
                ur.mapped := FALSE;
                ur.serial := ev.serial
              ELSE
                enqueue := FALSE
              END
          | X.MapNotify =&gt;
              IF (ur # NIL) AND NOT ur.mapped THEN
                enqueue := NOT ur.reshapeComing;
                IF enqueue THEN
                  ur.reshapeComing := TRUE;
                  ur.oldWidth := 0;
                  ur.oldHeight := 0
                END;
                ur.mapped := TRUE;
                ur.serial := ev.serial
              ELSE
                enqueue := FALSE
              END
          | X.ReparentNotify =&gt;
              IF ur # NIL THEN ur.nwValid := FALSE END;
              enqueue := FALSE
          | X.ConfigureNotify =&gt;
              WITH e = LOOPHOLE(ev, X.XConfigureEventStar) DO
                IF ur # NIL THEN
                  IF e.send_event # X.False THEN
                    ur.nw.h := e.x + e.border_width;
                    ur.nw.v := e.y + e.border_width;
                    ur.nwValid := TRUE
                  ELSE
                    ur.nwValid := FALSE
                  END;
                  IF ur.width = e.width AND ur.height = e.height THEN
                    e.send_event := X.True
                  ELSE
                    e.send_event := X.False
                  END;
                  enqueue := NOT ur.reshapeComing AND ur.mapped;
                  IF NOT ur.reshapeComing THEN
                    ur.oldWidth := ur.width;
                    ur.oldHeight := ur.height;
                    ur.reshapeComing := enqueue
                  END;
                  ur.width := e.width;
                  ur.height := e.height;
                  ur.serial := e.serial
                ELSE
                  enqueue := FALSE
                END
              END
          | X.PropertyNotify =&gt; enqueue := FALSE
          | X.GraphicsExpose =&gt;
              enqueue := FALSE;
              IF (waiter = NIL) AND (ur # NIL) THEN
                WITH e = LOOPHOLE(ev, X.XGraphicsExposeEventStar) DO
                  IF NOT popped THEN PopScroll(ur) END;
                  ExpandBadRegion(
                    ur, XClientF.ToRect(e.x, e.y, e.width, e.height));
                  popped := e.count # 0;
                  IF NOT popped THEN enqueue := TRUE END
                END
              END
          | X.NoExpose =&gt;
              IF (waiter = NIL) AND (ur # NIL) THEN PopScroll(ur) END;
              enqueue := FALSE
          | X.Expose =&gt;
              IF (waiter = NIL) AND (ur # NIL) THEN
                WITH e = LOOPHOLE(ev, X.XExposeEventStar) DO
                  IF e.serial = ur.serial THEN
                    ExpandBadRegion(
                      ur, Rect.Meet(
                            XClientF.ToRect(e.x, e.y, e.width, e.height),
                            Rect.FromSize(ur.oldWidth, ur.oldHeight)))
                  ELSE
                    ExpandBadRegion(
                      ur, XClientF.ToRect(e.x, e.y, e.width, e.height))
                  END;
                  enqueue := e.count = 0
                END
              ELSE
                enqueue := FALSE
              END
          | X.MappingNotify =&gt; enqueue := TRUE
          | X.DestroyNotify, X.SelectionClear, X.ClientMessage,
              X.VisibilityNotify =&gt;
              enqueue := ur # NIL
          ELSE
            enqueue := FALSE
          END;
          IF waiter # NIL THEN
            waiter.notify(evRec, xcon);

            (* waiter.turn := TRUE; waiter.ev := evRec; waiter.timeout :=
               FALSE; Thread.Signal(waiter); WHILE waiter.turn AND NOT
               xcon.dead DO Thread.Wait(xcon, waiter) END *)

            (* selection requests now have a waiter *)
            (* ELSIF ev.type = X.SelectionRequest THEN WITH e =
               LOOPHOLE(ev, X.XSelectionRequestEventStar) DO FOR s :=
               FIRST(xcon.sel^) TO LAST(xcon.sel^) DO IF xcon.sel[s].name =
               e.selection THEN XProperties.StartSelection( xcon,
               e.requestor, e.target, e.property, VBT.Selection{s}, e.time)
               END END END *)
          ELSIF enqueue THEN
            IF XEventQueue.IsEmpty(xcon.evq) THEN
              Thread.Signal(xcon.evc)
            END;
            XEventQueue.Insert(xcon.evq, evRec)
          ELSIF xcon.eventHook # NIL THEN
            xcon.eventHook(xcon, evRec)
          END
        END
      END
    EXCEPT
      X.Error =&gt; (* skip *)
    END;
    RETURN NIL
  END FilterXInput;

PROCEDURE <A NAME="PopScroll"><procedure>PopScroll</procedure></A> (ur: XClientF.Child) =
  (* Remove a scroll from the queue of unacknowleged scrolls in ur.  LL =
     ur.ch.parent *)
  &lt;*FATAL XScrollQueue.Exhausted*&gt;
  BEGIN
    EVAL XScrollQueue.Remove(ur.scrollQ)
  END PopScroll;

PROCEDURE <A NAME="ExpandBadRegion"><procedure>ExpandBadRegion</procedure></A> (ur: XClientF.Child; READONLY br: Rect.T) =
  (* Every x-vbt has an x-bad-region, which this expands.  If you call
     this, you must eventually call DeliverBadRegion.  LL = ur.ch.parent *)
  VAR
    i   := ur.scrollQ.lo;
    bad := Region.FromRect(br);
  BEGIN
    WITH hi   = ur.scrollQ.hi,
         buff = ur.scrollQ.buff DO
      WHILE i # hi DO
        WITH sc = buff[i] DO
          bad := Region.Join(bad, Region.Add(Region.MeetRect(
                                               Rect.Sub(sc.clip, sc.delta),
                                               bad), sc.delta))
        END;
        INC(i);
        IF i = NUMBER(buff^) THEN i := 0 END
      END
    END;
    ur.badR := Region.Join(ur.badR, bad)
  END ExpandBadRegion;

BEGIN
END XInput.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
