<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XPicture.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XPicture.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="XPicture.i3">XPicture</A></implements></module>;

IMPORT <A HREF="../picture/Completion.i3">Completion</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x1">Picture</A>, <A HREF="../picture/PictureRep.i3">PictureRep</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>,
       <A HREF="XClientF.i3">XClientF</A>, <A HREF="XImUtil.i3">XImUtil</A>, <A HREF="XScreenType.i3">XScreenType</A>;
</PRE> New() exported by XPictureFree 

<P><PRE>REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init    := Init;
        destroy := Destroy;
        put     := Put;
      END;

CONST Offset = 0;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (picture      : Picture.T;
                screenType   : VBT.ScreenType;
                width, height: CARDINAL        ): Picture.T
  RAISES {Picture.ScreenTypeNotSupported, Picture.TrestleFail} =
  (* these calculations taken from XShm.c *)

  PROCEDURE BytesPerLine (bitsPerPix, width, bitPad: X.Int): X.Int =
    BEGIN
      WITH nbytes = bitsPerPix * width,
           pad    = bitPad * 8          DO
        RETURN (nbytes + (pad - 1)) DIV (pad * pad); (* roundup *)
      END
    END BytesPerLine;

  VAR t := NARROW(picture, T);
  (* this should have been checked before calling Init *)
  BEGIN
    TYPECASE screenType OF
    | XScreenType.T (st) =&gt;
        TRY
          WITH depth        = X.XDefaultDepth(st.trsl.dpy, st.screenID),
               scanlinePad  = XImUtil.ScanlinePad(st.trsl.dpy, depth),
               bitsPerPixel = XImUtil.BitsPerPixel(st.trsl.dpy, depth),
               ximage = X.XCreateImage(
                          st.trsl.dpy, st.visual, depth, X.ZPixmap, Offset,
                          NIL, width, height, scanlinePad,
                          BytesPerLine(bitsPerPixel, width, scanlinePad)) DO
            IF ximage = NIL THEN RAISE Picture.TrestleFail; END;
            t.allocByCaller := FALSE;
            t.image := LOOPHOLE(ximage, Picture.ImageStar);
            EVAL Picture.T.init(t, screenType, width, height);
            RETURN t;
          END;
        EXCEPT
          X.Error =&gt; RAISE Picture.TrestleFail
        END;
    ELSE
      RAISE Picture.TrestleFail;
    END;
  END Init;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (                    t         : T;
                                   dpy       : X.DisplayStar;
                                   d         : X.Drawable;
                                   gc        : X.GC;
                          READONLY clip      : Rect.T;
                          READONLY delta     : Point.T;
               &lt;*UNUSED*&gt;          completion: Completion.T   )
  RAISES {TrestleComm.Failure} =
  VAR
    image  := LOOPHOLE(t.image, X.XImageStar);
    srcX   := MAX(clip.west - delta.h, 0);
    srcY   := MAX(clip.north - delta.v, 0);
    width  := MIN((clip.east - clip.west), (image.width - srcX));
    height := MIN((clip.south - clip.north), (image.height - srcY));
  BEGIN
    IF width &gt; 0 AND height &gt; 0 THEN
      TRY
        X.XPutImage(dpy, d, gc, image, srcX, srcY, clip.west, clip.north,
                    width, height);
      EXCEPT
        X.Error =&gt; RAISE TrestleComm.Failure;
      END;
      (* the client is Sync'd by Picture.Put after this call *)
    END;
  END Put;

PROCEDURE <A NAME="Destroy"><procedure>Destroy</procedure></A> (t: T) =
  BEGIN
    (* don't free the ximage if it was allocated by someone else. *)
    IF t.image # NIL AND NOT t.allocByCaller THEN
      t.image.data := NIL;       (* XDestroyImage frees the data as well,
                                    but it doesn't belong to us *)
      EVAL t.image.f.destroy_image(LOOPHOLE(t.image, X.XImageStar));
      t.image := NIL;
    END;
  END Destroy;

PROCEDURE <A NAME="MakeImage"><procedure>MakeImage</procedure></A> (screenType    : VBT.ScreenType;
                     width, height : Ctypes.int;
                     xoffset       : Ctypes.int       := 0;
                     bitmap_pad    : Ctypes.int       := 0;
                     bytes_per_line: Ctypes.int       := 0  ):
  Picture.ImageStar
  RAISES {Picture.TrestleFail} =
  BEGIN
    TYPECASE screenType OF
    | XScreenType.T (st) =&gt;
        TRY
          WITH depth = X.XDefaultDepth(st.trsl.dpy, st.screenID),
               ximage = X.XCreateImage(st.trsl.dpy, st.visual, depth,
                                       X.ZPixmap, xoffset, NIL, width,
                                       height, bitmap_pad, bytes_per_line) DO
            IF ximage = NIL THEN RAISE Picture.TrestleFail; END;
            RETURN LOOPHOLE(ximage, Picture.ImageStar);
          END;
        EXCEPT
          X.Error =&gt; RAISE Picture.TrestleFail
        END;
    ELSE
      RAISE Picture.TrestleFail;
    END;
  END MakeImage;

PROCEDURE <A NAME="MakeCompletion"><procedure>MakeCompletion</procedure></A> (&lt;*UNUSED*&gt; picture: T): Completion.T =
  BEGIN
    RETURN Completion.New();
  END MakeCompletion;

BEGIN
END XPicture.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Picture is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="../picture/Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
