<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XProperties.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XProperties.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE INTERFACE <interface><A HREF="XProperties.m3">XProperties</A></interface>;

IMPORT <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="XClient.i3">XClient</A>, <A HREF="XClientF.i3">XClientF</A>;

PROCEDURE <A HREF="XProperties.m3#InitialiseXClient">InitialiseXClient</A> (xcon: XClient.T);
</PRE><BLOCKQUOTE><EM> setup the XClient so it will look out for XSelectionRequest events </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="XProperties.m3#StartSelection">StartSelection</A> (trsl      : XClient.T;
                          w         : X.Window;
                          type, prop: X.Atom;
                          sel       : VBT.Selection;
                          ts        : VBT.TimeStamp;
                          stackSize                   := 20000);

PROCEDURE <A HREF="XProperties.m3#ExtendSel">ExtendSel</A> (VAR sa: XClientF.SelArray; s: VBT.Selection);
PROCEDURE <A HREF="XProperties.m3#ExtendOwns">ExtendOwns</A> (VAR sa: XClientF.OwnsArray; s: VBT.Selection);
</PRE><BLOCKQUOTE><EM> replace the given array with a larger one and copy the contents of the
   old one into the new one </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="XProperties.m3#AwaitConversion">AwaitConversion</A> (v              : XClient.T;
                           w              : X.Window;
                           name, type, sym: X.Atom;
                           ts             : VBT.TimeStamp;
                           limit                            := 10): X.Atom
  RAISES {VBT.Error};

PROCEDURE <A HREF="XProperties.m3#ReadXSelFromProp">ReadXSelFromProp</A> (v: XClient.T; w: X.Window; prop, type: X.Atom):
  TEXT RAISES {VBT.Error};

TYPE
  <A HREF="XProperties.m3#PropertyWaitFor">PropertyWaitFor</A> &lt;: PWF_Public;
  PWF_Public = XClientF.SimpleWaitFor OBJECT
                 a    : X.Atom;
                 ts   : VBT.TimeStamp := 0;
                 state: INTEGER;
               END;

PROCEDURE <A HREF="XProperties.m3#UnlockedPutProp">UnlockedPutProp</A> (         trsl      : XClient.T;
                                    w         : X.Window;
                                    prop, type: X.Atom;
                           READONLY data      : ARRAY OF CHAR;
                                    format    : INTEGER        )
  RAISES {TrestleComm.Failure};

PROCEDURE <A HREF="XProperties.m3#PutProp">PutProp</A> (         v         : XClient.T;
                            w         : X.Window;
                            prop, type: X.Atom;
                   READONLY data      : ARRAY OF CHAR;
                            format    : INTEGER        )
  RAISES {TrestleComm.Failure};

PROCEDURE <A HREF="XProperties.m3#UnlockedGetProp">UnlockedGetProp</A> (             trsl  : XClient.T;
                                        w     : X.Window;
                                        prop  : X.Atom;
                           VAR (* OUT*) type  : X.Atom;
                           VAR (* OUT*) data  : REF ARRAY OF CHAR;
                           VAR (* OUT*) format: INTEGER            ):
  BOOLEAN RAISES {TrestleComm.Failure};

PROCEDURE <A HREF="XProperties.m3#GetProp">GetProp</A> (             v     : XClient.T;
                                w     : X.Window;
                                prop  : X.Atom;
                   VAR (* OUT*) type  : X.Atom;
                   VAR (* OUT*) res   : REF ARRAY OF CHAR;
                   VAR (* OUT*) format: INTEGER            ): BOOLEAN
  RAISES {TrestleComm.Failure};

END XProperties.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
