<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XProperties.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XProperties.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XProperties.i3">XProperties</A></implements></module>;

IMPORT <A HREF="XClient.i3">XClient</A>, <A HREF="XClientF.i3">XClientF</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="#x1">Cstring</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>;
</PRE> -- initialise X client -- 

<P><PRE>PROCEDURE <A NAME="InitialiseXClient"><procedure>InitialiseXClient</procedure></A> (xcon: XClient.T) =
  BEGIN
    WITH wf = NEW(SelRequestWaitFor) DO
      wf.timelimit := -1;
      wf.types[0] := X.SelectionRequest;
      XClientF.RegisterWaiter(xcon, wf);
    END;
  END InitialiseXClient;

TYPE
  SelRequestWaitFor = XClientF.WaitFor OBJECT
                      OVERRIDES
                        match  := SRWFMatch;
                        notify := SRWFNotify;
                      END;

PROCEDURE <A NAME="SRWFMatch"><procedure>SRWFMatch</procedure></A> (&lt;* UNUSED*&gt;          wf: XClientF.WaitFor;
                                 READONLY ev: X.XEvent          ):
  BOOLEAN =
  BEGIN
    RETURN LOOPHOLE(ADR(ev), X.XAnyEventStar).type = X.SelectionRequest;
  END SRWFMatch;

PROCEDURE <A NAME="SRWFNotify"><procedure>SRWFNotify</procedure></A> (         wf  : XClientF.WaitFor;
                      READONLY ev  : X.XEvent;
                               xcon: XClient.T         ) =
  BEGIN
    WITH e = LOOPHOLE(ADR(ev), X.XSelectionRequestEventStar) DO
      FOR s := FIRST(xcon.sel^) TO LAST(xcon.sel^) DO
        IF xcon.sel[s].name = e.selection THEN
          StartSelection(xcon, e.requestor, e.target, e.property,
                         VBT.Selection{s}, e.time);
        END;
      END;
    END;
    XClientF.RegisterWaiter(xcon, wf); (* wf will have been removed from
                                          the list *)
  END SRWFNotify;
</PRE> -- start selection -- 

<P><PRE>TYPE
  SelectionClosure = Thread.SizedClosure OBJECT
                       trsl      : XClient.T;
                       w         : X.Window;
                       type, prop: X.Atom;
                       sel       : VBT.Selection;
                       ts        : VBT.TimeStamp;
                     OVERRIDES
                       apply := DoXSelection
                     END;

PROCEDURE <A NAME="CopyBytes"><procedure>CopyBytes</procedure></A>(src, dst: ADDRESS; n: INTEGER) =
  BEGIN
    EVAL Cstring.memcpy(dst, src, n)
  END CopyBytes;

PROCEDURE <A NAME="StartSelection"><procedure>StartSelection</procedure></A> (trsl      : XClient.T;
                          w         : X.Window;
                          type, prop: X.Atom;
                          sel       : VBT.Selection;
                          ts        : VBT.TimeStamp;
                          stackSize                   := 20000) =
  BEGIN
    EVAL Thread.Fork(
           NEW(SelectionClosure, stackSize := stackSize, trsl := trsl,
               w := w, type := type, prop := prop, sel := sel, ts := ts));

  END StartSelection;

PROCEDURE <A NAME="ExtendSel"><procedure>ExtendSel</procedure></A> (VAR sa: XClientF.SelArray; s: VBT.Selection) =
  VAR
    n                     := NUMBER(sa^);
    na: XClientF.SelArray;
  BEGIN
    IF s.sel &gt; LAST(sa^) THEN
      na := NEW(XClientF.SelArray, MAX(2 * n, s.sel + 1));
      SUBARRAY(na^, 0, n) := sa^;
      FOR i := n TO LAST(na^) DO na[i] := XClientF.SelectionRecord{} END;
      sa := na
    END
  END ExtendSel;

PROCEDURE <A NAME="ExtendOwns"><procedure>ExtendOwns</procedure></A> (VAR sa: XClientF.OwnsArray; s: VBT.Selection) =
  VAR
    n                      := NUMBER(sa^);
    na: XClientF.OwnsArray;
  BEGIN
    IF s.sel &gt; LAST(sa^) THEN
      na := NEW(XClientF.OwnsArray, MAX(2 * n, s.sel + 1));
      SUBARRAY(na^, 0, n) := sa^;
      FOR i := n TO LAST(na^) DO na[i] := FALSE END;
      sa := na
    END
  END ExtendOwns;

PROCEDURE <A NAME="DoXSelection"><procedure>DoXSelection</procedure></A> (cl: SelectionClosure): REFANY RAISES {} =
  VAR
    failed        := FALSE;
    alloc         := FALSE;
    v     : VBT.T;
  BEGIN
    TRY
      TRY
        TrestleOnX.Enter(cl.trsl);
        TRY
          ExtendSel(cl.trsl.sel, cl.sel);
          v := cl.trsl.sel[cl.sel.sel].v;
          IF v = NIL THEN failed := TRUE; RETURN NIL END;
          IF cl.prop = X.None THEN
            cl.prop := XClientF.NewAtom(v);
            alloc := TRUE
          END
        FINALLY
          TrestleOnX.Exit(cl.trsl)
        END;
        failed := NOT EvalSelection(cl, v, cl.type, cl.prop)
      FINALLY
        TrestleOnX.Enter(cl.trsl);
        TRY
          VAR ev: X.XSelectionEvent;
          BEGIN
            ev.type := X.SelectionNotify;
            ev.display := cl.trsl.dpy;
            ev.requestor := cl.w;
            ev.selection := cl.trsl.sel[cl.sel.sel].name;
            ev.target := cl.type;
            IF failed THEN
              ev.property := X.None
            ELSE
              ev.property := cl.prop
            END;
            ev.time := cl.ts;
            EVAL X.XSendEvent(cl.trsl.dpy, cl.w, X.False, 0,
                              LOOPHOLE(ADR(ev),X.XEventStar));
            IF alloc THEN XClientF.FreeAtom(v, cl.prop) END
          END
        FINALLY
          TrestleOnX.Exit(cl.trsl)
        END
      END
    EXCEPT
      X.Error, TrestleComm.Failure =&gt;    (* skip *)
    END;
    RETURN NIL
  END DoXSelection;

PROCEDURE <A NAME="EvalSelection"><procedure>EvalSelection</procedure></A> (cl        : SelectionClosure;
                         owner     : VBT.T;
                         type, prop: X.Atom            ): BOOLEAN
  RAISES {TrestleComm.Failure} =
  VAR
    ntype, nprop: X.Atom;
    format      : INTEGER;
    data        : REF ARRAY OF CHAR;
    p           : UNTRACED REF X.Atom;
    anyFail                           := FALSE;
    ts          : VBT.TimeStamp;
    multiple, atompair, targets, timestamp, string, text, atom, intatom,
    delete, insprop, inssel, null, sym, rsym, length: X.Atom;
    res: TEXT;
    ur : XClientF.Child;
  BEGIN
    TrestleOnX.Enter(cl.trsl);
    TRY
      length := XClient.ToAtom(cl.trsl, &quot;LENGTH&quot;);
      multiple := XClient.ToAtom(cl.trsl, &quot;MULTIPLE&quot;);
      atompair := XClient.ToAtom(cl.trsl, &quot;ATOM_PAIR&quot;);
      targets := XClient.ToAtom(cl.trsl, &quot;TARGETS&quot;);
      timestamp := XClient.ToAtom(cl.trsl, &quot;TIMESTAMP&quot;);
      string := XClient.ToAtom(cl.trsl, &quot;STRING&quot;);
      text := XClient.ToAtom(cl.trsl, &quot;TEXT&quot;);
      atom := XClient.ToAtom(cl.trsl, &quot;ATOM&quot;);
      intatom := XClient.ToAtom(cl.trsl, &quot;INTEGER&quot;);
      delete := XClient.ToAtom(cl.trsl, &quot;DELETE&quot;);
      insprop := XClient.ToAtom(cl.trsl, &quot;INSERT_PROPERTY&quot;);
      inssel := XClient.ToAtom(cl.trsl, &quot;INSERT_SELECTION&quot;);
      null := XClient.ToAtom(cl.trsl, &quot;NULL&quot;);
      ExtendSel(cl.trsl.sel, cl.sel);
      ts := cl.trsl.sel[cl.sel.sel].ts
    FINALLY
      TrestleOnX.Exit(cl.trsl)
    END;
    IF type = multiple THEN
      IF NOT UnlockedGetProp(cl.trsl, cl.w, prop, ntype, data, format)
           OR format # 32 OR ntype # atompair OR NUMBER(data^) MOD 8 # 0 THEN
        RETURN FALSE
      END;
      FOR i := 0 TO LAST(data^) BY 8 DO
        p := LOOPHOLE(ADR(data[i]), UNTRACED REF X.Atom);
        ntype := p^;
        p := LOOPHOLE(ADR(data[i + 4]), UNTRACED REF X.Atom);
        nprop := p^;
        IF NOT EvalSelection(cl, owner, ntype, nprop) THEN
          p^ := X.None;
          anyFail := TRUE
        END
      END;
      IF anyFail THEN
        UnlockedPutProp(cl.trsl, cl.w, prop, atompair, data^, 32)
      END
    ELSIF type = targets THEN
      VAR
        td := ARRAY [0 .. 4] OF
                Ctypes.int{multiple, targets, timestamp, string, text};
      BEGIN
        UnlockedPutProp(cl.trsl, cl.w, prop, atom,
                        LOOPHOLE(td, ARRAY [0 .. 19] OF CHAR), 32)
      END
    ELSIF type = timestamp THEN
      VAR tts: Ctypes.int := ts; BEGIN
        UnlockedPutProp(cl.trsl, cl.w, prop, intatom,
                        LOOPHOLE(tts, ARRAY [0 .. 3] OF CHAR), 32)
      END
    ELSIF type = text OR type = string THEN
      TRY
        TYPECASE owner.read(cl.sel, TYPECODE(TEXT)).toRef() OF
          NULL =&gt; RETURN FALSE
        | TEXT (t) =&gt;
            VAR buf := NEW(UNTRACED REF ARRAY OF CHAR, Text.Length(t));
            BEGIN
              IF Text.Length(t) &gt; 0 THEN Text.SetChars(buf^, t) END;
              UnlockedPutProp(cl.trsl, cl.w, prop, string, buf^, 8);
              DISPOSE(buf)
            END
        ELSE
          RETURN FALSE
        END
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END;
    ELSIF type = delete THEN
      TRY
        owner.write(cl.sel, VBT.FromRef(&quot;&quot;), TYPECODE(TEXT))
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END
    ELSIF type = insprop THEN
      IF NOT UnlockedGetProp(cl.trsl, cl.w, prop, ntype, data, format)
           OR ntype # string OR format # 8 THEN
        RETURN FALSE
      END;
      TRY
        owner.write(
          cl.sel, VBT.FromRef(Text.FromChars(data^)), TYPECODE(TEXT))
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END
    ELSIF type = inssel THEN
      TrestleOnX.Enter(cl.trsl);
      TRY
        ur := owner.upRef;
        IF ur = NIL OR ur.xcage = X.None THEN RETURN FALSE END;
        IF NOT GetProp(cl.trsl, cl.w, prop, ntype, data, format)
             OR ntype # atompair OR format # 32 OR NUMBER(data^) # 8 THEN
          RETURN FALSE
        END;
        p := LOOPHOLE(ADR(data[0]), UNTRACED REF X.Atom);
        nprop := p^;
        p := LOOPHOLE(ADR(data[4]), UNTRACED REF X.Atom);
        ntype := p^;
        sym := XClientF.NewAtom(cl.trsl);
        TRY
          IF ntype = text THEN ntype := string END;
          rsym :=
            AwaitConversion(cl.trsl, ur.xcage, nprop, ntype, sym, cl.ts);
          IF rsym # sym THEN XClientF.FreeAtom(cl.trsl, sym) END;
          res := ReadXSelFromProp(cl.trsl, ur.xcage, rsym, ntype);
          XClientF.FreeAtom(cl.trsl, sym);
        EXCEPT
          VBT.Error (ec) =&gt;
            IF ec # VBT.ErrorCode.TimeOut THEN
              XClientF.FreeAtom(cl.trsl, sym)
            END;
            RETURN FALSE
        END
      FINALLY
        TrestleOnX.Exit(cl.trsl)
      END;
      TRY
        owner.write(cl.sel, VBT.FromRef(res), TYPECODE(TEXT))
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END
    ELSIF type = length THEN
      TRY
        TYPECASE owner.read(cl.sel, TYPECODE(TEXT)).toRef() OF
          NULL =&gt; RETURN FALSE
        | TEXT (t) =&gt;
            VAR lnth: Ctypes.int := Text.Length(t);
            BEGIN
              UnlockedPutProp(cl.trsl, cl.w, prop, intatom,
                              LOOPHOLE(lnth, ARRAY [0 .. 3] OF CHAR), 32);
            END
        ELSE
          RETURN FALSE
        END
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END
    ELSE
      RETURN FALSE
    END;
    RETURN TRUE
  END EvalSelection;

TYPE
  SelectionWaitFor = XClientF.SimpleWaitFor OBJECT
                       sel, type, prop: X.Atom;
                       sent           : BOOLEAN       := FALSE;
                       ts             : VBT.TimeStamp := 0;
                     OVERRIDES
                       match := SelectionMatch;
                     END;

PROCEDURE <A NAME="SelectionMatch"><procedure>SelectionMatch</procedure></A> (wf: SelectionWaitFor; READONLY ev: X.XEvent):
  BOOLEAN =
  BEGIN
    IF NOT XClientF.SimpleWaitFor.match(wf, ev) THEN RETURN FALSE END;
    WITH e    = LOOPHOLE(ADR(ev), X.XAnyEventStar),
         type = e.type                              DO
      IF type # X.SelectionNotify THEN RETURN TRUE END;
      WITH pe = LOOPHOLE(e, X.XSelectionEventStar) DO
        wf.prop := pe.property;
        wf.sent := pe.send_event # X.False;
        RETURN
          pe.selection = wf.sel AND pe.target = wf.type AND pe.time = wf.ts
      END
    END
  END SelectionMatch;

PROCEDURE <A NAME="AwaitConversion"><procedure>AwaitConversion</procedure></A> (v              : XClient.T;
                           w              : X.Window;
                           name, type, sym: X.Atom;
                           ts             : VBT.TimeStamp;
                           limit                            := 10): X.Atom
  RAISES {VBT.Error} =
  VAR
    wf := NEW(SelectionWaitFor, d := w, sel := name, ts := ts,
              type := type, prop := X.None);
  BEGIN
    TRY
      wf.reqno := X.XNextRequest(v.dpy);
      X.XConvertSelection(v.dpy, name, type, sym, w, ts);
      wf.types[0] := 0;
      wf.types[1] := X.SelectionNotify;
      IF XClientF.Await(v, wf, limit) = 1 THEN
        RAISE VBT.Error(VBT.ErrorCode.TimeOut)
      ELSIF wf.prop = X.None THEN
        IF wf.sent THEN
          RAISE VBT.Error(VBT.ErrorCode.Unreadable)
        ELSE
          RAISE VBT.Error(VBT.ErrorCode.UnownedSelection)
        END
      END;
      RETURN wf.prop
    EXCEPT
      X.Error, TrestleComm.Failure =&gt; RAISE VBT.Error(VBT.ErrorCode.Uninstalled)
    END
  END AwaitConversion;

PROCEDURE <A NAME="ReadXSelFromProp"><procedure>ReadXSelFromProp</procedure></A> (v: XClient.T; w: X.Window; prop, type: X.Atom):
  TEXT RAISES {VBT.Error} =
  VAR
    propType: X.Atom;
    format  : INTEGER;
    res     : REF ARRAY OF CHAR;
    resT                        := &quot;&quot;;
    pwf                         := NEW(PropertyWaitFor);
  BEGIN
    TRY
      IF NOT GetProp(v, w, prop, propType, res, format) THEN
        RAISE VBT.Error(VBT.ErrorCode.Unreadable)
      ELSIF propType # type AND propType # XClient.ToAtom(v, &quot;INCR&quot;) THEN
        RAISE VBT.Error(VBT.ErrorCode.WrongType)
      ELSIF propType = type THEN
        IF type = XClient.ToAtom(v, &quot;STRING&quot;) THEN
          RETURN Text.FromChars(res^)
        ELSE
          Crash()
        END
      ELSE
        pwf.types[0] := X.PropertyNotify;
        pwf.d := w;
        pwf.a := prop;
        LOOP
          IF XClientF.Await(v, pwf, 10) = 1 THEN
            RAISE VBT.Error(VBT.ErrorCode.TimeOut)
          ELSIF pwf.state = X.PropertyNewValue THEN
            IF NOT GetProp(v, w, prop, propType, res, format) THEN
              RAISE VBT.Error(VBT.ErrorCode.Unreadable)
            ELSIF propType # type THEN
              RAISE VBT.Error(VBT.ErrorCode.WrongType)
            ELSIF NUMBER(res^) = 0 THEN
              IF type # XClient.ToAtom(v, &quot;STRING&quot;) THEN Crash() END;
              RETURN resT
            END;
            resT := resT &amp; Text.FromChars(res^)
          END
        END
      END
    EXCEPT
      TrestleComm.Failure =&gt; RAISE VBT.Error(VBT.ErrorCode.Uninstalled)
    END
  END ReadXSelFromProp;

REVEAL
  <A NAME="PropertyWaitFor">PropertyWaitFor</A> =
    PWF_Public BRANDED OBJECT OVERRIDES match := PropertyMatch END;

PROCEDURE <A NAME="PropertyMatch"><procedure>PropertyMatch</procedure></A> (wf: PropertyWaitFor; READONLY ev: X.XEvent):
  BOOLEAN =
  BEGIN
    IF NOT XClientF.SimpleWaitFor.match(wf, ev) THEN RETURN FALSE END;
    WITH e    = LOOPHOLE(ADR(ev), X.XAnyEventStar),
         type = e.type                              DO
      IF type # X.PropertyNotify THEN RETURN TRUE END;
      WITH pe = LOOPHOLE(e, X.XPropertyEventStar) DO
        wf.ts := pe.time;
        wf.state := pe.state;
        RETURN pe.atom = wf.a
      END
    END
  END PropertyMatch;

PROCEDURE <A NAME="UnlockedPutProp"><procedure>UnlockedPutProp</procedure></A> (         trsl      : XClient.T;
                                    w         : X.Window;
                                    prop, type: X.Atom;
                           READONLY data      : ARRAY OF CHAR;
                                    format    : INTEGER        )
  RAISES {TrestleComm.Failure} =
  BEGIN
    TrestleOnX.Enter(trsl);
    TRY
      PutProp(trsl, w, prop, type, data, format)
    FINALLY
      TrestleOnX.Exit(trsl)
    END
  END UnlockedPutProp;

PROCEDURE <A NAME="PutProp"><procedure>PutProp</procedure></A> (         v         : XClient.T;
                            w         : X.Window;
                            prop, type: X.Atom;
                   READONLY data      : ARRAY OF CHAR;
                            format    : INTEGER        )
  RAISES {TrestleComm.Failure} =
  VAR
    st               := 0;
    len              := NUMBER(data);
    n      : INTEGER;
    mode             := X.PropModeReplace;
    maxSize          := 4 * (X.XMaxRequestSize(v.dpy) - 50);
    p      : ADDRESS;
    format8          := format DIV 8;
  BEGIN
    TRY
    REPEAT
      n := MIN(len - st, maxSize);
      IF n # 0 THEN p := ADR(data[st]) ELSE p := ADR(p) END;
      X.XChangeProperty(
        v.dpy, w, prop, type, format, mode, p, n DIV format8);
      INC(st, n);
      mode := X.PropModeAppend
    UNTIL st = len;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END PutProp;

PROCEDURE <A NAME="UnlockedGetProp"><procedure>UnlockedGetProp</procedure></A> (            trsl  : XClient.T;
                                       w     : X.Window;
                                       prop  : X.Atom;
                           VAR (*OUT*) type  : X.Atom;
                           VAR (*OUT*) data  : REF ARRAY OF CHAR;
                           VAR (*OUT*) format: INTEGER            ):
  BOOLEAN RAISES {TrestleComm.Failure} =
  BEGIN
    TrestleOnX.Enter(trsl);
    TRY
      RETURN GetProp(trsl, w, prop, type, data, format)
    FINALLY
      TrestleOnX.Exit(trsl)
    END
  END UnlockedGetProp;

PROCEDURE <A NAME="GetProp"><procedure>GetProp</procedure></A> (            v     : XClient.T;
                               w     : X.Window;
                               prop  : X.Atom;
                   VAR (*OUT*) type  : X.Atom;
                   VAR (*OUT*) res   : REF ARRAY OF CHAR;
                   VAR (*OUT*) format: INTEGER            ): BOOLEAN
  RAISES {TrestleComm.Failure} =
  VAR
    len, remaining: INTEGER;
    data          : Ctypes.char_star;
    maxSize                           := X.XMaxRequestSize(v.dpy) - 50;
    st                                := 0;
    fmt: Ctypes.int := 0;
  BEGIN
    TRY
    IF X.XGetWindowProperty(
         v.dpy, w, prop, 0, maxSize, X.True, X.AnyPropertyType, ADR(type),
         ADR(fmt), ADR(len), ADR(remaining),
         LOOPHOLE(ADR(data), Ctypes.unsigned_char_star_star)) # X.Success THEN
      RETURN FALSE
    END;
    format := fmt;
    len := len * (format DIV 8);
    res := NEW(REF ARRAY OF CHAR, len + remaining);
    LOOP
      IF len # 0 THEN
        CopyBytes(data, ADR(res[st]), MIN(len, NUMBER(res^) - st))
      END;
      INC(st, len);
      X.XFree(data);
      IF remaining = 0 OR st &gt;= NUMBER(res^) THEN
        RETURN remaining = 0 AND st = NUMBER(res^)
      END;
      IF X.XGetWindowProperty(
           v.dpy, w, prop, st DIV 4, maxSize, X.True, X.AnyPropertyType,
           ADR(type), ADR(fmt), ADR(len), ADR(remaining),
           LOOPHOLE(ADR(data), Ctypes.unsigned_char_star_star))
           # X.Success THEN
        RETURN FALSE
      END;
      format := fmt;
      IF len = 0 THEN X.XFree(data); RETURN FALSE END;
      len := len * (format DIV 8)
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END GetProp;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN
END XProperties.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Cstring is in:
</A><UL>
<LI><A HREF="../../../C/src/AIX386/Cstring.i3#0TOP0">C/src/AIX386/Cstring.i3</A>
<LI><A HREF="../../../C/src/ALPHA_OSF/Cstring.i3#0TOP0">C/src/ALPHA_OSF/Cstring.i3</A>
<LI><A HREF="../../../C/src/AP3000/Cstring.i3#0TOP0">C/src/AP3000/Cstring.i3</A>
<LI><A HREF="../../../C/src/ARM/Cstring.i3#0TOP0">C/src/ARM/Cstring.i3</A>
<LI><A HREF="../../../C/src/DS3100/Cstring.i3#0TOP0">C/src/DS3100/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD/Cstring.i3#0TOP0">C/src/FreeBSD/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD2/Cstring.i3#0TOP0">C/src/FreeBSD2/Cstring.i3</A>
<LI><A HREF="../../../C/src/HP300/Cstring.i3#0TOP0">C/src/HP300/Cstring.i3</A>
<LI><A HREF="../../../C/src/HPPA/Cstring.i3#0TOP0">C/src/HPPA/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMR2/Cstring.i3#0TOP0">C/src/IBMR2/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMRT/Cstring.i3#0TOP0">C/src/IBMRT/Cstring.i3</A>
<LI><A HREF="../../../C/src/IRIX5/Cstring.i3#0TOP0">C/src/IRIX5/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUX/Cstring.i3#0TOP0">C/src/LINUX/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUXELF/Cstring.i3#0TOP0">C/src/LINUXELF/Cstring.i3</A>
<LI><A HREF="../../../C/src/NEXT/Cstring.i3#0TOP0">C/src/NEXT/Cstring.i3</A>
<LI><A HREF="../../../C/src/NT386/Cstring.i3#0TOP0">C/src/NT386/Cstring.i3</A>
<LI><A HREF="../../../C/src/OKI/Cstring.i3#0TOP0">C/src/OKI/Cstring.i3</A>
<LI><A HREF="../../../C/src/SEQUENT/Cstring.i3#0TOP0">C/src/SEQUENT/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLgnu/Cstring.i3#0TOP0">C/src/SOLgnu/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLsun/Cstring.i3#0TOP0">C/src/SOLsun/Cstring.i3</A>
<LI><A HREF="../../../C/src/SPARC/Cstring.i3#0TOP0">C/src/SPARC/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN3/Cstring.i3#0TOP0">C/src/SUN3/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN386/Cstring.i3#0TOP0">C/src/SUN386/Cstring.i3</A>
<LI><A HREF="../../../C/src/UMAX/Cstring.i3#0TOP0">C/src/UMAX/Cstring.i3</A>
<LI><A HREF="../../../C/src/VAX/Cstring.i3#0TOP0">C/src/VAX/Cstring.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
