<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XScrnCmap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XScrnCmap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XScrnCmap.i3">XScrnCmap</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnColorMap.i3">ScrnColorMap</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="XClient.i3">XClient</A>, <A HREF="XScreenType.i3">XScreenType</A>,
       <A HREF="XScrnTpRep.i3">XScrnTpRep</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>, <A HREF="../../../arith/src/Math.i3">Math</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>;

TYPE
  ColorMapOracle =
    ScrnColorMap.Oracle OBJECT
      st       : XScreenType.T;
      defaultCM: XColorMap;
    METHODS
      &lt;* LL.sup = SELF.st.trsl *&gt;
      init (st: XScreenType.T; READONLY vinfo: X.XVisualInfo):
            ColorMapOracle RAISES {TrestleComm.Failure} := InitColorMapOracle;
    OVERRIDES
      standard := ColorMapDefault;
      new      := ColorMapNew;
      list     := ColorMapList;
      lookup   := ColorMapLookup
    END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: XScreenType.T; READONLY vinfo: X.XVisualInfo):
  ScrnColorMap.Oracle RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NEW(ColorMapOracle).init(scrn, vinfo)
  END NewOracle;

TYPE
  Prim = ScrnColorMap.Primary;
  XColorMap = ScrnColorMap.T OBJECT
                st    : XScreenType.T;
                direct: BOOLEAN;
                xid   : X.Colormap;
              OVERRIDES
                fromRGB := ColorMapFromRGB;
                new     := ColorMapCube;
                read    := ColorMapRead;
                write   := ColorMapWrite;
                free    := ColorMapFreeCube;
              END;
</PRE><BLOCKQUOTE><EM> For all v: VBT.T, all cm: XColorMap, cm &lt; v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="ColorMapID"><procedure>ColorMapID</procedure></A> (cm: ScrnColorMap.T): X.Colormap =
  BEGIN
    TYPECASE cm OF
      NULL =&gt; RETURN X.None
    | XColorMap (xcm) =&gt; RETURN xcm.xid
    ELSE
      RETURN X.None
    END
  END ColorMapID;

PROCEDURE <A NAME="ColorMapFromRGB"><procedure>ColorMapFromRGB</procedure></A> (cm  : XColorMap;
                           rgb : ScrnColorMap.RGB;
                           mode: ScrnColorMap.Mode ): ScrnColorMap.Pixel
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  VAR
    xcol: X.XColor;
    ent : ScrnColorMap.Entry;
    trsl                     := cm.st.trsl;
  BEGIN
    TRY
    IF cm.direct AND mode = ScrnColorMap.Mode.Accurate THEN
      mode := ScrnColorMap.Mode.Normal
    END;
    IF mode # ScrnColorMap.Mode.Accurate THEN
      rgb.r := FLOAT(ROUND(rgb.r * FLOAT(cm.ramp.last[Prim.Red]))) / FLOAT(
                 cm.ramp.last[Prim.Red]);
      rgb.g := FLOAT(ROUND(rgb.g * FLOAT(cm.ramp.last[Prim.Green])))
                 / FLOAT(cm.ramp.last[Prim.Green]);
      rgb.b := FLOAT(ROUND(rgb.b * FLOAT(cm.ramp.last[Prim.Blue])))
                 / FLOAT(cm.ramp.last[Prim.Blue]);
    END;
    ent.rgb := rgb;
    XColorFromEntry(xcol, ent);
    TrestleOnX.Enter(trsl);
    TRY
      IF mode # ScrnColorMap.Mode.Accurate AND cm.ramp.base # -1 THEN
        ent.pix := cm.ramp.base;
        INC(ent.pix, cm.ramp.mult[Prim.Red] * ROUND(
                       rgb.r * FLOAT(cm.ramp.last[Prim.Red])));
        INC(ent.pix, cm.ramp.mult[Prim.Green] * ROUND(
                       rgb.g * FLOAT(cm.ramp.last[Prim.Green])));
        INC(ent.pix, cm.ramp.mult[Prim.Blue] * ROUND(
                       rgb.b * FLOAT(cm.ramp.last[Prim.Blue])));
      ELSE
        IF X.XAllocColor(trsl.dpy, cm.xid, ADR(xcol)) = 0 THEN
          RAISE ScrnColorMap.Failure
        END;
        ent.pix := xcol.pixel
      END
    FINALLY
      TrestleOnX.Exit(trsl)
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN ent.pix
  END ColorMapFromRGB;

PROCEDURE <A NAME="ColorMapRead"><procedure>ColorMapRead</procedure></A> (cm: XColorMap; VAR res: ARRAY OF ScrnColorMap.Entry)
  RAISES {TrestleComm.Failure} =
  VAR xres := NEW(UNTRACED REF ARRAY OF X.XColor, NUMBER(res));
  BEGIN
    TRY
    TRY
      IF NUMBER(res) = 0 THEN RETURN END;
      FOR i := 0 TO LAST(res) DO
        xres[i].pixel := res[i].pix;
        xres[i].flags := X.DoRed + X.DoGreen + X.DoBlue
      END;
      TrestleOnX.Enter(cm.st.trsl);
      TRY
        X.XQueryColors(cm.st.trsl.dpy, cm.xid, ADR(xres[0]), NUMBER(res));
        FOR i := 0 TO LAST(res) DO EntryFromXColor(res[i], xres[i]) END
      FINALLY
        TrestleOnX.Exit(cm.st.trsl)
      END
    FINALLY
      DISPOSE(xres)
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END ColorMapRead;

PROCEDURE <A NAME="ColorMapWrite"><procedure>ColorMapWrite</procedure></A> (         cm : XColorMap;
                         READONLY new: ARRAY OF ScrnColorMap.Entry)
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    IF cm.readOnly THEN RAISE ScrnColorMap.Failure END;
    InnerColorMapWrite(cm, new)
  END ColorMapWrite;

PROCEDURE <A NAME="ColorMapCube"><procedure>ColorMapCube</procedure></A> (cm: XColorMap; d: CARDINAL): ScrnColorMap.Cube
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  VAR
    res : ScrnColorMap.Cube;
    pm  : UNTRACED REF ARRAY OF INTEGER;
    trsl                                := cm.st.trsl;
    dpy                                 := trsl.dpy;
  BEGIN
    TRY
    IF cm.readOnly THEN RAISE ScrnColorMap.Failure END;
    pm := NEW(UNTRACED REF ARRAY OF INTEGER, MAX(d, 1));
    TRY
      TrestleOnX.Enter(trsl);
      TRY
        IF X.XAllocColorCells(
             dpy, cm.xid, X.False, ADR(pm[0]), d, ADR(res.lo), 1) = 0 THEN
          RAISE ScrnColorMap.Failure
        END;
        res.hi := res.lo;
        FOR i := 0 TO d - 1 DO INC(res.hi, pm[i]) END
      FINALLY
        TrestleOnX.Exit(trsl)
      END
    FINALLY
      DISPOSE(pm)
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN res
  END ColorMapCube;

PROCEDURE <A NAME="ColorMapFreeCube"><procedure>ColorMapFreeCube</procedure></A> (cm: XColorMap; READONLY cb: ScrnColorMap.Cube)
  RAISES {TrestleComm.Failure} =
  VAR
    pm  : UNTRACED REF ARRAY OF INTEGER;
    trsl                                := cm.st.trsl;
    dpy                                 := trsl.dpy;
  BEGIN
    TRY
    pm := NEW(UNTRACED REF ARRAY OF INTEGER, cm.depth);
    TRY
      TrestleOnX.Enter(trsl);
      TRY
        X.XFreeColors(dpy, cm.xid, ADR(cb.lo), 1, cb.hi - cb.lo)
      FINALLY
        TrestleOnX.Exit(trsl)
      END
    FINALLY
      DISPOSE(pm)
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END ColorMapFreeCube;

PROCEDURE <A NAME="InnerColorMapWrite"><procedure>InnerColorMapWrite</procedure></A> (         cm : XColorMap;
                              READONLY new: ARRAY OF ScrnColorMap.Entry)
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  VAR
    trsl                                    := cm.st.trsl;
    dpy                                     := trsl.dpy;
    xcolor : X.XColor;
    xcolors: UNTRACED REF ARRAY OF X.XColor;
  BEGIN
    TRY
    TrestleOnX.Enter(trsl);
    TRY
      IF NUMBER(new) = 1 THEN
        XColorFromEntry(xcolor, new[0]);
        X.XStoreColor(dpy, cm.xid, ADR(xcolor))
      ELSE
        xcolors := NEW(UNTRACED REF ARRAY OF X.XColor, NUMBER(new));
        TRY
          FOR i := 0 TO LAST(new) DO
            XColorFromEntry(xcolors[i], new[i])
          END;
          X.XStoreColors(dpy, cm.xid, ADR(xcolors[0]), NUMBER(new))
        FINALLY
          DISPOSE(xcolors)
        END
      END
    FINALLY
      TrestleOnX.Exit(trsl)
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END InnerColorMapWrite;

&lt;* UNUSED *&gt; PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A> (x: REAL): REAL =
  CONST epsilon = 0.25 / FLOAT(Word.Shift(1, 30));
  VAR
    r    : REAL;
    scale       := 0;
  BEGIN
    IF x &lt;= epsilon THEN RETURN 0.0 END;
    WHILE x &lt; 0.25 DO INC(scale); x := 4.0 * x END;
    r := (x + 1.0) / 2.0;
    FOR i := 1 TO 5 DO r := (r + x / r) / 2.0 END;
    IF scale # 0 THEN r := r / FLOAT(Word.Shift(1, scale)) END;
    RETURN r
  END Sqrt;

&lt;* UNUSED *&gt; PROCEDURE <A NAME="Cbrt"><procedure>Cbrt</procedure></A> (x: REAL): REAL =
  CONST epsilon = 1.0 / FLOAT(Word.Shift(1, 24));
  VAR
    r    : REAL;
    scale       := 0;
  BEGIN
    IF x &lt;= epsilon THEN RETURN 0.0 END;
    WHILE x &lt; 0.125 DO INC(scale); x := 8.0 * x END;
    r := (x + 2.0) / 3.0;
    FOR i := 1 TO 5 DO r := (2.0 * r + x / (r * r)) / 3.0 END;
    IF scale # 0 THEN r := r / FLOAT(Word.Shift(1, scale)) END;
    RETURN r
  END Cbrt;

CONST
  Gamma        = 2.4D0;
  GammaInverse = 1.0D0 / Gamma;

PROCEDURE <A NAME="XColorFromEntry"><procedure>XColorFromEntry</procedure></A> (VAR      xcolor: X.XColor;
                           READONLY ent   : ScrnColorMap.Entry)
  RAISES {ScrnColorMap.Failure} =
  CONST
    Scale = FLOAT(LAST(Card16), LONGREAL);
    DoAll = X.DoRed + X.DoGreen + X.DoBlue;
  BEGIN
    IF ent.rgb.r &lt; 0.0 OR ent.rgb.r &gt; 1.0 OR ent.rgb.g &lt; 0.0
         OR ent.rgb.g &gt; 1.0 OR ent.rgb.b &lt; 0.0 OR ent.rgb.b &gt; 1.0 THEN
      RAISE ScrnColorMap.Failure
    END;
    xcolor.pixel := ent.pix;
    (*
    VAR rr := Cbrt(ent.rgb.r); gg := Cbrt(ent.rgb.g);
      bb := Cbrt(ent.rgb.b); BEGIN
      xcolor.red := ROUND(Scale * rr * rr);
      xcolor.green := ROUND(Scale * gg * gg);
      xcolor.blue := ROUND(Scale * bb * bb)
    END;
    *)
    VAR
      rr := FLOAT(ent.rgb.r, LONGREAL);
      gg := FLOAT(ent.rgb.g, LONGREAL);
      bb := FLOAT(ent.rgb.b, LONGREAL);
    BEGIN
      xcolor.red := ROUND(Scale * Math.pow(rr, GammaInverse));
      xcolor.green := ROUND(Scale * Math.pow(gg, GammaInverse));
      xcolor.blue := ROUND(Scale * Math.pow(bb, GammaInverse));
    END;
    xcolor.flags := DoAll
  END XColorFromEntry;

PROCEDURE <A NAME="EntryFromXColor"><procedure>EntryFromXColor</procedure></A> (VAR      ent   : ScrnColorMap.Entry;
                           READONLY xcolor: X.XColor            ) =
  CONST Scale = FLOAT(LAST(Card16), LONGREAL);
  BEGIN
    ent.pix := xcolor.pixel;
    VAR
      rr := FLOAT(xcolor.red, LONGREAL) / Scale;
      gg := FLOAT(xcolor.green, LONGREAL) / Scale;
      bb := FLOAT(xcolor.blue, LONGREAL) / Scale;
    BEGIN
      (* ent.rgb.r := rr * Sqrt(rr); ent.rgb.g := gg * Sqrt(gg); ent.rgb.b
         := bb * Sqrt(bb) *)
      ent.rgb.r := FLOAT(Math.pow(rr, Gamma));
      ent.rgb.g := FLOAT(Math.pow(gg, Gamma));
      ent.rgb.b := FLOAT(Math.pow(bb, Gamma));
    END
  END EntryFromXColor;

TYPE Card16 = BITS 16 FOR [0 .. 16_ffff];

PROCEDURE <A NAME="InitColorMapOracle"><procedure>InitColorMapOracle</procedure></A> (         orc  : ColorMapOracle;
                                       st   : XScreenType.T;
                              READONLY vinfo: X.XVisualInfo    ):
  ColorMapOracle RAISES {TrestleComm.Failure}
  &lt;* LL.sup = st.trsl *&gt; =
  VAR
    vis   := vinfo.visual;
    xid   := X.XDefaultColormap(st.trsl.dpy, st.screenID);
    class := vis.class;
  BEGIN
    TRY
    orc.st := st;
    orc.defaultCM :=
      InnerColorMapNew(
        orc, xid, NIL, class # X.GrayScale AND class # X.PseudoColor,
        vinfo.depth, direct := class = X.DirectColor);
    VAR
      atm           := XClient.ToAtom(st.trsl, &quot;RGB_DEFAULT_MAP&quot;);
      n  : Ctypes.int;
      xsc, xscp: X.XStandardColormapStar;
      success := X.XGetRGBColormaps(
                   st.trsl.dpy, st.root, ADR(xsc), ADR(n), atm) # 0;
      x, y: X.VisualID;
    BEGIN
      IF success THEN
        success := FALSE;
        xscp := xsc;
        FOR i := 0 TO n - 1 DO
          x := xscp.visualid;
          y := orc.st.visual.visualid;
          IF x = y THEN
            success := TRUE;
            WITH ramp = orc.defaultCM.ramp DO
              ramp.last[Prim.Red] := xscp.red_max;
              ramp.last[Prim.Green] := xscp.green_max;
              ramp.last[Prim.Blue] := xscp.blue_max;
              ramp.mult[Prim.Red] := xscp.red_mult;
              ramp.mult[Prim.Green] := xscp.green_mult;
              ramp.mult[Prim.Blue] := xscp.blue_mult;
              IF xscp.colormap = xid THEN
                ramp.base := xscp.base_pixel
              ELSE
                ramp.base := -1
              END
            END
          END;
          INC(xscp, ADRSIZE(X.XStandardColormap))
        END;
        X.XFree(LOOPHOLE(xsc, Ctypes.char_star))
      END;
      IF NOT success THEN
        VAR np := MAX(1, Word.Shift(1, orc.st.depth DIV 3) - 1);
        BEGIN
          WITH ramp = orc.defaultCM.ramp DO
            IF class = X.DirectColor OR class = X.TrueColor THEN
              np := Word.Shift(1, vis.bits_per_rgb) - 1;
              ramp.mult[Prim.Red] :=
                Word.And(vis.red_mask, Word.Not(vis.red_mask - 1));
              ramp.mult[Prim.Green] :=
                Word.And(vis.green_mask, Word.Not(vis.green_mask - 1));
              ramp.mult[Prim.Blue] :=
                Word.And(vis.blue_mask, Word.Not(vis.blue_mask - 1));
              ramp.base := 0
            ELSE
              ramp.base := -1
            END;
            ramp.last[Prim.Red] := np;
            ramp.last[Prim.Green] := np;
            ramp.last[Prim.Blue] := np
          END
        END
      END
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN orc
  END InitColorMapOracle;

PROCEDURE <A NAME="ColorMapDefault"><procedure>ColorMapDefault</procedure></A> (orc: ColorMapOracle): ScrnColorMap.T RAISES {} =
  BEGIN
    RETURN orc.defaultCM
  END ColorMapDefault;

PROCEDURE <A NAME="ColorMapList"><procedure>ColorMapList</procedure></A> (&lt;*UNUSED*&gt; orc       : ColorMapOracle;
                        &lt;*UNUSED*&gt; pat       : TEXT;
                        &lt;*UNUSED*&gt; maxResults: CARDINAL        ):
  REF ARRAY OF TEXT RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapList;

PROCEDURE <A NAME="ColorMapLookup"><procedure>ColorMapLookup</procedure></A> (&lt;*UNUSED*&gt; orc: ColorMapOracle;
                          &lt;*UNUSED*&gt; pat: TEXT            ): ScrnColorMap.T
  RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapLookup;

PROCEDURE <A NAME="ColorMapNew"><procedure>ColorMapNew</procedure></A> (           orc      : ColorMapOracle;
                                  nm       : TEXT             := NIL;
                       &lt;*UNUSED*&gt; preLoaded                   := TRUE ):
  ScrnColorMap.T RAISES {TrestleComm.Failure} =
  VAR
    nxid: X.Colormap;
    res : ScrnColorMap.T;
  BEGIN
    TRY
    IF orc.defaultCM.readOnly THEN RETURN orc.defaultCM END;
    TrestleOnX.Enter(orc.st.trsl);
    TRY
      nxid := X.XCreateColormap(
                orc.st.trsl.dpy, orc.st.root, orc.st.visual, X.AllocNone);
      res := InnerColorMapNew(orc, nxid, nm, FALSE, orc.defaultCM.depth,
                              orc.defaultCM.direct);
      res.ramp := orc.defaultCM.ramp;
      res.ramp.base := -1;
      RETURN res
    FINALLY
      TrestleOnX.Exit(orc.st.trsl)
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END ColorMapNew;

PROCEDURE <A NAME="InnerColorMapNew"><procedure>InnerColorMapNew</procedure></A> (           orc     : ColorMapOracle;
                                       cm      : X.Colormap;
                            &lt;*UNUSED*&gt; nm      : TEXT             := NIL;
                                       readOnly: BOOLEAN;
                                       depth   : INTEGER;
                                       direct  : BOOLEAN                  ):
  XColorMap =
  BEGIN
    RETURN NEW(XColorMap, st := orc.st, xid := cm, readOnly := readOnly,
               depth := depth, direct := direct)
  END InnerColorMapNew;

BEGIN
END XScrnCmap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
