<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XScrnCrsr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XScrnCrsr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XScrnCrsr.i3">XScrnCrsr</A></implements></module>;

IMPORT <A HREF="../vbt/Cursor.i3">Cursor</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScrnCursor.i3">ScrnCursor</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="XClient.i3">XClient</A>,
       <A HREF="XClientF.i3">XClientF</A>, <A HREF="XCursors.i3">XCursors</A>, <A HREF="XScreenType.i3">XScreenType</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>, <A HREF="XScrnPxmp.i3">XScrnPxmp</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>;

REVEAL <A NAME="T">T</A> = T_Pub BRANDED OBJECT cursorGC, cursorGC2: X.GC := NIL;  END;

TYPE
  CursorOracle = ScrnCursor.Oracle OBJECT
                   st: XScreenType.T;
                 OVERRIDES
                   load    := CursorRegister;
                   list    := CursorList;
                   lookup  := CursorLookup;
                   builtIn := CursorBuiltIn
                 END;
  XCursor = ScrnCursor.T OBJECT
            OVERRIDES
              unload   := CursorUnregister;
              localize := CursorLocalize
            END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: XScreenType.T): ScrnCursor.Oracle =
  BEGIN
    RETURN NEW(CursorOracle, st := scrn)
  END NewOracle;

PROCEDURE <A NAME="NullCursor"><procedure>NullCursor</procedure></A> (dpy: X.DisplayStar; w: X.Drawable): X.Cursor
  RAISES {TrestleComm.Failure} &lt;* LL.sup = trsl, such that trsl.dpy = dpy *&gt; =
  VAR
    rgb               := X.XColor{0, 0, 0, 0, 0, 0};
    zero: X.Pixmap;
    gc  : X.GC;
    gcv : X.XGCValues;
    res : X.Cursor;
  BEGIN
    TRY
      zero := X.XCreatePixmap(dpy, w, 1, 1, 1);
      gcv.function := X.GXclear;
      gc := X.XCreateGC(dpy, zero, X.GCFunction, ADR(gcv));
      X.XFillRectangle(dpy, zero, gc, 0, 0, 1, 1);
      X.XFreeGC(dpy, gc);
      res :=
        X.XCreatePixmapCursor(dpy, zero, zero, ADR(rgb), ADR(rgb), 0, 0);
      X.XFreePixmap(dpy, zero);
    EXCEPT
      X.Error =&gt; RAISE TrestleComm.Failure
    END;
    RETURN res
  END NullCursor;

PROCEDURE <A NAME="CursorRegister"><procedure>CursorRegister</procedure></A> (                    orc: CursorOracle;
                                     READONLY c  : ScrnCursor.Raw;
                          &lt;*UNUSED*&gt;          nm : TEXT             := NIL):
  ScrnCursor.T RAISES {TrestleComm.Failure} =
  VAR
    gcv   : X.XGCValues;
    res                 := NEW(XCursor);
    fg, bg: X.XColor;
  BEGIN
    TRY
    IF (c.plane1 = NIL) OR (c.plane2 = NIL) OR (c.plane1.depth # 1)
         OR (c.plane2.depth # 1) OR Rect.IsEmpty(c.plane1.bounds)
         OR (c.plane1.bounds # c.plane2.bounds) THEN
      RETURN ScrnCursor.DontCare
    END;
    WITH st   = orc.st,
         trsl = st.trsl,
         dpy  = trsl.dpy DO
      TrestleOnX.Enter(trsl);
      TRY
        WITH mask   = XScrnPxmp.PixmapFromRaw(st.bits, c.plane1),
             source = XScrnPxmp.PixmapFromRaw(st.bits, c.plane2)  DO
          IF st.cursorGC = NIL THEN
            gcv.function := X.GXor;
            gcv.graphics_exposures := X.False;
            st.cursorGC := X.XCreateGC(dpy, mask, X.GCFunction, ADR(gcv))
          END;
          IF st.cursorGC2 = NIL THEN
            gcv.function := X.GXorInverted;
            gcv.graphics_exposures := X.False;
            st.cursorGC2 := X.XCreateGC(dpy, mask, X.GCFunction, ADR(gcv))
          END;
          X.XCopyArea(dpy, source, mask, st.cursorGC, 0, 0,
                      Rect.HorSize(c.plane1.bounds),
                      Rect.VerSize(c.plane1.bounds), 0, 0);
          IF st.color THEN
            fg.red := ROUND(FLOAT(16_ffff) * c.color1.r);
            fg.green := ROUND(FLOAT(16_ffff) * c.color1.g);
            fg.blue := ROUND(FLOAT(16_ffff) * c.color1.b);
            bg.red := ROUND(FLOAT(16_ffff) * c.color2.r);
            bg.green := ROUND(FLOAT(16_ffff) * c.color2.g);
            bg.blue := ROUND(FLOAT(16_ffff) * c.color2.b)
          ELSIF st.depth # 1 THEN
            fg.red := ROUND(FLOAT(16_ffff) * c.color1.gray);
            fg.green := fg.red;
            fg.blue := fg.red;
            bg.red := ROUND(FLOAT(16_ffff) * c.color2.gray);
            bg.green := bg.red;
            bg.blue := bg.red
          ELSE
            IF c.color1.bw = Cursor.BW.UseBg THEN
              fg.red := 16_ffff;
              (* gross hack for broken Macintosh XServer *)
              X.XCopyArea(dpy, mask, source, st.cursorGC2, 0, 0,
                          Rect.HorSize(c.plane1.bounds),
                          Rect.VerSize(c.plane1.bounds), 0, 0);
            ELSE
              fg.red := 0
            END;
            fg.green := fg.red;
            fg.blue := fg.red;
            IF c.color2.bw = Cursor.BW.UseBg THEN
              bg.red := 16_ffff
            ELSE
              bg.red := 0
            END;
            bg.green := bg.red;
            bg.blue := bg.red
          END;
          res.id :=
            X.XCreatePixmapCursor(dpy, source, mask, ADR(fg), ADR(bg),
                                  c.hotspot.h - c.plane1.bounds.west,
                                  c.hotspot.v - c.plane1.bounds.north);
          X.XFreePixmap(dpy, mask);
          X.XFreePixmap(dpy, source)
        END
      FINALLY
        TrestleOnX.Exit(trsl)
      END
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN res
  END CursorRegister;

PROCEDURE <A NAME="CursorList"><procedure>CursorList</procedure></A> (&lt;*UNUSED*&gt; orc       : CursorOracle;
                      &lt;*UNUSED*&gt; pat       : TEXT;
                      &lt;*UNUSED*&gt; maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT =
  BEGIN
    RETURN NIL
  END CursorList;

PROCEDURE <A NAME="CursorLookup"><procedure>CursorLookup</procedure></A> (orc: CursorOracle; name: TEXT): ScrnCursor.T
  RAISES {TrestleComm.Failure} =
  VAR
    trsl: XClient.T := orc.st.trsl;
    res             := NEW(XCursor);
  BEGIN
    TRY
    FOR i := 0 TO LAST(XCursors.Names) DO
      IF Text.Equal(name, XCursors.Names[i]) THEN
        TrestleOnX.Enter(trsl);
        TRY
          res.id := X.XCreateFontCursor(trsl.dpy, 2 * i);
          RETURN res
        FINALLY
          TrestleOnX.Exit(trsl)
        END
      END
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN NIL
  END CursorLookup;

PROCEDURE <A NAME="CursorBuiltIn"><procedure>CursorBuiltIn</procedure></A> (orc: CursorOracle; cs: Cursor.Predefined):
  ScrnCursor.T =
  VAR xid: X.Cursor;
  BEGIN
    WITH st   = orc.st,
         trsl = st.trsl,
         dpy  = trsl.dpy DO
      TRY
        TrestleOnX.Enter(trsl);
        TRY
          CASE cs OF
            Cursor.DontCare.cs =&gt; RETURN ScrnCursor.DontCare
          | Cursor.TextPointer.cs =&gt;
              xid := X.XCreateFontCursor(dpy, 68 (*X.XC_left_ptr*))
          | Cursor.NotReady.cs =&gt;
              xid := X.XCreateFontCursor(dpy, 150 (*X.XC_watch*))
          ELSE
            xid := X.None
          END
        FINALLY
          TrestleOnX.Exit(trsl)
        END
      EXCEPT
        X.Error, TrestleComm.Failure =&gt; RETURN ScrnCursor.DontCare
      END
    END;
    RETURN NEW(XCursor, id := xid)
  END CursorBuiltIn;

PROCEDURE <A NAME="CursorLocalize"><procedure>CursorLocalize</procedure></A> (&lt;*UNUSED*&gt; cs: XCursor): ScrnCursor.Raw
  RAISES {ScrnCursor.Failure} =
  BEGIN
    RAISE ScrnCursor.Failure
  END CursorLocalize;

PROCEDURE <A NAME="CursorUnregister"><procedure>CursorUnregister</procedure></A> (&lt;*UNUSED*&gt; cs: XCursor) =
  BEGIN
  END CursorUnregister;

BEGIN
END XScrnCrsr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
