<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XScrnFont.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XScrnFont.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XScrnFont.i3">XScrnFont</A></implements></module>;

IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/ScrnFont.i3">ScrnFont</A>,
       <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="XClient.i3">XClient</A>, <A HREF="XScreenType.i3">XScreenType</A>, <A HREF="XScrnTpRep.i3">XScrnTpRep</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>,
       <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;

TYPE
  DeepFontOracle =
    ScrnFont.Oracle OBJECT
      st: XScreenType.T;
    METHODS
      init (st: XScreenType.T): DeepFontOracle := DeepInitFontOracle;
      (* LL = st.trsl *)
    OVERRIDES
      list    := DeepFontList;
      match   := DeepFontMatch;
      lookup  := DeepFontLookup;
      builtIn := DeepFontBuiltIn
    END;
  FontOracle =
    ScrnFont.Oracle OBJECT
      st: XScreenType.T;
      familyAtm, pointSizeAtm, slantAtm, weightNameAtm, foundryAtm,
        widthAtm, pixelSizeAtm, resXAtm, resYAtm, spacingAtm, aveWidthAtm,
        registryAtm, encodingAtm: X.Atom;
      slants  : ARRAY [0 .. 5] OF X.Atom;
      spacings: ARRAY [0 .. 2] OF X.Atom;
    METHODS
      init (st: XScreenType.T): FontOracle RAISES {TrestleComm.Failure} := InitFontOracle;
      (* LL = st.trsl *)
    OVERRIDES
      list    := FontList;
      match   := FontMatch;
      lookup  := FontLookup;
      builtIn := FontBuiltIn
    END;
  XFont = ScrnFont.T;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: XScreenType.T; depthOne := FALSE): ScrnFont.Oracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    IF depthOne THEN
      RETURN NEW(FontOracle).init(scrn);
    ELSE
      RETURN NEW(DeepFontOracle).init(scrn);
    END;
  END NewOracle;

PROCEDURE <A NAME="DeepFontMatch"><procedure>DeepFontMatch</procedure></A> (orc            : DeepFontOracle;
                         family         : TEXT;
                         pointSize      : INTEGER;
                         slant          : ScrnFont.Slant;
                         maxResults     : CARDINAL;
                         weightName     : TEXT;
                         version        : TEXT;
                         foundry        : TEXT;
                         width          : TEXT;
                         pixelsize      : INTEGER;
                         hres, vres     : INTEGER;
                         spacing        : ScrnFont.Spacing;
                         averageWidth   : INTEGER;
                         charsetRegistry: TEXT;
                         charsetEncoding: TEXT              ):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.match(
             family, pointSize, slant, maxResults, weightName, version,
             foundry, width, pixelsize, hres, vres, spacing, averageWidth,
             charsetRegistry, charsetEncoding)
  END DeepFontMatch;

PROCEDURE <A NAME="DeepFontList"><procedure>DeepFontList</procedure></A> (orc: DeepFontOracle; pat: TEXT; maxResults: INTEGER):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.list(pat, maxResults)
  END DeepFontList;

PROCEDURE <A NAME="FontMatch"><procedure>FontMatch</procedure></A> (orc            : FontOracle;
                     family         : TEXT;
                     pointSize      : INTEGER;
                     slant          : ScrnFont.Slant;
                     maxResults     : CARDINAL;
                     weightName     : TEXT;
                     version        : TEXT;
                     foundry        : TEXT;
                     width          : TEXT;
                     pixelsize      : INTEGER;
                     hres, vres     : INTEGER;
                     spacing        : ScrnFont.Spacing;
                     averageWidth   : INTEGER;
                     charsetRegistry: TEXT;
                     charsetEncoding: TEXT              ):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  VAR fname: TEXT;
  BEGIN
    IF Text.Length(version) # 0 THEN
      fname := &quot;+&quot; &amp; version
    ELSE
      fname := &quot;&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; foundry &amp; &quot;-&quot; &amp; family &amp; &quot;-&quot; &amp; weightName &amp; &quot;-&quot;;
    CASE slant OF
      ScrnFont.Slant.Roman =&gt; fname := fname &amp; &quot;R&quot;
    | ScrnFont.Slant.Italic =&gt; fname := fname &amp; &quot;I&quot;
    | ScrnFont.Slant.Oblique =&gt; fname := fname &amp; &quot;O&quot;
    | ScrnFont.Slant.ReverseItalic =&gt; fname := fname &amp; &quot;RI&quot;
    | ScrnFont.Slant.ReverseOblique =&gt; fname := fname &amp; &quot;RO&quot;
    | ScrnFont.Slant.Other =&gt; fname := fname &amp; &quot;OT&quot;
    | ScrnFont.Slant.Any =&gt; fname := fname &amp; &quot;*&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; width &amp; &quot;-*-&quot; &amp; Num(pixelsize) &amp; Num(pointSize)
               &amp; ResNum(hres, orc.st.res[Axis.T.Hor])
               &amp; ResNum(vres, orc.st.res[Axis.T.Ver]);
    CASE spacing OF
      ScrnFont.Spacing.Proportional =&gt; fname := fname &amp; &quot;P&quot;
    | ScrnFont.Spacing.Monospaced =&gt; fname := fname &amp; &quot;M&quot;
    | ScrnFont.Spacing.CharCell =&gt; fname := fname &amp; &quot;C&quot;
    | ScrnFont.Spacing.Any =&gt; fname := fname &amp; &quot;*&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; Num(averageWidth) &amp; charsetRegistry &amp; &quot;-&quot;
               &amp; charsetEncoding;
    RETURN orc.list(fname, maxResults)
  END FontMatch;

PROCEDURE <A NAME="FontList"><procedure>FontList</procedure></A> (orc: FontOracle; pat: TEXT; maxResults: INTEGER):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  VAR s: Ctypes.char_star;
  BEGIN
    TRY
      TrestleOnX.Enter(orc.st.trsl);
      TRY
        s := M3toC.TtoS(pat);
        VAR
          xcount: Ctypes.int;
          fonts := X.XListFonts(orc.st.trsl.dpy, s, MIN(maxResults, 32767),
                                ADR(xcount));
          count: INTEGER           := xcount;
          fp                       := fonts;
          res  : REF ARRAY OF TEXT;
        BEGIN
          IF fonts = NIL THEN RETURN NIL END;
          res := NEW(REF ARRAY OF TEXT, count);
          FOR i := 0 TO count - 1 DO
            res[i] := M3toC.CopyStoT(fp^);
            fp := fp + ADRSIZE(Ctypes.char_star)
          END;
          X.XFreeFontNames(fonts);
          RETURN res
        END
      FINALLY
        TrestleOnX.Exit(orc.st.trsl)
      END
    EXCEPT
      X.Error =&gt; RAISE TrestleComm.Failure
    END;
  END FontList;

PROCEDURE <A NAME="Num"><procedure>Num</procedure></A> (n: INTEGER): TEXT =
  BEGIN
    IF n &lt; 0 THEN RETURN &quot;*-&quot; ELSE RETURN Fmt.Int(n) &amp; &quot;-&quot; END
  END Num;

PROCEDURE <A NAME="ResNum"><procedure>ResNum</procedure></A> (n: INTEGER; res: REAL): TEXT =
  BEGIN
    (* Gross hack to deal with the fact that all available fonts for X are
       either scaled for 75 pixel per inch or 100 pixel per inch
       displays *)
    IF n = -2 THEN
      RETURN Num(ROUND(res * 25.4 / 25.0) * 25)
    ELSE
      RETURN Num(n)
    END
  END ResNum;

PROCEDURE <A NAME="DeepFontLookup"><procedure>DeepFontLookup</procedure></A> (orc: DeepFontOracle; name: TEXT): ScrnFont.T
  RAISES {ScrnFont.Failure, TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.lookup(name)
  END DeepFontLookup;

PROCEDURE <A NAME="FontLookup"><procedure>FontLookup</procedure></A> (orc: FontOracle; name: TEXT): ScrnFont.T
  RAISES {ScrnFont.Failure, TrestleComm.Failure} =
  VAR s: Ctypes.char_star;
  BEGIN
    TRY
    TrestleOnX.Enter(orc.st.trsl);
    TRY
      s := M3toC.TtoS(name);
      VAR xfs := X.XLoadQueryFont(orc.st.trsl.dpy, s);
      BEGIN
        IF xfs = NIL THEN RAISE ScrnFont.Failure END;
        RETURN FontFromXStruct(orc, xfs)
      END
    FINALLY
      TrestleOnX.Exit(orc.st.trsl)
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END FontLookup;

CONST
  BuiltInNames = ARRAY OF
                   TEXT{
                   &quot;-adobe-helvetica-medium-r-normal--*-100-*-*-p-*-iso8859-1&quot;,
                   &quot;-*-helvetica-medium-r-*-*-*-10?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-times-medium-r-*-*-*-10?-*-*-*-*-iso8859-1&quot;,
                   &quot;fixed&quot;, &quot;-*-helvetica-*-r-*-*-*-11?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-helvetica-*-r-*-*-*-12?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-helvetica-*-r-*-*-*-1??-*-*-*-*-iso8859-?&quot;,
                   &quot;-*-times-*-r-*-*-*-1??-*-*-*-*-iso8859-?&quot;, &quot;timrom1?&quot;,
                   &quot;times_roman1?&quot;, &quot;*&quot;};

PROCEDURE <A NAME="DeepFontBuiltIn"><procedure>DeepFontBuiltIn</procedure></A> (orc: DeepFontOracle; id: Font.Predefined):
  ScrnFont.T =
  BEGIN
    RETURN Palette.ResolveFont(orc.st.bits, Font.T{id})
  END DeepFontBuiltIn;

PROCEDURE <A NAME="FontBuiltIn"><procedure>FontBuiltIn</procedure></A> (orc: FontOracle; id: Font.Predefined): ScrnFont.T =
  VAR xfont: X.XFontStructStar := NIL;
  BEGIN
    IF id # Font.BuiltIn.fnt THEN Crash() END;
    WITH st   = orc.st,
         trsl = st.trsl,
         dpy  = trsl.dpy DO
      TRY
        TrestleOnX.Enter(trsl);
        TRY
          FOR i := FIRST(BuiltInNames) TO LAST(BuiltInNames) DO
            VAR s: Ctypes.char_star;
            BEGIN
              s := M3toC.TtoS(BuiltInNames[i]);
              xfont := X.XLoadQueryFont(dpy, s);
            END;
            IF xfont # NIL THEN RETURN FontFromXStruct(orc, xfont) END
          END;
          Crash();   (* better to return a useless font *)
          &lt;*ASSERT FALSE*&gt;
        FINALLY
          TrestleOnX.Exit(orc.st.trsl)
        END
      EXCEPT
        X.Error, TrestleComm.Failure =&gt;
          RETURN NEW(ScrnFont.T, id := 0,
                     metrics :=
                       NEW(NullMetrics,
                           minBounds := ScrnFont.CharMetric{0, Rect.Empty},
                           maxBounds := ScrnFont.CharMetric{0, Rect.Empty},
                           firstChar := 0, lastChar := 0,
                           selfClearing := TRUE, charMetrics := NIL))
      END
    END;
  END FontBuiltIn;

TYPE
  NullMetrics = ScrnFont.Metrics OBJECT
                OVERRIDES
                  intProp  := NullIntProp;
                  textProp := NullTextProp
                END;

PROCEDURE <A NAME="NullIntProp"><procedure>NullIntProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                       &lt;*UNUSED*&gt; name: TEXT;
                       &lt;*UNUSED*&gt; ch  : INTEGER       := -1): INTEGER
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullIntProp;

PROCEDURE <A NAME="NullTextProp"><procedure>NullTextProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                        &lt;*UNUSED*&gt; name: TEXT;
                        &lt;*UNUSED*&gt; ch  : INTEGER       := -1): TEXT
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullTextProp;

PROCEDURE <A NAME="FontFromXStruct"><procedure>FontFromXStruct</procedure></A> (orc: FontOracle; xfs: X.XFontStructStar): XFont
  RAISES {TrestleComm.Failure} &lt;* LL.sup = orc.st.trsl *&gt; =
  (* return font for xfs and free xfs, even if the exception is raised. *)
  VAR
    res := NEW(XFont, id := xfs.fid, metrics := NEW(NullMetrics));
    xcs: X.XCharStructStar;
  BEGIN
    TRY
    TRY
      WITH trsl = orc.st.trsl,
           m    = res.metrics  DO
        m.family := TextProp(trsl, xfs, orc.familyAtm);
        m.pointSize := IntProp(xfs, orc.pointSizeAtm);
        m.slant :=
          VAL(OrdProp(xfs, orc.slantAtm, orc.slants), ScrnFont.Slant);
        m.weightName := TextProp(trsl, xfs, orc.weightNameAtm);
        m.version := &quot;&quot;;
        m.foundry := TextProp(trsl, xfs, orc.foundryAtm);
        m.width := TextProp(trsl, xfs, orc.widthAtm);
        m.pixelsize := IntProp(xfs, orc.pixelSizeAtm);
        m.hres := IntProp(xfs, orc.resXAtm);
        m.vres := IntProp(xfs, orc.resYAtm);
        m.spacing := VAL(OrdProp(xfs, orc.spacingAtm, orc.spacings),
                         ScrnFont.Spacing);
        m.averageWidth := IntProp(xfs, orc.aveWidthAtm);
        m.charsetRegistry := TextProp(trsl, xfs, orc.registryAtm);
        m.charsetEncoding := TextProp(trsl, xfs, orc.encodingAtm);
        m.firstChar := xfs.min_char_or_byte2;
        m.lastChar := xfs.max_char_or_byte2;
        m.isAscii := Text.Equal(m.charsetRegistry, &quot;ISO8859&quot;);
        m.defaultChar := xfs.default_char;
        m.ascent := xfs.ascent;
        m.descent := xfs.descent;
        m.fprint := Fingerprint.FromText(&quot;X font:&quot;);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.firstChar), ARRAY OF CHAR),
                                m.fprint);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.lastChar), ARRAY OF CHAR),
                                m.fprint);
        m.fprint := Fingerprint.FromChars(
                      LOOPHOLE(ADR(m.defaultChar), ARRAY OF CHAR),
                      m.fprint);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.ascent), ARRAY OF CHAR),
                                m.fprint);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.descent), ARRAY OF CHAR),
                                m.fprint);
        VAR temp := xfs.min_bounds.lbearing;
        BEGIN
          xfs.min_bounds.lbearing := xfs.max_bounds.lbearing;
          xfs.max_bounds.lbearing := temp
        END;
        ToCharMetric(xfs.min_bounds, m.minBounds);
        ToCharMetric(xfs.max_bounds, m.maxBounds);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.minBounds), ARRAY OF CHAR),
                                m.fprint);
        m.fprint :=
          Fingerprint.FromChars(LOOPHOLE(ADR(m.maxBounds), ARRAY OF CHAR),
                                m.fprint);
        IF (xfs.per_char = NIL) OR (m.minBounds = m.maxBounds) THEN
          m.charMetrics := NIL;
          WITH bd = m.minBounds,
               bb = bd.boundingBox DO
            IF bd.printWidth &gt;= 0 THEN
              m.rightKerning := bb.east &gt; bd.printWidth;
              m.leftKerning := bb.west &lt; 0
            ELSE
              m.rightKerning := bb.east &gt; 0;
              m.leftKerning := bb.west &lt; bd.printWidth;
            END;
            m.selfClearing := NOT (m.rightKerning OR m.leftKerning)
          END
        ELSE
          m.fprint :=
            Fingerprint.FromChars(
              LOOPHOLE(xfs.per_char, ARRAY OF CHAR), m.fprint);
          m.charMetrics :=
            NEW(ScrnFont.CharMetrics, m.lastChar - m.firstChar + 1);
          WITH maxb = m.maxBounds.boundingBox DO
            m.selfClearing :=
              (maxb.north &gt;= -xfs.ascent) AND (maxb.south &lt;= xfs.descent)
          END;
          m.rightKerning := FALSE;
          m.leftKerning := FALSE;
          xcs := xfs.per_char;
          FOR i := 0 TO LAST(m.charMetrics^) DO
            ToCharMetric(xcs^, m.charMetrics[i]);
            WITH bd = m.charMetrics[i],
                 bb = bd.boundingBox    DO
              IF bd.printWidth &gt;= 0 THEN
                m.rightKerning :=
                  m.rightKerning OR (bb.east &gt; bd.printWidth);
                m.leftKerning := m.leftKerning OR (bb.west &lt; 0)
              ELSE
                m.rightKerning := m.rightKerning OR (bb.east &gt; 0);
                m.leftKerning :=
                  m.leftKerning OR (bb.west &lt; bd.printWidth);
              END;
              m.selfClearing :=
                m.selfClearing AND NOT (m.rightKerning OR m.leftKerning)
            END;
            xcs := xcs + ADRSIZE(X.XCharStruct)
          END
        END
      END
    FINALLY
      X.XFreeFontInfo(NIL, xfs, 1)
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN res
  END FontFromXStruct;

PROCEDURE <A NAME="ToCharMetric"><procedure>ToCharMetric</procedure></A> (READONLY xcs: X.XCharStruct;
                        VAR      cm : ScrnFont.CharMetric) =
  BEGIN
    cm.printWidth := xcs.width;
    WITH bb = cm.boundingBox DO
      bb.west := xcs.lbearing;
      bb.east := xcs.rbearing;
      bb.north := -xcs.ascent;
      bb.south := xcs.descent;
      IF (bb.west &gt;= bb.east) OR (bb.north &gt;= bb.south) THEN
        bb := Rect.Empty
      END
    END
  END ToCharMetric;

PROCEDURE <A NAME="TextProp"><procedure>TextProp</procedure></A> (trsl: XClient.T; xfs: X.XFontStructStar; a: X.Atom):
  TEXT RAISES {TrestleComm.Failure} =
  VAR b: X.Atom;
  BEGIN
    TRY
    IF X.XGetFontProperty(xfs, a, ADR(b)) # X.False THEN
      RETURN XClient.ToName(trsl, b)
    ELSE
      RETURN &quot;*&quot;
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END TextProp;

PROCEDURE <A NAME="IntProp"><procedure>IntProp</procedure></A> (xfs: X.XFontStructStar; a: X.Atom): INTEGER
  RAISES {TrestleComm.Failure} =
  VAR b: INTEGER;
  BEGIN
    TRY
    IF X.XGetFontProperty(xfs, a, ADR(b)) # X.False THEN
      RETURN b
    ELSE
      RETURN -1
    END
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
  END IntProp;

PROCEDURE <A NAME="OrdProp"><procedure>OrdProp</procedure></A> (         xfs  : X.XFontStructStar;
                            a    : X.Atom;
                   READONLY names: ARRAY OF X.Atom    ): INTEGER
  RAISES {TrestleComm.Failure} =
  VAR b: X.Atom;
  BEGIN
    TRY
    IF X.XGetFontProperty(xfs, a, ADR(b)) # X.False THEN
      FOR i := 0 TO LAST(names) DO IF names[i] = b THEN RETURN i END END
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN NUMBER(names)
  END OrdProp;

PROCEDURE <A NAME="InitFontOracle"><procedure>InitFontOracle</procedure></A> (orc: FontOracle; st: XScreenType.T): FontOracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    orc.st := st;
    WITH trsl = st.trsl DO
      orc.familyAtm := XClient.ToAtom(trsl, &quot;FAMILY_NAME&quot;);
      orc.pointSizeAtm := XClient.ToAtom(trsl, &quot;POINT_SIZE&quot;);
      orc.slantAtm := XClient.ToAtom(trsl, &quot;SLANT&quot;);
      orc.weightNameAtm := XClient.ToAtom(trsl, &quot;WEIGHT_NAME&quot;);
      orc.foundryAtm := XClient.ToAtom(trsl, &quot;FOUNDRY&quot;);
      orc.widthAtm := XClient.ToAtom(trsl, &quot;SETWIDTH_NAME&quot;);
      orc.pixelSizeAtm := XClient.ToAtom(trsl, &quot;PIXEL_SIZE&quot;);
      orc.resXAtm := XClient.ToAtom(trsl, &quot;RESOLUTION_X&quot;);
      orc.resYAtm := XClient.ToAtom(trsl, &quot;RESOLUTION_Y&quot;);
      orc.spacingAtm := XClient.ToAtom(trsl, &quot;SPACING&quot;);
      orc.aveWidthAtm := XClient.ToAtom(trsl, &quot;AVERAGE_WIDTH&quot;);
      orc.registryAtm := XClient.ToAtom(trsl, &quot;CHARSET_REGISTRY&quot;);
      orc.encodingAtm := XClient.ToAtom(trsl, &quot;CHARSET_ENCODING&quot;);
      orc.slants[0] := XClient.ToAtom(trsl, &quot;R&quot;);
      orc.slants[1] := XClient.ToAtom(trsl, &quot;I&quot;);
      orc.slants[2] := XClient.ToAtom(trsl, &quot;O&quot;);
      orc.slants[3] := XClient.ToAtom(trsl, &quot;RI&quot;);
      orc.slants[4] := XClient.ToAtom(trsl, &quot;RO&quot;);
      orc.slants[5] := XClient.ToAtom(trsl, &quot;OT&quot;);
      orc.spacings[0] := XClient.ToAtom(trsl, &quot;P&quot;);
      orc.spacings[1] := XClient.ToAtom(trsl, &quot;M&quot;);
      orc.spacings[2] := XClient.ToAtom(trsl, &quot;C&quot;)
    END;
    RETURN orc
  END InitFontOracle;

PROCEDURE <A NAME="DeepInitFontOracle"><procedure>DeepInitFontOracle</procedure></A> (orc: DeepFontOracle; st: XScreenType.T):
  DeepFontOracle =
  BEGIN
    orc.st := st;
    RETURN orc
  END DeepInitFontOracle;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN
END XScrnFont.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
