<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XScrnPxmp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XScrnPxmp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="XScrnPxmp.i3">XScrnPxmp</A></implements></module>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>,
       <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="XClientF.i3">XClientF</A>, <A HREF="XScreenType.i3">XScreenType</A>, <A HREF="XScrnTpRep.i3">XScrnTpRep</A>, <A HREF="TrestleOnX.i3">TrestleOnX</A>,
       <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A>;

REVEAL
  <A NAME="T">T</A> = T_Pub BRANDED OBJECT
        copyGC := ARRAY BOOLEAN OF X.GC{NIL, NIL};
        (* copyGC[FALSE] is for initializing depth 1 pixmaps, copyGC[TRUE]
           is for initializing deep pixmaps. *)
        bestX, bestY := ARRAY BOOLEAN OF INTEGER{-1, ..};
        (* [FALSE] =&gt; stipple, [TRUE] =&gt; tile *)
        tileGC            := ARRAY BOOLEAN OF X.GC{NIL, ..};
        pmcount: CARDINAL := 0
        (* number of entries in pmtable *)
      END;

TYPE
  XPixmap = ScrnPixmap.T OBJECT
              st: XScreenType.T;
            OVERRIDES
              unload   := PixmapUnregister;
              localize := PixmapLocalize;
              free     := PixmapFree
            END;

  PixmapOracle = ScrnPixmap.Oracle OBJECT
                   st: XScreenType.T;
                 OVERRIDES
                   load    := PixmapRegister;
                   list    := PixmapList;
                   lookup  := PixmapLookup;
                   builtIn := PixmapBuiltIn
                 END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (st: XScreenType.T): ScrnPixmap.Oracle =
  BEGIN
    RETURN NEW(PixmapOracle, st := st)
  END NewOracle;

PROCEDURE <A NAME="FromXPixmap"><procedure>FromXPixmap</procedure></A> (         st   : XScreenType.T;
                                xpm  : X.Pixmap;
                       READONLY dom  : Rect.T;
                                depth: INTEGER        ): ScrnPixmap.T =
  BEGIN
    RETURN NewPixmap(
             st, XScrnTpRep.PixmapRecord{pixmap := xpm, domain := dom,
                                         depth := depth, isLazy := FALSE})
  END FromXPixmap;

PROCEDURE <A NAME="FakeCapture"><procedure>FakeCapture</procedure></A> (         st    : XScreenType.T;
                                w     : X.Drawable;
                       READONLY dom: Rect.T;
                                depth : INTEGER        ): ScrnPixmap.T =
  BEGIN
    RETURN NewPixmap(
             st, XScrnTpRep.PixmapRecord{pixmap := w, domain := dom,
                                         depth := depth, isLazy := TRUE})
  END FakeCapture;

PROCEDURE <A NAME="PixmapDomain"><procedure>PixmapDomain</procedure></A> (st: XScreenType.T; pmId: INTEGER): Rect.T =
  BEGIN
    IF pmId &lt; 0 THEN
      IF pmId = XScrnTpRep.SolidPixmap THEN RETURN rawSolid.bounds END;
      pmId := XScrnTpRep.SolidPixmap - pmId;
      st := st.bits
    END;
    IF pmId &lt; NUMBER(st.pmtable^) THEN
      RETURN st.pmtable[pmId].domain
    ELSE
      RETURN Rect.Empty
    END
  END PixmapDomain;

PROCEDURE <A NAME="IsLazy"><procedure>IsLazy</procedure></A>(st: XScreenType.T; pmId: INTEGER): BOOLEAN =
  BEGIN
    IF pmId &lt; 0 THEN
      IF pmId = XScrnTpRep.SolidPixmap THEN RETURN FALSE END;
      pmId := XScrnTpRep.SolidPixmap - pmId;
      st := st.bits
    END;
    IF pmId &lt; NUMBER(st.pmtable^) THEN
      RETURN st.pmtable[pmId].isLazy
    ELSE
      RETURN FALSE
    END
  END IsLazy;

PROCEDURE <A NAME="GetDrawable"><procedure>GetDrawable</procedure></A>(st: XScreenType.T; pmId: INTEGER): X.Drawable =
  BEGIN
    IF pmId &lt; 0 THEN
      IF pmId = XScrnTpRep.SolidPixmap THEN RETURN X.None END;
      pmId := XScrnTpRep.SolidPixmap - pmId;
      st := st.bits
    END;
    IF pmId &lt; NUMBER(st.pmtable^) THEN
      RETURN st.pmtable[pmId].pixmap
    ELSE
      RETURN X.None
    END
  END GetDrawable;

PROCEDURE <A NAME="FinishCapture"><procedure>FinishCapture</procedure></A> (st: XScreenType.T; pmId: INTEGER; xpm: X.Pixmap) =
  BEGIN
    IF pmId &lt; 0 THEN
      IF pmId = XScrnTpRep.SolidPixmap THEN RETURN END;
      pmId := XScrnTpRep.SolidPixmap - pmId;
      st := st.bits
    END;
    IF pmId &lt; NUMBER(st.pmtable^) THEN
      st.pmtable[pmId].isLazy := FALSE;
      st.pmtable[pmId].pixmap := xpm
    END
  END FinishCapture;

PROCEDURE <A NAME="NewPixmap"><procedure>NewPixmap</procedure></A> (         st : XScreenType.T;
                     READONLY rec: XScrnTpRep.PixmapRecord): XPixmap
  &lt;* LL.sup = st.trsl *&gt; =
  VAR res := NEW(XPixmap, depth := rec.depth, bounds := rec.domain);
  BEGIN
    IF rec.depth = 1 THEN st := st.bits END;
    res.st := st;
    WITH n = NUMBER(st.pmtable^) DO
      IF n = st.pmcount THEN
        WITH new = NEW(REF ARRAY OF XScrnTpRep.PixmapRecord, 2 * n) DO
          FOR i := 0 TO n - 1 DO new[i] := st.pmtable[i] END;
          st.pmtable := new
        END
      END
    END;
    IF st.bits = st THEN
      res.id := XScrnTpRep.SolidPixmap - st.pmcount
    ELSE
      res.id := st.pmcount
    END;
    st.pmtable[st.pmcount] := rec;
    INC(st.pmcount);
    RETURN res
  END NewPixmap;

&lt;*INLINE*&gt; PROCEDURE <A NAME="XDestroyImage"><procedure>XDestroyImage</procedure></A> (xim: X.XImageStar) =
  BEGIN
    EVAL xim.f.destroy_image(xim)
  END XDestroyImage;

&lt;*INLINE*&gt; PROCEDURE <A NAME="XGetPixel"><procedure>XGetPixel</procedure></A> (xim: X.XImageStar; x, y: Ctypes.int):
  Ctypes.unsigned_long =
  BEGIN
    RETURN xim.f.get_pixel(xim, x, y)
  END XGetPixel;
</PRE> PixmapRegister, List, and Lookup must be changed to use the names. 

<P><PRE>PROCEDURE <A NAME="PixmapRegister"><procedure>PixmapRegister</procedure></A> (                    orc: PixmapOracle;
                                     READONLY pm : ScrnPixmap.Raw;
                          &lt;*UNUSED*&gt;          nm : TEXT             := NIL):
  ScrnPixmap.T RAISES {TrestleComm.Failure} =
  VAR rec: XScrnTpRep.PixmapRecord;
  BEGIN
    WITH st   = orc.st,
         trsl = st.trsl,
         dpy  = trsl.dpy DO
      TrestleOnX.Enter(trsl);
      TRY
        IF pm.depth # 1 AND pm.depth # st.depth THEN Crash() END;
        rec.domain := pm.bounds;
        rec.depth := pm.depth;
        rec.pixmap := PixmapFromRaw(st, pm);
        rec.isLazy := FALSE;
        RETURN NewPixmap(st, rec)
      FINALLY
        TrestleOnX.Exit(trsl)
      END
    END
  END PixmapRegister;

PROCEDURE <A NAME="PixmapFromRaw"><procedure>PixmapFromRaw</procedure></A> (st: XScreenType.T; pm: ScrnPixmap.Raw): X.Pixmap
  RAISES {TrestleComm.Failure} &lt;* LL.sup = st.trsl *&gt; =
  VAR
    gcv: X.XGCValues;
    xim: X.XImageStar;
    res: X.Pixmap;
    w_ret, h_ret: Ctypes.unsigned_int;
  BEGIN
    TRY
      IF Rect.IsEmpty(pm.bounds) THEN RETURN X.None END;
      WITH dpy    = st.trsl.dpy,
           width  = Rect.HorSize(pm.bounds),
           height = Rect.VerSize(pm.bounds),
           depth  = pm.depth                 DO
        res := X.XCreatePixmap(dpy, st.root, width, height, depth);
        WITH deep = (depth # 1) DO
          IF st.copyGC[deep] = NIL THEN
            gcv.graphics_exposures := X.False;
            st.copyGC[deep] :=
              X.XCreateGC(dpy, res, X.GCGraphicsExposures, ADR(gcv))
          END;
          IF st.bestX[deep] = -1 THEN
            IF deep THEN
              EVAL
                X.XQueryBestTile(dpy, st.root, width, height,
                                 ADR(w_ret), ADR(h_ret))
            ELSE
              EVAL X.XQueryBestStipple(
                     dpy, st.root, width, height, ADR(w_ret),
                     ADR(h_ret))
            END;
            st.bestX[deep] := w_ret;
            st.bestY[deep] := h_ret
          END;
          xim := X.XCreateImage(
                   dpy, st.visual, depth, X.ZPixmap,
                   pm.bounds.west MOD (BITSIZE(ScrnPixmap.PixWord) DIV pm.bitsPerPixel),
                   LOOPHOLE(ADR(pm.pixels[pm.offset]), Ctypes.char_star),
                   width, height,
                   BITSIZE(ScrnPixmap.PixWord),
                   BYTESIZE(ScrnPixmap.PixWord) * pm.wordsPerRow);
          TRY
            IF pm.pixelOrder = ScrnPixmap.ByteOrder.LSBFirst THEN
              xim.bitmap_bit_order := X.LSBFirst
            ELSE
              xim.bitmap_bit_order := X.MSBFirst
            END;
            IF PaintPrivate.HostByteOrder = PaintPrivate.ByteOrder.LSBFirst THEN
              xim.byte_order := X.LSBFirst
            ELSE
              xim.byte_order := X.MSBFirst
            END;
            xim.bitmap_unit := BITSIZE(ScrnPixmap.PixWord);
            xim.bits_per_pixel := pm.bitsPerPixel;
            X.XPutImage(
              dpy, res, st.copyGC[deep], xim, 0, 0, 0, 0, width, height);
            IF width &lt;= st.bestX[deep] AND height &lt;= st.bestY[deep]
                 AND (width # st.bestX[deep] OR height # st.bestY[deep])
                 AND st.bestX[deep] MOD width = 0
                 AND st.bestY[deep] MOD height = 0 THEN
              VAR
                tmp := X.XCreatePixmap(dpy, st.root, st.bestX[deep],
                                       st.bestY[deep], depth);
              BEGIN
                IF st.tileGC[deep] = NIL THEN
                  gcv.graphics_exposures := X.False;
                  gcv.fill_style := X.FillTiled;
                  st.tileGC[deep] :=
                    X.XCreateGC(
                      dpy, tmp, X.GCGraphicsExposures + X.GCFillStyle,
                      ADR(gcv))
                END;
                X.XSetTile(dpy, st.tileGC[deep], res);
                X.XFreePixmap(dpy, res);
                res := tmp;
              END;
              X.XFillRectangle(dpy, res, st.tileGC[deep], 0, 0,
                               st.bestX[deep], st.bestY[deep])
            END
          FINALLY
            xim.data := NIL;
            XDestroyImage(xim)
          END
        END
      END;
    EXCEPT
      X.Error =&gt; RAISE TrestleComm.Failure
    END;
    RETURN res
  END PixmapFromRaw;

PROCEDURE <A NAME="PixmapList"><procedure>PixmapList</procedure></A> (&lt;*UNUSED*&gt; orc       : PixmapOracle;
                      &lt;*UNUSED*&gt; pat       : TEXT;
                      &lt;*UNUSED*&gt; maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT =
  BEGIN
    RETURN NIL
  END PixmapList;

PROCEDURE <A NAME="PixmapLookup"><procedure>PixmapLookup</procedure></A> (&lt;*UNUSED*&gt; orc: PixmapOracle; &lt;*UNUSED*&gt; name: TEXT):
  ScrnPixmap.T =
  BEGIN
    RETURN NIL
  END PixmapLookup;

PROCEDURE <A NAME="PixmapBuiltIn"><procedure>PixmapBuiltIn</procedure></A> (orc: PixmapOracle; pm: Pixmap.Predefined):
  ScrnPixmap.T =
  VAR res: ScrnPixmap.T;
  BEGIN
    IF orc.st.bits # orc.st THEN
      res := Palette.ResolvePixmap(orc.st.bits, Pixmap.T{pm});
      IF pm = Pixmap.Empty.pm THEN orc.st.empty := res.id END;
      RETURN res
    END;
    TRY
      CASE pm OF
        Pixmap.Solid.pm =&gt;
          WITH res = PixmapRegister(orc, rawSolid) DO
            res.id := XScrnTpRep.SolidPixmap;
            RETURN res
          END
      | Pixmap.Gray.pm =&gt; RETURN PixmapRegister(orc, rawGray)
      | Pixmap.Empty.pm =&gt;
          res := PixmapRegister(orc, rawEmpty);
          orc.st.empty := res.id;
          RETURN res
      ELSE
        Crash(); &lt;*ASSERT FALSE*&gt;
      END
    EXCEPT
      TrestleComm.Failure =&gt;
        RETURN NEW(XPixmap, id := 0, depth := 1, bounds := Rect.Empty)
    END
  END PixmapBuiltIn;

PROCEDURE <A NAME="PixmapLocalize"><procedure>PixmapLocalize</procedure></A> (pm: XPixmap; READONLY rect: Rect.T):
  ScrnPixmap.Raw RAISES {TrestleComm.Failure} =
  VAR
    res: ScrnPixmap.Raw;
    id                  := pm.id;
  BEGIN
    TRY
    IF id = XScrnTpRep.SolidPixmap THEN RETURN rawSolid END;
    WITH r      = Rect.Meet(rect, pm.bounds),
         st     = pm.st,
         trsl   = st.trsl,
         dpy    = trsl.dpy,
         width  = Rect.HorSize(r),
         height = Rect.VerSize(r)             DO
      IF Rect.IsEmpty(r) THEN RETURN NIL END;
      IF id &lt; 0 THEN id := XScrnTpRep.SolidPixmap - id END;
      TrestleOnX.Enter(trsl);
      TRY
        WITH xim = X.XGetImage(
                     dpy, st.pmtable[id].pixmap, r.west - pm.bounds.west,
                     r.north - pm.bounds.north, width, height, -1,
                     X.ZPixmap) DO
          res := ScrnPixmap.NewRaw(xim.depth, r);
          FOR v := r.north TO r.south - 1 DO
            FOR h := r.west TO r.east - 1 DO
              res.set(
                Point.T{h, v}, XGetPixel(xim, h - r.west, v - r.north))
            END
          END;
          XDestroyImage(xim)
        END
      FINALLY
        TrestleOnX.Exit(trsl)
      END
    END;
    EXCEPT X.Error =&gt; RAISE TrestleComm.Failure END;
    RETURN res
  END PixmapLocalize;

PROCEDURE <A NAME="PixmapUnregister"><procedure>PixmapUnregister</procedure></A> (&lt;*UNUSED*&gt; pm: ScrnPixmap.T) =
  BEGIN
  END PixmapUnregister;

PROCEDURE <A NAME="PixmapFree"><procedure>PixmapFree</procedure></A> (pm: XPixmap) RAISES {TrestleComm.Failure} =
  VAR
    id   := pm.id;
    st   := pm.st;
    trsl := st.trsl;
    dpy  := trsl.dpy;
  BEGIN
    TRY
      IF id = XScrnTpRep.SolidPixmap THEN RETURN END;
      IF id &lt; 0 THEN id := XScrnTpRep.SolidPixmap - id END;
      TrestleOnX.Enter(trsl);
      TRY
        IF st.pmtable[id].isLazy THEN
          st.pmtable[id].pixmap := X.None;
          st.pmtable[id].isLazy := FALSE
        ELSE
          WITH xpm = st.pmtable[id].pixmap DO
            IF xpm # X.None THEN X.XFreePixmap(dpy, xpm) END;
            xpm := X.None
          END
        END
      FINALLY
        TrestleOnX.Exit(trsl)
      END;
    EXCEPT
      X.Error =&gt; RAISE TrestleComm.Failure
    END;
  END PixmapFree;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError
  END Crash;

VAR
  rawSolid, rawGray, rawEmpty: ScrnPixmap.Raw;
  gp                         : Word.T         := 5;
  i                                           := 4;

BEGIN
  rawSolid := ScrnPixmap.NewRaw(1, Rect.FromSize(1, 1));
  IF FIRST(ScrnPixmap.PixWord) &lt; 0 THEN
    rawSolid.pixels[rawSolid.offset] := FIRST(ScrnPixmap.PixWord);
  ELSE
    rawSolid.pixels[rawSolid.offset] := LAST(ScrnPixmap.PixWord);
  END;
  rawEmpty := ScrnPixmap.NewRaw(1, Rect.FromSize(1, 1));
  rawEmpty.pixels[rawEmpty.offset] := 0;
  rawGray := ScrnPixmap.NewRaw(1, Rect.FromSize(2, 2));
  WHILE i &lt; BITSIZE(ScrnPixmap.PixWord) DO
    gp := Word.Or(gp, Word.LeftShift(gp, i));
    INC(i,i)
  END;
  rawGray.pixels[rawGray.offset] := gp;
  IF FIRST(ScrnPixmap.PixWord) &lt; 0 THEN
    rawGray.pixels[rawGray.offset + rawGray.wordsPerRow] :=
      Word.Not(gp)
  ELSE
    rawGray.pixels[rawGray.offset + rawGray.wordsPerRow] :=
      Word.And(LAST(ScrnPixmap.PixWord), Word.Not(gp));
  END
END XScrnPxmp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
