<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XSharedMem.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XSharedMem.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="XSharedMem.i3">XSharedMem</A></implements></module>;

IMPORT <A HREF="../picture/Completion.i3">Completion</A>, <A HREF="Compl.i3">Compl</A>, <A HREF="../../derived/ComplSeq.i3">ComplSeq</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x1">Picture</A>, <A HREF="../picture/PictureRep.i3">PictureRep</A>, <A HREF="../../../tcp/src/common/IP.i3">IP</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>,
       <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="XClient.i3">XClient</A>, <A HREF="XClientExt.i3">XClientExt</A>, <A HREF="XClientF.i3">XClientF</A>, <A HREF="XPicture.i3">XPicture</A>,
       <A HREF="XScreenType.i3">XScreenType</A>, <A HREF="XShm.i3">XShm</A>;
</PRE> New() exported by XSharedFree 

<P> {{{ -- XClient and XScreenType stuff -- 

<P><PRE>REVEAL
  <A NAME="XClient_T">XClient_T</A> = XClientF.T_Rel BRANDED OBJECT
                wf: WaitFor := NIL; (* this catches all the completion
                                       events for this client *)
                shmEventBase := -1; (* GetEventBase returns -1 on error, so
                                       use it to signify no extension *)
              END;

PROCEDURE <A NAME="InitXClient"><procedure>InitXClient</procedure></A> (v: XClient.T) RAISES {TrestleComm.Failure} =
  BEGIN
    TRY
      IF SameHost(v) AND XShm.QueryExtension(v.dpy) = X.True THEN
        v.shmEventBase := XShm.GetEventBase(v.dpy);
        v.wf := NEW(WaitFor, seq := NEW(ComplSeq.T).init(),
                    timeout := FALSE, timelimit := -1);
        v.wf.types[0] := v.shmEventBase + XShm.ShmCompletion;
        v.wf.types[1] := 0;
        XClientF.RegisterWaiter(v, v.wf);
      END;
    EXCEPT
      X.Error =&gt; RAISE TrestleComm.Failure
    END;
  END InitXClient;

PROCEDURE <A NAME="InitXScreenType"><procedure>InitXScreenType</procedure></A> (&lt;* UNUSED *&gt; st: XScreenType.T) =
  BEGIN
  END InitXScreenType;

PROCEDURE <A NAME="UsesExtension"><procedure>UsesExtension</procedure></A> (st: VBT.ScreenType): BOOLEAN =
  BEGIN
    TYPECASE st OF
    | XScreenType.T (xst) =&gt; RETURN xst.trsl.shmEventBase # -1;
    ELSE
      RETURN FALSE;
    END;
  END UsesExtension;

PROCEDURE <A NAME="EventBase"><procedure>EventBase</procedure></A> (v: XClient.T): X.Int =
  BEGIN
    RETURN v.shmEventBase;
  END EventBase;

PROCEDURE <A NAME="PictureUsesExt"><procedure>PictureUsesExt</procedure></A> (st: VBT.ScreenType; picture: Picture.T):
  BOOLEAN =
  BEGIN
    TYPECASE (st) OF
    | XScreenType.T (xst) =&gt;
        TYPECASE (picture) OF
        | T (shpicture) =&gt;
            RETURN
              xst.trsl.shmEventBase # -1 AND shpicture.segmentInfo # NIL
                AND shpicture.dpy = xst.trsl.dpy;
        ELSE
          RETURN FALSE;
        END;
    ELSE
      RETURN FALSE;
    END;
  END PictureUsesExt;

PROCEDURE <A NAME="MakeCompletion"><procedure>MakeCompletion</procedure></A> (&lt;*UNUSED*&gt; im: T): Completion.T =
  BEGIN
    RETURN Completion.New();
  END MakeCompletion;
</PRE> }}} 
 {{{ -- host name stuff -- 

<P> return TRUE if server and client are on same host 
<PRE>PROCEDURE <A NAME="SameHost"><procedure>SameHost</procedure></A> (trsl: XClient.T): BOOLEAN =
  VAR
    display                 := DisplayHost(trsl);
    displayAddr: IP.Address;
  BEGIN
    IF display = NIL THEN RETURN TRUE; END;

    TRY
      IF NOT IP.GetHostByName(display, displayAddr) THEN RETURN FALSE; END;
    EXCEPT
    | IP.Error =&gt; RETURN FALSE;
    END;
    RETURN displayAddr = IP.GetHostAddr();
  END SameHost;

PROCEDURE <A NAME="DisplayHost"><procedure>DisplayHost</procedure></A> (trsl: XClient.T): TEXT =
  (* return NIL if host is local *)
  VAR display := M3toC.CopyStoT(X.XDisplayString(trsl.dpy));
  BEGIN
    WITH ix = Text.FindChar(display, ':') DO
      IF ix &lt;= 0 THEN RETURN NIL; END;
      display := Text.Sub(display, 0, ix);
    END;
    IF Text.Equal(display, &quot;local&quot;) THEN display := NIL; END;
    RETURN display;
  END DisplayHost;
</PRE> }}} 
 {{{ -- WaitFor -- 
 the WaitFor is protected by the XClient lock 

<P><PRE>TYPE
  WaitFor =
    XClientF.WaitFor OBJECT
      seq: ComplSeq.T := NIL;
      (* we assume that XShm Completion events arrive in the same order as
         their related XShmPutPicture.  There is an element in the sequence
         for each X call which generates an X Completion event *)
      nextSerial: Ctypes.unsigned_long;  (* cache of seq.getLo().serial *)
      nextSerialValid := FALSE;  (* false when seq.size() = 0 *)
    METHODS
      addC (xserial: Ctypes.unsigned_long; c: Completion.T) := AddC;
      (* append the details of the X request to the sequence *)
    OVERRIDES
      match  := Match;
      notify := Notify;
    END;

PROCEDURE <A NAME="AddC"><procedure>AddC</procedure></A> (wf: WaitFor; xserial: Ctypes.unsigned_long; c: Completion.T) =
  BEGIN
    WITH compl = Compl.Get() DO
      compl.serial := xserial;
      compl.completion := c;
      wf.seq.addhi(compl);
      IF NOT wf.nextSerialValid THEN
        wf.nextSerial := xserial;
        wf.nextSerialValid := TRUE;
      END;
    END;
  END AddC;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A> (wf: WaitFor; READONLY ev: X.XEvent): BOOLEAN =
  VAR serial: Ctypes.unsigned_int;
  BEGIN
    WITH any = LOOPHOLE(ADR(ev), X.XAnyEventStar) DO
      IF any.type = 0 THEN
        WITH error = LOOPHOLE(ADR(ev), X.XErrorEventStar) DO
          serial := error.serial;
        END;
      ELSE
        serial := any.serial;
      END;
    END;
    RETURN wf.nextSerialValid AND wf.nextSerial = serial;
  END Match;

PROCEDURE <A NAME="Notify"><procedure>Notify</procedure></A> (wf: WaitFor; READONLY ev: X.XEvent; xcon: XClient.T) =
  VAR serial: Ctypes.unsigned_int;
  BEGIN
    WITH seq  = wf.seq,
         size = seq.size() DO
      &lt;* ASSERT size &gt; 0 *&gt;
      WITH compl = wf.seq.remlo(),
           e     = LOOPHOLE(ADR(ev), X.XAnyEventStar) DO
        IF e.type = 0 THEN
          serial := LOOPHOLE(e, X.XErrorEventStar).serial;
        ELSE
          serial := e.serial;
        END;
        &lt;* ASSERT compl.serial = serial *&gt;
        compl.completion.dec();
        compl.completion := NIL; (* so it can be collected *)
        Compl.Free(compl);
      END;

      IF size &gt; 1 THEN
        wf.nextSerial := seq.getlo().serial;
        (* we know wf.nextSerialValid = TRUE *)
      ELSE
        wf.nextSerialValid := FALSE;
      END;
    END;
    XClientF.RegisterWaiter(xcon, wf); (* wf will have been removed from
                                          the list *)
  END Notify;
</PRE> }}} 
 {{{ -- picture type and methods -- 

<P><PRE>REVEAL
  <A NAME="T">T</A> = XPicture.T BRANDED &quot;XSharedMem.Picture&quot; OBJECT
        xcon: XClient.T     := NIL;
        dpy : X.DisplayStar := NIL;
        (* a shared memory segment is associated with a particular display
           so this field is set during the initialisation.  If a caller
           attempts to put the picture to another display, it is sent using
           XPutPicture. *)
        segmentInfo: XShm.SegmentInfoStar := NIL;
      OVERRIDES
        init          := Init;
        initFromImage := InitFromImage;
        attachData    := AttachData;
        detachData    := DetachData;
        destroy       := Destroy;
        put           := Put;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: Picture.T; st: VBT.ScreenType; width, height: CARDINAL):
  Picture.T RAISES {Picture.ScreenTypeNotSupported, Picture.TrestleFail} =
  VAR
    picture                       := NARROW(t, T);
    shminfo: XShm.SegmentInfoStar;
  BEGIN
    TRY
      TYPECASE st OF
      | XScreenType.T (xst) =&gt;
          shminfo := NewSegment();
          WITH trsl = xst.trsl,
               ximage = XShm.CreateImage(
                          trsl.dpy, xst.visual,
                          X.XDefaultDepth(trsl.dpy, xst.screenID),
                          X.ZPixmap, NIL, shminfo, width, height) DO
            IF ximage = NIL THEN
              FreeSegment(shminfo);
              RAISE Picture.TrestleFail;
            END;
            picture.dpy := trsl.dpy;
            picture.allocByCaller := FALSE;
            picture.image := LOOPHOLE(ximage, Picture.ImageStar);
            picture.segmentInfo := shminfo;
            picture.xcon := trsl;
          END;
      ELSE
        RAISE Picture.ScreenTypeNotSupported;
      END;
      EVAL Picture.T.init(picture, st, width, height);
    EXCEPT
      X.Error =&gt; RAISE Picture.TrestleFail
    END;
    RETURN picture;
  END Init;

PROCEDURE <A NAME="InitFromImage"><procedure>InitFromImage</procedure></A> (im          : Picture.T;
                         st          : VBT.ScreenType;
                         image       : Picture.ImageStar;
                         sharedMemory                      := FALSE):
  Picture.T RAISES {Picture.ScreenTypeNotSupported, Picture.TrestleFail} =
  BEGIN
    EVAL XPicture.T.initFromImage(im, st, image, sharedMemory);

    IF sharedMemory THEN
      &lt;* ASSERT ISTYPE(im, T) *&gt;
      WITH t = NARROW(im, T) DO
        IF st = NIL THEN RAISE Picture.ScreenTypeNotSupported; END;
        TYPECASE st OF
        | XScreenType.T (xst) =&gt;
            &lt;* ASSERT image.obdata # NIL *&gt;
            (* obdata is used to hold the segment info *)
            t.dpy := xst.trsl.dpy;
            t.segmentInfo := LOOPHOLE(image.obdata, XShm.SegmentInfoStar);
            t.xcon := xst.trsl;
        ELSE
          RAISE Picture.ScreenTypeNotSupported;
        END;
      END;
    END;
    RETURN im;
  END InitFromImage;

CONST
  ReadOnly       = ARRAY BOOLEAN OF X.Bool{X.False, X.True};
  InvalidSegment = -1;

PROCEDURE <A NAME="AttachData"><procedure>AttachData</procedure></A> (t      : Picture.T;
                      dataPtr: Ctypes.char_star;
                      info   : Picture.SharedMemInfo := NIL)
  RAISES {Picture.TrestleFail} =
  VAR picture: T;
  BEGIN
    TYPECASE t OF
    | T (it) =&gt; picture := it;
    ELSE
      RAISE Picture.TrestleFail;
    END;

    TRY
      picture.image.data := dataPtr;
      IF picture.segmentInfo # NIL THEN
        IF info = NIL THEN
          (* treat as ordinary data *)
          picture.segmentInfo.shmid := InvalidSegment;
          picture.segmentInfo.shmaddr := NIL;
        ELSE
          picture.segmentInfo.shmid := info.id;
          picture.segmentInfo.shmaddr := dataPtr;
          picture.segmentInfo.readOnly := ReadOnly[info.readOnly];
          IF XShm.Attach(picture.dpy, picture.segmentInfo) # X.True THEN
            RAISE Picture.TrestleFail;
          END;
        END;
      END;
    EXCEPT
      X.Error =&gt; RAISE Picture.TrestleFail
    END;
  END AttachData;

PROCEDURE <A NAME="DetachData"><procedure>DetachData</procedure></A> (t: Picture.T) RAISES {Picture.TrestleFail} =
  BEGIN
    TRY
      TYPECASE (t) OF
      | T (xshm) =&gt;
          IF xshm.image # NIL THEN
            IF xshm.dpy # NIL AND xshm.segmentInfo # NIL THEN
              IF XShm.Detach(xshm.dpy, xshm.segmentInfo) # X.True THEN
                RAISE Picture.TrestleFail;
              END;
              FreeSegment(xshm.segmentInfo);
              xshm.segmentInfo := NIL;
            END;
          END;
      | XPicture.T (xpicture) =&gt; XPicture.T.detachData(xpicture);
      ELSE
        Picture.T.detachData(t);
      END;
    EXCEPT
      X.Error =&gt; RAISE Picture.TrestleFail
    END;
  END DetachData;

PROCEDURE <A NAME="Destroy"><procedure>Destroy</procedure></A> (t: Picture.T) =
  &lt;* FATAL Picture.TrestleFail *&gt;
  BEGIN
    TYPECASE (t) OF
    | T (xshm) =&gt;
        (* don't free the ximage if it was allocated by someone else. *)
        IF xshm.image # NIL AND NOT xshm.allocByCaller THEN
          DetachData(t);

          xshm.image.data := NIL;
          (* XDestroyImage frees the data as well, but it doesn't belong to
             us *)
          EVAL
            xshm.image.f.destroy_image(LOOPHOLE(xshm.image, X.XImageStar));
          xshm.image := NIL;
        END;

        IF xshm.segmentInfo # NIL THEN
          FreeSegment(xshm.segmentInfo);
          xshm.segmentInfo := NIL;
        END;
    | XPicture.T (xpicture) =&gt; XPicture.T.destroy(xpicture);
    ELSE
      Picture.T.destroy(t);      (* will crash *)
    END;
  END Destroy;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (         t         : XPicture.T;
                        dpy       : X.DisplayStar;
                        d         : X.Drawable;
                        gc        : X.GC;
               READONLY clip      : Rect.T;
               READONLY delta     : Point.T;
                        completion: Completion.T   )
  RAISES {TrestleComm.Failure} =
  BEGIN
    WITH picture = NARROW(t, T) DO
      IF dpy # picture.dpy OR picture.segmentInfo = NIL
           OR picture.segmentInfo.shmid = InvalidSegment THEN
        (* this is not the display the picture data is attached to, or
           there is no shared memory segment *)
        XPicture.T.put(t, dpy, d, gc, clip, delta, completion);
      ELSE
        VAR
          imageStar := LOOPHOLE(t.image, X.XImageStar);
          srcX      := MAX(clip.west - delta.h, 0);
          srcY      := MAX(clip.north - delta.v, 0);
          width     := clip.east - clip.west;
          height    := clip.south - clip.north;
        BEGIN
          (* we remove the last 12 pixels from the width as these are blank
             with the JVideo card *)
          width := MIN(width, (imageStar.width - srcX - 12));
          height := MIN(height, (imageStar.height - srcY));
          IF 0 &lt; width AND 0 &lt; height THEN
            completion.inc();    (* decremented when X.CompletionEvent
                                    arrives *)
            picture.xcon.wf.addC(X.XNextRequest(dpy), completion);
            TRY
              WITH status = XShm.PutImage(
                              dpy, d, gc, imageStar, srcX, srcY, clip.west,
                              clip.north, width, height, X.True) DO
                &lt;* ASSERT status = X.True *&gt;
              END;
            EXCEPT
              X.Error =&gt; RAISE TrestleComm.Failure;
            END;
          END;
        END;
      END;
    END;
  END Put;
</PRE> }}} 
 {{{ -- free list for Segment Info -- 
 these procedures provide clean access to the free list.  Freeing is
   explicit as the record is not traced 

<P><PRE>PROCEDURE <A NAME="NewSegment"><procedure>NewSegment</procedure></A> (): XShm.SegmentInfoStar =
  VAR res: SegInfoStar := NIL;
  BEGIN
    LOCK freeMu DO
      IF freeSegs # NIL THEN res := freeSegs; freeSegs := res.next; END;
    END;
    IF res = NIL THEN res := NEW(SegInfoStar); END;

    RETURN LOOPHOLE(res, XShm.SegmentInfoStar);
  END NewSegment;

PROCEDURE <A NAME="FreeSegment"><procedure>FreeSegment</procedure></A> (s: XShm.SegmentInfoStar) =
  BEGIN
    WITH si = LOOPHOLE(s, SegInfoStar) DO
      LOCK freeMu DO si.next := freeSegs; freeSegs := si; END;
    END;
  END FreeSegment;

TYPE
  SegInfo = RECORD
              s   : XShm.SegmentInfo;
              next: SegInfoStar;
            END;
  SegInfoStar = UNTRACED REF SegInfo;

VAR
  freeMu                := NEW(MUTEX);
  freeSegs: SegInfoStar := NIL;
</PRE> }}} 
<PRE>BEGIN
END XSharedMem.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Picture is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="../picture/Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
