<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/xvbt/XShm.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/xvbt/XShm.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE INTERFACE <interface>XShm</interface>;
</PRE> M3 version of X Shared memory extension interface 

<P><PRE>IMPORT <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>;

CONST
  ShmQueryVersion = 0;
  ShmAttach       = 1;
  ShmDetach       = 2;
  ShmPutImage     = 3;
  ShmGetImage     = 4;
  ShmCreatePixmap = 5;

CONST
  ShmCompletion   = 0;
  ShmNumberEvents = ShmCompletion + 1;

  BadShmSeg       = 0;
  ShmNumberErrors = BadShmSeg + 1;

TYPE ShmSeg = Ctypes.unsigned_int;

TYPE
  CompletionEvent =
    RECORD
      type: X.Int;               (* of event *)
      serial: Ctypes.unsigned_long;  (* # of last request processed by
                                        server *)
      send_event: X.Bool;        (* true if this came frome a SendEvent
                                    request *)
      display   : X.DisplayStar;  (* Display the event was read from *)
      drawable  : X.Drawable;     (* drawable of request *)
      major_code: X.Int;          (* ShmReqCode *)
      minor_code: X.Int;          (* X_ShmPutImage *)
      shmseg    : ShmSeg;         (* the ShmSeg used in the request *)
      offset: Ctypes.unsigned_long;  (* the offset into ShmSeg used in the
                                        request *)
    END;
  CompletionEventStar = UNTRACED REF CompletionEvent;

TYPE
  SegmentInfo =
    RECORD
      shmseg : ShmSeg;           (* resource id *)
      shmid  : X.Int            := -1; (* kernel id *)
      shmaddr: Ctypes.char_star := NIL; (* address in client *)
      readOnly: X.Bool := X.False; (* how the server should attach it *)
    END;
  SegmentInfoStar = UNTRACED REF SegmentInfo;

&lt;* EXTERNAL XShmQueryExtension *&gt;
  PROCEDURE QueryExtension (dpy: X.DisplayStar): X.Bool RAISES {X.Error};

&lt;* EXTERNAL XShmGetEventBase *&gt;
  PROCEDURE GetEventBase (dpy: X.DisplayStar): X.Int RAISES {X.Error};
</PRE><BLOCKQUOTE><EM> returns -1 for errors </EM></BLOCKQUOTE><PRE>

&lt;* EXTERNAL XShmQueryVersion *&gt;
  PROCEDURE QueryVersion (dpy          : X.DisplayStar;
                          majorVersion : Ctypes.int_star;
                          minorVersion : Ctypes.int_star;
                          sharedPixmaps: X.BoolStar       ): X.Bool RAISES {X.Error};

&lt;* EXTERNAL XShmAttach*&gt;
  PROCEDURE Attach (dpy: X.DisplayStar; shminfo: SegmentInfoStar):
  X.Status RAISES {X.Error};

&lt;* EXTERNAL XShmDetach *&gt;
  PROCEDURE Detach (dpy: X.DisplayStar; shminfo: SegmentInfoStar):
  X.Status RAISES {X.Error};

&lt;* EXTERNAL XShmPutImage *&gt;
  PROCEDURE PutImage (dpy                  : X.DisplayStar;
                      d                    : X.Drawable;
                      gc                   : X.GC;
                      image                : X.XImageStar;
                      src_x, src_y         : X.Int;
                      dst_x, dst_y         : X.Int;
                      src_width, src_height: Ctypes.unsigned_int;
                      sendEvent            : X.Bool;              ):
  X.Status RAISES {X.Error};

&lt;* EXTERNAL XShmGetImage *&gt;
  PROCEDURE GetImage (dpy       : X.DisplayStar;
                      d         : X.Drawable;
                      image     : X.XImageStar;
                      x, y      : X.Int;
                      plane_mask: X.Mask         ): X.Status RAISES {X.Error};

&lt;* EXTERNAL XShmCreateImage *&gt;
  PROCEDURE CreateImage (dpy          : X.DisplayStar;
                         visual       : X.VisualStar;
                         depth        : Ctypes.unsigned_int;
                         format       : X.Int;
                         data         : Ctypes.char_star;
                         shminfo      : SegmentInfoStar;
                         width, height: Ctypes.unsigned_int  ):
  X.XImageStar RAISES {X.Error};

&lt;* EXTERNAL XShmCreatePixmap *&gt;
  PROCEDURE CreatePixmap (dpy                 : X.DisplayStar;
                          d                   : X.Drawable;
                          data                : Ctypes.char_star;
                          shminfo             : SegmentInfoStar;
                          widht, height, depth: Ctypes.unsigned_int):
  X.Pixmap RAISES {X.Error};

END XShm.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
