<HTML>
<HEAD>
<TITLE>SRC Modula-3: uid/src/Common/Capability.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>uid/src/Common/Capability.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="Capability.i3">Capability</A></implements></module>;

IMPORT <A HREF="../../../random/src/Common/Random.i3">Random</A>, <A HREF="TimeStamp.i3">TimeStamp</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Swap.i3">Swap</A>;

EXCEPTION Failure;
&lt;*FATAL Failure*&gt;

VAR state := NEW(Thread.Mutex OBJECT r: Random.T := NIL; END);

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T =
  VAR t: T;
  BEGIN
    t.ts := TimeStamp.New();
    LOCK state DO
      IF state.r = NIL THEN state.r := NEW(Random.Default).init() END;
      IF BYTESIZE(INTEGER) = 4 THEN
        t.random := LOOPHOLE(Swap.Int64On32{a := state.r.integer(), b :=
                                            state.r.integer()},
                             ARRAY [0 .. 7] OF BITS 8 FOR [0 .. 255]);
      ELSIF BYTESIZE(INTEGER) = 8 THEN
        t.random := LOOPHOLE(Swap.Int64On64{v := state.r.integer()},
                             ARRAY [0 .. 7] OF BITS 8 FOR [0 .. 255]);
      ELSE
        RAISE Failure;
      END;
    END;
    RETURN t;
  END New;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(READONLY t1, t2: T): BOOLEAN =
  BEGIN RETURN t1 = t2; END Equal;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY t: T): INTEGER =
  VAR i: Swap.Int64On32;
  BEGIN
    LOOPHOLE(i, ARRAY [0 .. 7] OF BITS 8 FOR [0 .. 255]) := t.random;
    IF Swap.endian = Swap.Endian.Little THEN
      RETURN Swap.Swap4(i.a);
    ELSE
      RETURN i.a;
    END;
  END Hash;

BEGIN
END Capability.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
