<HTML>
<HEAD>
<TITLE>SRC Modula-3: uid/src/Common/TimeStamp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>uid/src/Common/TimeStamp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="TimeStamp.m3">TimeStamp</A></interface>;

IMPORT <A HREF="../../../time/src/Common/Time.i3">Time</A>;

TYPE
  T     = RECORD r: Bytes; END;
  Bytes = ARRAY [0 .. 15] OF Byte;
  Byte  = BITS 8 FOR [0 .. 255];
</PRE> Each TimeStamp.T is unique globally.  TimeStamp.Ts are totally ordered
   in a relation that approximates the real time when the value was
   generated.  If two TimeStamp.Ts are generated in the same process then
   the ordering of the TimeStamp.Ts is consistent with the order that New
   was called. 

<P><PRE>CONST
  First = T{r := Bytes{0, .. }};
  (* All time stamps generated by New are larger than First. *)

CONST
  Last = T{r := Bytes{255, .. }};
  (* All time stamps generated by New are smaller than Last *)

PROCEDURE <A HREF="TimeStamp.m3#New">New</A>(): T;
  (* Returns a new TimeStamp.T, unequal to any other produced by New, anywhere,
     anytime. *)
</PRE>***************************************************************************
 A note on uniqueness: The implementation of 'New' and uses the
real-time clock and assume that time flows monotonically and that this
machine cannot reboot in less than one second.  Consequently, if the
real-time clock moves <CODE>backwards in time</CODE>, the uniqueness guarantee of
this interface may be compromised.  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A HREF="TimeStamp.m3#Compare">Compare</A>(READONLY t1, t2: T): [-1..1];
  (* Compares two time stamps according the the total order relationship. *)

PROCEDURE <A HREF="TimeStamp.m3#Max">Max</A>(READONLY t1, t2: T): T;
PROCEDURE <A HREF="TimeStamp.m3#Min">Min</A>(READONLY t1, t2: T): T;
  (* Convenience procedures *)

PROCEDURE <A HREF="TimeStamp.m3#Equal">Equal</A>(READONLY t1, t2: T): BOOLEAN;
  (* Returns TRUE if the two time stamps were generated by the same
     call  to New.  Equivalent to &quot;=&quot; for use by generic modules. *)

PROCEDURE <A HREF="TimeStamp.m3#Hash">Hash</A>(READONLY t: T): INTEGER;
  (* Returns a hash function of the timestamp usable by generic table
     packages. Note that unlike some other hash functions this
     hash function is invariant over byte order and word size.  As
     such the return value is always such that it fits in a 32
     bit integer *)

PROCEDURE <A HREF="TimeStamp.m3#ToTime">ToTime</A>(READONLY t: T): Time.T;
  (* Returns an approximation to the time the time stamp was generated.
     This can be compared with Time.Now for validating time stamps.
     Returns -1.0D0 if the time stamp is out of the range of times
     that can be represented by this machine.   This normally means
     that the TimeStamp was not generated by New.  *)

END TimeStamp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
