<HTML>
<HEAD>
<TITLE>SRC Modula-3: uid/src/POSIX/MachineIDPosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>uid/src/POSIX/MachineIDPosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>MachineIDPosix</module> EXPORTS <A HREF="../Common/MachineID.i3"><implements>MachineID</A></implements>;

IMPORT <A HREF="#x1">Unix</A>, <A HREF="#x2">Usocket</A>, <A HREF="#x3">Unetdb</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>;

FROM <A HREF="../../../word/src/Word.i3">Word</A> IMPORT Shift, And, Or;

TYPE
  Byte = BITS 8 FOR [0..255];
</PRE> The following information is commented out in the Unix interface.  This
   is probably system dependent. 

<P><PRE>TYPE
  struct_ifreq = RECORD
    ifr_name  : ARRAY [0 .. 15] OF CHAR;  (* if name, e.g.  &quot;en0&quot; *)
    ifru_addr : Usocket.struct_sockaddr;
  END;

  struct_ifconf = RECORD
    ifc_len  : INTEGER;  (* size of associated buffer *)
    ifcu_req : UNTRACED REF struct_ifreq;
  END;

  struct_ifdevea = RECORD
    ifr_name   : ARRAY [0 .. 15] OF CHAR;  (* if name, e.g.  &quot;en0&quot; *)
    default_pa : ARRAY [0 .. 5] OF Byte;   (* default hardware address *)
    current_pa : ARRAY [0 .. 5] OF Byte;   (* current physical address *)
  END;

CONST
  IFD = Shift(And(BYTESIZE(struct_ifdevea), Unix.IOCPARM_MASK), 16);
  IFC = Shift(And(BYTESIZE(struct_ifconf), Unix.IOCPARM_MASK), 16);

  SIOCGIFCONF   = Or(Unix.SIOCGIFCONF, IFC);   (* Get ifnet ls.*)
  SIOCRPHYSADDR = Or(Unix.SIOCRPHYSADDR, IFD); (* Read phy.  ad.*)

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (): T =
  VAR
    hostname: ARRAY [0 .. 33] OF Ctypes.char;
    hostent : Unetdb.struct_hostent_star;
    id      : T;
    list    : struct_ifconf;
    buf     : ARRAY [0 .. 10] OF struct_ifreq;
    req     : struct_ifdevea;
    s       : INTEGER;
  BEGIN
    (* try to find an ethernet hardware address *)

    s := Usocket.socket(Usocket.AF_UNIX, Usocket.SOCK_STREAM,
                        Usocket.PF_UNSPEC);
    IF (s &gt;= 0) THEN
      list.ifc_len := BYTESIZE(buf);
      list.ifcu_req := ADR(buf[0]);
      IF Unix.ioctl(s, SIOCGIFCONF, ADR(list)) # -1 THEN
        FOR i := 0 TO list.ifc_len DIV BYTESIZE(struct_ifreq) - 1 DO
          req.ifr_name := buf[i].ifr_name;
          IF (Unix.ioctl(s, SIOCRPHYSADDR, ADR(req)) # -1)
            AND (req.default_pa[0] # 0 OR req.default_pa[1] # 0) THEN
            id.r := req.default_pa;
            RETURN id;
          END;
        END;
      END;
    END;

    (* try using the machine's internet address *)

    IF Unix.gethostname(ADR(hostname[0]), 32) # 0 THEN Die (); END;
    hostent := Unetdb.gethostbyname(ADR(hostname[0]));
    IF hostent = NIL THEN Die (); END;
    IF hostent.h_length # 4 THEN Die (); END;
    TYPE Ptr = UNTRACED REF ARRAY [0 .. 3] OF Byte;
    VAR p : Ptr := LOOPHOLE (hostent.h_addr_list^, Ptr); BEGIN
      id.r[0] := 0;
      id.r[1] := 0;
      id.r[2] := p[0];
      id.r[3] := p[1];
      id.r[4] := p[2];
      id.r[5] := p[3];
    END;
    RETURN id;
  END Get;

EXCEPTION Failure;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A> () =
  &lt;*FATAL Failure*&gt;
  BEGIN
    RAISE Failure;
  END Die;

BEGIN
END MachineIDPosix.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Usocket is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usocket.i3#0TOP0">unix/src/aix-3-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usocket.i3#0TOP0">unix/src/aix-ps2-1-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usocket.i3#0TOP0">unix/src/freebsd-1/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usocket.i3#0TOP0">unix/src/freebsd-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usocket.i3#0TOP0">unix/src/hpux-7-0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usocket.i3#0TOP0">unix/src/ibm-4-3/Usocket.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usocket.i3#0TOP0">unix/src/irix-5.2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/linux/Usocket.i3#0TOP0">unix/src/linux/Usocket.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Usocket.i3#0TOP0">unix/src/osf-1.generic/Usocket.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usocket.i3#0TOP0">unix/src/solaris-2-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usocket.i3#0TOP0">unix/src/sunos-4-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usocket.i3#0TOP0">unix/src/sysv-4.0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Usocket.i3#0TOP0">unix/src/ultrix-3-1.generic/Usocket.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Unetdb is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unetdb.i3#0TOP0">unix/src/aix-3-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unetdb.i3#0TOP0">unix/src/aix-ps2-1-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unetdb.i3#0TOP0">unix/src/freebsd-1/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unetdb.i3#0TOP0">unix/src/freebsd-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unetdb.i3#0TOP0">unix/src/hpux-7-0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unetdb.i3#0TOP0">unix/src/ibm-4-3/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unetdb.i3#0TOP0">unix/src/irix-5.2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/linux/Unetdb.i3#0TOP0">unix/src/linux/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Unetdb.i3#0TOP0">unix/src/osf-1.generic/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unetdb.i3#0TOP0">unix/src/solaris-2-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unetdb.i3#0TOP0">unix/src/sunos-4-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unetdb.i3#0TOP0">unix/src/sysv-4.0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Unetdb.i3#0TOP0">unix/src/ultrix-3-1.generic/Unetdb.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
