<HTML>
<HEAD>
<TITLE>SRC Modula-3: uid/src/WIN32/MachineIDWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>uid/src/WIN32/MachineIDWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>MachineIDWin32</module> EXPORTS <A HREF="../Common/MachineID.i3"><implements>MachineID</A></implements>;

IMPORT <A HREF="../../../win32/src/NB30.i3">NB30</A>;
</PRE><P>
PROCEDURE Get (): T =
  VAR
    uid: WinRPC.UUID;
    id : T;
  VAR id: T;
  BEGIN
    WinRPC.UuidCreate(ADR(uid));
    id.r := SUBARRAY(uid.Data4, 2, 6);
    RETURN id;
  END GetMachineID;


<P><PRE>PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (): T =
  VAR
    ncb          : NB30.NCB;
    lanaEnum     : NB30.LANA_ENUM;
    adaptorStatus: NB30.ADAPTER_STATUS;
    id           : T;
  BEGIN
    ncb.ncb_command := NB30.NCBENUM;
    ncb.ncb_buffer := ADR(lanaEnum);
    ncb.ncb_length := BYTESIZE(lanaEnum);
    EVAL NB30.Netbios(ADR(ncb));
    &lt;*ASSERT ncb.ncb_retcode = 0 *&gt;
    &lt;*ASSERT lanaEnum.length &gt;= 1 *&gt;
    ncb.ncb_command := NB30.NCBRESET;
    ncb.ncb_lana_num := lanaEnum.lana[0];
    ncb.ncb_lsn := 0;
    ncb.ncb_num := 0;
    ncb.ncb_buffer := NIL;
    ncb.ncb_length := 0;
    EVAL NB30.Netbios(ADR(ncb));
    &lt;*ASSERT ncb.ncb_retcode = 0 *&gt;
    ncb.ncb_command := NB30.NCBASTAT;
    ncb.ncb_callname[0] := ORD('*');
    ncb.ncb_callname[1] := ORD('\000');
    ncb.ncb_buffer := ADR(adaptorStatus);
    ncb.ncb_length := BYTESIZE(adaptorStatus);
    EVAL NB30.Netbios(ADR(ncb));
    &lt;*ASSERT ncb.ncb_retcode = 0 *&gt;
    id.r := LOOPHOLE(adaptorStatus.adapter_address,
                     ARRAY [0 .. 5] OF BITS 8 FOR [0 .. 255]);
    RETURN id;
  END Get;

BEGIN
END MachineIDWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
