<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/aix-ps2-1-2/Uexec.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/aix-ps2-1-2/Uexec.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE INTERFACE <interface>Uexec</interface>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x1">Utypes</A>, <A HREF="#x2">Uresource</A>;
</PRE> Some of the Unix library process control calls. This is not a complete
interface, and should be added to as needed 

<P> Remember that any of the calls which may return an error code in
'Uerror.errno' should be serialized by use of 'UnixMutex.errno'. 

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE execv(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE execvp(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE exect(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star;
    envp: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};
</PRE> options bits for the second argument of wait3. 
<PRE>CONST
  WNOHANG = 1;			 (* dont hang in wait *)
  WUNTRACED = 2;		 (* tell about stopped, untraced children *)

TYPE
  w_A = Ctypes.unsigned_int;

  (* terminated process status *)
  w_T = RECORD
      w_Termsig : BITS  7 FOR [0..16_7F];  (* termination signal *)
      w_Coredump: BITS  1 FOR [0..16_01];  (* core dump indicator *)
      w_Retcode : BITS  8 FOR [0..16_FF];  (* exit code if w_termsig == 0 *)
      w_Filler  : BITS 16 FOR [0..16_FFFF]; END;

  (* stopped process status *)
  w_S = RECORD
      w_Stopval : BITS  8 FOR [0..16_FF];  (* == W_STOPPED if stopped *)
      w_Stopsig : BITS  8 FOR [0..16_FF];  (* signal that stopped us *)
      w_Filler  : BITS 16 FOR [0..16_FFFF]; END;

  (* union wait is a union of the three types above.  We will use w_A
     in the declarations and do a LOOPHOLE when necessary *)
  w_A_star = UNTRACED REF w_A;
</PRE>** wait, wait3, waitpid - wait for process to terminate **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE wait (status: w_A_star): Utypes.pid_t;

&lt;*EXTERNAL*&gt;
PROCEDURE wait3 (status: w_A_star; options: Ctypes.int;
                 rusage: Uresource.struct_rusage_star): Utypes.pid_t;

&lt;*EXTERNAL*&gt;
PROCEDURE waitpid (pid: Utypes.pid_t; status: w_A_star;
                   options: Ctypes.int): Utypes.pid_t;

END Uexec.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uresource is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uresource.i3#0TOP0">unix/src/aix-3-2/Uresource.i3</A>
<LI><A HREF="Uresource.i3#0TOP0">unix/src/aix-ps2-1-2/Uresource.i3</A>
<LI><A HREF="../freebsd-1/Uresource.i3#0TOP0">unix/src/freebsd-1/Uresource.i3</A>
<LI><A HREF="../freebsd-2/Uresource.i3#0TOP0">unix/src/freebsd-2/Uresource.i3</A>
<LI><A HREF="../hpux-7-0/Uresource.i3#0TOP0">unix/src/hpux-7-0/Uresource.i3</A>
<LI><A HREF="../ibm-4-3/Uresource.i3#0TOP0">unix/src/ibm-4-3/Uresource.i3</A>
<LI><A HREF="../irix-5.2/Uresource.i3#0TOP0">unix/src/irix-5.2/Uresource.i3</A>
<LI><A HREF="../linux/Uresource.i3#0TOP0">unix/src/linux/Uresource.i3</A>
<LI><A HREF="../osf-1.generic/Uresource.i3#0TOP0">unix/src/osf-1.generic/Uresource.i3</A>
<LI><A HREF="../solaris-2-x/Uresource.i3#0TOP0">unix/src/solaris-2-x/Uresource.i3</A>
<LI><A HREF="../sunos-4-x/Uresource.i3#0TOP0">unix/src/sunos-4-x/Uresource.i3</A>
<LI><A HREF="../sysv-4.0/Uresource.i3#0TOP0">unix/src/sysv-4.0/Uresource.i3</A>
<LI><A HREF="../ultrix-3-1.generic/Uresource.i3#0TOP0">unix/src/ultrix-3-1.generic/Uresource.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
