<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/freebsd-1/Usignal.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/freebsd-1/Usignal.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>
</PRE> ow 03.10.1994 

<P><PRE>INTERFACE <interface><A HREF="#x1">Usignal</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, unsigned_int;
</PRE>** &lt;signal.h&gt; **

<P>   I don't know about all the indented values below from the 
     Linux implementation 
<PRE>CONST
  SIGHUP    =  1;      (* hangup *)
  SIGINT    =  2;      (* interrupt *)
  SIGQUIT   =  3;      (* quit *)
  SIGILL    =  4;      (* illegal instruction (not reset when caught) *)
  SIGTRAP   =  5;      (* trace trap (not reset when caught) *)
  SIGIOT    =  6;      (* IOT instruction *)
  SIGEMT    =  7;      (* EMT instruction *)
  SIGFPE    =  8;      (* floating point exception *)
      FPE_INTDIV_TRAP      = 20;  (* integer divide by zero *)
      FPE_INTOVF_TRAP      = 21;  (* integer overflow *)
      FPE_FLTOPERR_TRAP    =  1;  (* [floating operand error] *)
      FPE_FLTDEN_TRAP      =  2;  (* [floating denormalized operand] *)
      FPE_FLTDIV_TRAP      =  3;  (* [floating divide by zero] *)
      FPE_FLTOVF_TRAP      =  4;  (* [floating overflow] *)
      FPE_FLTUND_TRAP      =  5;  (* [floating underflow] *)
      FPE_FLTINEX_TRAP     =  6;  (* [floating inexact result] *)
      FPE_UUOP_TRAP        =  7;  (* [floating undefined opcode] *)
      FPE_DATACH_TRAP      =  8;  (* [floating data chain exception] *)
      FPE_FLTSTK_TRAP      = 16;  (* [floating stack fault] *)
      FPE_FPA_ENABLE       = 17;  (* [FPA not enabled] *)
      FPE_FPA_ERROR        = 18;  (* [FPA arithmetic exception] *)
  SIGKILL   =  9;      (* kill (cannot be caught or ignored) *)
  SIGBUS    =  10;     (* bus error *)
      BUS_HWERR	  = 1;     (* misc hardware error (e.g. timeout) *)
      BUS_ALIGN	  = 2;     (* hardware alignment error *)
  SIGSEGV   =  11;     (* segmentation violation *)
      SEGV_NOMAP  = 3;     (* no mapping at the fault address *)
      SEGV_PROT   = 4;      (* access exceeded protections *)
      SEGV_OBJERR = 5;    (* object returned errno value *)
  SIGSYS    =  12;     (* bad argument to system call *)
  SIGPIPE   =  13;     (* write on a pipe with no one to read it *)
  SIGALRM   =  14;     (* alarm clock *)
  SIGTERM   =  15;     (* software termination signal from kill *)
  SIGURG    =  16;     (* urgent condition on IO channel *)
  SIGSTOP   =  17;     (* sendable stop signal not from tty *)
  SIGTSTP   =  18;     (* stop signal from tty *)
  SIGCONT   =  19;     (* continue a stopped process *)
  SIGCHLD   =  20;     (* to parent on child stop or exit *)
  SIGTTIN   =  21;     (* to readers pgrp upon background tty read *)
  SIGTTOU   =  22;     (* like TTIN for output if (tp-&gt;t_local&amp;LTOSTOP) *)
  SIGIO     =  23;     (* input/output possible signal *)
  SIGXCPU   =  24;     (* exceeded CPU time limit *)
  SIGXFSZ   =  25;     (* exceeded file size limit *)
  SIGVTALRM =  26;     (* virtual time alarm *)
  SIGPROF   =  27;     (* profiling time alarm *)
  SIGWINCH  =  28;     (* window size changes *)
  SIGLOST   =  29;     (* Sys-V rec lock: notify user upon server crash *)
  SIGUSR1   =  30;     (* User signal 1 (from SysV) *)
  SIGUSR2   =  31;     (* User signal 2 (from SysV) *)

  (* System V definitions *)
  SIGCLD    = SIGCHLD;
  SIGABRT   = SIGIOT;
</PRE> Signal vector <CODE>template</CODE> used in sigaction call. 
<PRE>TYPE
  SignalHandler = PROCEDURE (sig, code: int;
                             scp: UNTRACED REF struct_sigcontext);

  sigset_t = int;

  struct_sigvec  = RECORD
    sv_handler: SignalHandler;     (* signal handler *)
    sv_mask:    sigset_t;          (* signal mask to apply *)
    sv_flags:   int;               (* see signal options below *) END;

CONST
  empty_sigset_t : sigset_t = 0;
  empty_sv_mask  : sigset_t = 0;

CONST
  SV_ONSTACK   = 16_0001;  (* take signal on signal stack *)
  SV_INTERRUPT = 16_0002;  (* do not restart system on signal return *)
  SV_NOCLDSTOP = 16_0004;  (* Don't generate SIGCLD when children stop *)
  (*
  SV_OLDSIG    = 16_1000;  (* Emulate old signal() for POSIX *)
  *)

  (* Defines for sigprocmask() call. POSIX. *)
  SIG_BLOCK    = 1;    (* Add these signals to block mask *)
  SIG_UNBLOCK  = 2;    (* Remove these signals from block mask *)
  SIG_SETMASK  = 3;    (* Set block mask to this mask *)

TYPE
  SignalActionHandler  = PROCEDURE (sig: int);
  SignalRestoreHandler = PROCEDURE ();

  struct_sigaction = RECORD
    sa_handler  : SignalActionHandler;  (* signal handler *)
    sa_mask     : sigset_t;             (* signals to block while in handler *)
    sa_flags    : int;                  (* signal action flags *)
    (* ow
    sa_restorer : SignalRestoreHandler; (* restores interrupted state *)
    *)
  END;

  struct_sigaction_star = UNTRACED REF struct_sigaction;

 (* valid flags define for sa_flag field of sigaction structure  *)
CONST
  SA_ONSTACK     = 16_0001;   (* run on special signal stack *)
  SA_RESTART     = 16_0002;   (* restart system calls on sigs *)
  SA_NOCLDSTOP   = 16_0004;   (* do not generate SIGCHLD on child stop *)
  (*
  SA_NODUMP      = 16_0010;   (* termination by this sig does not use a
                                 core file *)
  SA_PARTDUMP    = 16_0020;   (* create a partial dump for this signal *)
  SA_FULLDUMP    = 16_0040;   (* create a full dump (with data areas) *)
  SA_SIGSETSTYLE = 16_0080;   (* new system V sigset type semantics *)
  *)
TYPE
  struct_sigstack = RECORD
    ss_sp:      ADDRESS; (* signal stack pointer *)
    ss_onstack: int;     (* current status *)
  END;
</PRE><P>
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 *
 * WARNING: THE sigcontext MUST BE KEPT CONSISTENT WITH /usr/include/setjmp.h
 * AND THE LIBC ROUTINES setjmp() AND longjmp()
 *  ???? (ow)
 

<P><PRE>TYPE
  struct_sigcontext = RECORD
    sc_onstack: int;   (* sigstack state to restore *)
    sc_mask: int;      (* signal mask to restore *)
    sc_esp: int;       (* stack pinter *)
    sc_ebp: int;       (* frame pointer *)
    sc_isp: int;
    sc_eip: int;       (* program counter *)
    sc_efl: int;       (* program status word *)
    sc_es: int;
    sc_ds: int;
    sc_cs: int;
    sc_ss: int;
    sc_edi: int;
    sc_esi: int;
    sc_ebx: int;
    sc_edx: int;
    sc_ecx: int;
    sc_eax: int;
  END;
</PRE> Do not modifiy these variables 
<PRE>VAR (*CONST*)
  BADSIG, SIG_ERR, SIG_DFL, SIG_IGN, SIG_HOLD: SignalHandler;
</PRE> Convert a signal number to a mask suitable for sigblock(). 
<PRE>&lt;*INLINE*&gt; PROCEDURE <A HREF="#x2">sigmask</A> (n: int): int;
</PRE>** kill(2) - send signal to a process **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE kill (pid, sig: int): int;
</PRE>** killpg(2) - send signal to a process or process group **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE killpg (pgrp, sig: int): int;
</PRE>** sigblock(2) - block signals **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sigblock (mask: int): int;
</PRE>** sigpause(2) - atomically release blocked signals and wait for
                   interrupt **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sigpause (sigmask: int): int;
</PRE>** sigpending(2) - examine pending signals **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sigpending (VAR set: sigset_t): int;
</PRE>** sigsetmask(2) - set current signal mask **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sigsetmask (mask: int): unsigned_int;
</PRE>** sigstack(2) - set and/or get signal stack context **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sigstack (VAR ss, oss: struct_sigstack): int;
</PRE>** sigaction(2) - software signal facilities **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE sigaction (sig: int;  act, oact: struct_sigaction_star): int;
</PRE>** sigvec(2) - software signal facilities **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE sigvec (sig: int; VAR vec, ovec: struct_sigvec): int;

&lt;*EXTERNAL*&gt;
PROCEDURE sigprocmask (how: int; VAR set, oldset: sigset_t) : int;

END Usignal.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Usignal's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Usignal.m3#0TOP0">unix/src/aix-3-2/Usignal.m3</A>
<LI><A HREF="../aix-ps2-1-2/Usignal.m3#0TOP0">unix/src/aix-ps2-1-2/Usignal.m3</A>
<LI><A HREF="Usignal.m3#0TOP0">unix/src/freebsd-1/Usignal.m3</A>
<LI><A HREF="../freebsd-2/Usignal.m3#0TOP0">unix/src/freebsd-2/Usignal.m3</A>
<LI><A HREF="../hpux-7-0/Usignal.m3#0TOP0">unix/src/hpux-7-0/Usignal.m3</A>
<LI><A HREF="../ibm-4-3/Usignal.m3#0TOP0">unix/src/ibm-4-3/Usignal.m3</A>
<LI><A HREF="../irix-5.2/Usignal.m3#0TOP0">unix/src/irix-5.2/Usignal.m3</A>
<LI><A HREF="../linux/Usignal.m3#0TOP0">unix/src/linux/Usignal.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Usignal.m3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.m3</A>
<LI><A HREF="../osf-1.DS3100/Usignal.m3#0TOP0">unix/src/osf-1.DS3100/Usignal.m3</A>
<LI><A HREF="../solaris-2-x/Usignal.m3#0TOP0">unix/src/solaris-2-x/Usignal.m3</A>
<LI><A HREF="../sunos-4-x/Usignal.m3#0TOP0">unix/src/sunos-4-x/Usignal.m3</A>
<LI><A HREF="../sysv-4.0/Usignal.m3#0TOP0">unix/src/sysv-4.0/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Usignal.m3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.ARM/Usignal.m3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Usignal.m3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Usignal.m3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Usignal.m3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Usignal.m3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Usignal.m3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Usignal.m3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.VAX/Usignal.m3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Usignal.sigmask is in:
</A><UL>
<LI><A HREF="../aix-3-2/Usignal.m3#sigmask">unix/src/aix-3-2/Usignal.m3</A>
<LI><A HREF="../aix-ps2-1-2/Usignal.m3#sigmask">unix/src/aix-ps2-1-2/Usignal.m3</A>
<LI><A HREF="Usignal.m3#sigmask">unix/src/freebsd-1/Usignal.m3</A>
<LI><A HREF="../freebsd-2/Usignal.m3#sigmask">unix/src/freebsd-2/Usignal.m3</A>
<LI><A HREF="../hpux-7-0/Usignal.m3#sigmask">unix/src/hpux-7-0/Usignal.m3</A>
<LI><A HREF="../ibm-4-3/Usignal.m3#sigmask">unix/src/ibm-4-3/Usignal.m3</A>
<LI><A HREF="../irix-5.2/Usignal.m3#sigmask">unix/src/irix-5.2/Usignal.m3</A>
<LI><A HREF="../linux/Usignal.m3#sigmask">unix/src/linux/Usignal.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Usignal.m3#sigmask">unix/src/osf-1.ALPHA_OSF/Usignal.m3</A>
<LI><A HREF="../osf-1.DS3100/Usignal.m3#sigmask">unix/src/osf-1.DS3100/Usignal.m3</A>
<LI><A HREF="../solaris-2-x/Usignal.m3#sigmask">unix/src/solaris-2-x/Usignal.m3</A>
<LI><A HREF="../sunos-4-x/Usignal.m3#sigmask">unix/src/sunos-4-x/Usignal.m3</A>
<LI><A HREF="../sysv-4.0/Usignal.m3#sigmask">unix/src/sysv-4.0/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Usignal.m3#sigmask">unix/src/ultrix-3-1.AP3000/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.ARM/Usignal.m3#sigmask">unix/src/ultrix-3-1.ARM/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Usignal.m3#sigmask">unix/src/ultrix-3-1.DS3100/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Usignal.m3#sigmask">unix/src/ultrix-3-1.NEXT/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Usignal.m3#sigmask">unix/src/ultrix-3-1.SEQUENT/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Usignal.m3#sigmask">unix/src/ultrix-3-1.SUN3/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Usignal.m3#sigmask">unix/src/ultrix-3-1.SUN386/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Usignal.m3#sigmask">unix/src/ultrix-3-1.UMAX/Usignal.m3</A>
<LI><A HREF="../ultrix-3-1.VAX/Usignal.m3#sigmask">unix/src/ultrix-3-1.VAX/Usignal.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
