<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/freebsd-1/Uutmp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/freebsd-1/Uutmp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>
</PRE> File: Uutmp.i3                                             

<P><PRE>INTERFACE <interface>Uutmp</interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char, char_star, long, short;
FROM <A HREF="#x1">Utypes</A> IMPORT pid_t, time_t;
</PRE>** &lt;utmp.h&gt; **

<P>
 * Structure of utmp and wtmp files.
 *
 

<P><PRE>CONST
  (* Constants for the ut_type field : *)
  UT_UNKNOWN = 0;

  (* Size of user name *)
  UT_NAMESIZE = 8;

  (* Other things *)
  RUN_LVL = 1;
  BOOT_TIME = 2;
  NEW_TIME = 3;
  OLD_TIME = 4;

  INIT_PROCESS = 5;
  LOGIN_PROCESS = 6;
  USER_PROCESS = 7;
  DEAD_PROCESS = 8;

TYPE
  struct_utmp = RECORD
    ut_type : short;                 (* type of login *)
    ut_pid  : pid_t;                 (* pid of login process *)
    ut_line : ARRAY [0..11] OF char; (* name of tty - &quot;/dev&quot;, null-term  *)
    ut_id   : ARRAY [0..1] OF char;  (* abbrev. ttyname, as 01, s1, etc *)
    ut_time : time_t;                (* login time *)
    ut_user : ARRAY [0..UT_NAMESIZE-1] OF char;  (* user id *)
    ut_host : ARRAY [0..15] OF char; (* host name, if remote *)
    ut_addr : long                   (* IP addr of remote host *)
  END;

CONST
  UTMP_FILE      = &quot;/etc/utmp&quot;;
  WTMP_FILE      = &quot;/var/adm/wtmp&quot;;
  UTMP_FILEMNAME = UTMP_FILE;
  WTMP_FILENAME  = WTMP_FILE;
</PRE>	Special strings or formats used in the <CODE>ut_line</CODE> field when	
	accounting for something other than a process.			
	No string for the ut_line field can be more than 7 chars +	
	a NULL in length.						

<P> These constants may not be used under Linux - use ut_type and the
   constants specified above for this purpose instead 

<P>   <PRE>EMPTY	= &quot;&quot;;
   BOOT_MSG	= &quot;~&quot;;
   OTIME_MSG	= &quot;|&quot;;
   NTIME_MSG	= &quot;}&quot;;
</PRE>** getlogin(3) **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE getlogin (): char_star;

END Uutmp.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
