<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/freebsd-2/Uuio.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/freebsd-2/Uuio.i3</H2></A><HR>
<inInterface>
<PRE></PRE>                                                            
 ow 30.09.1994 

<P><PRE>INTERFACE <interface>Uuio</interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, char_star, void_star;
</PRE>** sys/uio.h **

<P>
<P><PRE>TYPE
  struct_iovec = RECORD
    iov_base: void_star;
    iov_len: int;
  END;
  struct_iovec_star = UNTRACED REF struct_iovec;

  (* There's no corresponding structure to struct_uio - be careful *)
  struct_uio = RECORD
    uio_iov: struct_iovec_star;
    uio_iovcnt: int;
    uio_offset: int;
    uio_resid: int;
    uio_segflg: int;
    uio_flag: int;
    uio_procp: void_star;
  END;

  uio_rw = {UIO_READ, UIO_WRITE};
</PRE><P>
 * Segment flag values (should be enum).
 

<P><PRE>CONST
  (* There appear to be no corresponing definitions for any of these
     constants - use with caution. *)
  UIO_USERSPACE =	0;		(* from user data space *)
  UIO_SYSSPACE =	1;		(* from system space *)
  UIO_USERISPACE =	2;		(* from user I space *)

CONST
  MAX_IOVEC = 		1024;		(* maximum length of io vectors *)
</PRE>** read, readv(2) - read from a file **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE read (d: int; buf: char_star; nbytes: int): int;
&lt;*EXTERNAL*&gt; PROCEDURE readv (d: int; iov: struct_iovec_star;
                              iovcnt: int): int;
</PRE>** write, writev(2) - write on a file **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE write (d: int; buf: char_star; nbytes: int): int;
&lt;*EXTERNAL*&gt; PROCEDURE writev (d: int; iov: struct_iovec_star;
                               ioveclen: int): int;

END Uuio.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
