<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/hpux-7-0/Uerror.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/hpux-7-0/Uerror.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Uerror</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, char_star;
</PRE>** &lt;errno.h&gt; **

<P><PRE>CONST

EPERM		= 1;	(* Not super-user *)
ENOENT		= 2;	(* No such file or directory *)
ESRCH		= 3;	(* No such process *)
EINTR		= 4;	(* interrupted system call *)
EIO		= 5;	(* I/O error *)
ENXIO		= 6;	(* No such device or address *)
E2BIG		= 7;    (* Arg list too long *)
ENOEXEC		= 8;	(* Exec format error *)
EBADF		= 9;	(* Bad file number *)
ECHILD		= 10;	(* No children *)
EAGAIN		= 11;	(* No more processes *)
ENOMEM		= 12;	(* Not enough core *)
EACCES		= 13;   (* Permission denied *)
EFAULT		= 14;	(* Bad address *)
EBUSY		= 16;	(* Mount device busy *)
EEXIST		= 17;	(* File exists *)
EXDEV		= 18;	(* Cross-device link *)
ENODEV		= 19;	(* No such device *)
ENOTDIR		= 20;	(* Not a directory *)
EISDIR		= 21;	(* Is a directory *)
EINVAL		= 22;	(* Invalid argument *)
ENFILE		= 23;	(* File table overflow *)
EMFILE		= 24;	(* Too many open files *)
ENOTTY		= 25;	(* Not a typewriter *)
EFBIG		= 27;	(* File too large *)
ENOSPC		= 28;	(* No space left on device *)
ESPIPE		= 29;	(* Illegal seek *)
EROFS		= 30;	(* Read only file system *)
EMLINK		= 31;	(* Too many links *)
EPIPE		= 32;	(* Broken pipe *)
EDEADLK 	= 45;	(* A deadlock would occur *)
ENOLCK  	= 46;	(* System record lock table was full  *)
ENOTEMPTY   	= 247;	(* Directory not empty           *)
ENAMETOOLONG 	= 248;	(* File name too long            *)
ENOSYS 	  	= 251;  (* Function not implemented      *)
ENOTBLK		= 15;	(* Block device required *)
ETXTBSY		= 26;	(* Text file busy *)
ENOMSG  	= 35;   (* No message of desired type    *)
EIDRM		= 36;	(* Identifier removed *)
</PRE> math software 

<P><PRE>EDOM		= 33;	(* Math arg out of domain of func *)
ERANGE		= 34;	(* Math result not representable *)
</PRE> Network File System  

<P><PRE>ESTALE		= 70;	(* Stale NFS file handle  *)
EREMOTE		= 71;	(* Too many levels of remote in path  *)
</PRE> ipc/network software  

<P> argument errors  
<PRE>ENOTSOCK		= 216;	(* Socket operation on non-socket  *)
EDESTADDRREQ		= 217;	(* Destination address required  *)
EMSGSIZE		= 218;	(* Message too long  *)
EPROTOTYPE		= 219;	(* Protocol wrong type for socket  *)
ENOPROTOOPT		= 220;	(* Protocol not available  *)
EPROTONOSUPPORT		= 221;	(* Protocol not supported  *)
ESOCKTNOSUPPORT		= 222;	(* Socket type not supported  *)
EOPNOTSUPP	 	= 223;	(* Operation not supported  *)
EPFNOSUPPORT 		= 224;	(* Protocol family not supported  *)
EAFNOSUPPORT 		= 225; 	(* Address family not supported by protocol family *)
EADDRINUSE		= 226;	(* Address already in use  *)
EADDRNOTAVAIL 		= 227;	(* Can't assign requested address  *)
</PRE> operational errors  
<PRE>ENETDOWN		= 228;	(* Network is down  *)
ENETUNREACH		= 229;	(* Network is unreachable  *)
ENETRESET		= 230;	(* Network dropped connection on reset  *)
ECONNABORTED		= 231;	(* Software caused connection abort  *)
ECONNRESET		= 232;	(* Connection reset by peer  *)
ENOBUFS			= 233;	(* No buffer space available  *)
EISCONN			= 234;	(* Socket is already connected  *)
ENOTCONN		= 235;	(* Socket is not connected  *)
ESHUTDOWN		= 236;	(* Can't send after socket shutdown  *)
ETOOMANYREFS		= 237;	(* Too many references: can't splice  *)
ETIMEDOUT		= 238;	(* Connection timed out  *)
ECONNREFUSED		= 239;	(* Connection refused  *)
EREMOTERELEASE		= 240;	(* Remote peer released connection  *)
EHOSTDOWN		= 241;	(* Host is down  *)
EHOSTUNREACH		= 242;	(* No route to host  *)

ENET  	    		= 243;	(* Network error  *)
EALREADY    		= 244;	(* Operation already in progress  *)
EINPROGRESS 		= 245;	(* Operation now in progress  *)
EWOULDBLOCK 		= 246;	(* Operation would block  *)
ELOOP	    		= 249;	(* Too many levels of symbolic links  *)

&lt;*EXTERNAL*&gt;
VAR
  errno: int;
</PRE> Extention by mjordan 
<PRE>CONST
  Max = ENOLCK; (* should be exported from Uerror *)

&lt;*EXTERNAL*&gt; VAR
  sys_nerr: int;
  sys_errlist: ARRAY [0..Max] OF char_star;

PROCEDURE <A HREF="#x2">GetFrom_sys_errlist</A>(n: INTEGER): char_star RAISES {};
</PRE><BLOCKQUOTE><EM> returns entry 'n' of the 'sys_errlist' array; a checked runtime error
   unless 0 &lt;= n &lt;= sys_nerr. Its safer and more portable to use this 
   procedure than to access the array directly. </EM></BLOCKQUOTE><PRE>

END Uerror.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Uerror's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uerror.m3#0TOP0">unix/src/aix-3-2/Uerror.m3</A>
<LI><A HREF="../aix-ps2-1-2/Uerror.m3#0TOP0">unix/src/aix-ps2-1-2/Uerror.m3</A>
<LI><A HREF="../freebsd-1/Uerror.m3#0TOP0">unix/src/freebsd-1/Uerror.m3</A>
<LI><A HREF="../freebsd-2/Uerror.m3#0TOP0">unix/src/freebsd-2/Uerror.m3</A>
<LI><A HREF="Uerror.m3#0TOP0">unix/src/hpux-7-0/Uerror.m3</A>
<LI><A HREF="../ibm-4-3/Uerror.m3#0TOP0">unix/src/ibm-4-3/Uerror.m3</A>
<LI><A HREF="../irix-5.2/Uerror.m3#0TOP0">unix/src/irix-5.2/Uerror.m3</A>
<LI><A HREF="../linux/Uerror.m3#0TOP0">unix/src/linux/Uerror.m3</A>
<LI><A HREF="../osf-1.generic/Uerror.m3#0TOP0">unix/src/osf-1.generic/Uerror.m3</A>
<LI><A HREF="../solaris-2-x/Uerror.m3#0TOP0">unix/src/solaris-2-x/Uerror.m3</A>
<LI><A HREF="../sunos-4-x/Uerror.m3#0TOP0">unix/src/sunos-4-x/Uerror.m3</A>
<LI><A HREF="../sysv-4.0/Uerror.m3#0TOP0">unix/src/sysv-4.0/Uerror.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Uerror.m3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Uerror.GetFrom_sys_errlist is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uerror.m3#GetFrom_sys_errlist">unix/src/aix-3-2/Uerror.m3</A>
<LI><A HREF="../aix-ps2-1-2/Uerror.m3#GetFrom_sys_errlist">unix/src/aix-ps2-1-2/Uerror.m3</A>
<LI><A HREF="../freebsd-1/Uerror.m3#GetFrom_sys_errlist">unix/src/freebsd-1/Uerror.m3</A>
<LI><A HREF="../freebsd-2/Uerror.m3#GetFrom_sys_errlist">unix/src/freebsd-2/Uerror.m3</A>
<LI><A HREF="Uerror.m3#GetFrom_sys_errlist">unix/src/hpux-7-0/Uerror.m3</A>
<LI><A HREF="../ibm-4-3/Uerror.m3#GetFrom_sys_errlist">unix/src/ibm-4-3/Uerror.m3</A>
<LI><A HREF="../irix-5.2/Uerror.m3#GetFrom_sys_errlist">unix/src/irix-5.2/Uerror.m3</A>
<LI><A HREF="../linux/Uerror.m3#GetFrom_sys_errlist">unix/src/linux/Uerror.m3</A>
<LI><A HREF="../osf-1.generic/Uerror.m3#GetFrom_sys_errlist">unix/src/osf-1.generic/Uerror.m3</A>
<LI><A HREF="../solaris-2-x/Uerror.m3#GetFrom_sys_errlist">unix/src/solaris-2-x/Uerror.m3</A>
<LI><A HREF="../sunos-4-x/Uerror.m3#GetFrom_sys_errlist">unix/src/sunos-4-x/Uerror.m3</A>
<LI><A HREF="../sysv-4.0/Uerror.m3#GetFrom_sys_errlist">unix/src/sysv-4.0/Uerror.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Uerror.m3#GetFrom_sys_errlist">unix/src/ultrix-3-1.generic/Uerror.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
