<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/hpux-7-0/Utime.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/hpux-7-0/Utime.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="../irix-5.2/Utime.m3">Utime</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char_star, int, long, long_star,
                   unsigned_short, short;
</PRE>** &lt;sys/time.h&gt; **

<P><PRE>TYPE
  struct_timeval = RECORD
    tv_sec: long;          (* seconds *)
    tv_usec: long;         (* and microseconds *) END;

  struct_timezone = RECORD
    tz_minuteswest:  int; (* minutes west of Greenwich *)
    tz_dsttime:      int; (* type of dst correction *) END;

CONST
  DST_NONE = 0;  (* not on dst *)

  DST_USA  = 1;  (* USA style dst *)
  DST_AUST = 2;  (* Australian style dst *)
  DST_WET  = 3;  (* Western European dst *)
  DST_MET  = 4;  (* Middle European dst *)
  DST_EET  = 5;  (* Eastern European dst *)

TYPE
  struct_itimerval = RECORD
    it_interval: struct_timeval;            (* timer interval *)
    it_value:    struct_timeval;            (* current value *)  END;

  struct_tm = RECORD
    tm_sec:   int;     (* seconds (0 - 59) *)
    tm_min:   int;     (* minutes (0 - 59) *)
    tm_hour:  int;     (* hours (0 - 23) *)
    tm_mday:  int;     (* day of month (1 - 31) *)
    tm_mon:   int;     (* month of year (0 - 11) *)
    tm_year:  int;     (* year - 1900 *)
    tm_wday:  int;     (* day of week (Sunday = 0) *)
    tm_yday:  int;     (* day of year (0 - 365) *)
    tm_isdst: int;     (* flag: daylight savings time in effect *)
    tm_gmtoff:long;    (* offset from GMT in seconds *)
    tm_zone:  char_star; (* abbreviation of timezone name *)
  END;

  struct_tm_star = UNTRACED REF struct_tm;

  time_t = int; (* seconds since the Epoch *)
</PRE>** &lt;sys/times.h&gt; **

<P>
 * Structure returned by times()
 

<P><PRE>TYPE
  struct_tms = RECORD
        tms_utime: long;              (* user time *)
        tms_stime: long;              (* system time *)
        tms_cutime: long;             (* user time, children *)
        tms_cstime: long;             (* system time, children *)
  END;

  struct_tms_star = UNTRACED REF struct_tms;
</PRE>** &lt;sys/timeb.h&gt; **

<P>
 * Structure returned by ftime system call
 

<P><PRE>TYPE
  struct_timeb = RECORD
    time:	long;
    millitm:	unsigned_short;
    timezone:	short;
    dstflag:	short;
  END;

  struct_timeb_star = UNTRACED REF struct_timeb;
</PRE>** gettimeofday(2), settimeofday(2) - get/set date and time **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE gettimeofday (VAR t: struct_timeval;
                        VAR z: struct_timezone): int;

&lt;*EXTERNAL*&gt;
PROCEDURE settimeofday (VAR t: struct_timeval;
                        VAR z: struct_timezone): int;
</PRE>** adjtime(2) - correct the time to allow synchronization of the 
                  system clock **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE adjtime (VAR delta, oldDelta: struct_timeval): int;
</PRE>** getitimer(2), setitimer(2) - get/set value of interval timer **

<P><PRE>CONST (* which *)
  ITIMER_REAL =    0;   (* real time intervals *)
  ITIMER_VIRTUAL = 1;   (* virtual time intervals *)
  ITIMER_PROF    = 2;   (* user and system virtual time *)

&lt;*EXTERNAL*&gt;
PROCEDURE getitimer (which: int; VAR value: struct_itimerval): int;

&lt;*EXTERNAL*&gt;
PROCEDURE setitimer (which: int;
                     VAR value, ovalue: struct_itimerval): int;
</PRE>** stime(2) - set time **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE stime (VAR tp: long): int;
</PRE>** clock(3) - report CPU time used (in micro-seconds) **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE clock (): long;
</PRE>** times(3) - get process times (in ticks) **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE times (buffer: struct_tms_star): long;
</PRE>** time(3), ftime(3) - get date and time (in seconds) **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE time  (tloc: long_star): long;
&lt;*EXTERNAL*&gt; PROCEDURE ftime (tp: struct_timeb_star);
</PRE>** ctime(3), localtime(3), gmtime(3), asctime(3)
     - convert date and time (in seconds)  to string **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE ctime     (clock: long_star): char_star;
&lt;*EXTERNAL*&gt; PROCEDURE localtime (clock: long_star): struct_tm_star;
&lt;*EXTERNAL*&gt; PROCEDURE gmtime    (clock: long_star): struct_tm_star;
&lt;*EXTERNAL*&gt; PROCEDURE asctime   (tm: struct_tm_star): char_star;
</PRE>** mktime(3) - convert a struct_tm to a time_t **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE mktime (tm: struct_tm_star): time_t;
</PRE> HP-UX NLS calls 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE nl_asctime (tm: struct_tm_star; format: char_star;
						langid: int): char_star;
&lt;*EXTERNAL*&gt; PROCEDURE nl_ctime (clock: long_star; format: char_star;
						langid: int): char_star;
&lt;*EXTERNAL*&gt; PROCEDURE nl_ascxtime (tm: struct_tm_star; format: char_star)
							: char_star;
&lt;*EXTERNAL*&gt; PROCEDURE nl_cxtime     (clock: long_star; format: char_star)
							: char_star;

END Utime.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
