<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/irix-5.2/Ustat.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/irix-5.2/Ustat.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface>Ustat</interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, long, char_star,char;
FROM <A HREF="#x1">Utypes</A> IMPORT dev_t, ino_t, off_t,
                   mode_t, nlink_t, uid_t, gid_t, time_t;
</PRE> MODE MASKS 

<P> de facto standard definitions 
<PRE>CONST
  S_IFMT	 = 16_F000;	(* type of file *)
  S_IAMB	 = 16_1FF;	(* access mode bits *)
  S_IFIFO	 = 16_1000;	(* fifo *)
  S_IFCHR	 = 16_2000;	(* character special *)
  S_IFDIR	 = 16_4000;	(* directory *)
  S_IFNAM	 = 16_5000;  (* XENIX special named file *)
  S_INSEM  = 16_1;	(* XENIX semaphore subtype of IFNAM *)
  S_INSHD  = 16_2;	(* XENIX shared data subtype of IFNAM *)

  S_IFBLK	 = 16_6000;	(* block special *)
  S_IFREG	 = 16_8000;	(* regular *)
  S_IFLNK	 = 16_A000;	(* symbolic link *)
  S_IFSOCK	 = 16_C000;	(* socket *)
</PRE>** PIPE and PORT don't exist, they're for src/os/POSIX/FilePosix.m3 **
  <PRE>S_IFPIPE       = 16_1000;     (* fifo *)
  S_IFPORT       = 16_0000;     (* pipe *)

  S_ISUID	 = 16_800;	(* set user id on execution *)
  S_ISGID	 = 16_400;	(* set group id on execution *)

  S_ISVTX	 = 16_200;	(* save swapped text even after use *)

  S_ENFMT	 = S_ISGID;	(* record locking enforcement flag *)
</PRE> the following macros are for POSIX conformance 

<P>  <PRE>S_IRWXU	 = 8_0700;		(* read, write, execute: owner *)
  S_IRUSR	 = 8_0400;		(* read permission: owner *)
  S_IWUSR	 = 8_0200;		(* write permission: owner *)
  S_IXUSR	 = 8_0100;		(* execute permission: owner *)
  S_IRWXG	 = 8_0070;		(* read, write, execute: group *)
  S_IRGRP	 = 8_0040;		(* read permission: group *)
  S_IWGRP	 = 8_0020;		(* write permission: group *)
  S_IXGRP	 = 8_0010;		(* execute permission: group *)
  S_IRWXO	 = 8_0007;		(* read, write, execute: other *)
  S_IROTH	 = 8_0004;		(* read permission: other *)
  S_IWOTH	 = 8_0002;		(* write permission: other *)
  S_IXOTH	 = 8_0001;		(* execute permission: other *)

  (* deprecated: use S_IRUSR, ... defined above *)
  S_IREAD  = S_IRUSR;
  S_IWRITE = S_IWUSR;
  S_IEXEC  = S_IXUSR;
  S_GREAD  = S_IRGRP;
  S_GWRITE = S_IWGRP;
  S_GEXEC  = S_IXGRP;
  S_OREAD  = S_IROTH;
  S_OWRITE = S_IWOTH;
  S_OEXEC  = S_IXOTH;

TYPE
  struct_stat = RECORD
               st_dev    : dev_t;
	       st_pad1	 : ARRAY [0..2] OF long;
               st_ino    : ino_t;
               st_mode   : mode_t;
               st_nlink  : nlink_t;
               st_uid    : uid_t;
               st_gid    : gid_t;
               st_rdev   : dev_t;
	       st_pad2 	 : ARRAY [0..1] OF long;
               st_size   : off_t;
	       st_pad3	 : long;
            (* st_atime  : timestruc_t;  *** KLUDGE for FSPosix and FilePosix*)
               st_atime  : time_t;
               st_atime_tv_nsec : long;

            (* st_mtime  : timestruc_t;  *** KLUDGE for FSPosix and FilePosix*)
               st_mtime  : time_t;
               st_mtime_tv_nsec : long;

            (* st_ctime  : timestruc_t;  *** KLUDGE for FSPosix and FilePosix*)
               st_ctime  : time_t;
               st_ctime_tv_nsec : long;

               st_blksize: long;
               st_blocks : long;
	       st_fstype : ARRAY  [0..15] OF char ;
	       st_pad4 	 : ARRAY  [0..7] OF long; END;

  struct_stat_star = UNTRACED REF struct_stat;

&lt;*EXTERNAL*&gt; PROCEDURE stat (path: char_star; buf: struct_stat_star): int;

&lt;*EXTERNAL*&gt; PROCEDURE lstat (path: char_star; buf: struct_stat_star): int;

&lt;*EXTERNAL*&gt; PROCEDURE fstat (fd: int;  buf: struct_stat_star): int;

END Ustat.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
