<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/irix-5.2/Utime.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/irix-5.2/Utime.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Utime.m3">Utime</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char_star, int, long, double;
IMPORT <A HREF="#x1">Utypes</A>;
</PRE>** &lt;time.h&gt; **

<P><PRE>CONST
  CLOCKS_PER_SEC	 = 1000000;

TYPE
  clock_t = Utypes.clock_t;
  time_t = Utypes.time_t;
  time_t_star = UNTRACED REF time_t;

  struct_tm = RECORD
    tm_sec:   int;     (* seconds (0 - 59) *)
    tm_min:   int;     (* minutes (0 - 59) *)
    tm_hour:  int;     (* hours (0 - 23) *)
    tm_mday:  int;     (* day of month (1 - 31) *)
    tm_mon:   int;     (* month of year (0 - 11) *)
    tm_year:  int;     (* year - 1900 *)
    tm_wday:  int;     (* day of week (Sunday = 0) *)
    tm_yday:  int;     (* day of year (0 - 365) *)
    tm_isdst: int;     (* flag: daylight savings time in effect *)
  END;
  struct_tm_star = UNTRACED REF struct_tm;
</PRE>** clock(3) - report CPU time used (in micro-seconds) **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE clock (): clock_t;
</PRE>** difftime(3c) - compute difference between two calendar times **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE difftime (time1, time0: time_t): double;
</PRE>** mktime(3) - convert a struct_tm to a time_t **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE mktime (tm: struct_tm_star): time_t;
</PRE>** time(2) - get time **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE time (tloc: time_t_star): time_t;
</PRE>** ctime(3), localtime(3), gmtime(3), asctime(3)
     - convert date and time (in seconds)  to string **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE asctime   (tm: struct_tm_star): char_star;
&lt;*EXTERNAL*&gt; PROCEDURE ctime     (clock: time_t_star): char_star;
&lt;*EXTERNAL*&gt; PROCEDURE gmtime    (clock: time_t_star): struct_tm_star;
&lt;*EXTERNAL*&gt; PROCEDURE localtime (clock: time_t_star): struct_tm_star;
</PRE>** Re-entrant versions of the above **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE asctime_r(tm: struct_tm_star; buf: char_star; buflen: int):char_star;

&lt;*EXTERNAL*&gt;
PROCEDURE ctime_r(clock: time_t_star; buf: char_star; buflen: int): char_star;

&lt;*EXTERNAL*&gt;
PROCEDURE gmtime_r(clock: time_t_star; result: struct_tm_star): struct_tm_star;

&lt;*EXTERNAL*&gt;
PROCEDURE localtime_r(clock: time_t_star; result: struct_tm_star): struct_tm_star;
</PRE>** tzset(3c) - set time zone information from environment variable TZ
               - called automatically by asctime, asctime_r **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE tzset ();

&lt;*EXTERNAL*&gt; VAR tzname: ARRAY [0..1] OF char_star;
&lt;*EXTERNAL*&gt; VAR daylight: int;
&lt;*EXTERNAL*&gt; VAR timezone, altzone: time_t;

VAR (*CONST*) CLK_TCK: INTEGER;
</PRE>** &lt;sys/time.h&gt; **

<P><PRE>TYPE
  struct_timeval = RECORD
    tv_sec: long;          (* seconds *)
    tv_usec: long;         (* and microseconds *) END;

  struct_timezone = RECORD
    tz_minuteswest:  int; (* minutes west of Greenwich *)
    tz_dsttime:      int; (* type of dst correction *) END;

CONST
  DST_NONE = 0;  (* not on dst *)
  DST_USA  = 1;  (* USA style dst *)
  DST_AUST = 2;  (* Australian style dst *)
  DST_WET  = 3;  (* Western European dst *)
  DST_MET  = 4;  (* Middle European dst *)
  DST_EET  = 5;  (* Eastern European dst *)
  DST_CAN	= 6;	(* Canada *)
  DST_GB        = 7;       (* Great Britain and Eire *)
  DST_RUM       = 8;       (* Rumania *)
  DST_TUR       = 9;       (* Turkey *)
  DST_AUSTALT   = 10;      (* Australian style with shift in 1986 *)

CONST (* which *)
  ITIMER_REAL =    0;   (* real time intervals *)
  ITIMER_VIRTUAL = 1;   (* virtual time intervals *)
  ITIMER_PROF    = 2;   (* user and system virtual time *)

TYPE
  struct_itimerval = RECORD
    it_interval: struct_timeval;            (* timer interval *)
    it_value:    struct_timeval;            (* current value *)  END;
</PRE><P>
 * Higher resolution time information
 
<PRE>TYPE
  timestruc_t = struct_timestruc;
  struct_timestruc = RECORD
	tv_sec	: time_t;		(* seconds *)
        tv_nsec : long;                 (* and nanoseconds *)
  END;
</PRE>** gettimeofday(2), settimeofday(2) - get/set date and time **

<P><PRE>&lt;*EXTERNAL BSDgettimeofday *&gt;
PROCEDURE gettimeofday (VAR t: struct_timeval;
                        VAR z: struct_timezone): int;

&lt;*EXTERNAL BSDsettimeofday *&gt;
PROCEDURE settimeofday (VAR t: struct_timeval;
                        VAR z: struct_timezone): int;
</PRE>** adjtime(2) - correct the time to allow synchronization of the 
                  system clock **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE adjtime (VAR delta, oldDelta: struct_timeval): int;
</PRE>** getitimer(2), setitimer(2) - get/set value of interval timer **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE getitimer (which: int; VAR value: struct_itimerval): int;

&lt;*EXTERNAL*&gt;
PROCEDURE setitimer (which: int;
                     VAR value, ovalue: struct_itimerval): int;
</PRE>** &lt;unistd.h&gt; **

<P>** stime(2) - set time **
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE stime (tp: time_t_star): int;
</PRE>** &lt;sys/times.h&gt; **

<P>
 * Structure returned by times()
 

<P><PRE>TYPE
  struct_tms = RECORD
        tms_utime: long;              (* user time *)
        tms_stime: long;              (* system time *)
        tms_cutime: long;             (* user time, children *)
        tms_cstime: long;             (* system time, children *)
  END;

  struct_tms_star = UNTRACED REF struct_tms;
</PRE>** times(3) - get process times (in ticks) **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE times (buffer: struct_tms_star): clock_t;

END Utime.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
