<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/irix-5.2/Utypes.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/irix-5.2/Utypes.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Utypes</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT
	long, unsigned_long, int, unsigned_int, short, unsigned_short,
        unsigned_char, char_star, signed_char, long_star;
</PRE>** &lt;sgidefs.h&gt; **

<P>
 * sgidefs.h - SGI/MIPS basic software generation system constants &amp; types
 *
 * This file MUST be includable in any language
 * and in the 'C' case must be ANSI compliant
 * In particular this means NO long long ...
 *
 * Constants and types defined here are to support
 * multi-isa (instruction set architecture) coding
 *
 * Each catagory has a define that the compilation system will set
 * based on the environment the compile is initiated in. Programs
 * can test the define using the manifest constants defined here.
 * (e.g. #if (MIPS_FPSET == 16) )
 

<P>
 * Floating Point register set
 * Define:
 *	MIPS_FPSET
 * Can take on the values 16 or 32
 

<P>
 * Instruction Set Architecture
 * Define:
 *	MIPS_ISA
 
<PRE>CONST
  MIPS_ISA_MIPS1	 = 1;	(* R2/3K *)
  MIPS_ISA_MIPS2	 = 2;	(* R4K/6K *)
  MIPS_ISA_MIPS3	 = 3;	(* R4K *)
  MIPS_ISA_MIPS4	 = 4;	(* TFP *)
</PRE><P>
 * Subprogram Interface Model
 * Define:
 *	MIPS_SIM
 
<PRE>CONST
  MIPS_SIM_ABI32	 = 1;	(* MIPS MSIG calling convention *)
  MIPS_SIM_ABI64	 = 2;	(* MIPS 64 calling convention *)
</PRE><P>
 * Data Types Sizes (C and C++)
 * Defines:
 *	MIPS_SZINT
 *	MIPS_SZLONG
 *	MIPS_SZPTR
 *
 * These can take on the values: 32, 64, 128
 

<P>
 * Compilation Environments
 *	various compilers may offer a set of different compilation environments
 *	each one will pre-define the above defines appropriately.
 * The MIPS ABI environment will pre-define the following:
 *	(cc -systype=XXX)
 *
 *	-D_MIPS_FPSET=16 -D_MIPS_ISA=MIPS_ISA_MIPS1
 *	-D_MIPS_SIM=MIPS_SIM_ABI32 -D_MIPS_SZINT=32
 *	-D_MIPS_SZLONG=32 -D_MIPS_SZPTR=32
 *
 * The MIPS 64 bit environment will pre-define the following
 *	(cc -systype=XXX)
 *	-D_MIPS_FPSET=32 -D_MIPS_ISA=MIPS_ISA_MIPS3
 *	-D_MIPS_SIM=MIPS_SIM_ABI64 -D_MIPS_SZINT=32
 *	-D_MIPS_SZLONG=64 -D_MIPS_SZPTR=64
 *
 

<P>
 * Language Specific
 * Type psint_t - a pointer sized int - this can be used:
 *	a) when casting a pointer so can perform e.g. a bit operation
 *	b) as a return code for functions incorrectly typed as int but
 *	   return a pointer.
 * User level code can also use the ANSI std ptrdiff_t, defined in stddef.h
 *	in place of psint_t
 * Type scint_t - a 'scaling' int - used when in fact one wants an 'int'
 *	that scales when moving to say 64 bit. (e.g. byte counts, bit lens)
 

<P> Assuming MIPS ABI environment:
 *
 * MIPS_ISA    = MIPS_ISA_MIPS1        (* instruction set architecture 
 <PRE>* MIPS_SIM    = MIPS_SIM_ABI32        (* subprogram interface model *)
 * MIPS_SZINT  = 32                     (* size of &quot;int&quot; *)
 * MIPS_SZLONG = 32                     (* size of &quot;long&quot; *)
 * MIPS_SZPTR  = 32                     (* size of &quot;void *&quot; *)
 * MIPS_FPSET  = 16                     (* floating point register set *)
 *)

TYPE
  int32_t      = int;
  uint32_t     = unsigned_int;
  int64_t      = RECORD hi, lo: int END;
  uint64_t     = RECORD hi, lo: unsigned_int END;
  psint_t      = int32_t;
  psunsigned_t = uint32_t;
  scint_t      = int32_t;
  scunsigned_t = uint32_t;
</PRE>** &lt;sys/types.h&gt; **

<P><PRE>TYPE
  (* POSIX Extensions *)
  uchar_t  = unsigned_char;
  ushort_t = unsigned_short;
  uint_t   = unsigned_int;
  ulong_t  = unsigned_long;

  (* Primarily Kernel types *)
  addr_t    = char_star;  (* ?&lt;core address&gt; type *)
  caddr_t   = char_star;  (* ?&lt;core address&gt; type *)
  daddr_t   = long;       (* &lt;disk address&gt; type *)
  pgno_t    = long;       (* virtual page number type *)
  pfn_t     = uint32_t; (* physical page number type *)
  cnt_t     = short;      (* ?&lt;count&gt; type *)

TYPE
  boolean_t = int;

CONST
  B_FALSE = 0;
  B_TRUE = 1;
</PRE><P>
 * The following type is for various kinds of identifiers.  The
 * actual type must be the same for all since some system calls
 * (such as sigsend) take arguments that may be any of these
 * types.  The enumeration type idtype_t defined in sys/procset.h
 * is used to indicate what type of id is being specified.
 

<P><PRE>TYPE
  id_t = long;	(* A process id,	*)
		(* process group id,	*)
		(* session id, 		*)
		(* scheduling class id,	*)
		(* user id, or group id.*)
</PRE> Typedefs for dev_t components 

<P><PRE>TYPE
  major_t = ulong_t;	(* major part of device number *)
  minor_t = ulong_t;	(* minor part of device number *)

TYPE
  mode_t  = unsigned_long;		(* file attrs *)
  dev_t   = unsigned_long;		(* device type *)
  uid_t   = long;
  gid_t   = long;
  nlink_t = unsigned_long;	(* used for link counts *)
  pid_t   = long;		(* proc &amp; grp IDs  *)
  ino_t   = unsigned_long;		(* &lt;inode&gt; type *)

  swblk_t = long;
  off_t   = long;		(* ?&lt;offset&gt; type *)
  paddr_t = unsigned_long;	(* &lt;physical address&gt; type *)
  key_t   = int;		(* IPC key type *)
  use_t   = unsigned_char;		(* use count for swap.  *)
  sysid_t = short;
  index_t = short;
  lock_t  = unsigned_int;		(* &lt;spinlock&gt; type *)
  cpuid_t = signed_char;	(* cpuid *)

  size_t    = unsigned_int;
  ssize_t   = int;
  time_t    = long;		(* &lt;time&gt; type *)
  clock_t   = long; (* relative time in a specified resolution *)
  bitnum_t  = scunsigned_t;	(* bit number *)
  bitlen_t  = scunsigned_t;	(* bit length *)
</PRE> a cpu machine register - user interface definitions 

<P>  <PRE>machreg_t = unsigned_int;
</PRE> a fpu machine register - user interface definitions 

<P>  <PRE>fpreg_t   = uint32_t;

  processorid_t   = int;	(* a processor name *)
  toid_t          = int;	(* timeout id *)
  qaddr_t         = long_star;	(* XXX should be typedef quad * qaddr_t *)
  inst_t          = uint32_t;	(* an instruction *)

  int8_t          = signed_char;
  int16_t         = short;
  u_int8_t        = unsigned_char;
  u_int16_t       = unsigned_short;
  u_int32_t       = uint32_t;
</PRE><P>
 * The following is the value of type id_t to use to indicate the
 * caller's current id.  See procset.h for the type idtype_t
 * which defines which kind of id is being specified.
 
<PRE>CONST
  P_MYID = (-1);
  NOPID  = (-1);
  NODEV  = (-1);
  P_MYPID = 0;
</PRE><P>
 * A host identifier is used to uniquely define a particular node
 * on an rfs network.  Its type is as follows.
 
<PRE>TYPE
  hostid_t  = long;
</PRE><P>
 * The following value of type is	: hostid_t used to indicate the
 * current host.
 
<PRE>CONST
  P_MYHOSTID  = (-1);

TYPE
  k_sigset_t = RECORD                (* signal set type *)
    sigbits : ARRAY [0..1] OF uint32_t;
  END;
  k_fltset_t = uint32_t;     (* kernel fault set type *)
</PRE>*********************** BSD stuff *******************

<P>** &lt;sys/bsdtypes.h&gt; **

<P>
 * These typedefs are needed by lots of BSD derived code - especially
 * networking. Alas these are not POSIX compliant so cannot be part of
 * sys/types.h
 
  <PRE>struct__physadr = RECORD r: ARRAY [0..0] OF int; END;
  physadr         = struct__physadr;

  unchar   = unsigned_char;
  u_char   = unsigned_char;
  ushort   = unsigned_short;
  u_short  = unsigned_short;
  uint     = unsigned_int;
  u_int    = unsigned_int;
  ulong    = unsigned_long;
  u_long   = unsigned_long;

  struct__quad = RECORD val: ARRAY [0..1] OF long; END;
  quad         = struct__quad;
</PRE>** &lt;sys/mkdev.h&gt; **

<P><PRE>CONST
  NBITSMAJOR	 = 14;	(* # of SVR4 major device bits *)
  NBITSMINOR	 = 18;	(* # of SVR4 minor device bits *)
  MAXMAJ	 = 16_ff;	(* XXXdh this may change if we decide to make
				 * lboot size the MAJOR array flexibly. *)

  MAXMIN	 = 16_3ffff;	(* MAX minor *)

&lt;*EXTERNAL*&gt; PROCEDURE <A HREF="#x2">makedev</A>(maj: major_t; min: minor_t): dev_t;
&lt;*EXTERNAL*&gt; PROCEDURE <A HREF="#x3">major</A>(dev: dev_t): major_t;
&lt;*EXTERNAL*&gt; PROCEDURE <A HREF="#x4">minor</A>(dev: dev_t): minor_t;
</PRE>** &lt;sys/select.h&gt; **

<P><PRE>CONST
  (*
   * Select uses bit masks of file descriptors in longs.
   * These macros manipulate such bit fields (the filesystem macros use chars).
   * FD_SETSIZE may be defined by the user, but the default here
   * should be &gt;= NOFILE (param.h).
   *)
  FD_SETSIZE = 1024;
  NBBY = 8;                           (* number of bits in a byte *)

TYPE
  fd_mask        = unsigned_long;

CONST
  NFDBITS = BYTESIZE (fd_mask) * NBBY;      (* bits per mask (power of 2!)*)

PROCEDURE <A HREF="#x5">howmany</A> (x, y: int): int;

TYPE
  struct_fd_set = RECORD
       fds_bits: ARRAY [0 .. ((FD_SETSIZE + NFDBITS - 1) DIV NFDBITS) - 1]
                       OF fd_mask;
    END;
  fd_set = struct_fd_set;

PROCEDURE <A HREF="#x6">FD_SET</A>   (n: int; p: UNTRACED REF fd_set): int;
PROCEDURE <A HREF="#x7">FD_CLEAR</A> (n: int; p: UNTRACED REF fd_set): int;
PROCEDURE <A HREF="#x8">FD_ISSET</A> (n: int; p: UNTRACED REF fd_set): int;
PROCEDURE <A HREF="#x9">FD_ZERO</A>  (p: UNTRACED REF fd_set);

END Utypes.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Utypes's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#0TOP0">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#0TOP0">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#0TOP0">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#0TOP0">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#0TOP0">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#0TOP0">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#0TOP0">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#0TOP0">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#0TOP0">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#0TOP0">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#0TOP0">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#0TOP0">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#0TOP0">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Utypes.makedev is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#makedev">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#makedev">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#makedev">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#makedev">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#makedev">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#makedev">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#makedev">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#makedev">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#makedev">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#makedev">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#makedev">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#makedev">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#makedev">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Utypes.major is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#major">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#major">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#major">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#major">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#major">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#major">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#major">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#major">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#major">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#major">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#major">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#major">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#major">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Utypes.minor is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#minor">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#minor">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#minor">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#minor">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#minor">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#minor">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#minor">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#minor">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#minor">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#minor">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#minor">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#minor">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#minor">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Utypes.howmany is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#howmany">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#howmany">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#howmany">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#howmany">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#howmany">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#howmany">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#howmany">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#howmany">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#howmany">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#howmany">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#howmany">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#howmany">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#howmany">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#howmany">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Utypes.FD_SET is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_SET">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_SET">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_SET">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_SET">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_SET">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_SET">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_SET">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_SET">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#FD_SET">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_SET">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_SET">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_SET">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_SET">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_SET">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Utypes.FD_CLEAR is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_CLEAR">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_CLEAR">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_CLEAR">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_CLEAR">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_CLEAR">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_CLEAR">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_CLEAR">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_CLEAR">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#FD_CLEAR">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_CLEAR">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_CLEAR">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_CLEAR">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_CLEAR">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_CLEAR">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Utypes.FD_ISSET is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_ISSET">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_ISSET">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_ISSET">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_ISSET">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_ISSET">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_ISSET">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_ISSET">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_ISSET">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#FD_ISSET">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_ISSET">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_ISSET">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_ISSET">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_ISSET">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_ISSET">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Utypes.FD_ZERO is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_ZERO">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_ZERO">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_ZERO">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_ZERO">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_ZERO">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_ZERO">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_ZERO">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_ZERO">unix/src/linux/Utypes.m3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.m3#FD_ZERO">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_ZERO">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_ZERO">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_ZERO">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_ZERO">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_ZERO">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
