<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/osf-1.ALPHA_OSF/Utypes.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/osf-1.ALPHA_OSF/Utypes.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="#x1">Utypes</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT
	long, unsigned_long, int, unsigned_int, short, unsigned_short,
        unsigned_char, char_star, void_star, char;
</PRE>** &lt;sys/types.h&gt; **

<P>
<P><PRE>TYPE
  ptrdiff_t  = long;
  wchar_t    = unsigned_char;
  wctype_t   = unsigned_int;
  fpos_t     = long;
  time_t     = int;
  clock_t    = int;
  size_t     = unsigned_long;
  ssize_t    = long;
</PRE><P>
 * shorthand type definitions for unsigned storage classes
 
<PRE>TYPE
  uchar     = unsigned_char;
  u_char    = unsigned_char;
  uchar_t   = unsigned_char;
  vuchar_t  = (* volatile *) unsigned_char;
  vu_char   = (* volatile *) unsigned_char;

  ushort    = unsigned_short;
  u_short   = unsigned_short;
  ushort_t  = unsigned_short;
  vushort_t = (* volatile *) unsigned_short;
  vu_short  = (* volatile *) unsigned_short;

  uint      = unsigned_int;
  u_int     = unsigned_int;
  uint_t    = unsigned_int;
  vuint_t   = (* volatile *) unsigned_int;
  vu_int    = (* volatile *) unsigned_int;

  ulong     = unsigned_long;
  u_long    = unsigned_long;
  ulong_t   = unsigned_long;
  vulong_t  = (* volatile *) unsigned_long;
  vu_long   = (* volatile *) unsigned_long;

TYPE
  struct__physadr = RECORD r: ARRAY [0..0] OF long; END;
  physadr_t       = UNTRACED REF struct__physadr;
  physadr         = physadr_t;

TYPE
  struct_label_t  = RECORD val: ARRAY [0..9] OF long; END;
  label_t         = struct_label_t;

TYPE
  level_t      = int;

  daddr_t      = int;            (* disk address *)
  caddr_t      = char_star;      (* &quot;core&quot; (i.e. memory) address *)
  qaddr_t      = UNTRACED REF quad;
  addr_t       = char_star;

  ino_t        = uint_t;         (* inode number (filesystem) *)
  cnt_t        = short;
  dev_t        = int;            (* device number (major+minor) *)
  chan_t       = int;            (* channel number (minor's minor) *)
  off_t        = long;           (* file offset *)

  rlim_t       = unsigned_long;  (* resource limit *)
  paddr_t      = int;
  nlink_t      = ushort_t;

  key_t        = int;            (* ipc key type *)
  mode_t       = uint_t;         (* file mode *)
  uid_t        = uint_t;         (* user ID *)
  gid_t        = uint_t;         (* group ID *)
  mid_t        = void_star;      (* module ID *)
  pid_t        = int;            (* process ID *)

  slab_t       = ARRAY [0..11] OF char;  (* security label *)
</PRE><P>
 * The following type is for various kinds of identifiers.  The
 * actual type must be the same for all since some system calls
 * (such as sigsend) take arguments that may be any of these
 * types.  The enumeration type idtype_t defined in sys/procset.h
 * is used to indicate what type of id is being specified.
 
<PRE>TYPE
  id_t = pid_t; (* A process, process group, session, scheduling class,
                   user or group id. *)

CONST
  P_MYID = -1;  (* a usually illegal value for IDs, but specifying
                   whatever the value is for my process *)

TYPE
  shmatt_t  = ulong_t;  (* for shmid_ds.shm_nattach *)
  msgqnum_t = ulong_t;  (* for msqid_ds.msg_qnum *)
  msglen_t  = ulong_t;  (* for msqid_ds.msg_qbytes *)

TYPE
  wint_t   = unsigned_int;      (* wide character *)
  sigset_t = unsigned_long;   (* signal mask *)
  timer_t  = long;            (* timer id *)

TYPE
  sig_t  = PROCEDURE ();
</PRE><P>
 * Types used by dev_t annotation procedures
 
<PRE>TYPE
  major_t = uint_t;      (* major device number   *)
  minor_t = uint_t;      (* minor device number   *)
  devs_t  = uint_t;      (* device-specific info  *)
  unit_t  = uint_t;      (* unit number of device *)
</PRE><P>
 * Basic system types and major/minor device constructing/busting macros.
 

<P> major part of a device 
<PRE>PROCEDURE <A HREF="#x2">major</A> (x: dev_t): major_t;
</PRE> minor part of a device 
<PRE>PROCEDURE <A HREF="#x3">minor</A> (x: dev_t): minor_t;
</PRE> make a device number 
<PRE>PROCEDURE <A HREF="#x4">makedev</A> (x: major_t;  y: minor_t): dev_t;

TYPE
  struct__quad = RECORD val: ARRAY [0..1] OF int; END;
  quad         = struct__quad;

TYPE
  swblk_t      = long;
  fixpt_t      = u_long;

CONST
  NBBY = 8; (* number of bits in a byte *)

  (*
   * Select uses bit masks of file descriptors in longs.
   * These macros manipulate such bit fields (the filesystem macros use chars).
   * FD_SETSIZE may be defined by the user, but the default here
   * should be equal to OPEN_MAX_SYSTEM (param.h).
   *)
  MAX_NOFILE = 4096;
  FD_SETSIZE = MAX_NOFILE;

  (* How many things we'll allow select to use. 0 if unlimited *)
  MAXSELFD = MAX_NOFILE;

TYPE
  fd_mask = int;

CONST
  NFDBITS = BYTESIZE (fd_mask) * NBBY;      (* bits per mask (power of 2!)*)
  NFDSHIFT = 5;                             (* Shift based on above *)

PROCEDURE <A HREF="#x5">howmany</A> (x, y: INTEGER): INTEGER;

CONST
  n_masks = (FD_SETSIZE + NFDBITS - 1) DIV NFDBITS;
            (* == howmany (FD_SETSIZE, NFDBITS) *)

TYPE
  struct_fd_set = RECORD
       fds_bits: ARRAY [0 .. n_masks - 1] OF fd_mask;
  END;
  fd_set = struct_fd_set;

PROCEDURE <A HREF="#x6">FD_SET</A>   (n: INTEGER; p: UNTRACED REF fd_set): INTEGER;
PROCEDURE <A HREF="#x7">FD_CLEAR</A> (n: INTEGER; p: UNTRACED REF fd_set): INTEGER;
PROCEDURE <A HREF="#x8">FD_ISSET</A> (n: INTEGER; p: UNTRACED REF fd_set): INTEGER;
PROCEDURE <A HREF="#x9">FD_ZERO</A>  (p: UNTRACED REF fd_set);

END Utypes.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Utypes's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#0TOP0">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#0TOP0">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#0TOP0">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#0TOP0">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#0TOP0">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#0TOP0">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#0TOP0">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#0TOP0">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#0TOP0">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#0TOP0">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#0TOP0">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#0TOP0">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#0TOP0">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Utypes.major is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#major">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#major">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#major">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#major">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#major">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#major">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#major">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#major">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#major">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#major">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#major">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#major">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#major">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Utypes.minor is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#minor">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#minor">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#minor">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#minor">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#minor">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#minor">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#minor">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#minor">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#minor">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#minor">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#minor">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#minor">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#minor">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Utypes.makedev is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#makedev">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#makedev">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#makedev">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#makedev">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#makedev">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#makedev">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#makedev">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#makedev">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#makedev">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#makedev">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#makedev">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#makedev">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#makedev">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Utypes.howmany is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#howmany">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#howmany">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#howmany">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#howmany">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#howmany">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#howmany">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#howmany">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#howmany">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#howmany">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#howmany">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#howmany">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#howmany">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#howmany">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#howmany">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Utypes.FD_SET is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_SET">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_SET">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_SET">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_SET">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_SET">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_SET">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#FD_SET">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_SET">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_SET">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_SET">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_SET">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_SET">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_SET">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_SET">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Utypes.FD_CLEAR is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_CLEAR">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_CLEAR">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_CLEAR">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_CLEAR">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_CLEAR">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_CLEAR">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#FD_CLEAR">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_CLEAR">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_CLEAR">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_CLEAR">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_CLEAR">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_CLEAR">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_CLEAR">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_CLEAR">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Utypes.FD_ISSET is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_ISSET">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_ISSET">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_ISSET">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_ISSET">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_ISSET">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_ISSET">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#FD_ISSET">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_ISSET">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_ISSET">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_ISSET">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_ISSET">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_ISSET">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_ISSET">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_ISSET">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Utypes.FD_ZERO is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.m3#FD_ZERO">unix/src/aix-3-2/Utypes.m3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.m3#FD_ZERO">unix/src/aix-ps2-1-2/Utypes.m3</A>
<LI><A HREF="../freebsd-1/Utypes.m3#FD_ZERO">unix/src/freebsd-1/Utypes.m3</A>
<LI><A HREF="../freebsd-2/Utypes.m3#FD_ZERO">unix/src/freebsd-2/Utypes.m3</A>
<LI><A HREF="../hpux-7-0/Utypes.m3#FD_ZERO">unix/src/hpux-7-0/Utypes.m3</A>
<LI><A HREF="../ibm-4-3/Utypes.m3#FD_ZERO">unix/src/ibm-4-3/Utypes.m3</A>
<LI><A HREF="../irix-5.2/Utypes.m3#FD_ZERO">unix/src/irix-5.2/Utypes.m3</A>
<LI><A HREF="../linux/Utypes.m3#FD_ZERO">unix/src/linux/Utypes.m3</A>
<LI><A HREF="Utypes.m3#FD_ZERO">unix/src/osf-1.ALPHA_OSF/Utypes.m3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.m3#FD_ZERO">unix/src/osf-1.DS3100/Utypes.m3</A>
<LI><A HREF="../solaris-2-x/Utypes.m3#FD_ZERO">unix/src/solaris-2-x/Utypes.m3</A>
<LI><A HREF="../sunos-4-x/Utypes.m3#FD_ZERO">unix/src/sunos-4-x/Utypes.m3</A>
<LI><A HREF="../sysv-4.0/Utypes.m3#FD_ZERO">unix/src/sysv-4.0/Utypes.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Utypes.m3#FD_ZERO">unix/src/ultrix-3-1.generic/Utypes.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
