<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/osf-1.generic/Udir.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/osf-1.generic/Udir.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE INTERFACE <interface><A HREF="#x1">Udir</A></interface>;
</PRE>** &lt;dir.h&gt; **

<P><PRE>IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x2">Utypes</A>;

CONST
  MAXNAMLEN = 255;   (* maximum length of component of file path name *)
  MAXPATHLEN = 1024; (* maximum length of file path name *)

TYPE
  gen_dir = RECORD        (* describes directory entry *)
    d_ino     : Utypes.ino_t;     (* inode number of entry *)
    d_reclen  : Utypes.ushort_t;  (* record length in bytes *)
    d_namelen : Utypes.ushort_t;  (* name length in bytes *)
    d_name    : ARRAY [0..MAXNAMLEN] OF Ctypes.char;  (* name *)
  END;

  direct = gen_dir;                    (* backwards compatibility *)

  DIR = RECORD
    dd_fd:      Ctypes.int;     (* file descriptor associated with directory *)
    dd_loc:     Ctypes.long;    (* offset in current buffer *)
    dd_size:    Ctypes.long;    (* amount of data returned by getdirentries *)
    dd_buf:     Ctypes.char_star; (* data buffer *)
    dd_bufsize: Ctypes.int;
    dd_len:     Ctypes.int;     (* size of data buffer *)
    dd_seek:    Ctypes.long;    (* magic cookie returned by getdirentries *)
    dd_lock:    Ctypes.void_star; (* for inter-thread locking *)
  END;

  DIR_star = UNTRACED REF DIR;

  direct_star = UNTRACED REF direct;

&lt;*EXTERNAL*&gt; PROCEDURE opendir (filename: Ctypes.char_star): DIR_star;
&lt;*EXTERNAL*&gt; PROCEDURE <A HREF="../solaris-2-x/Udir.m3#readdir">readdir</A> (dirp: DIR_star): direct_star;
&lt;*EXTERNAL*&gt; PROCEDURE telldir (dirp: DIR_star): Ctypes.long;
&lt;*EXTERNAL*&gt; PROCEDURE seekdir (dirp: DIR_star; loc: Ctypes.long);
</PRE><BLOCKQUOTE><EM> 'rewinddir' is usually a macro for 'seekdir(dirp, 0)' </EM></BLOCKQUOTE><PRE>
&lt;*EXTERNAL*&gt; PROCEDURE closedir(dirp: DIR_star): Ctypes.int;

END Udir.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Udir's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Udir.m3#0TOP0">unix/src/aix-3-2/Udir.m3</A>
<LI><A HREF="../aix-ps2-1-2/Udir.m3#0TOP0">unix/src/aix-ps2-1-2/Udir.m3</A>
<LI><A HREF="../solaris-2-x/Udir.m3#0TOP0">unix/src/solaris-2-x/Udir.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
