<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/osf-1.generic/Uerror.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/osf-1.generic/Uerror.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Uerror</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, char_star;
</PRE>** &lt;errno.h&gt; **

<P><PRE>CONST
  EPERM   = 1;                 (* Not owner *)
  ENOENT  = 2;                 (* No such file or directory *)
  ESRCH   = 3;                 (* No such process *)
  EINTR   = 4;                 (* Interrupted system call *)
  EIO     = 5;                 (* I/O error *)
  ENXIO   = 6;                 (* No such device or address *)
  E2BIG   = 7;                 (* Arg list too long *)
  ENOEXEC = 8;                 (* Exec format error *)
  EBADF   = 9;                 (* Bad file number *)
  ECHILD  = 10;                (* No children *)
  EAGAIN  = 11;                (* No more processes *)
  ENOMEM  = 12;                (* Not enough core *)
  EACCES  = 13;                (* Permission denied *)
  EFAULT  = 14;                (* Bad address *)
  ENOTBLK = 15;                (* Block device required *)
  EBUSY   = 16;                (* Mount device busy *)
  EEXIST  = 17;                (* File exists *)
  EXDEV   = 18;                (* Cross-device link *)
  ENODEV  = 19;                (* No such device *)
  ENOTDIR = 20;                (* Not a directory*)
  EISDIR  = 21;                (* Is a directory *)
  EINVAL  = 22;                (* Invalid argument *)
  ENFILE  = 23;                (* File table overflow *)
  EMFILE  = 24;                (* Too many open files *)
  ENOTTY  = 25;                (* Not a typewriter *)
  ETXTBSY = 26;                (* Text file busy *)
  EFBIG   = 27;                (* File too large *)
  ENOSPC  = 28;                (* No space left on device *)
  ESPIPE  = 29;                (* Illegal seek *)
  EROFS   = 30;                (* Read-only file system *)
  EMLINK  = 31;                (* Too many links *)
  EPIPE   = 32;                (* Broken pipe *)

  (* math software *)
  EDOM    = 33;                (* Argument too large *)
  ERANGE  = 34;                (* Result too large *)

 (* non-blocking and interrupt i/o *)
  EWOULDBLOCK  = 35;           (* Operation would block *)
  EINPROGRESS  = 36;           (* Operation now in progress *)
  EALREADY     = 37;           (* Operation already in progress *)

  (* ipc/network software *)
        (* argument errors *)
  ENOTSOCK        = 38;   (* Socket operation on non-socket *)
  EDESTADDRREQ    = 39;   (* Destination address required *)
  EMSGSIZE        = 40;   (* Message too long *)
  EPROTOTYPE      = 41;   (* Protocol wrong type for socket *)
  ENOPROTOOPT     = 42;   (* Protocol not available *)
  EPROTONOSUPPORT = 43;   (* Protocol not supported *)
  ESOCKTNOSUPPORT = 44;   (* Socket type not supported *)
  EOPNOTSUPP      = 45;   (* Operation not supported on socket *)
  EPFNOSUPPORT    = 46;   (* Protocol family not supported *)
  EAFNOSUPPORT    = 47;   (* Address family not supported by protocol family *)
  EADDRINUSE      = 48;   (* Address already in use *)
  EADDRNOTAVAIL   = 49;   (* Can't assign requested address *)

        (* operational errors *)
  ENETDOWN        = 50;          (* Network is down *)
  ENETUNREACH     = 51;          (* Network is unreachable *)
  ENETRESET       = 52;          (* Network dropped connection on reset *)
  ECONNABORTED    = 53;          (* Software caused connection abort *)
  ECONNRESET      = 54;          (* Connection reset by peer *)
  ENOBUFS         = 55;          (* No buffer space available *)
  EISCONN         = 56;          (* Socket is already connected *)
  ENOTCONN        = 57;          (* Socket is not connected *)
  ESHUTDOWN       = 58;          (* Can't send after socket shutdown *)
  ETOOMANYREFS    = 59;          (* Too many references: can't splice *)
  ETIMEDOUT       = 60;          (* Connection timed out *)
  ECONNREFUSED    = 61;          (* Connection refused *)

        (* *)
  ELOOP           = 62;          (* Too many levels of symbolic links *)
  ENAMETOOLONG    = 63;          (* File name too long *)

  (* should be rearranged *)
  EHOSTDOWN       = 64;          (* Host is down *)
  EHOSTUNREACH    = 65;          (* No route to host *)
  ENOTEMPTY       = 66;          (* Directory not empty *)

  (* quotas &amp; mush *)
  EPROCLIM        = 67;          (* Too many processes *)
  EUSERS          = 68;          (* Too many users *)
  EDQUOT          = 69;          (* Disc quota exceeded *)

  (* NFS error codes *)
  ESTALE  = 70;
  EREMOTE = 71;

  (* IPC errors *)

  ENOMSG = 72;                   (* No message of desired type *)
  EIDRM  = 73;                   (* Identifier removed *)

  (* Alignment error of some type (i.e., cluster, page, block ...) *)
  EALIGN  = 74;                  (* alignment error *)

  (* System V mappings from BRL package *)
  EDEADLK  = EWOULDBLOCK;        (* resource deadlock would occur *)

  (* POSIX errnos *)
  ENOLCK  = 75;                  (* LOCK_MAX exceeded     *)

&lt;*EXTERNAL*&gt;
VAR
  errno: int;
</PRE> Extention by mjordan 
<PRE>CONST
  Max = ENOLCK; (* should be exported from Uerror *)

&lt;*EXTERNAL*&gt; VAR
  sys_nerr: int;
  sys_errlist: ARRAY [0..Max] OF char_star;

PROCEDURE <A HREF="#x2">GetFrom_sys_errlist</A>(n: INTEGER): char_star RAISES {};
</PRE><BLOCKQUOTE><EM> returns entry 'n' of the 'sys_errlist' array; a checked runtime error
   unless 0 &lt;= n &lt;= sys_nerr. Its safer and more portable to use this 
   procedure than to access the array directly.
</EM></BLOCKQUOTE><PRE>

END Uerror.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Uerror's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uerror.m3#0TOP0">unix/src/aix-3-2/Uerror.m3</A>
<LI><A HREF="../aix-ps2-1-2/Uerror.m3#0TOP0">unix/src/aix-ps2-1-2/Uerror.m3</A>
<LI><A HREF="../freebsd-1/Uerror.m3#0TOP0">unix/src/freebsd-1/Uerror.m3</A>
<LI><A HREF="../freebsd-2/Uerror.m3#0TOP0">unix/src/freebsd-2/Uerror.m3</A>
<LI><A HREF="../hpux-7-0/Uerror.m3#0TOP0">unix/src/hpux-7-0/Uerror.m3</A>
<LI><A HREF="../ibm-4-3/Uerror.m3#0TOP0">unix/src/ibm-4-3/Uerror.m3</A>
<LI><A HREF="../irix-5.2/Uerror.m3#0TOP0">unix/src/irix-5.2/Uerror.m3</A>
<LI><A HREF="../linux/Uerror.m3#0TOP0">unix/src/linux/Uerror.m3</A>
<LI><A HREF="Uerror.m3#0TOP0">unix/src/osf-1.generic/Uerror.m3</A>
<LI><A HREF="../solaris-2-x/Uerror.m3#0TOP0">unix/src/solaris-2-x/Uerror.m3</A>
<LI><A HREF="../sunos-4-x/Uerror.m3#0TOP0">unix/src/sunos-4-x/Uerror.m3</A>
<LI><A HREF="../sysv-4.0/Uerror.m3#0TOP0">unix/src/sysv-4.0/Uerror.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Uerror.m3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Uerror.GetFrom_sys_errlist is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uerror.m3#GetFrom_sys_errlist">unix/src/aix-3-2/Uerror.m3</A>
<LI><A HREF="../aix-ps2-1-2/Uerror.m3#GetFrom_sys_errlist">unix/src/aix-ps2-1-2/Uerror.m3</A>
<LI><A HREF="../freebsd-1/Uerror.m3#GetFrom_sys_errlist">unix/src/freebsd-1/Uerror.m3</A>
<LI><A HREF="../freebsd-2/Uerror.m3#GetFrom_sys_errlist">unix/src/freebsd-2/Uerror.m3</A>
<LI><A HREF="../hpux-7-0/Uerror.m3#GetFrom_sys_errlist">unix/src/hpux-7-0/Uerror.m3</A>
<LI><A HREF="../ibm-4-3/Uerror.m3#GetFrom_sys_errlist">unix/src/ibm-4-3/Uerror.m3</A>
<LI><A HREF="../irix-5.2/Uerror.m3#GetFrom_sys_errlist">unix/src/irix-5.2/Uerror.m3</A>
<LI><A HREF="../linux/Uerror.m3#GetFrom_sys_errlist">unix/src/linux/Uerror.m3</A>
<LI><A HREF="Uerror.m3#GetFrom_sys_errlist">unix/src/osf-1.generic/Uerror.m3</A>
<LI><A HREF="../solaris-2-x/Uerror.m3#GetFrom_sys_errlist">unix/src/solaris-2-x/Uerror.m3</A>
<LI><A HREF="../sunos-4-x/Uerror.m3#GetFrom_sys_errlist">unix/src/sunos-4-x/Uerror.m3</A>
<LI><A HREF="../sysv-4.0/Uerror.m3#GetFrom_sys_errlist">unix/src/sysv-4.0/Uerror.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Uerror.m3#GetFrom_sys_errlist">unix/src/ultrix-3-1.generic/Uerror.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
