<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/solaris-2-x/Udir.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/solaris-2-x/Udir.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="#x1">Udir</A></interface>;

IMPORT <A HREF="#x2">Utypes</A>;
FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char_star, int, long, unsigned_short;

CONST
  MAXNAMELEN = 512;     (* Maximum length of component of file path name. *)
  MAXPATHLEN = 1024;    (* Maximum length of file path name. *)

TYPE
  struct_dirent_star_star = UNTRACED REF struct_dirent_star;
  struct_dirent_star = UNTRACED REF struct_dirent;
  struct_dirent = RECORD
    d_ino        : Utypes.ino_t;
    d_offset_XXX : Utypes.off_t; (* not set until libucb is no *)
                                 (* longer linked into M3 programs. *)
    d_reclen     : unsigned_short;
    d_name       : D_name;
  END;

  D_name = ARRAY [0..MAXNAMELEN] OF CHAR;

  DIR_star = UNTRACED REF DIR;
  DIR = RECORD
    dd_fd   : int;
    dd_loc  : int;
    dd_size : int;
    dd_buf  : char_star;
    nlist   : struct_dirent_star_star;
  END;

&lt;* EXTERNAL *&gt; PROCEDURE opendir(dir: char_star): DIR_star;
</PRE><BLOCKQUOTE><EM> Make readdir external again when libucb is no longer linked into M3
   programs. </EM></BLOCKQUOTE><PRE>
               PROCEDURE <A HREF="Udir.m3#readdir">readdir</A>(dirPtr: DIR_star): struct_dirent_star;
&lt;* EXTERNAL *&gt; PROCEDURE telldir(dirPtr: DIR_star): long;
&lt;* EXTERNAL *&gt; PROCEDURE seekdir(dirPtr: DIR_star; location: long);
&lt;* EXTERNAL *&gt; PROCEDURE rewinddir(dirPtr: DIR_star);
&lt;* EXTERNAL *&gt; PROCEDURE closedir(dirPtr: DIR_star): int;
</PRE>----------------------------------------------- UCB compatibility hack ---
 This is an interface to the Berkeley-style readdir routine.  The rest
   of Udir is identical between Berkeley and System V.  This should go
   away when libucb is no longer linked into M3 programs. 

<P><PRE>TYPE
  UCB_struct_direct_star = UNTRACED REF UCB_struct_direct;
  UCB_struct_direct = RECORD
    d_ino     : Utypes.ino_t;
    d_reclen  : unsigned_short;
    d_namlen  : unsigned_short;
    d_name    : D_name;
  END;

&lt;* EXTERNAL &quot;readdir&quot;*&gt;
PROCEDURE UCB_readdir(dirPtr: DIR_star): UCB_struct_direct_star;

END Udir.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Udir's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Udir.m3#0TOP0">unix/src/aix-3-2/Udir.m3</A>
<LI><A HREF="../aix-ps2-1-2/Udir.m3#0TOP0">unix/src/aix-ps2-1-2/Udir.m3</A>
<LI><A HREF="Udir.m3#0TOP0">unix/src/solaris-2-x/Udir.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
