<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/solaris-2-x/Unetdb.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/solaris-2-x/Unetdb.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Unetdb</A></interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, char_star, char_star_star, unsigned_long;
</PRE>** &lt;netdb.h&gt; **

<P>
 * Structures returned by network
 * data base library.  All addresses
 * are supplied in host order, and
 * returned in network order (suitable
 * for use in system calls).
 

<P><PRE>TYPE
  struct_hostent  = RECORD
    h_name:       char_star;        (* official name of host *)
    h_aliases:    char_star_star;   (* alias list *)
    h_addrtype:   int;              (* host address type *)
    h_length:     int;              (* length of address *)
    h_addr_list:  char_star_star;   (* list of addresses from name server *)
    END;
  struct_hostent_star = UNTRACED REF struct_hostent;
</PRE><P>
 * Assumption here is that a network number
 * fits in 32 bits -- probably a poor one.
 

<P>  <PRE>struct_netent = RECORD
    n_name:     char_star;      (* official name of net *)
    n_aliases:  char_star_star; (* alias list *)
    n_addrtype: int;            (* net address type *)
    n_net:      unsigned_long;  (* network # *)
    END;
  struct_netent_star = UNTRACED REF struct_netent;

  struct_servent = RECORD
    s_name:    char_star;       (* official service name *)
    s_aliases: char_star_star;  (* alias list *)
    s_port:    int;             (* port # *)
    s_proto:   char_star;       (* protocol to use *)
    END;
  struct_servent_star = UNTRACED REF struct_servent;

  struct_protoent = RECORD
    p_name:    char_star;       (* official protocol name *)
    p_aliases: char_star_star;  (* alias list *)
    p_proto:   int;             (* protocol # *)
    END;
  struct_protoent_star = UNTRACED REF struct_protoent;

  struct_rpcent = RECORD
    r_name:    char_star;        (* name of server for this rpc program *)
    r_aliases: char_star_star;   (* alias list *)
    r_number:  int;              (* rpc program number *)
    END;
</PRE><P>
 * Error return codes from gethostbyname() and gethostbyaddr()
 

<P><PRE>CONST
  HOST_NOT_FOUND = 1; (* Authoritive Answer Host not found *)
  TRY_AGAIN      = 2; (* Non-Authoritive Host not found, or SERVERFAIL *)
  NO_RECOVERY    = 3; (* Non recoverable errors, FORMERR, REFUSED, NOTIMP *)
  NO_ADDRESS     = 4; (* Valid host name, no address, look for MX record *)
</PRE> The services accessible via the V2.4 gethostent interface 

<P>  <PRE>SVC_LOCAL = 1;    (* /etc/hosts *)
  SVC_BIND  = 2;    (* Internet domain service *)
  SVC_YP    = 3;    (* Yellow Pages service *)
</PRE> Number of services 

<P>  <PRE>NSVCS = 4;        (* Number of supported services *)

PROCEDURE <A HREF="#x2">VALID_SVC</A> (a: int): BOOLEAN;
</PRE>** gethostent(3n), gethostbyaddr(3n), gethostbyname(3n), 
     sethostent(3n), endhostent(3n) - get network host entry **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE gethostent (): struct_hostent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE gethostbyname (name: char_star): struct_hostent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE gethostbyaddr (addr: char_star; len, type: int): struct_hostent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE sethostent (stayopen: int);

&lt;*EXTERNAL*&gt;
PROCEDURE endhostent ();
</PRE>** getnetent(3n), getnetbyaddr(3n), getnetbyname(3n), 
     setnetent(3n), endnetent(3n) - get network entry **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE getnetent (): struct_netent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getnetbyname (name: char_star): struct_netent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getnetbyaddr (addr: char_star; type: int): struct_netent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE setnetent (stayopen: int);

&lt;*EXTERNAL*&gt;
PROCEDURE endnetent ();
</PRE>** getprotoent(3n), getprotobynumber(3n), getprotobyname(3n), 
     setprotoent(3n), endprotoent(3n) - get protocol entry **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE getprotoent (): struct_protoent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getprotobynumber (proto: int): struct_protoent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getprotobyname (name: char_star): struct_protoent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE setprotoent (stayopen: int);

&lt;*EXTERNAL*&gt;
PROCEDURE endprotoent ();
</PRE>** getservent(3n), getservbynumber(3n), getservbyname(3n), 
     setservent(3n), endservent(3n) - get service entry **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE getservent (): struct_servent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getservbyport (port: int; proto: char_star): struct_servent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE getservbyname (name, proto: char_star): struct_servent_star;

&lt;*EXTERNAL*&gt;
PROCEDURE setservent (stayopen: int);

&lt;*EXTERNAL*&gt;
PROCEDURE endservent ();

END Unetdb.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Unetdb's implementation  is in:
</A><UL>
<LI><A HREF="../aix-3-2/Unetdb.m3#0TOP0">unix/src/aix-3-2/Unetdb.m3</A>
<LI><A HREF="../aix-ps2-1-2/Unetdb.m3#0TOP0">unix/src/aix-ps2-1-2/Unetdb.m3</A>
<LI><A HREF="../freebsd-1/Unetdb.m3#0TOP0">unix/src/freebsd-1/Unetdb.m3</A>
<LI><A HREF="../freebsd-2/Unetdb.m3#0TOP0">unix/src/freebsd-2/Unetdb.m3</A>
<LI><A HREF="../ibm-4-3/Unetdb.m3#0TOP0">unix/src/ibm-4-3/Unetdb.m3</A>
<LI><A HREF="../irix-5.2/Unetdb.m3#0TOP0">unix/src/irix-5.2/Unetdb.m3</A>
<LI><A HREF="../linux/Unetdb.m3#0TOP0">unix/src/linux/Unetdb.m3</A>
<LI><A HREF="../osf-1.generic/Unetdb.m3#0TOP0">unix/src/osf-1.generic/Unetdb.m3</A>
<LI><A HREF="Unetdb.m3#0TOP0">unix/src/solaris-2-x/Unetdb.m3</A>
<LI><A HREF="../sunos-4-x/Unetdb.m3#0TOP0">unix/src/sunos-4-x/Unetdb.m3</A>
<LI><A HREF="../sysv-4.0/Unetdb.m3#0TOP0">unix/src/sysv-4.0/Unetdb.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Unetdb.m3#0TOP0">unix/src/ultrix-3-1.generic/Unetdb.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Unetdb.VALID_SVC is in:
</A><UL>
<LI><A HREF="../aix-3-2/Unetdb.m3#VALID_SVC">unix/src/aix-3-2/Unetdb.m3</A>
<LI><A HREF="../aix-ps2-1-2/Unetdb.m3#VALID_SVC">unix/src/aix-ps2-1-2/Unetdb.m3</A>
<LI><A HREF="../freebsd-1/Unetdb.m3#VALID_SVC">unix/src/freebsd-1/Unetdb.m3</A>
<LI><A HREF="../freebsd-2/Unetdb.m3#VALID_SVC">unix/src/freebsd-2/Unetdb.m3</A>
<LI><A HREF="../ibm-4-3/Unetdb.m3#VALID_SVC">unix/src/ibm-4-3/Unetdb.m3</A>
<LI><A HREF="../irix-5.2/Unetdb.m3#VALID_SVC">unix/src/irix-5.2/Unetdb.m3</A>
<LI><A HREF="../linux/Unetdb.m3#VALID_SVC">unix/src/linux/Unetdb.m3</A>
<LI><A HREF="../osf-1.generic/Unetdb.m3#VALID_SVC">unix/src/osf-1.generic/Unetdb.m3</A>
<LI><A HREF="Unetdb.m3#VALID_SVC">unix/src/solaris-2-x/Unetdb.m3</A>
<LI><A HREF="../sunos-4-x/Unetdb.m3#VALID_SVC">unix/src/sunos-4-x/Unetdb.m3</A>
<LI><A HREF="../sysv-4.0/Unetdb.m3#VALID_SVC">unix/src/sysv-4.0/Unetdb.m3</A>
<LI><A HREF="../ultrix-3-1.generic/Unetdb.m3#VALID_SVC">unix/src/ultrix-3-1.generic/Unetdb.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
