<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/sunos-4-x/Uresource.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/sunos-4-x/Uresource.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>Uresource</interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, long;
IMPORT <A HREF="#x1">Utime</A>;
</PRE>** &lt;sys/resource.h&gt; **

<P><PRE>CONST
  PRIO_MIN = -20;
  PRIO_MAX = 20;

  PRIO_PROCESS = 0;
  PRIO_PGRP    = 1;
  PRIO_USER    = 2;
</PRE> Resource utilization information. 

<P><PRE>CONST
  RUSAGE_SELF     = 0;
  RUSAGE_CHILDREN = -1;

TYPE
  struct_rusage = RECORD
             ru_utime: Utime.struct_timeval;  (* user time used *)
             ru_stime: Utime.struct_timeval;  (* system time used *)
             ru_maxrss: long;
             ru_ixrss: long;            (* integral shared text size *)
             ru_ismrss: long;           (* integral shared memory size*)
             ru_idrss: long;            (* integral unshared data &quot; *)
             ru_isrss: long;            (* integral unshared stack &quot; *)
             ru_minflt: long;           (* page reclaims *)
             ru_majflt: long;           (* page faults *)
             ru_nswap: long;            (* swaps *)
             ru_inblock: long;          (* block input operations *)
             ru_oublock: long;          (* block output operations *)
             ru_msgsnd: long;           (* messages sent *)
             ru_msgrcv: long;           (* messages received *)
             ru_nsignals: long;         (* signals received *)
             ru_nvcsw: long;            (* voluntary context switches *)
             ru_nivcsw: long;           (* involuntary &quot; *) END;
  struct_rusage_star = UNTRACED REF struct_rusage;
</PRE> Resource limits 

<P><PRE>CONST
  RLIMIT_CPU   = 0;		(* cpu time in milliseconds *)
  RLIMIT_FSIZE = 1;		(* maximum file size *)
  RLIMIT_DATA  = 2;		(* data size *)
  RLIMIT_STACK = 3;		(* stack size *)
  RLIMIT_CORE  = 4;		(* core file size *)
  RLIMIT_RSS   = 5;		(* resident set size *)

  RLIM_NLIMITS = 6;		(* number of resource limits *)

  RLIM_INFINITY	= 16_7fffffff;

TYPE
  struct_rlimit = RECORD
	            rlim_cur: int;     (* current (soft) limit *)
 	            rlim_max: int;     (* maximum value for rlim_cur *)
                    END;
</PRE>** getpriority(2), setpriority(2) - get/set program scheduling priority **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE getpriority (which, who: int): int;
&lt;*EXTERNAL*&gt; PROCEDURE setpriority (which, who, prio: int): int;
</PRE>** getrlimit(2), setrlimit(2) - control maximum system resource
                                  consumption **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE getrlimit (resource: int; VAR rlp: struct_rlimit): int;
&lt;*EXTERNAL*&gt; PROCEDURE setrlimit (resource: int; VAR rlp: struct_rlimit): int;
</PRE>** getrusage(2) - get information about resource utilization **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE getrusage (who: int; rus: struct_rusage_star): int;
</PRE>** nice(3) - set program priority **

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE nice (incr: int): int;

END Uresource.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utime is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utime.i3#0TOP0">unix/src/aix-3-2/Utime.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utime.i3#0TOP0">unix/src/aix-ps2-1-2/Utime.i3</A>
<LI><A HREF="../freebsd-1/Utime.i3#0TOP0">unix/src/freebsd-1/Utime.i3</A>
<LI><A HREF="../freebsd-2/Utime.i3#0TOP0">unix/src/freebsd-2/Utime.i3</A>
<LI><A HREF="../hpux-7-0/Utime.i3#0TOP0">unix/src/hpux-7-0/Utime.i3</A>
<LI><A HREF="../ibm-4-3/Utime.i3#0TOP0">unix/src/ibm-4-3/Utime.i3</A>
<LI><A HREF="../irix-5.2/Utime.i3#0TOP0">unix/src/irix-5.2/Utime.i3</A>
<LI><A HREF="../linux/Utime.i3#0TOP0">unix/src/linux/Utime.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utime.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utime.i3</A>
<LI><A HREF="../osf-1.DS3100/Utime.i3#0TOP0">unix/src/osf-1.DS3100/Utime.i3</A>
<LI><A HREF="../solaris-2-x/Utime.i3#0TOP0">unix/src/solaris-2-x/Utime.i3</A>
<LI><A HREF="Utime.i3#0TOP0">unix/src/sunos-4-x/Utime.i3</A>
<LI><A HREF="../sysv-4.0/Utime.i3#0TOP0">unix/src/sysv-4.0/Utime.i3</A>
<LI><A HREF="../ultrix-3-1.generic/Utime.i3#0TOP0">unix/src/ultrix-3-1.generic/Utime.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
