<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/ultrix-3-1.SEQUENT/Ushm.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/ultrix-3-1.SEQUENT/Ushm.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>Ushm</interface>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT short, int, char_star, unsigned_short, void_star;
FROM <A HREF="#x1">Utypes</A> IMPORT time_t, key_t, size_t, swblk_t, pid_t;
FROM <A HREF="#x2">Uipc</A>   IMPORT struct_ipc_perm;
FROM <A HREF="#x3">Udmap</A>  IMPORT struct_dmap_star;
</PRE><BLOCKQUOTE><EM> FROM Uproc  IMPORT struct_proc_star; </EM></BLOCKQUOTE><PRE>
</PRE>** &lt;sys/shm.h&gt; **

<P>
**      IPC Shared Memory Facility.


<P>
**      Implementation Constants.


<P><PRE>CONST
                        (* segment low boundary address multiple *)
                        (* (SMLBA must be a power of 2) *)
  (* SMLBA = ctob(CLSIZE);   where does ctob come from ? - em *)

                        (* for SYSTEM V compatibility           *)
  (* SHMLBA = SMLBA;         see SMLBA - em *)
</PRE><P>
**      Permission Definitions.


<P>  <PRE>SM_R = 8_0400; (* read permission *)
  SM_W = 8_0200;  (* write permission *)

                        (* for SYSTEM V compatibility           *)
  SHM_R = SM_R;
  SHM_W = SM_W;
</PRE><P>
**      ipc_perm Mode Definitions.


<P>  <PRE>SM_CLEAR = 8_01000; (* clear segment on next attach *)
  SM_DEST  = 8_02000; (* destroy seg when # attached = 0 *)

                        (* for SYSTEM V compatibility           *)
  SHM_INIT = SM_CLEAR;
  SHM_DEST = SM_DEST;
</PRE><P>
**      Message Operation Flags.


<P>  <PRE>SM_RDONLY = 8_010000;        (* attach read-only (else read-write) *)
  SM_RND    = 8_020000;        (* round attach address to SHMLBA *)

                        (* for SYSTEM V compatibility           *)
  SHM_RDONLY = SM_RDONLY;
  SHM_RND    = SM_RND;
</PRE><P>
 *  sizing constant (the balance are in /sys/h/param.h and /sys/conf/param.c.
 
  <PRE>SMMNI = 100;        (* Max number SM segments in system *)
</PRE><P>
**      Structure Definitions.


<P>
<P>
**      There is a shared mem id struct for each segment in the system.


<P><PRE>TYPE
  struct_smem = RECORD
                                 (* SM_PERM must be the first               *)
                                 (* element in the structure.               *)
    sm_perm: struct_ipc_perm;    (* permission struct                    (s)*)
    sm_dmap: struct_dmap_star;   (* disk map of shm segment              (p)*)
    sm_ptdaddr: swblk_t;         (* disk address of page table           (p)*)
    sm_size: int;                (* segment size (bytes)                 (p)*)
</PRE> The field sm_caddr is really a struct_proc_star, but
   this require a whole bunch of other interfaces we don't have yet.
   I'll make it void_star for now.  EM. 
    sm_caddr: struct_proc_star;   ptr to linked proc, if loaded        (s)
    <PRE>sm_caddr: void_star;
</PRE>    sm_ptaddr: struct_pte_star;   ptr to assoc page table              (p)
    <PRE>sm_ptaddr: void_star;

    sm_rssize: size_t;           (* SM resource set size (pages)         (s)*)
    sm_lpid: pid_t;              (* pid of last smop                     (.)*)
    sm_cpid: pid_t;              (* pid of creator                       (p)*)
    sm_count: unsigned_short;    (* reference count                      (x)*)
    sm_ccount: unsigned_short;   (* number of loaded references          (s)*)
    sm_lcount: unsigned_short;   (* number of processes locking SMS      (s)*)
    sm_flag: short;              (* traced, written flags        (see below)*)
    sm_poip: short;              (* page out in progress count           (s)*)
    sm_atime: time_t;            (* last smat time                       (u)*)
    sm_dtime: time_t;            (* last smdt time                       (u)*)
    sm_ctime: time_t;            (* last change time                     (u)*)
    END;
  struct_smem_star = UNTRACED REF struct_smem;

  (* sys/shm.h uses a bunch of #define to provide what seems to be
     alternate naming:
	#define shmid_ds        smem
	#define shm_perm        sm_perm
	#define shm_segsz       sm_size
	#define shm_cpid        sm_cpid
	#define shm_lpid        sm_lpid
	#define shm_nattch      sm_count
	#define shm_atime       sm_atime
	#define shm_dtime       sm_dtime
	#define shm_ctime       sm_ctime
     I guess that struct shmid_ds was the old form of that type, which
     when then extended in struct smem; fields that existed in
     struct shmid_ds were given a #define, new fields, did not get one.
     Because we cannot simulate the effect of #define, I suppose it is
     better to provide a struct_shmid_ds with &quot;old&quot; style names only. *)

  struct_shmid_ds = RECORD
                                  (* SM_PERM must be the first               *)
                                  (* element in the structure.               *)
    shm_perm: struct_ipc_perm;    (* permission struct                    (s)*)
    shm_dmap: struct_dmap_star;   (* disk map of shm segment              (p)*)
    shm_ptdaddr: swblk_t;         (* disk address of page table           (p)*)
    shm_size: int;                (* segment size (bytes)                 (p)*)
</PRE><BLOCKQUOTE><EM> same as above </EM></BLOCKQUOTE><PRE>
</PRE>    shm_caddr: struct_proc_star;   ptr to linked proc, if loaded        (s)
    <PRE>shm_caddr: void_star;
</PRE><BLOCKQUOTE><EM>    shm_ptaddr: struct_pte_star;</EM></BLOCKQUOTE><PRE>  (* ptr to assoc page table              (p)*)
    shm_ptaddr: void_star;

    shm_rssize: size_t;           (* SM resource set size (pages)         (s)*)
    shm_lpid: pid_t;              (* pid of last smop                     (.)*)
    shm_cpid: pid_t;              (* pid of creator                       (p)*)
    shm_count: unsigned_short;    (* reference count                      (x)*)
    shm_ccount: unsigned_short;   (* number of loaded references          (s)*)
    shm_lcount: unsigned_short;   (* number of processes locking SMS      (s)*)
    shm_flag: short;              (* traced, written flags        (see below)*)
    shm_poip: short;              (* page out in progress count           (s)*)
    shm_atime: time_t;            (* last smat time                       (u)*)
    shm_dtime: time_t;            (* last smdt time                       (u)*)
    shm_ctime: time_t;            (* last change time                     (u)*)
    END;

  struct_shmid_ds_star = UNTRACED REF struct_shmid_ds;

CONST
</PRE> NOTE:  These values must align with X* flag values in text.h 
  <PRE>SMLOCK =  8_0010;           (* Being swapped in or out *)
  SMWANT =  8_0020;           (* Wanted for swapping *)
  SMNOSW =  8_0100;           (* Lock segment in memory *)
</PRE> shared memory specific commands for shmctl syscall 
  <PRE>SHM_LOCK   = 3;       (* Lock segment in memory *)
  SHM_UNLOCK = 4;       (* Unlock segment in memory *)
</PRE><P>
 * sminfo structure is used by the system for bounds checking.  All of 
 * the elements in this structure are initialized in /sys/conf/param.c.
 *
 * Three of the elements are configurable via the <CODE>config</CODE> program
 * (smmax, smmin, smbrk).  If they are not config'ed, then they all
 * have defaults.
   

<P><PRE>TYPE
  struct_sminfo = RECORD
      smmax: int;       (* max shared memory segment size *)
      smmin: int;       (* min shared memory segment size *)
      smmni: int;       (* # of shared memory identifiers *)
      smseg: int;       (* max attached shared memory segs per proc *)
      smbrk: int;       (* gap (in clicks) used between data and SM *)
      smsmat: int;      (* max shmem attach addr (clicks) *)
    END;

                        (* for SYSTEM V compatibility *)
  struct_shminfo = RECORD
      shmmax: int;       (* max shared memory segment size *)
      shmmin: int;       (* min shared memory segment size *)
      shmmni: int;       (* # of shared memory identifiers *)
      shmseg: int;       (* max attached shared memory segs per proc *)
      shmbrk: int;       (* gap (in clicks) used between data and SM *)
      smsmat: int;       (* max shmem attach addr (clicks) *)
    END;
</PRE>** shmctl(2) - shared memory control operations **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE shmctl (shmid, cmd: int; buf: struct_shmid_ds_star): int;
</PRE>** shmget(2) - get shared memory segment **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE shmget (key: key_t; size, semflg: int): int;
</PRE>** shmat(2), shmdt(2) - shared memory operations **

<P><PRE>&lt;*EXTERNAL*&gt;
PROCEDURE shmat (shmid: int; shmaddr: char_star; shmflg: int): char_star;

&lt;*EXTERNAL*&gt;
PROCEDURE shmdt (shmaddr: char_star): int;

END Ushm.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uipc is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uipc.i3#0TOP0">unix/src/aix-3-2/Uipc.i3</A>
<LI><A HREF="../aix-ps2-1-2/Uipc.i3#0TOP0">unix/src/aix-ps2-1-2/Uipc.i3</A>
<LI><A HREF="../freebsd-1/Uipc.i3#0TOP0">unix/src/freebsd-1/Uipc.i3</A>
<LI><A HREF="../freebsd-2/Uipc.i3#0TOP0">unix/src/freebsd-2/Uipc.i3</A>
<LI><A HREF="../hpux-7-0/Uipc.i3#0TOP0">unix/src/hpux-7-0/Uipc.i3</A>
<LI><A HREF="../ibm-4-3/Uipc.i3#0TOP0">unix/src/ibm-4-3/Uipc.i3</A>
<LI><A HREF="../irix-5.2/Uipc.i3#0TOP0">unix/src/irix-5.2/Uipc.i3</A>
<LI><A HREF="../linux/Uipc.i3#0TOP0">unix/src/linux/Uipc.i3</A>
<LI><A HREF="../osf-1.generic/Uipc.i3#0TOP0">unix/src/osf-1.generic/Uipc.i3</A>
<LI><A HREF="../solaris-2-x/Uipc.i3#0TOP0">unix/src/solaris-2-x/Uipc.i3</A>
<LI><A HREF="../sunos-4-x/Uipc.i3#0TOP0">unix/src/sunos-4-x/Uipc.i3</A>
<LI><A HREF="../sysv-4.0/Uipc.i3#0TOP0">unix/src/sysv-4.0/Uipc.i3</A>
<LI><A HREF="../ultrix-3-1.generic/Uipc.i3#0TOP0">unix/src/ultrix-3-1.generic/Uipc.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Udmap is in:
</A><UL>
<LI><A HREF="../ultrix-3-1.DS3100/Udmap.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Udmap.i3</A>
<LI><A HREF="Udmap.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Udmap.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
