<HTML>
<HEAD>
<TITLE>SRC Modula-3: unix/src/ultrix-3-1.generic/Usocket.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>unix/src/ultrix-3-1.generic/Usocket.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>Usocket</interface>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x1">Utypes</A>, <A HREF="#x2">Uuio</A>;
</PRE>** sys/socket.h **

<P>
 * Definitions related to sockets: types, address families, options.
 

<P>
 * Types
 
<PRE>CONST
  SOCK_STREAM    = 1;            (* stream socket *)
  SOCK_DGRAM     = 2;            (* datagram socket *)
  SOCK_RAW       = 3;            (* raw-protocol interface *)
  SOCK_RDM       = 4;            (* reliably-delivered message *)
  SOCK_SEQPACKET = 5;            (* sequenced packet stream *)
</PRE><P>
 * Option flags per-socket.
 
  <PRE>SO_DEBUG       = 16_01;        (* turn on debugging info recording *)
  SO_ACCEPTCONN  = 16_02;        (* socket has had listen() *)
  SO_REUSEADDR   = 16_04;        (* allow local address reuse *)
  SO_KEEPALIVE   = 16_08;        (* keep connections alive *)
  SO_DONTROUTE   = 16_10;        (* just use interface addresses *)
  SO_BROADCAST   = 16_20;        (* permit sending of broadcast msgs *)
  SO_USELOOPBACK = 16_40;        (* bypass hardware when possible *)
  SO_LINGER      = 16_80;        (* linger on close if data present *)
  SO_OOBINLINE   = 16_100;       (* leave received OOB data in line *)
</PRE><P>
 * Additional options, not kept in so_options.
 
  <PRE>SO_SNDBUF      = 16_1001;       (* send buffer size *)
  SO_RCVBUF      = 16_1002;       (* receive buffer size *)
  SO_SNDLOWAT    = 16_1003;       (* send low-water mark *)
  SO_RCVLOWAT    = 16_1004;       (* receive low-water mark *)
  SO_SNDTIMEO    = 16_1005;       (* send timeout *)
  SO_RCVTIMEO    = 16_1006;       (* receive timeout *)
  SO_ERROR       = 16_1007;       (* get error status and clear *)
  SO_TYPE        = 16_1008;         (* get socket type *)
</PRE><P>
 * Structure used for manipulating linger option.
 
<PRE>TYPE
  struct_linger = RECORD
    l_onoff: Ctypes.int;		(* option on/off *)
    l_linger: Ctypes.int;		(* linger time *)
  END;
</PRE><P>
 * Level number for (get/set)sockopt() to apply to socket itself.
 
<PRE>CONST
  SOL_SOCKET     = 16_ffff;      (* options for socket level *)
</PRE><P>
 * Address families.
 
  <PRE>AF_UNSPEC      = 0;            (* unspecified *)
  AF_UNIX        = 1;            (* local to host (pipes, portals) *)
  AF_INET        = 2;            (* internetwork: UDP, TCP, etc. *)
  AF_IMPLINK     = 3;            (* arpanet imp addresses *)
  AF_PUP         = 4;            (* pup protocols: e.g. BSP *)
  AF_CHAOS       = 5;            (* mit CHAOS protocols *)
  AF_NS          = 6;            (* XEROX NS protocols *)
  AF_NBS         = 7;            (* nbs protocols *)
  AF_ECMA        = 8;            (* european computer manufacturers *)
  AF_DATAKIT     = 9;            (* datakit protocols *)
  AF_CCITT       = 10;           (* CCITT protocols, X.25 etc *)
  AF_SNA         = 11;           (* IBM SNA *)
  AF_DECnet	 = 12;           (* DECnet *)
  AF_DLI	 = 13;           (* Direct data link interface *)
  AF_LAT         = 14;           (* LAT *)
  AF_HYLINK      = 15;           (* NSC Hyperchannel *)
  AF_APPLETALK   = 16;           (* Apple talk *)
  AF_BSC         = 17;           (* BISYNC 2780/3780 *)
  AF_DSS         = 18;           (* Distributed system services *)

  AF_MAX         = 19;
</PRE><P>
 * Structure used by kernel to store most
 * addresses.
 
<PRE>TYPE
  struct_sockaddr = RECORD
    sa_family: Ctypes.unsigned_short;        (* address family *)
    sa_data: ARRAY [0..13] OF Ctypes.char;
                                 (* up to 14 bytes of direct address *)
  END;
</PRE><P>
 * Structure used by kernel to pass protocol
 * information in raw sockets.
 
  <PRE>struct_sockproto = RECORD
    sp_family: Ctypes.unsigned_short;        (* address family *)
    sp_protocol: Ctypes.unsigned_short;      (* protocol *)
  END;
</PRE><P>
 * Protocol families, same as address families for now.
 
<PRE>CONST
  PF_UNSPEC      = AF_UNSPEC;
  PF_UNIX        = AF_UNIX;
  PF_INET        = AF_INET;
  PF_IMPLINK     = AF_IMPLINK;
  PF_PUP         = AF_PUP;
  PF_CHAOS       = AF_CHAOS;
  PF_NS          = AF_NS;
  PF_NBS         = AF_NBS;
  PF_ECMA        = AF_ECMA;
  PF_DATAKIT     = AF_DATAKIT;
  PF_CCITT       = AF_CCITT;
  PF_SNA         = AF_SNA;
  PF_DECnet      = AF_DECnet;
  PF_DLI         = AF_DLI;
  PF_LAT         = AF_LAT;
  PF_HYLINK      = AF_HYLINK;
  PF_APPLETALK   = AF_APPLETALK;
  PF_BSC         = AF_BSC;
  PF_DSS         = AF_DSS;

  PF_MAX	 = AF_MAX;
</PRE><P>
 * Maximum queue length specifiable by listen.
 
  <PRE>SOMAXCONN      = 5;
</PRE><P>
 * Message header for recvmsg and sendmsg calls.
 
<PRE>TYPE
  struct_msghdr = RECORD
    msg_name: Utypes.caddr_t;         (* optional address *)
    msg_namelen: Ctypes.int;          (* size of address *)
    msg_iov: Uuio.struct_iovec_star;  (* scatter/gather array *)
    msg_iovlen: Ctypes.int;           (* # elements in msg_iov *)
    msg_accrights: Utypes.caddr_t;    (* access rights sent/received *)
    msg_accrightslen: Ctypes.int;
  END;

CONST
  MSG_OOB        = 16_1;         (* process out-of-band data *)
  MSG_PEEK       = 16_2;         (* peek at incoming message *)
  MSG_DONTROUTE  = 16_4;         (* send without using routing tables *)

  MSG_MAXIOVLEN  = 16;
</PRE><P>
 * Definitions for UNIX IPC domain.
 
<PRE>TYPE
  struct_sockaddr_un = RECORD
    sun_family: Ctypes.short;         (* AF_UNIX *)
    sun_path: ARRAY [0..107-4] OF Ctypes.char;
                                 (* path name (gag) *)
  END;

&lt;*EXTERNAL*&gt;
PROCEDURE accept(
    s: Ctypes.int;
    addr: UNTRACED REF struct_sockaddr;
    addrlen: Ctypes.int_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE bind(
    s: Ctypes.int;
    name: UNTRACED REF struct_sockaddr;
    namelen: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE connect(
    s: Ctypes.int;
    name: UNTRACED REF struct_sockaddr;
    namelen: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE getpeername(
    s: Ctypes.int;
    name: UNTRACED REF struct_sockaddr;
    namelen: Ctypes.int_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE getsockname(
    s: Ctypes.int;
    name: UNTRACED REF struct_sockaddr;
    namelen: Ctypes.int_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE getsockopt(
    s, level, optname: Ctypes.int;
    optval: Ctypes.char_star;
    optlen: Ctypes.int_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE listen(s, backlog: Ctypes.int): Ctypes.int RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE recv(s: Ctypes.int; buf: Ctypes.char_star; len, flags: Ctypes.int): Ctypes.int RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE recvfrom(
    s: Ctypes.int;
    buf: Ctypes.char_star;
    len, flags: Ctypes.int;
    from: UNTRACED REF struct_sockaddr;
    fromlen: Ctypes.int_star)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE recvmsg(
    s: Ctypes.int;
    msg: UNTRACED REF struct_msghdr;
    flags: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE send(s: Ctypes.int; msg: Ctypes.char_star; len, flags: Ctypes.int): Ctypes.int RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE sendto(
    s: Ctypes.int;
    msg: Ctypes.char_star;
    len, flags: Ctypes.int;
    to: UNTRACED REF struct_sockaddr;
    tolen: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE sendmsg(
    s: Ctypes.int;
    msg: UNTRACED REF struct_msghdr;
    flags: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE setsockopt(
    s, level, optname: Ctypes.int;
    optval: Ctypes.char_star;
    optlen: Ctypes.int)
    : Ctypes.int
    RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE shutdown(s, how: Ctypes.int): Ctypes.int RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE socket(af, type, protocol: Ctypes.int): Ctypes.int RAISES {};

&lt;*EXTERNAL*&gt;
PROCEDURE socketpair(
    d, type, protocol: Ctypes.int;
    sv: UNTRACED REF ARRAY [0..1] OF Ctypes.int)
    : Ctypes.int
    RAISES {};

END Usocket.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface Utypes is in:
</A><UL>
<LI><A HREF="../aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uuio is in:
</A><UL>
<LI><A HREF="../aix-3-2/Uuio.i3#0TOP0">unix/src/aix-3-2/Uuio.i3</A>
<LI><A HREF="../aix-ps2-1-2/Uuio.i3#0TOP0">unix/src/aix-ps2-1-2/Uuio.i3</A>
<LI><A HREF="../freebsd-1/Uuio.i3#0TOP0">unix/src/freebsd-1/Uuio.i3</A>
<LI><A HREF="../freebsd-2/Uuio.i3#0TOP0">unix/src/freebsd-2/Uuio.i3</A>
<LI><A HREF="../hpux-7-0/Uuio.i3#0TOP0">unix/src/hpux-7-0/Uuio.i3</A>
<LI><A HREF="../ibm-4-3/Uuio.i3#0TOP0">unix/src/ibm-4-3/Uuio.i3</A>
<LI><A HREF="../irix-5.2/Uuio.i3#0TOP0">unix/src/irix-5.2/Uuio.i3</A>
<LI><A HREF="../linux/Uuio.i3#0TOP0">unix/src/linux/Uuio.i3</A>
<LI><A HREF="../osf-1.generic/Uuio.i3#0TOP0">unix/src/osf-1.generic/Uuio.i3</A>
<LI><A HREF="../solaris-2-x/Uuio.i3#0TOP0">unix/src/solaris-2-x/Uuio.i3</A>
<LI><A HREF="../sunos-4-x/Uuio.i3#0TOP0">unix/src/sunos-4-x/Uuio.i3</A>
<LI><A HREF="../sysv-4.0/Uuio.i3#0TOP0">unix/src/sysv-4.0/Uuio.i3</A>
<LI><A HREF="Uuio.i3#0TOP0">unix/src/ultrix-3-1.generic/Uuio.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
