<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/AnyEvent.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/AnyEvent.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> An <CODE>AnyEvent.T</CODE> is an object that can hold any of the Trestle
   event-time events.  This object type is useful for <CODE>VBT</CODE>
   methods that are called in response to multiple styles of user
   gestures.  For instance, the <CODE>callback</CODE> method of a
   <CODE>NumericVBT</CODE> is invoked either because a user clicked on the
   plus or minus button or because the user typed a carriage
   return in the type-in field.  The Trestle event is passed to the
   <CODE>callback</CODE> method as an <CODE>AnyEvent.T</CODE>, and the <CODE>callback</CODE>
   method can then use a <CODE>TYPECASE</CODE> to differentiate button clicks
   from carriage returns, and to retrieve the data specific to
   each type of event. 
<P>
   The locking level is arbitrary for all procedures in this interface. 

<P><PRE>INTERFACE <interface><A HREF="AnyEvent.m3">AnyEvent</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  T = BRANDED OBJECT END;
  Key = T OBJECT key: VBT.KeyRec END;
  Mouse = T OBJECT mouse: VBT.MouseRec END;
  Position = T OBJECT position: VBT.PositionRec END;
  Misc = T OBJECT misc: VBT.MiscRec END;
</PRE><BLOCKQUOTE><EM> The four subtypes of <CODE>AnyEvent.T</CODE> correspond to the four
   event-time Trestle events: keyboard, mouse, position, and
   miscellaneous. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnyEvent.m3#FromKey">FromKey</A> (
            READONLY event: VBT.KeyRec): Key;
PROCEDURE <A HREF="AnyEvent.m3#FromMouse">FromMouse</A> (
            READONLY event: VBT.MouseRec): Mouse;
PROCEDURE <A HREF="AnyEvent.m3#FromPosition">FromPosition</A> (
            READONLY event: VBT.PositionRec): Position;
PROCEDURE <A HREF="AnyEvent.m3#FromMisc">FromMisc</A> (
            READONLY event: VBT.MiscRec): Misc;
</PRE><BLOCKQUOTE><EM> Return <CODE>event</CODE> as an appropriate subtype of <CODE>AnyEvent.T</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnyEvent.m3#TimeStamp">TimeStamp</A> (anyevent: T): VBT.TimeStamp;
</PRE><BLOCKQUOTE><EM> Return the timestamp of the <CODE>anyevent</CODE>.  It is a checked
   runtime error if <CODE>anyevent</CODE> is not a proper subtype of <CODE>AnyEvent.T</CODE>. </EM></BLOCKQUOTE><PRE>

END AnyEvent.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
