<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/AutoRepeat.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/AutoRepeat.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                          </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>AutoRepeat</CODE> interface provides support for calling a procedure
   repetitively.  Auto-repeating typically takes place while a key or
   mouse button is held down, although there is no direct relation
   between <CODE>AutoRepeat</CODE> and <CODE>VBT</CODE>s.
<P>
   When an auto-repeat object <CODE>ar</CODE> is activated, it forks a {\it timer
   thread\/} that calls <CODE>ar.repeat()</CODE> after <CODE>firstWait</CODE> milliseconds,
   and every <CODE>period</CODE> milliseconds thereafter.  However, there is a
   flow-control mechanism: if the call to <CODE>ar.repeat()</CODE> has not
   returned by the time the next repetition is scheduled to take
   place, the timer thread will wait.  That is, repetitions cannot
   queue up more than one deep.
<P>
   An auto-repeat object <CODE>ar</CODE> is activated by a call to <CODE>Start(ar)</CODE>,
   terminated by a call to <CODE>Stop(ar)</CODE>, and resumed by a call to
   <CODE>Continue(ar)</CODE>.
<P>
   All locking is handled within <CODE>AutoRepeat</CODE>; calls to <CODE>Start(ar)</CODE>,
   <CODE>Stop(ar)</CODE>, and <CODE>Continue(ar)</CODE> are serialized on a per-<CODE>ar</CODE> basis.
   These procedures may be called by a <CODE>repeat</CODE> method.  Clients must
   not call the <CODE>repeat</CODE> method directly; it is called by the timer
   thread subject to client-calls to <CODE>Start</CODE>, <CODE>Stop</CODE>, and <CODE>Continue</CODE>.
   The <CODE>AutoRepeat</CODE> interface will never call a <CODE>repeat</CODE> method
   re-entrantly. 

<P><PRE>INTERFACE <interface><A HREF="AutoRepeat.m3">AutoRepeat</A></interface>;

TYPE
  Milliseconds = CARDINAL;

CONST
  DefaultFirstWait: Milliseconds = 500;
  DefaultPeriod   : Milliseconds = 66;

TYPE
  <A HREF="AutoRepeat.m3#T">T</A> &lt;: Public;
  Public =
    Private OBJECT
    METHODS
      init (firstWait: Milliseconds := DefaultFirstWait;
            period   : Milliseconds := DefaultPeriod): T;
      repeat ();
      canRepeat(): BOOLEAN;
    END;
  <A HREF="AutoRepeat.m3#Private">Private</A> &lt;: ROOT;
</PRE> The call <CODE>ar.init(firstWait, period)</CODE> initializes <CODE>ar</CODE> as an
   <CODE>AutoRepeat.T</CODE>, and it returns <CODE>ar</CODE>.  The <CODE>firstWait</CODE> and
   <CODE>period</CODE> parameters are stored internally for use by the
   <CODE>Start</CODE> and <CODE>Continue</CODE> procedures.
<P>
   The call <CODE>ar.canRepeat</CODE> should return <CODE>FALSE</CODE> whenever there's
   reason to suspect that a client might want to call <CODE>Stop</CODE> in
   the near future.  The next call to <CODE>ar.repeat</CODE> will be
   suspended for <CODE>period</CODE> milliseconds.  The default for
   this method always returns <CODE>TRUE</CODE>.
<P>
   The <CODE>canRepeat</CODE> method is intended for situations when a
   <CODE>repeat</CODE> method takes more time than <CODE>period</CODE>
   milliseconds to complete.  The problem with slow <CODE>repeat</CODE>
   methods is that the scheduler might decide to always run the
   timer thread (since it will want to call the <CODE>repeat</CODE> method
   as soon as the slow <CODE>repeat</CODE> method completes), thereby
   blocking another thread from being able to call <CODE>Stop</CODE>.
<P>
   The default <CODE>repeat</CODE> method is a no-op. 

<P><PRE>PROCEDURE <A HREF="AutoRepeat.m3#Start">Start</A> (ar: T);
</PRE><BLOCKQUOTE><EM> Initiate auto-repeating for <CODE>ar</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Start(ar)</CODE> forks a timer thread that will wait <CODE>ar.firstWait</CODE>
   milliseconds before calling <CODE>ar.repeat()</CODE> the first time, then
   <CODE>ar.period</CODE> milliseconds between subsequent calls to <CODE>ar.repeat()</CODE>.
   This procedure is a no-op if <CODE>ar</CODE> is already running. 

<P><PRE>PROCEDURE <A HREF="AutoRepeat.m3#Stop">Stop</A> (ar: T);
</PRE><BLOCKQUOTE><EM> Stop auto-repeating as soon as possible. </EM></BLOCKQUOTE><PRE>
</PRE> After calling <CODE>Stop(ar)</CODE>, the implementation will not call
   <CODE>ar.repeat()</CODE> again until a call to <CODE>Start(ar)</CODE> or <CODE>Continue(ar)</CODE>
   restarts auto-repeating.  This procedure is a no-op if <CODE>ar</CODE> is not
   already running.
<P>
   It is possible (but unlikely) that <CODE>ar.repeat()</CODE> is called one more
   time after a call to <CODE>Stop(ar)</CODE> returns.  This can happen because
   calls to <CODE>ar.repeat</CODE> are not serialized with respect to the call to
   <CODE>Stop(ar)</CODE>.  They are not serialized in order to allow a <CODE>repeat</CODE>
   method to call <CODE>Stop</CODE>. 

<P><PRE>PROCEDURE <A HREF="AutoRepeat.m3#Continue">Continue</A> (ar: T);
</PRE><BLOCKQUOTE><EM> Resume auto-repeating immediately. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Continue(ar)</CODE> is like <CODE>Start(ar)</CODE>, except rather than waiting
   <CODE>ar.firstWait</CODE> milliseconds as in the call to <CODE>Start(ar)</CODE>, the
   timer thread calls <CODE>ar.repeat</CODE> without waiting at all.  Subsequent
   calls to <CODE>ar.repeat()</CODE> happen every <CODE>period</CODE> milliseconds, as
   usual.  This procedure is a no-op if <CODE>ar</CODE> is already running. 

<P><PRE>END AutoRepeat.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
