<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/AutoRepeat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/AutoRepeat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL                                                                 *&gt;

MODULE <module><implements><A HREF="AutoRepeat.i3">AutoRepeat</A></implements></module>;

IMPORT <A HREF="../../time/src/Common/Time.i3">Time</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
</PRE> This code needs an overhaul.  It could be simplified to take
   advantage of two features of the current interface:
<P>
   1) The repeat method can be called by the timer thread rather
   than from a thread forked by the timer thread. 
<P>
   2) The Start and Continue are no-ops if ar is already running.
   (The code was written when Start and Continue tried to change
   the timing of the existing timer thread.)
<P>
   

<P><PRE>REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        timerMutex    : MUTEX;
        timerCondition: Thread.Condition;
        repeater      : RepeatClosure      := NIL;
        &lt;* LL = timerMutex *&gt;
        timerWait, firstWait, period: Time.T;
        (* current wait, initial wait, next wait *)
        timer: Thread.T := NIL;  (* auto-repeat timer thread *)
        timerSet, doRepeat, repeating := FALSE;
        (* running?, time to repeat?, repeater forked? *)
      OVERRIDES
        init      := Init;
        canRepeat := CanRepeat;
        apply     := Timer;
        repeat    := Repeat
      END;

REVEAL <A NAME="Private">Private</A> = Thread.Closure BRANDED OBJECT END;

TYPE
  RepeatClosure =
    Thread.Closure OBJECT cl: T OVERRIDES apply := Repeater END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (cl       : T;
                firstWait: Milliseconds := DefaultFirstWait;
                period   : Milliseconds := DefaultPeriod     ): T =
  BEGIN
    cl.timerMutex := NEW (MUTEX);
    cl.timerCondition := NEW (Thread.Condition);
    cl.repeater := NEW (RepeatClosure, cl := cl);
    LOCK cl.timerMutex DO
       (* milliseconds -&gt; seconds *)
      cl.firstWait := FLOAT (firstWait, Time.T) / 1.0D3;
      cl.period := FLOAT (period, Time.T) / 1.0D3;
    END;
    RETURN cl
  END Init;

PROCEDURE <A NAME="CanRepeat"><procedure>CanRepeat</procedure></A>(&lt;* UNUSED *&gt; cl: T): BOOLEAN =
  BEGIN RETURN TRUE END CanRepeat;

PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> (cl: T) =
  BEGIN
    LOCK cl.timerMutex DO
      IF cl.timerSet THEN RETURN END;
      cl.timerWait := cl.firstWait;
      ContinueWithTimerLocked(cl)
    END
  END Start;

PROCEDURE <A NAME="Stop"><procedure>Stop</procedure></A> (cl: T) =
  BEGIN
    LOCK cl.timerMutex DO cl.timerSet := FALSE END
  END Stop;

PROCEDURE <A NAME="Continue"><procedure>Continue</procedure></A> (cl: T) =
  BEGIN
    LOCK cl.timerMutex DO
      IF cl.timerSet THEN RETURN END;
      cl.timerWait := 0.0D0;
      ContinueWithTimerLocked(cl);
    END
  END Continue;

PROCEDURE <A NAME="ContinueWithTimerLocked"><procedure>ContinueWithTimerLocked</procedure></A> (cl: T) =
  BEGIN
    cl.timerSet := TRUE;
    IF cl.timer = NIL THEN
      cl.timer := Thread.Fork(cl)
    ELSE
      Thread.Alert(cl.timer)
    END
  END ContinueWithTimerLocked;

PROCEDURE <A NAME="Timer"><procedure>Timer</procedure></A> (cl: T): REFANY =
  VAR
    wait: Time.T;
    set : BOOLEAN;
  BEGIN
    LOOP
      TRY
        LOCK cl.timerMutex DO
          wait := cl.timerWait;
          set := cl.timerSet;
          cl.timerWait := cl.period
        END;
        IF set THEN
          IF wait # 0.0D0 THEN Thread.AlertPause (wait) END
        ELSE
          Thread.AlertPause (10.0D0);
          (* kill thread if unused for 10 sec. *)
          LOCK cl.timerMutex DO
            IF NOT cl.timerSet THEN
              cl.timer := NIL;
              Thread.Signal (cl.timerCondition);
              RETURN NIL
            END
          END
        END;
        IF cl.canRepeat () THEN
          LOCK cl.timerMutex DO
            IF cl.timerSet THEN
              WHILE cl.doRepeat DO
                Thread.AlertWait (cl.timerMutex, cl.timerCondition)
              END;
              IF NOT cl.repeating THEN
                EVAL Thread.Fork (cl.repeater);
                cl.repeating := TRUE
              END;
              cl.doRepeat := TRUE;
              Thread.Signal (cl.timerCondition)
            END
          END
        END
      EXCEPT
      | Thread.Alerted =&gt;        (* good, the wait was broken *)
      END
    END
  END Timer;

PROCEDURE <A NAME="Repeater"><procedure>Repeater</procedure></A> (rcl: RepeatClosure): REFANY =
  &lt;* LL = {} *&gt;
  VAR cl: T := rcl.cl;
  BEGIN
    LOOP
      LOCK cl.timerMutex DO
        WHILE cl.timer # NIL AND NOT cl.doRepeat DO
          Thread.Wait (cl.timerMutex, cl.timerCondition)
        END;
        IF cl.timer = NIL THEN
          cl.doRepeat := FALSE;
          cl.repeating := FALSE;
          RETURN NIL
        END;
        cl.doRepeat := FALSE
      END;
      Thread.Signal (cl.timerCondition);
      cl.repeat ()
    END;
  END Repeater;

PROCEDURE <A NAME="Repeat"><procedure>Repeat</procedure></A> (&lt;* UNUSED *&gt; cl: T) =
  BEGIN
  END Repeat;

BEGIN
END AutoRepeat.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
