<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/Pts.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/Pts.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>Pts</CODE> interface contains utilities to convert between points
   and pixels.  VBTkit uses 72 points per inch and 25.4 millimeters
   per inch.
<P>
   The locking level is arbitrary for all procedures in this interface. 

<P><PRE>INTERFACE <interface><A HREF="Pts.m3">Pts</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

PROCEDURE <A HREF="Pts.m3#ToScreenPixels">ToScreenPixels</A> (v: VBT.T; pts: REAL; ax: Axis.T):
  INTEGER;
</PRE><BLOCKQUOTE><EM> Return the number of screen pixels that correspond to <CODE>pts</CODE>
   points on <CODE>v</CODE>'s screentype in the axis <CODE>ax</CODE>; or return <CODE>0</CODE> if
   <CODE>v</CODE>'s screentype is <CODE>NIL</CODE>.  Equivalent to <CODE>ROUND (ToPixels (v, pts, ax))</CODE>
  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Pts.m3#ToPixels">ToPixels</A> (v: VBT.T; pts: REAL; ax: Axis.T): REAL;
</PRE><BLOCKQUOTE><EM> Return the number of pixels that correspond to <CODE>pts</CODE> points on
   <CODE>v</CODE>'s screentype in the axis <CODE>ax</CODE>; or return <CODE>0</CODE> if <CODE>v</CODE>'s
   screentype is <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Pts.m3#FromPixels">FromPixels</A> (v: VBT.T; pixels: REAL; ax: Axis.T): REAL;
</PRE><BLOCKQUOTE><EM> Return the number of points that correspond to <CODE>pixels</CODE>
   pixels on <CODE>v</CODE>'s screentype in the axis <CODE>ax</CODE>; or return <CODE>0</CODE> if
   <CODE>v</CODE>'s screentype is <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

CONST
  PtsPerInch = 72.0;
  MMPerInch  = 25.4;

PROCEDURE <A HREF="Pts.m3#FromMM">FromMM</A> (mm: REAL): REAL;
</PRE><BLOCKQUOTE><EM> Convert from millimeters to points. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Pts.m3#ToMM">ToMM</A> (pts: REAL): REAL;
</PRE><BLOCKQUOTE><EM> Convert from points to millimeters. </EM></BLOCKQUOTE><PRE>

END Pts.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
