<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/Pts.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/Pts.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Pts.i3">Pts</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

PROCEDURE <A NAME="ToScreenPixels"><procedure>ToScreenPixels</procedure></A> (v: VBT.T; pts: REAL; ax: Axis.T): INTEGER =
  VAR st := VBT.ScreenTypeOf(v);
  BEGIN
    IF st = NIL THEN
      RETURN 0
    ELSE
      RETURN ROUND(pts * MMPerInch * st.res[ax] / PtsPerInch)
    END
  END ToScreenPixels;

PROCEDURE <A NAME="ToPixels"><procedure>ToPixels</procedure></A> (v: VBT.T; pts: REAL; ax: Axis.T): REAL  =
  VAR st := VBT.ScreenTypeOf(v);
  BEGIN
    IF st = NIL THEN
      RETURN 0.0
    ELSE
      RETURN pts * MMPerInch * st.res[ax] / PtsPerInch
    END
  END ToPixels;

PROCEDURE <A NAME="FromPixels"><procedure>FromPixels</procedure></A> (v: VBT.T; pixels: REAL; ax: Axis.T): REAL  =
  VAR st := VBT.ScreenTypeOf(v);
  BEGIN
    IF st = NIL THEN
      RETURN 0.0
    ELSE
      RETURN pixels * PtsPerInch / (MMPerInch * st.res[ax])
    END
  END FromPixels;

PROCEDURE <A NAME="FromMM"><procedure>FromMM</procedure></A> (mm: REAL): REAL =
  BEGIN
    RETURN mm * PtsPerInch / MMPerInch;
  END FromMM;

PROCEDURE <A NAME="ToMM"><procedure>ToMM</procedure></A> (pts: REAL): REAL =
  BEGIN
    RETURN pts * MMPerInch / PtsPerInch
  END ToMM;

BEGIN
END Pts.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
