<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/Rsrc.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/Rsrc.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> {\em Resources\/} are arbitrary texts that are associated with
   applications.  Resources can be bundled into an application
   using the <CODE>m3bundle</CODE> facility.  They may also be found in the
   file system.
<P>
   This interface supports retrieval of resources using a {\em search
   path}.  A search path is a list of elements; each element is either
   a <CODE>Pathname.T</CODE> that refers to a directory, or a <CODE>Bundle.T</CODE>,
   typically created by <CODE>m3bundle</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="Rsrc.m3">Rsrc</A></interface>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE Path = RefList.T; (* of Pathname.T or Bundle.T *)

EXCEPTION NotFound;

PROCEDURE <A HREF="Rsrc.m3#Open">Open</A> (name: TEXT; path: Path): Rd.T
  RAISES {NotFound};
</PRE><BLOCKQUOTE><EM> If <CODE>name</CODE> is an absolute pathname, then look for <CODE>name</CODE> in the
   file system: A reader is returned if
<PRE>
      FileRd.Open(name)
   </PRE>
is successeful; otherwise an exception is raised.  If <CODE>name</CODE>
   is not an absolute pathname, then search each element of
   <CODE>path</CODE>, from front to back, for the first occurrence of the
   resource called <CODE>name</CODE> and return a reader on the resource.
   If the path element is a pathname <CODE>p</CODE>, then a reader is
   returned if
<PRE>
      FileRd.Open(Pathname.Join (p, name, NIL))
   </PRE>
is successful.  If the path element is a bundle <CODE>b</CODE>, a reader
   is returned if
<PRE>
      TextRd.New(Bundle.Get(b, name))
   </PRE>
is successful.  The <CODE>NotFound</CODE> exception is raised if no
   element of <CODE>path</CODE> yields a successful reader on <CODE>name</CODE>.  It is
   a checked runtime error if <CODE>path</CODE> contains an element that is
   neither a pathname nor a bundle. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Rsrc.m3#Get">Get</A> (name: TEXT; path: Path): TEXT
  RAISES {NotFound, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> A convenience procedure to retrieve the contents of the
   resource <CODE>name</CODE> as a <CODE>TEXT</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The procedure <CODE>Get</CODE> is logically equivalent to
<PRE>
       VAR rd := Open(name, path);
       BEGIN
         TRY
           RETURN Rd.GetText(rd, LAST(CARDINAL))
         FINALLY
           Rd.Close(rd)
         END
       END;
   </PRE>
The implementation is slightly more efficient, because it
   takes advantage of <CODE>Bundle.Get</CODE> procedure which returns the
   contents of the bundle element as a <CODE>TEXT</CODE>.  The <CODE>Rd.Failure</CODE>
   exception is raised if <CODE>Rd.GetText</CODE> or <CODE>Rd.Close</CODE> report a
   problem.  The <CODE>Thread.Alerted</CODE> can be raised by the call to
   <CODE>Rd.GetText</CODE>. 

<P><PRE>PROCEDURE <A HREF="Rsrc.m3#BuildPath">BuildPath</A> (a1, a2, a3, a4: REFANY := NIL): Path;
</PRE><BLOCKQUOTE><EM> Build a <CODE>Path</CODE> from the non-<CODE>NIL</CODE> elements. Each element must be
   either a <CODE>Bundle.T</CODE> or a <CODE>TEXT</CODE>.  If it is a <CODE>TEXT</CODE>, is assumed to
   be the pathname of a directory, unless it starts with a dollar
   sign, in which case it is assumed to be environment variable whose
   value is the name of a directory; the value is retrieved using
   <CODE>Env.Get</CODE>. It is a checked runtime error of the pathname is not
   valid. </EM></BLOCKQUOTE><PRE>

END Rsrc.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
