<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/Rsrc.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/Rsrc.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Rsrc.i3">Rsrc</A></implements></module>;

IMPORT <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../params/src/Env.i3">Env</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="Open"><procedure>Open</procedure></A> (name: TEXT; p: Path): Rd.T RAISES {NotFound} =
  BEGIN
    IF Pathname.Absolute(name) THEN
      IF Pathname.Valid(name) THEN
        TRY RETURN FileRd.Open(name) EXCEPT OSError.E =&gt; END
      END;
      RAISE NotFound
    END;
    WHILE p # NIL DO
      TYPECASE p.head OF
      | NULL =&gt;                  &lt;* ASSERT FALSE *&gt;
      | Pathname.T (pn) =&gt;
          TRY
            RETURN FileRd.Open(Pathname.Join(pn, name, NIL))
          EXCEPT
          | OSError.E =&gt;
          END
      | Bundle.T (b) =&gt;
          WITH t = Bundle.Get(b, name) DO
            IF t # NIL THEN RETURN TextRd.New(t) END
          END
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END;
      p := p.tail;
    END;
    RAISE NotFound
  END Open;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (name: TEXT; p: Path): TEXT
  RAISES {NotFound, Rd.Failure, Thread.Alerted} =
  BEGIN
    WHILE p # NIL DO
      TYPECASE p.head OF
      | NULL =&gt;                  &lt;* ASSERT FALSE *&gt;
      | Pathname.T (pn) =&gt;
          VAR rd: Rd.T := NIL;
          BEGIN
            TRY
              rd := FileRd.Open (Pathname.Join (pn, name, NIL))
            EXCEPT
            | OSError.E =&gt;
            END;
            IF rd # NIL THEN
              TRY
                RETURN Rd.GetText (rd, LAST (CARDINAL))
              FINALLY
                Rd.Close (rd)
              END
            END
          END
      | Bundle.T (b) =&gt;
          WITH t = Bundle.Get (b, name) DO IF t # NIL THEN RETURN t END END
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END;
      p := p.tail
    END;
    RAISE NotFound
  END Get;

PROCEDURE <A NAME="BuildPath"><procedure>BuildPath</procedure></A> (a1, a2, a3, a4: REFANY := NIL): Path =
  BEGIN
    RETURN RefList.AppendD (
             Convert (a1),
             RefList.AppendD (
               Convert (a2), RefList.AppendD (Convert (a3), Convert (a4))))
  END BuildPath;

PROCEDURE <A NAME="Convert"><procedure>Convert</procedure></A> (a: REFANY): Path =
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN NIL
    | Bundle.T (b) =&gt; RETURN RefList.List1 (b)
    | TEXT (t) =&gt; RETURN ExpandPath (t)
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END
  END Convert;

PROCEDURE <A NAME="ExpandPath"><procedure>ExpandPath</procedure></A> (path: TEXT): RefList.T =
  BEGIN
    IF NOT Text.Empty (path) AND Text.GetChar (path, 0) = '$' THEN
      path := Env.Get (Text.Sub (path, 1, LAST (CARDINAL)))
    END;
    IF path = NIL OR Text.Empty (path) THEN
      RETURN NIL
    ELSIF Pathname.Valid (path) THEN
      RETURN RefList.List1 (path)
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END
  END ExpandPath;

BEGIN
END Rsrc.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
