<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/XParam.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/XParam.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                         </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>XParam</CODE> interface provides utilities for handling X-style
   <CODE>-display</CODE> and <CODE>-geometry</CODE> command-line arguments.  If your
   application installs a single top-level window, the <CODE>XTrestle</CODE>
   interface may be more appropriate than this interface. 

<P><PRE>INTERFACE <interface><A HREF="XParam.m3">XParam</A></interface>;

IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>;
</PRE> Here are routines for manipulating the <CODE>-display</CODE> argument: 

<P><PRE>TYPE
  Display = RECORD
              hostname: TEXT     := &quot;&quot;;
              display : CARDINAL := 0;
              screen  : CARDINAL := 0;
              DECnet  : BOOLEAN  := FALSE
            END;

PROCEDURE <A HREF="XParam.m3#ParseDisplay">ParseDisplay</A> (spec: TEXT): Display RAISES {Error};
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return a parsed version of the <CODE>-display</CODE> argument in <CODE>spec</CODE>.</EM></BLOCKQUOTE><PRE>
</PRE> For example, if <CODE>spec</CODE> contains the string
   <CODE>myrtle.pa.dec.com:0.2</CODE>, the record returned would be
<PRE>
        Display{hostname := &quot;myrtle.pa.dec.com&quot;,
                display := 0, screen := 2, DECnet := FALSE}
   

<P><PRE>PROCEDURE <A HREF="XParam.m3#UnparseDisplay">UnparseDisplay</A> (READONLY d: Display): TEXT;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return the text-version of the <CODE>-display</CODE> argument <CODE>d</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Here are routines for manipulating the <CODE>-geometry</CODE> argument: 

<P><PRE>CONST Missing = Point.T{-1, -1};

TYPE
  Geometry =
    RECORD
      vertex := Rect.Vertex.NW;  (* corner for displacement *)
      dp     := Point.Origin;    (* displacement *)
      size   := Missing;         (* width, height *)
    END;

PROCEDURE <A HREF="XParam.m3#ParseGeometry">ParseGeometry</A> (spec: TEXT): Geometry RAISES {Error};
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return a parsed version of the <CODE>-geometry</CODE> argument in <CODE>spec</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> For example, if <CODE>spec</CODE> contains the string
   <CODE>1024x800-0-10</CODE>, the returned record would be
<PRE>
          Geometry {Rect.Vertex.SE,
                    Point.T {0, 10},
                    Point.T {1024, 800}}
   </PRE>
The <CODE>size</CODE> field defaults to <CODE>Missing</CODE>.  The horizontal and
   vertical displacements default to <CODE>Point.Origin</CODE> (no
   displacement).  The displacements are always positive values;
   use the <CODE>vertex</CODE> field to find out from which corner they are
   to be offset. 

<P><PRE>PROCEDURE <A HREF="XParam.m3#UnparseGeometry">UnparseGeometry</A> (READONLY g: Geometry): TEXT;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return the text-version of the <CODE>-geometry</CODE> argument <CODE>g</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="XParam.m3#Position">Position</A> (         trsl: Trestle.T;
                             id  : Trestle.ScreenID;
                    READONLY g   : Geometry          ): Point.T
  RAISES {TrestleComm.Failure};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the position specified by <CODE>g</CODE> in the screen coordinates
   for the screenID <CODE>id</CODE> on the window system connected to <CODE>trsl</CODE>
   (cf.  <CODE>Trestle.GetScreens</CODE>).  The value of <CODE>g.size</CODE> must not
   be <CODE>Missing</CODE>, unless <CODE>g.vertex</CODE> is the northwest corner. </EM></BLOCKQUOTE><PRE>
</PRE> Here is the definition of the <CODE>Error</CODE> exception: 

<P><PRE>TYPE
  Info = OBJECT
           spec : TEXT;
           index: CARDINAL
         END;
  GeometryInfo = Info BRANDED OBJECT END;
  DisplayInfo  = Info BRANDED OBJECT END;

EXCEPTION Error(Info);
</PRE><BLOCKQUOTE><EM> Parsing errors are reported with the text (<CODE>spec</CODE>) and
   position (<CODE>index</CODE>) of the first illegal character in the
   text. </EM></BLOCKQUOTE><PRE>

END XParam.
</PRE> \subsubsection{An example}
<P>
   Here is an example of how to use this interface to install a VBT
   <CODE>v</CODE> as a top level window, obeying the display and geometry
   arguments given to the application. It relies on the <CODE>Params</CODE>
   interface, which provides the number of arguments passed to the
   program, <CODE>Params.Count</CODE>, and a procedure to retrieve the value of
   the <CODE>n</CODE>th argument, <CODE>Params.Get(n)</CODE>.
<P>
<PRE>
       EXCEPTION Error (TEXT);
       VAR
         display, geometry: TEXT := NIL;
         d: XParam.DisplayRec;
         g: XParam.Geometry;
         i: CARDINAL := 1;
       BEGIN
         LOOP
           IF i &gt;= Params.Count - 1 THEN EXIT END;
           WITH argument = Params.Get (i) DO
             IF Text.Equal (argument, &quot;-display&quot;) THEN
               display := Params.Get (i + 1);
               TRY d := XParam.ParseDisplay (display)
               EXCEPT XParam.Error (info) =&gt;
                 RAISE Error (&quot;Illegal -display argument: &quot;
                               &amp; info.spec)
               END;
               INC (i, 2)
             ELSIF Text.Equal (argument, &quot;-geometry&quot;) THEN
               geometry := Params.Get (i + 1);
               TRY
                 g := XParam.ParseGeometry (geometry);
                 IF g.size = XParam.Missing THEN
                   WITH shapes = VBTClass.GetShapes (v, FALSE) DO
                     g.size.h := shapes [Axis.T.Hor].pref;
                     g.size.v := shapes [Axis.T.Ver].pref
                   END
                 END
               EXCEPT XParam.Error (info) =&gt;
                 RAISE Error (&quot;Illegal -geometry argument: &quot;
                               &amp; info.spec);
               END;
               INC (i, 2)
             ELSE INC (i)
             END          (* IF 

<PRE>|      END            (* WITH *)
|    END;             (* LOOP *)

   At this point, if &quot;display&quot; is non-&quot;NIL&quot;, then &quot;d&quot; contains the
   information from the &quot;-display&quot; argument.  Similarly, if &quot;geometry&quot;
   is non-&quot;NIL&quot;, then &quot;g&quot; contains the information from the
   &quot;-geometry&quot; argument.  If the window-size specificiation was
   missing, the preferred shape of the window is used.

   Finally, we now process the &quot;display&quot; and &quot;geometry&quot; information:

|    VAR
|      trsl := Trestle.Connect (display);
|      screen: CARDINAL;
|    BEGIN
|      TrestleImpl.SetDefault (trsl);
|      Trestle.Attach (v, trsl);
|      Trestle.Decorate (v, ...);
|      IF geometry = NIL THEN
|        Trestle.MoveNear (v, NIL)
|      ELSE
|        StableVBT.SetShape (v, g.size.h, g.size.v)
|        IF d = NIL THEN
|          screen := Trestle.ScreenOf (v, Point.Origin).id
|        ELSE
|          screen := d.screen
|        END;
|        Trestle.Overlap (
|          v, screen, XParam.Position(trsl, screen, g))
|      END      (* IF *)
|    END        (* BEGIN *)
|  END;         (* BEGIN *)

   The call to &quot;TrestleImpl.SetDefault&quot; establishes the value of the
   &quot;-display&quot; argument as the default Trestle connection.  The call to
   &quot;StableVBT.SetShape&quot; is used to control the size of a top-level
   window. The &quot;TrestleImpl&quot; and &quot;StableVBT&quot; interfaces are part of
   Trestle.*)
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
