<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/XParam.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/XParam.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="XParam.i3">XParam</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>;

PROCEDURE <A NAME="ParseDisplay"><procedure>ParseDisplay</procedure></A> (t: TEXT): Display RAISES {Error} =
  VAR
    n                           := Text.Length (t);
    i, start: CARDINAL          := 0;
    z       : Display;
    buf     : REF ARRAY OF CHAR;
  PROCEDURE Err (spec: TEXT; index: CARDINAL) RAISES {Error} =
    BEGIN
      RAISE Error (NEW (DisplayInfo, spec := spec, index := index))
    END Err;
  PROCEDURE scan () RAISES {Error} =
    BEGIN
      IF n = 0 THEN Err (t, 0) END;
      buf := NEW (REF ARRAY OF CHAR, n);
      Text.SetChars (buf^, t);
      WHILE buf [i] # ':' DO INC (i); IF i = n THEN Err (t, 0) END END;
      IF i = n THEN Err (t, 0) END;
      (* IF buf [i] # ':' THEN Err (t, i) END; *)
      IF i # 0 THEN
        z.hostname := Text.FromChars (SUBARRAY (buf^, 0, i))
      END;
      INC (i);
      IF i = n THEN Err (t, i - 1) END;
      IF buf [i] = ':' THEN
        z.DECnet := TRUE;
        INC (i);
        IF i = n THEN Err (t, i - 1) END
      END;
      start := i;
      z.display := num (i, n, buf);
      IF i = start THEN Err (t, start) END;
      IF i = n THEN RETURN END;
      IF buf [i] # '.' THEN Err (t, i) END;
      INC (i);
      IF i = n THEN Err (t, i - 1) END;
      start := i;
      z.screen := num (i, n, buf);
      IF i = start THEN Err (t, start) END;
      IF i # n THEN Err (t, i) END;
    END scan;
  BEGIN
    scan ();
    RETURN z
  END ParseDisplay;

PROCEDURE <A NAME="UnparseDisplay"><procedure>UnparseDisplay</procedure></A> (READONLY d: Display): TEXT =
  CONST colons = ARRAY BOOLEAN OF TEXT {&quot;:&quot;, &quot;::&quot;};
  BEGIN
    RETURN Fmt.F (&quot;%s%s%s.%s&quot;, d.hostname, colons [d.DECnet],
                  Fmt.Int (d.display), Fmt.Int (d.screen))
  END UnparseDisplay;

PROCEDURE <A NAME="ParseGeometry"><procedure>ParseGeometry</procedure></A> (t: TEXT): Geometry RAISES {Error} =
  CONST
    VertexMap = ARRAY BOOLEAN, BOOLEAN OF
                  Rect.Vertex{
                  ARRAY BOOLEAN OF
                    Rect.Vertex{Rect.Vertex.SE, Rect.Vertex.NE},
                  ARRAY BOOLEAN OF
                    Rect.Vertex{Rect.Vertex.SW, Rect.Vertex.NW}};
  VAR
    width, height: INTEGER;
    x, y                             := 0;
    i, start     : CARDINAL          := 0;
    n                                := Text.Length(t);
    buf          : REF ARRAY OF CHAR;
    xplus, yplus                     := TRUE;
  PROCEDURE Err (spec: TEXT; index: CARDINAL) RAISES {Error} =
    BEGIN
      RAISE
        Error(NEW(GeometryInfo, spec := spec, index := index))
    END Err;
  PROCEDURE scan () RAISES {Error} =
    BEGIN
      IF n = 0 THEN Err(t, 0) END;
      buf := NEW(REF ARRAY OF CHAR, n);
      Text.SetChars(buf^, t);
      width := num(i, n, buf);
      IF i = 0 THEN width := Missing.h END;
      IF i = n THEN RETURN END;
      IF buf[i] = 'x' THEN
        INC(i);
        start := i;
        height := num(i, n, buf);
        IF start = i THEN Err(t, start) END
      ELSE
        height := Missing.v
      END;
      IF i = n THEN RETURN END;
      IF buf[i] # '+' AND buf[i] # '-' THEN Err(t, i) END;
      INC(i);
      start := i;
      x := num(i, n, buf);
      IF i = start THEN Err(t, start) END;
      IF buf[start - 1] = '-' THEN xplus := FALSE END;
      IF i = n THEN RETURN END;
      IF buf[i] # '+' AND buf[i] # '-' THEN Err(t, i) END;
      INC(i);
      start := i;
      y := num(i, n, buf);
      IF i = start OR i # n THEN Err(t, start) END;
      IF buf[start - 1] = '-' THEN yplus := FALSE END;
    END scan;
  BEGIN
    scan();
    RETURN Geometry{VertexMap[xplus, yplus], Point.T{x, y},
                    Point.T{width, height}}
  END ParseGeometry;

PROCEDURE <A NAME="UnparseGeometry"><procedure>UnparseGeometry</procedure></A> (READONLY g: Geometry): TEXT =
  CONST
    xplus = ARRAY Rect.Vertex OF TEXT {&quot;+&quot;, &quot;-&quot;, &quot;+&quot;, &quot;-&quot;};
    yplus = ARRAY Rect.Vertex OF TEXT {&quot;+&quot;, &quot;+&quot;, &quot;-&quot;, &quot;-&quot;};
  BEGIN
    RETURN Fmt.Int (g.size.h) &amp; &quot;x&quot; &amp; Fmt.Int (g.size.v) &amp; xplus [g.vertex]
             &amp; Fmt.Int (ABS (g.dp.h)) &amp; yplus [g.vertex]
             &amp; Fmt.Int (ABS (g.dp.v))
  END UnparseGeometry;

PROCEDURE <A NAME="num"><procedure>num</procedure></A> (VAR i: CARDINAL; n: CARDINAL; buf: REF ARRAY OF CHAR):
  CARDINAL =
  CONST DIGITS = SET OF CHAR {'0'.. '9'};
  VAR v: CARDINAL := 0;
  BEGIN
    LOOP
      IF i = n OR NOT buf [i] IN DIGITS THEN RETURN v END;
      v := 10 * v + ORD (buf [i]) - ORD ('0');
      INC (i)
    END
  END num;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (         trsl: Trestle.T;
                             id  : Trestle.ScreenID;
                    READONLY g   : Geometry          ): Point.T
  RAISES {TrestleComm.Failure} =
  BEGIN
    WITH array = Trestle.GetScreens(trsl) DO
      IF array = NIL THEN RAISE TrestleComm.Failure END;
      FOR i := FIRST(array^) TO LAST(array^) DO
        IF id = Trestle.NoScreen OR array[i].id = id THEN
          WITH s = array[i].dom DO
            CASE g.vertex OF
            | Rect.Vertex.NW =&gt;
                RETURN Point.T{v := s.north + g.dp.v,
                               h := s.west + g.dp.h}
            | Rect.Vertex.SW =&gt;
                RETURN Point.T{v := s.south - g.size.v - g.dp.v,
                               h := s.west + g.dp.h}
            | Rect.Vertex.NE =&gt;
                RETURN Point.T{v := s.north + g.dp.v,
                               h := s.east - g.size.h - g.dp.h}
            | Rect.Vertex.SE =&gt;
                RETURN Point.T{v := s.south - g.size.v - g.dp.v,
                               h := s.east - g.size.h - g.dp.h}
            END;
          END
        END
      END
    END;
    RAISE TrestleComm.Failure
  END Position;

BEGIN
END XParam.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
