<HTML>
<HEAD>
<TITLE>SRC Modula-3: vbtkitutils/src/XTrestle.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vbtkitutils/src/XTrestle.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="XTrestle.i3">XTrestle</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../params/src/Params.i3">Params</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../ui/src/split/StableVBT.i3">StableVBT</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="../../ui/src/trestle/TrestleImpl.i3">TrestleImpl</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="XParam.i3">XParam</A>;

PROCEDURE <A NAME="Install"><procedure>Install</procedure></A> (v          : VBT.T;
                   applName   : TEXT    := NIL;
                   inst       : TEXT    := NIL;
                   windowTitle: TEXT    := NIL;
                   iconTitle  : TEXT    := NIL;
                   bgColorR   : REAL    := -1.0;
                   bgColorG   : REAL    := -1.0;
                   bgColorB   : REAL    := -1.0;
                   iconWindow : VBT.T   := NIL   )
  RAISES {TrestleComm.Failure, Error} =
  VAR
    display   : TEXT            := NIL;
    geometry  : TEXT            := NIL;
    screen    : INTEGER;
    g         : XParam.Geometry;
    trsl      : Trestle.T;
    needScreen                  := TRUE;
    i                           := 1;
  BEGIN
    TRY
      LOOP
        IF i &gt;= Params.Count - 1 THEN
          EXIT
        ELSIF Text.Equal(Params.Get(i), &quot;-display&quot;) THEN
          display := Params.Get(i + 1);
          screen := XParam.ParseDisplay(display).screen;
          needScreen := FALSE;
          INC(i, 2)
        ELSIF Text.Equal(Params.Get(i), &quot;-geometry&quot;) THEN
          geometry := Params.Get(i + 1);
          g := XParam.ParseGeometry(geometry);
          IF g.size = XParam.Missing THEN
            WITH shapes = VBTClass.GetShapes(v, FALSE) DO
              g.size.h := shapes[Axis.T.Hor].pref;
              g.size.v := shapes[Axis.T.Ver].pref;
            END
          END;
          INC(i, 2)
        ELSE
          INC(i)
        END
      END                        (* LOOP *)
    EXCEPT
      XParam.Error =&gt; RAISE Error
    END;

    trsl := Trestle.Connect(display);
    TrestleImpl.SetDefault(trsl);
    Trestle.Attach(v, trsl);
    Trestle.Decorate(v, inst, windowTitle, iconTitle, bgColorR, bgColorG,
                     bgColorB, applName, iconWindow);

    IF geometry = NIL THEN
      Trestle.MoveNear(v, NIL)
    ELSE
      StableVBT.SetShape(v, g.size.h, g.size.v);
      IF needScreen THEN
        screen := Trestle.ScreenOf(v, Point.Origin).id;
      END;
      WITH pos = XParam.Position(trsl, screen, g) DO
        Trestle.Overlap(v, screen, pos);
        (* XParam.Position can't always do the right thing if screen = NoScreen,
           so it does the best it can and then we check to see if that is right
           and do it again if it isn't.  NOTE: the second Trestle.Overlap
           call can be off by the height and width of the X border/title for
           the window *)
        IF screen = Trestle.NoScreen
             AND pos # XParam.Position(
                         trsl, Trestle.ScreenOf(v, Point.Origin).id, g) THEN
          Trestle.Overlap(
            v, screen,
            XParam.Position(trsl, Trestle.ScreenOf(v, Point.Origin).id, g));
        END;
      END;
    END;
  END Install;

BEGIN
END XTrestle.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
