<HTML>
<HEAD>
<TITLE>SRC Modula-3: videovbt/src/AudioVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>videovbt/src/AudioVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="AudioVBT.m3">AudioVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../jvideo/src/Jva.i3">Jva</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
&lt;* PRAGMA LL *&gt;
</PRE> An <CODE>AudioVBT.T</CODE> is a filter which is associated with the audio stream
   from a JVideo server.
<P>
   All audio streams for a given host in an application share the same
   connection so the most recent setting is used if there are several
   AudioVBT.Ts operating on the same source.  The meaning of the <CODE>source</CODE>
   string is determined by the underlying audio software.
<P>
   If <CODE>mute</CODE> is true then the audio connection is silent but remains
   connected.
<P>
   Unless <CODE>ignoreMapping</CODE> is true, the audio connection is muted whenever
   the <CODE>T</CODE> is unmapped, and unmuted when the <CODE>T</CODE> is mapped again.
<P>
   At present, <CODE>volume</CODE> is a value in the range [-30..30].  Its default
   value is 0.
<P>
   A mute push button can be implemented by wrapping a AudioVBT.T around a
   child of a TSplit with 2 children.  By switching between the children
   the TSplit will map and unmap the AudioVBT.T, so turning muting on and
   off.
<P>
   The T releases its connection to the source when it is deleted.  It does
   not reset the state of the connection before releasing. 

<P><PRE>TYPE
  <A HREF="AudioVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT
           METHODS
             &lt;* LL &lt; self *&gt;
             init (ch           : VBT.T;
                   source       : TEXT;
                   mute                      := FALSE;
                   ignoreMapping             := FALSE;
                   volume       : Jva.Volume := 0      ): T
                   RAISES {OSError.E, Thread.Alerted};

           END;

&lt;* LL &lt; self *&gt;
PROCEDURE <A HREF="AudioVBT.m3#SetMute">SetMute</A> (t: T; mute: BOOLEAN) RAISES {Thread.Alerted};
PROCEDURE <A HREF="AudioVBT.m3#SetIgnoreMapping">SetIgnoreMapping</A> (t: T; ignore: BOOLEAN) RAISES {Thread.Alerted};
PROCEDURE <A HREF="AudioVBT.m3#SetVolume">SetVolume</A> (t: T; volume: Jva.Volume) RAISES {Thread.Alerted};

END AudioVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
