<HTML>
<HEAD>
<TITLE>SRC Modula-3: videovbt/src/AudioVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>videovbt/src/AudioVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="AudioVBT.i3">AudioVBT</A></implements></module>;

IMPORT <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../jvideo/src/Jva.i3">Jva</A>, <A HREF="../../jvideo/src/JVAudio.i3">JVAudio</A>, <A HREF="../../jvideo/src/JVConverter.i3">JVConverter</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        jva                : JVAudio.T := NIL;
        ignoreMapping, mute: BOOLEAN;
      OVERRIDES
        init     := Init;
        reshape  := Reshape;
        rescreen := Rescreen;
        misc     := Misc;
        discard  := Discard;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t            : T;
                ch           : VBT.T;
                source       : TEXT;
                mute                      := FALSE;
                ignoreMapping             := FALSE;
                volume       : Jva.Volume := 0      ): T
  RAISES {OSError.E, Thread.Alerted} =
  BEGIN
    t.jva := JVAudio.New(source);
    t.ignoreMapping := ignoreMapping;
    t.mute := mute;
    (* we know we're unmapped at the moment *)
    t.jva.setMute(mute AND NOT ignoreMapping);
    t.jva.setVolume(volume);
    RETURN Filter.T.init(t, ch);
  END Init;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (t: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF NOT Rect.Congruent(cd.prev, cd.new) THEN
      TRY
        DoMute(t, &quot;AudioVBT: Reshape&quot;);
      EXCEPT
      | Thread.Alerted =&gt;          (*skip *)
      END
    END;
    Filter.T.reshape(t, cd);
  END Reshape;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (t: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    TRY
      DoMute(t, &quot;AudioVBT: Rescreen&quot;);
    EXCEPT
    | Thread.Alerted =&gt;          (*skip *)
    END;
    Filter.T.rescreen(t, cd);
  END Rescreen;

PROCEDURE <A NAME="Misc"><procedure>Misc</procedure></A> (t: T; READONLY cd: VBT.MiscRec) =
  BEGIN
    IF cd.type = VBT.Deleted OR cd.type = VBT.Disconnected THEN
      LOCK t DO IF t.jva # NIL THEN t.jva.close(); END; END;
    END;
    Filter.T.misc(t, cd);
  END Misc;

PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (t: T) =
  BEGIN
    LOCK t DO IF t.jva # NIL THEN t.jva.close(); END; END;
    Filter.T.discard(t);
  END Discard;
</PRE> -- external procedures -- 

<P><PRE>PROCEDURE <A NAME="SetMute"><procedure>SetMute</procedure></A> (t: T; mute: BOOLEAN) RAISES {Thread.Alerted} =
  BEGIN
    IF mute = t.mute THEN RETURN; END;
    LOCK t DO
      t.mute := mute;
      DoMute(t, &quot;AudioVBT: SetMute&quot;);
    END;
  END SetMute;

PROCEDURE <A NAME="SetIgnoreMapping"><procedure>SetIgnoreMapping</procedure></A> (t: T; ignore: BOOLEAN)
  RAISES {Thread.Alerted} =
  BEGIN
    LOCK t DO
      t.ignoreMapping := ignore;
      DoMute(t, &quot;AudioVBT: SetIgnoreMapping&quot;);
    END;
  END SetIgnoreMapping;

PROCEDURE <A NAME="SetVolume"><procedure>SetVolume</procedure></A> (t: T; volume: Jva.Volume) RAISES {Thread.Alerted} =
  BEGIN
    TRY
      LOCK t DO t.jva.setVolume(volume); END;
    EXCEPT
    | OSError.E (e) =&gt; Report(e, &quot;AudioVBT: SetVolume&quot;);
    END;
  END SetVolume;
</PRE> -- internal procedures -- 

<P> check the state of the T and set muting accordingly  <PRE>&lt;* LL &gt;= t *&gt;

PROCEDURE <A NAME="DoMute"><procedure>DoMute</procedure></A> (t: T; msg: TEXT) RAISES {Thread.Alerted} =
  VAR
    mute := t.mute OR ((Rect.IsEmpty(t.domain) OR t.st = NIL)
                         AND NOT t.ignoreMapping);
  BEGIN
    TRY t.jva.setMute(mute); EXCEPT | OSError.E (e) =&gt; Report(e, msg); END;
  END DoMute;

PROCEDURE <A NAME="Report"><procedure>Report</procedure></A> (e: AtomList.T; msg: TEXT) =
  BEGIN
    VAR etext := &quot;&quot;;
    BEGIN
      IF e # NIL AND e.head # NIL THEN
        etext := RdUtils.FailureText(e);
      END;
      JVConverter.ReportError(msg &amp; etext);
    END;
  END Report;

BEGIN
END AudioVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
